//go:build linux && cgo && !agent

// Code generated by generate-database from the incus project - DO NOT EDIT.

package cluster

import (
	"context"
	"database/sql"
	"errors"
	"fmt"
	"strings"

	"github.com/mattn/go-sqlite3"
)

var profileObjects = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles
  JOIN projects ON profiles.project_id = projects.id
  ORDER BY projects.id, profiles.name
`)

var profileObjectsByID = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles
  JOIN projects ON profiles.project_id = projects.id
  WHERE ( profiles.id = ? )
  ORDER BY projects.id, profiles.name
`)

var profileObjectsByName = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles
  JOIN projects ON profiles.project_id = projects.id
  WHERE ( profiles.name = ? )
  ORDER BY projects.id, profiles.name
`)

var profileObjectsByProject = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles
  JOIN projects ON profiles.project_id = projects.id
  WHERE ( project = ? )
  ORDER BY projects.id, profiles.name
`)

var profileObjectsByProjectAndName = RegisterStmt(`
SELECT profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')
  FROM profiles
  JOIN projects ON profiles.project_id = projects.id
  WHERE ( project = ? AND profiles.name = ? )
  ORDER BY projects.id, profiles.name
`)

var profileID = RegisterStmt(`
SELECT profiles.id FROM profiles
  JOIN projects ON profiles.project_id = projects.id
  WHERE projects.name = ? AND profiles.name = ?
`)

var profileCreate = RegisterStmt(`
INSERT INTO profiles (project_id, name, description)
  VALUES ((SELECT projects.id FROM projects WHERE projects.name = ?), ?, ?)
`)

var profileRename = RegisterStmt(`
UPDATE profiles SET name = ? WHERE project_id = (SELECT projects.id FROM projects WHERE projects.name = ?) AND name = ?
`)

var profileUpdate = RegisterStmt(`
UPDATE profiles
  SET project_id = (SELECT projects.id FROM projects WHERE projects.name = ?), name = ?, description = ?
 WHERE id = ?
`)

var profileDeleteByProjectAndName = RegisterStmt(`
DELETE FROM profiles WHERE project_id = (SELECT projects.id FROM projects WHERE projects.name = ?) AND name = ?
`)

// GetProfileID return the ID of the profile with the given key.
// generator: profile ID
func GetProfileID(ctx context.Context, db tx, project string, name string) (_ int64, _err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	stmt, err := Stmt(db, profileID)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"profileID\" prepared statement: %w", err)
	}

	row := stmt.QueryRowContext(ctx, project, name)
	var id int64
	err = row.Scan(&id)
	if errors.Is(err, sql.ErrNoRows) {
		return -1, ErrNotFound
	}

	if err != nil {
		return -1, fmt.Errorf("Failed to get \"profiles\" ID: %w", err)
	}

	return id, nil
}

// ProfileExists checks if a profile with the given key exists.
// generator: profile Exists
func ProfileExists(ctx context.Context, db dbtx, project string, name string) (_ bool, _err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	stmt, err := Stmt(db, profileID)
	if err != nil {
		return false, fmt.Errorf("Failed to get \"profileID\" prepared statement: %w", err)
	}

	row := stmt.QueryRowContext(ctx, project, name)
	var id int64
	err = row.Scan(&id)
	if errors.Is(err, sql.ErrNoRows) {
		return false, nil
	}

	if err != nil {
		return false, fmt.Errorf("Failed to get \"profiles\" ID: %w", err)
	}

	return true, nil
}

// profileColumns returns a string of column names to be used with a SELECT statement for the entity.
// Use this function when building statements to retrieve database entries matching the Profile entity.
func profileColumns() string {
	return "profiles.id, profiles.project_id, projects.name AS project, profiles.name, coalesce(profiles.description, '')"
}

// getProfiles can be used to run handwritten sql.Stmts to return a slice of objects.
func getProfiles(ctx context.Context, stmt *sql.Stmt, args ...any) ([]Profile, error) {
	objects := make([]Profile, 0)

	dest := func(scan func(dest ...any) error) error {
		p := Profile{}
		err := scan(&p.ID, &p.ProjectID, &p.Project, &p.Name, &p.Description)
		if err != nil {
			return err
		}

		objects = append(objects, p)

		return nil
	}

	err := selectObjects(ctx, stmt, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"profiles\" table: %w", err)
	}

	return objects, nil
}

// getProfilesRaw can be used to run handwritten query strings to return a slice of objects.
func getProfilesRaw(ctx context.Context, db dbtx, sql string, args ...any) ([]Profile, error) {
	objects := make([]Profile, 0)

	dest := func(scan func(dest ...any) error) error {
		p := Profile{}
		err := scan(&p.ID, &p.ProjectID, &p.Project, &p.Name, &p.Description)
		if err != nil {
			return err
		}

		objects = append(objects, p)

		return nil
	}

	err := scan(ctx, db, sql, dest, args...)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"profiles\" table: %w", err)
	}

	return objects, nil
}

// GetProfiles returns all available profiles.
// generator: profile GetMany
func GetProfiles(ctx context.Context, db dbtx, filters ...ProfileFilter) (_ []Profile, _err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	var err error

	// Result slice.
	objects := make([]Profile, 0)

	// Pick the prepared statement and arguments to use based on active criteria.
	var sqlStmt *sql.Stmt
	args := []any{}
	queryParts := [2]string{}

	if len(filters) == 0 {
		sqlStmt, err = Stmt(db, profileObjects)
		if err != nil {
			return nil, fmt.Errorf("Failed to get \"profileObjects\" prepared statement: %w", err)
		}
	}

	for i, filter := range filters {
		if filter.Project != nil && filter.Name != nil && filter.ID == nil {
			args = append(args, []any{filter.Project, filter.Name}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, profileObjectsByProjectAndName)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"profileObjectsByProjectAndName\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(profileObjectsByProjectAndName)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"profileObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.Project != nil && filter.ID == nil && filter.Name == nil {
			args = append(args, []any{filter.Project}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, profileObjectsByProject)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"profileObjectsByProject\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(profileObjectsByProject)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"profileObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.Name != nil && filter.ID == nil && filter.Project == nil {
			args = append(args, []any{filter.Name}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, profileObjectsByName)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"profileObjectsByName\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(profileObjectsByName)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"profileObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.ID != nil && filter.Project == nil && filter.Name == nil {
			args = append(args, []any{filter.ID}...)
			if len(filters) == 1 {
				sqlStmt, err = Stmt(db, profileObjectsByID)
				if err != nil {
					return nil, fmt.Errorf("Failed to get \"profileObjectsByID\" prepared statement: %w", err)
				}

				break
			}

			query, err := StmtString(profileObjectsByID)
			if err != nil {
				return nil, fmt.Errorf("Failed to get \"profileObjects\" prepared statement: %w", err)
			}

			parts := strings.SplitN(query, "ORDER BY", 2)
			if i == 0 {
				copy(queryParts[:], parts)
				continue
			}

			_, where, _ := strings.Cut(parts[0], "WHERE")
			queryParts[0] += "OR" + where
		} else if filter.ID == nil && filter.Project == nil && filter.Name == nil {
			return nil, fmt.Errorf("Cannot filter on empty ProfileFilter")
		} else {
			return nil, fmt.Errorf("No statement exists for the given Filter")
		}
	}

	// Select.
	if sqlStmt != nil {
		objects, err = getProfiles(ctx, sqlStmt, args...)
	} else {
		queryStr := strings.Join(queryParts[:], "ORDER BY")
		objects, err = getProfilesRaw(ctx, db, queryStr, args...)
	}

	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"profiles\" table: %w", err)
	}

	return objects, nil
}

// GetProfileDevices returns all available Profile Devices
// generator: profile GetMany
func GetProfileDevices(ctx context.Context, db tx, profileID int, filters ...DeviceFilter) (_ map[string]Device, _err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	profileDevices, err := GetDevices(ctx, db, "profiles", "profile", filters...)
	if err != nil {
		return nil, err
	}

	devices := map[string]Device{}
	for _, ref := range profileDevices[profileID] {
		_, ok := devices[ref.Name]
		if !ok {
			devices[ref.Name] = ref
		} else {
			return nil, fmt.Errorf("Found duplicate Device with name %q", ref.Name)
		}
	}

	return devices, nil
}

// GetProfileConfig returns all available Profile Config
// generator: profile GetMany
func GetProfileConfig(ctx context.Context, db tx, profileID int, filters ...ConfigFilter) (_ map[string]string, _err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	profileConfig, err := GetConfig(ctx, db, "profiles", "profile", filters...)
	if err != nil {
		return nil, err
	}

	config, ok := profileConfig[profileID]
	if !ok {
		config = map[string]string{}
	}

	return config, nil
}

// GetProfile returns the profile with the given key.
// generator: profile GetOne
func GetProfile(ctx context.Context, db dbtx, project string, name string) (_ *Profile, _err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	filter := ProfileFilter{}
	filter.Project = &project
	filter.Name = &name

	objects, err := GetProfiles(ctx, db, filter)
	if err != nil {
		return nil, fmt.Errorf("Failed to fetch from \"profiles\" table: %w", err)
	}

	switch len(objects) {
	case 0:
		return nil, ErrNotFound
	case 1:
		return &objects[0], nil
	default:
		return nil, fmt.Errorf("More than one \"profiles\" entry matches")
	}
}

// CreateProfile adds a new profile to the database.
// generator: profile Create
func CreateProfile(ctx context.Context, db dbtx, object Profile) (_ int64, _err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	args := make([]any, 3)

	// Populate the statement arguments.
	args[0] = object.Project
	args[1] = object.Name
	args[2] = object.Description

	// Prepared statement to use.
	stmt, err := Stmt(db, profileCreate)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"profileCreate\" prepared statement: %w", err)
	}

	// Execute the statement.
	result, err := stmt.Exec(args...)
	var sqliteErr sqlite3.Error
	if errors.As(err, &sqliteErr) {
		if sqliteErr.Code == sqlite3.ErrConstraint {
			return -1, ErrConflict
		}
	}

	if err != nil {
		return -1, fmt.Errorf("Failed to create \"profiles\" entry: %w", err)
	}

	id, err := result.LastInsertId()
	if err != nil {
		return -1, fmt.Errorf("Failed to fetch \"profiles\" entry ID: %w", err)
	}

	return id, nil
}

// CreateProfileDevices adds new profile Devices to the database.
// generator: profile Create
func CreateProfileDevices(ctx context.Context, db tx, profileID int64, devices map[string]Device) (_err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	for key, device := range devices {
		device.ReferenceID = int(profileID)
		devices[key] = device
	}

	err := CreateDevices(ctx, db, "profiles", "profile", devices)
	if err != nil {
		return fmt.Errorf("Insert Device failed for Profile: %w", err)
	}

	return nil
}

// CreateProfileConfig adds new profile Config to the database.
// generator: profile Create
func CreateProfileConfig(ctx context.Context, db dbtx, profileID int64, config map[string]string) (_err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	referenceID := int(profileID)
	for key, value := range config {
		insert := Config{
			ReferenceID: referenceID,
			Key:         key,
			Value:       value,
		}

		err := CreateConfig(ctx, db, "profiles", "profile", insert)
		if err != nil {
			return fmt.Errorf("Insert Config failed for Profile: %w", err)
		}

	}

	return nil
}

// RenameProfile renames the profile matching the given key parameters.
// generator: profile Rename
func RenameProfile(ctx context.Context, db dbtx, project string, name string, to string) (_err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	stmt, err := Stmt(db, profileRename)
	if err != nil {
		return fmt.Errorf("Failed to get \"profileRename\" prepared statement: %w", err)
	}

	result, err := stmt.Exec(to, project, name)
	if err != nil {
		return fmt.Errorf("Rename Profile failed: %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows failed: %w", err)
	}

	if n != 1 {
		return fmt.Errorf("Query affected %d rows instead of 1", n)
	}

	return nil
}

// UpdateProfile updates the profile matching the given key parameters.
// generator: profile Update
func UpdateProfile(ctx context.Context, db tx, project string, name string, object Profile) (_err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	id, err := GetProfileID(ctx, db, project, name)
	if err != nil {
		return err
	}

	stmt, err := Stmt(db, profileUpdate)
	if err != nil {
		return fmt.Errorf("Failed to get \"profileUpdate\" prepared statement: %w", err)
	}

	result, err := stmt.Exec(object.Project, object.Name, object.Description, id)
	if err != nil {
		return fmt.Errorf("Update \"profiles\" entry failed: %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n != 1 {
		return fmt.Errorf("Query updated %d rows instead of 1", n)
	}

	return nil
}

// UpdateProfileDevices updates the profile Device matching the given key parameters.
// generator: profile Update
func UpdateProfileDevices(ctx context.Context, db tx, profileID int64, devices map[string]Device) (_err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	err := UpdateDevices(ctx, db, "profiles", "profile", int(profileID), devices)
	if err != nil {
		return fmt.Errorf("Replace Device for Profile failed: %w", err)
	}

	return nil
}

// UpdateProfileConfig updates the profile Config matching the given key parameters.
// generator: profile Update
func UpdateProfileConfig(ctx context.Context, db tx, profileID int64, config map[string]string) (_err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	err := UpdateConfig(ctx, db, "profiles", "profile", int(profileID), config)
	if err != nil {
		return fmt.Errorf("Replace Config for Profile failed: %w", err)
	}

	return nil
}

// DeleteProfile deletes the profile matching the given key parameters.
// generator: profile DeleteOne-by-Project-and-Name
func DeleteProfile(ctx context.Context, db dbtx, project string, name string) (_err error) {
	defer func() {
		_err = mapErr(_err, "Profile")
	}()

	stmt, err := Stmt(db, profileDeleteByProjectAndName)
	if err != nil {
		return fmt.Errorf("Failed to get \"profileDeleteByProjectAndName\" prepared statement: %w", err)
	}

	result, err := stmt.Exec(project, name)
	if err != nil {
		return fmt.Errorf("Delete \"profiles\": %w", err)
	}

	n, err := result.RowsAffected()
	if err != nil {
		return fmt.Errorf("Fetch affected rows: %w", err)
	}

	if n == 0 {
		return ErrNotFound
	} else if n > 1 {
		return fmt.Errorf("Query deleted %d Profile rows instead of 1", n)
	}

	return nil
}
