
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_parcsr_ls.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSCreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSCreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSCreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *rel_resid_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSGetFinalRelativeResidualNorm_flt( solver, rel_resid_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSGetFinalRelativeResidualNorm_dbl( solver, rel_resid_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSGetFinalRelativeResidualNorm_long_dbl( solver, rel_resid_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetAMGOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetAMGOptions_flt( solver, coarsen_type, agg_levels, relax_type, strength_threshold, interp_type, Pmax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetAMGOptions_dbl( solver, coarsen_type, agg_levels, relax_type, strength_threshold, interp_type, Pmax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetAMGOptions_long_dbl( solver, coarsen_type, agg_levels, relax_type, strength_threshold, interp_type, Pmax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetAMSOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type, HYPRE_Int coarsen_type, HYPRE_Int agg_levels, HYPRE_Int relax_type, hypre_long_double strength_threshold, HYPRE_Int interp_type, HYPRE_Int Pmax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetAMSOptions_flt( solver, cycle_type, coarsen_type, agg_levels, relax_type, strength_threshold, interp_type, Pmax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetAMSOptions_dbl( solver, cycle_type, coarsen_type, agg_levels, relax_type, strength_threshold, interp_type, Pmax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetAMSOptions_long_dbl( solver, cycle_type, coarsen_type, agg_levels, relax_type, strength_threshold, interp_type, Pmax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetChebySmoothingOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cheby_order, hypre_long_double cheby_fraction )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetChebySmoothingOptions_flt( solver, cheby_order, cheby_fraction );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetChebySmoothingOptions_dbl( solver, cheby_order, cheby_fraction );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetChebySmoothingOptions_long_dbl( solver, cheby_order, cheby_fraction );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetCoordinateVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetCoordinateVectors_flt( solver, x, y, z );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetCoordinateVectors_dbl( solver, x, y, z );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetCoordinateVectors_long_dbl( solver, x, y, z );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetCycleType_flt( solver, cycle_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetCycleType_dbl( solver, cycle_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetCycleType_long_dbl( solver, cycle_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetDiscreteCurl_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix C )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetDiscreteCurl_flt( solver, C );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetDiscreteCurl_dbl( solver, C );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetDiscreteCurl_long_dbl( solver, C );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetDiscreteGradient_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix G )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetDiscreteGradient_flt( solver, G );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetDiscreteGradient_dbl( solver, G );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetDiscreteGradient_long_dbl( solver, G );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetInterpolations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix RT_Pi, HYPRE_ParCSRMatrix RT_Pix, HYPRE_ParCSRMatrix RT_Piy, HYPRE_ParCSRMatrix RT_Piz, HYPRE_ParCSRMatrix ND_Pi, HYPRE_ParCSRMatrix ND_Pix, HYPRE_ParCSRMatrix ND_Piy, HYPRE_ParCSRMatrix ND_Piz )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetInterpolations_flt( solver, RT_Pi, RT_Pix, RT_Piy, RT_Piz, ND_Pi, ND_Pix, ND_Piy, ND_Piz );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetInterpolations_dbl( solver, RT_Pi, RT_Pix, RT_Piy, RT_Piz, ND_Pi, ND_Pix, ND_Piy, ND_Piz );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetInterpolations_long_dbl( solver, RT_Pi, RT_Pix, RT_Piy, RT_Piz, ND_Pi, ND_Pix, ND_Piy, ND_Piz );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int maxit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetMaxIter_flt( solver, maxit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetMaxIter_dbl( solver, maxit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetMaxIter_long_dbl( solver, maxit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetSmoothingOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetSmoothingOptions_flt( solver, relax_type, relax_times, relax_weight, omega );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetSmoothingOptions_dbl( solver, relax_type, relax_times, relax_weight, omega );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetSmoothingOptions_long_dbl( solver, relax_type, relax_times, relax_weight, omega );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ADSSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ADSSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ADSSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ADSSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMECreate_pre( HYPRE_Precision precision, HYPRE_Solver *esolver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMECreate_flt( esolver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMECreate_dbl( esolver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMECreate_long_dbl( esolver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMEDestroy_pre( HYPRE_Precision precision, HYPRE_Solver esolver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMEDestroy_flt( esolver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMEDestroy_dbl( esolver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMEDestroy_long_dbl( esolver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMEGetEigenvalues_pre( HYPRE_Precision precision, HYPRE_Solver esolver, void *eigenvalues )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMEGetEigenvalues_flt( esolver, eigenvalues );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMEGetEigenvalues_dbl( esolver, eigenvalues );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMEGetEigenvalues_long_dbl( esolver, eigenvalues );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMEGetEigenvectors_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_ParVector **eigenvectors )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMEGetEigenvectors_flt( esolver, eigenvectors );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMEGetEigenvectors_dbl( esolver, eigenvectors );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMEGetEigenvectors_long_dbl( esolver, eigenvectors );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetAMSSolver_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Solver ams_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESetAMSSolver_flt( esolver, ams_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESetAMSSolver_dbl( esolver, ams_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESetAMSSolver_long_dbl( esolver, ams_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetBlockSize_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Int block_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESetBlockSize_flt( esolver, block_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESetBlockSize_dbl( esolver, block_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESetBlockSize_long_dbl( esolver, block_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetMassMatrix_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_ParCSRMatrix M )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESetMassMatrix_flt( esolver, M );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESetMassMatrix_dbl( esolver, M );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESetMassMatrix_long_dbl( esolver, M );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Int maxit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESetMaxIter_flt( esolver, maxit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESetMaxIter_dbl( esolver, maxit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESetMaxIter_long_dbl( esolver, maxit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetMaxPCGIter_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Int maxit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESetMaxPCGIter_flt( esolver, maxit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESetMaxPCGIter_dbl( esolver, maxit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESetMaxPCGIter_long_dbl( esolver, maxit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver esolver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESetPrintLevel_flt( esolver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESetPrintLevel_dbl( esolver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESetPrintLevel_long_dbl( esolver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetRTol_pre( HYPRE_Precision precision, HYPRE_Solver esolver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESetRTol_flt( esolver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESetRTol_dbl( esolver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESetRTol_long_dbl( esolver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetTol_pre( HYPRE_Precision precision, HYPRE_Solver esolver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESetTol_flt( esolver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESetTol_dbl( esolver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESetTol_long_dbl( esolver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESetup_pre( HYPRE_Precision precision, HYPRE_Solver esolver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESetup_flt( esolver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESetup_dbl( esolver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESetup_long_dbl( esolver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMESolve_pre( HYPRE_Precision precision, HYPRE_Solver esolver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMESolve_flt( esolver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMESolve_dbl( esolver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMESolve_long_dbl( esolver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSConstructDiscreteGradient_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix A, HYPRE_ParVector x_coord, HYPRE_BigInt *edge_vertex, HYPRE_Int edge_orientation, HYPRE_ParCSRMatrix *G )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSConstructDiscreteGradient_flt( A, x_coord, edge_vertex, edge_orientation, G );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSConstructDiscreteGradient_dbl( A, x_coord, edge_vertex, edge_orientation, G );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSConstructDiscreteGradient_long_dbl( A, x_coord, edge_vertex, edge_orientation, G );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSCreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSCreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSCreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *rel_resid_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSGetFinalRelativeResidualNorm_flt( solver, rel_resid_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSGetFinalRelativeResidualNorm_dbl( solver, rel_resid_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSGetFinalRelativeResidualNorm_long_dbl( solver, rel_resid_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSProjectOutGradients_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSProjectOutGradients_flt( solver, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSProjectOutGradients_dbl( solver, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSProjectOutGradients_long_dbl( solver, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetAlphaAMGCoarseRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int alpha_coarse_relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetAlphaAMGCoarseRelaxType_flt( solver, alpha_coarse_relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetAlphaAMGCoarseRelaxType_dbl( solver, alpha_coarse_relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetAlphaAMGCoarseRelaxType_long_dbl( solver, alpha_coarse_relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetAlphaAMGOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int alpha_coarsen_type, HYPRE_Int alpha_agg_levels, HYPRE_Int alpha_relax_type, hypre_long_double alpha_strength_threshold, HYPRE_Int alpha_interp_type, HYPRE_Int alpha_Pmax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetAlphaAMGOptions_flt( solver, alpha_coarsen_type, alpha_agg_levels, alpha_relax_type, alpha_strength_threshold, alpha_interp_type, alpha_Pmax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetAlphaAMGOptions_dbl( solver, alpha_coarsen_type, alpha_agg_levels, alpha_relax_type, alpha_strength_threshold, alpha_interp_type, alpha_Pmax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetAlphaAMGOptions_long_dbl( solver, alpha_coarsen_type, alpha_agg_levels, alpha_relax_type, alpha_strength_threshold, alpha_interp_type, alpha_Pmax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetAlphaPoissonMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A_alpha )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetAlphaPoissonMatrix_flt( solver, A_alpha );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetAlphaPoissonMatrix_dbl( solver, A_alpha );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetAlphaPoissonMatrix_long_dbl( solver, A_alpha );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetBetaAMGCoarseRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int beta_coarse_relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetBetaAMGCoarseRelaxType_flt( solver, beta_coarse_relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetBetaAMGCoarseRelaxType_dbl( solver, beta_coarse_relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetBetaAMGCoarseRelaxType_long_dbl( solver, beta_coarse_relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetBetaAMGOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int beta_coarsen_type, HYPRE_Int beta_agg_levels, HYPRE_Int beta_relax_type, hypre_long_double beta_strength_threshold, HYPRE_Int beta_interp_type, HYPRE_Int beta_Pmax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetBetaAMGOptions_flt( solver, beta_coarsen_type, beta_agg_levels, beta_relax_type, beta_strength_threshold, beta_interp_type, beta_Pmax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetBetaAMGOptions_dbl( solver, beta_coarsen_type, beta_agg_levels, beta_relax_type, beta_strength_threshold, beta_interp_type, beta_Pmax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetBetaAMGOptions_long_dbl( solver, beta_coarsen_type, beta_agg_levels, beta_relax_type, beta_strength_threshold, beta_interp_type, beta_Pmax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetBetaPoissonMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A_beta )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetBetaPoissonMatrix_flt( solver, A_beta );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetBetaPoissonMatrix_dbl( solver, A_beta );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetBetaPoissonMatrix_long_dbl( solver, A_beta );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetCoordinateVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector x, HYPRE_ParVector y, HYPRE_ParVector z )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetCoordinateVectors_flt( solver, x, y, z );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetCoordinateVectors_dbl( solver, x, y, z );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetCoordinateVectors_long_dbl( solver, x, y, z );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetCycleType_flt( solver, cycle_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetCycleType_dbl( solver, cycle_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetCycleType_long_dbl( solver, cycle_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetDimension_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetDimension_flt( solver, dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetDimension_dbl( solver, dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetDimension_long_dbl( solver, dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetDiscreteGradient_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix G )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetDiscreteGradient_flt( solver, G );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetDiscreteGradient_dbl( solver, G );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetDiscreteGradient_long_dbl( solver, G );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetEdgeConstantVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector Gx, HYPRE_ParVector Gy, HYPRE_ParVector Gz )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetEdgeConstantVectors_flt( solver, Gx, Gy, Gz );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetEdgeConstantVectors_dbl( solver, Gx, Gy, Gz );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetEdgeConstantVectors_long_dbl( solver, Gx, Gy, Gz );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetInteriorNodes_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector interior_nodes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetInteriorNodes_flt( solver, interior_nodes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetInteriorNodes_dbl( solver, interior_nodes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetInteriorNodes_long_dbl( solver, interior_nodes );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetInterpolations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix Pi, HYPRE_ParCSRMatrix Pix, HYPRE_ParCSRMatrix Piy, HYPRE_ParCSRMatrix Piz )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetInterpolations_flt( solver, Pi, Pix, Piy, Piz );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetInterpolations_dbl( solver, Pi, Pix, Piy, Piz );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetInterpolations_long_dbl( solver, Pi, Pix, Piy, Piz );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int maxit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetMaxIter_flt( solver, maxit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetMaxIter_dbl( solver, maxit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetMaxIter_long_dbl( solver, maxit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetProjectionFrequency_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int projection_frequency )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetProjectionFrequency_flt( solver, projection_frequency );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetProjectionFrequency_dbl( solver, projection_frequency );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetProjectionFrequency_long_dbl( solver, projection_frequency );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetSmoothingOptions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int relax_times, hypre_long_double relax_weight, hypre_long_double omega )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetSmoothingOptions_flt( solver, relax_type, relax_times, relax_weight, omega );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetSmoothingOptions_dbl( solver, relax_type, relax_times, relax_weight, omega );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetSmoothingOptions_long_dbl( solver, relax_type, relax_times, relax_weight, omega );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_AMSSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_AMSSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_AMSSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_AMSSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BlockTridiagCreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BlockTridiagCreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BlockTridiagCreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BlockTridiagDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BlockTridiagDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BlockTridiagDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetAMGNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BlockTridiagSetAMGNumSweeps_flt( solver, num_sweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BlockTridiagSetAMGNumSweeps_dbl( solver, num_sweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BlockTridiagSetAMGNumSweeps_long_dbl( solver, num_sweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetAMGRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BlockTridiagSetAMGRelaxType_flt( solver, relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BlockTridiagSetAMGRelaxType_dbl( solver, relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BlockTridiagSetAMGRelaxType_long_dbl( solver, relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetAMGStrengthThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double thresh )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BlockTridiagSetAMGStrengthThreshold_flt( solver, thresh );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BlockTridiagSetAMGStrengthThreshold_dbl( solver, thresh );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BlockTridiagSetAMGStrengthThreshold_long_dbl( solver, thresh );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetIndexSet_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int n, HYPRE_Int *inds )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BlockTridiagSetIndexSet_flt( solver, n, inds );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BlockTridiagSetIndexSet_dbl( solver, n, inds );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BlockTridiagSetIndexSet_long_dbl( solver, n, inds );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BlockTridiagSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BlockTridiagSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BlockTridiagSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BlockTridiagSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BlockTridiagSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BlockTridiagSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BlockTridiagSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BlockTridiagSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BlockTridiagSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BlockTridiagSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGCreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGCreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGCreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDCreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDCreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDCreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDGetAMG_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *amg_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDGetAMG_flt( solver, amg_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDGetAMG_dbl( solver, amg_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDGetAMG_long_dbl( solver, amg_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *rel_resid_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm_flt( solver, rel_resid_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm_dbl( solver, rel_resid_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDGetFinalRelativeResidualNorm_long_dbl( solver, rel_resid_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int amgdd_fac_cycle_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSetFACCycleType_flt( solver, amgdd_fac_cycle_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSetFACCycleType_dbl( solver, amgdd_fac_cycle_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSetFACCycleType_long_dbl( solver, amgdd_fac_cycle_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumCycles_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_cycles )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSetFACNumCycles_flt( solver, amgdd_fac_num_cycles );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSetFACNumCycles_dbl( solver, amgdd_fac_num_cycles );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSetFACNumCycles_long_dbl( solver, amgdd_fac_num_cycles );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACNumRelax_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int amgdd_fac_num_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSetFACNumRelax_flt( solver, amgdd_fac_num_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSetFACNumRelax_dbl( solver, amgdd_fac_num_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSetFACNumRelax_long_dbl( solver, amgdd_fac_num_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int amgdd_fac_relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSetFACRelaxType_flt( solver, amgdd_fac_relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSetFACRelaxType_dbl( solver, amgdd_fac_relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSetFACRelaxType_long_dbl( solver, amgdd_fac_relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetFACRelaxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double amgdd_fac_relax_weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSetFACRelaxWeight_flt( solver, amgdd_fac_relax_weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSetFACRelaxWeight_dbl( solver, amgdd_fac_relax_weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSetFACRelaxWeight_long_dbl( solver, amgdd_fac_relax_weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetNumGhostLayers_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_ghost_layers )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSetNumGhostLayers_flt( solver, num_ghost_layers );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSetNumGhostLayers_dbl( solver, num_ghost_layers );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSetNumGhostLayers_long_dbl( solver, num_ghost_layers );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetPadding_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int padding )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSetPadding_flt( solver, padding );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSetPadding_dbl( solver, padding );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSetPadding_long_dbl( solver, padding );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetStartLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int start_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSetStartLevel_flt( solver, start_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSetStartLevel_dbl( solver, start_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSetStartLevel_long_dbl( solver, start_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDDSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDDSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDDSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDDSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetAdditive_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *additive )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetAdditive_flt( solver, additive );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetAdditive_dbl( solver, additive );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetAdditive_long_dbl( solver, additive );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCoarsenCutFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *coarsen_cut_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetCoarsenCutFactor_flt( solver, coarsen_cut_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetCoarsenCutFactor_dbl( solver, coarsen_cut_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetCoarsenCutFactor_long_dbl( solver, coarsen_cut_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCoarsenType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *coarsen_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetCoarsenType_flt( solver, coarsen_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetCoarsenType_dbl( solver, coarsen_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetCoarsenType_long_dbl( solver, coarsen_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetConvergeType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetConvergeType_flt( solver, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetConvergeType_dbl( solver, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetConvergeType_long_dbl( solver, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCumNnzAP_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *cum_nnz_AP )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetCumNnzAP_flt( solver, cum_nnz_AP );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetCumNnzAP_dbl( solver, cum_nnz_AP );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetCumNnzAP_long_dbl( solver, cum_nnz_AP );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCumNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *cum_num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetCumNumIterations_flt( solver, cum_num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetCumNumIterations_dbl( solver, cum_num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetCumNumIterations_long_dbl( solver, cum_num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCycleNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_sweeps, HYPRE_Int k )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetCycleNumSweeps_flt( solver, num_sweeps, k );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetCycleNumSweeps_dbl( solver, num_sweeps, k );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetCycleNumSweeps_long_dbl( solver, num_sweeps, k );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCycleRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *relax_type, HYPRE_Int k )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetCycleRelaxType_flt( solver, relax_type, k );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetCycleRelaxType_dbl( solver, relax_type, k );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetCycleRelaxType_long_dbl( solver, relax_type, k );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *cycle_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetCycleType_flt( solver, cycle_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetCycleType_dbl( solver, cycle_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetCycleType_long_dbl( solver, cycle_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetDebugFlag_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *debug_flag )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetDebugFlag_flt( solver, debug_flag );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetDebugFlag_dbl( solver, debug_flag );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetDebugFlag_long_dbl( solver, debug_flag );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetDomainType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *domain_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetDomainType_flt( solver, domain_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetDomainType_dbl( solver, domain_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetDomainType_long_dbl( solver, domain_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetFCycle_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *fcycle )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetFCycle_flt( solver, fcycle );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetFCycle_dbl( solver, fcycle );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetFCycle_long_dbl( solver, fcycle );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetFilterFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *filter_functions )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetFilterFunctions_flt( solver, filter_functions );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetFilterFunctions_dbl( solver, filter_functions );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetFilterFunctions_long_dbl( solver, filter_functions );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetFilterThresholdR_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *filter_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetFilterThresholdR_flt( solver, filter_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetFilterThresholdR_dbl( solver, filter_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetFilterThresholdR_long_dbl( solver, filter_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *rel_resid_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetFinalRelativeResidualNorm_flt( solver, rel_resid_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetFinalRelativeResidualNorm_dbl( solver, rel_resid_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetFinalRelativeResidualNorm_long_dbl( solver, rel_resid_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetGridHierarchy_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *cgrid )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetGridHierarchy_flt( solver, cgrid );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetGridHierarchy_dbl( solver, cgrid );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetGridHierarchy_long_dbl( solver, cgrid );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetJacobiTruncThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *jacobi_trunc_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetJacobiTruncThreshold_flt( solver, jacobi_trunc_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetJacobiTruncThreshold_dbl( solver, jacobi_trunc_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetJacobiTruncThreshold_long_dbl( solver, jacobi_trunc_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMaxCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_coarse_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetMaxCoarseSize_flt( solver, max_coarse_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetMaxCoarseSize_dbl( solver, max_coarse_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetMaxCoarseSize_long_dbl( solver, max_coarse_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMaxLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetMaxLevels_flt( solver, max_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetMaxLevels_dbl( solver, max_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetMaxLevels_long_dbl( solver, max_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMaxRowSum_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *max_row_sum )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetMaxRowSum_flt( solver, max_row_sum );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetMaxRowSum_dbl( solver, max_row_sum );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetMaxRowSum_long_dbl( solver, max_row_sum );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMeasureType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *measure_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetMeasureType_flt( solver, measure_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetMeasureType_dbl( solver, measure_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetMeasureType_long_dbl( solver, measure_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMinCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *min_coarse_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetMinCoarseSize_flt( solver, min_coarse_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetMinCoarseSize_dbl( solver, min_coarse_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetMinCoarseSize_long_dbl( solver, min_coarse_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetMultAdditive_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *mult_additive )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetMultAdditive_flt( solver, mult_additive );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetMultAdditive_dbl( solver, mult_additive );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetMultAdditive_long_dbl( solver, mult_additive );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_functions )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetNumFunctions_flt( solver, num_functions );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetNumFunctions_dbl( solver, num_functions );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetNumFunctions_long_dbl( solver, num_functions );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetOverlap_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *overlap )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetOverlap_flt( solver, overlap );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetOverlap_dbl( solver, overlap );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetOverlap_long_dbl( solver, overlap );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *P_max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetPMaxElmts_flt( solver, P_max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetPMaxElmts_dbl( solver, P_max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetPMaxElmts_long_dbl( solver, P_max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetPostInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *post_interp_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetPostInterpType_flt( solver, post_interp_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetPostInterpType_dbl( solver, post_interp_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetPostInterpType_long_dbl( solver, post_interp_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetRedundant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *redundant )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetRedundant_flt( solver, redundant );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetRedundant_dbl( solver, redundant );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetRedundant_long_dbl( solver, redundant );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSchwarzRlxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *schwarz_rlx_weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetSchwarzRlxWeight_flt( solver, schwarz_rlx_weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetSchwarzRlxWeight_dbl( solver, schwarz_rlx_weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetSchwarzRlxWeight_long_dbl( solver, schwarz_rlx_weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSeqThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *seq_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetSeqThreshold_flt( solver, seq_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetSeqThreshold_dbl( solver, seq_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetSeqThreshold_long_dbl( solver, seq_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSimple_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *simple )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetSimple_flt( solver, simple );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetSimple_dbl( solver, simple );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetSimple_long_dbl( solver, simple );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_num_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetSmoothNumLevels_flt( solver, smooth_num_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetSmoothNumLevels_dbl( solver, smooth_num_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetSmoothNumLevels_long_dbl( solver, smooth_num_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSmoothNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_num_sweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetSmoothNumSweeps_flt( solver, smooth_num_sweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetSmoothNumSweeps_dbl( solver, smooth_num_sweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetSmoothNumSweeps_long_dbl( solver, smooth_num_sweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetSmoothType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetSmoothType_flt( solver, smooth_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetSmoothType_dbl( solver, smooth_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetSmoothType_long_dbl( solver, smooth_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetStrongThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *strong_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetStrongThreshold_flt( solver, strong_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetStrongThreshold_dbl( solver, strong_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetStrongThreshold_long_dbl( solver, strong_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetStrongThresholdR_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *strong_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetStrongThresholdR_flt( solver, strong_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetStrongThresholdR_dbl( solver, strong_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetStrongThresholdR_long_dbl( solver, strong_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *trunc_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetTruncFactor_flt( solver, trunc_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetTruncFactor_dbl( solver, trunc_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetTruncFactor_long_dbl( solver, trunc_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGGetVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *variant )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGGetVariant_flt( solver, variant );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGGetVariant_dbl( solver, variant );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGGetVariant_long_dbl( solver, variant );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGInitGridRelaxation_pre( HYPRE_Precision precision, HYPRE_Int **num_grid_sweeps_ptr, HYPRE_Int **grid_relax_type_ptr, HYPRE_Int ***grid_relax_points_ptr, HYPRE_Int coarsen_type, void *relax_weights_ptr, HYPRE_Int max_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGInitGridRelaxation_flt( num_grid_sweeps_ptr, grid_relax_type_ptr, grid_relax_points_ptr, coarsen_type, relax_weights_ptr, max_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGInitGridRelaxation_dbl( num_grid_sweeps_ptr, grid_relax_type_ptr, grid_relax_points_ptr, coarsen_type, relax_weights_ptr, max_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGInitGridRelaxation_long_dbl( num_grid_sweeps_ptr, grid_relax_type_ptr, grid_relax_points_ptr, coarsen_type, relax_weights_ptr, max_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetADropTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double A_drop_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetADropTol_flt( solver, A_drop_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetADropTol_dbl( solver, A_drop_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetADropTol_long_dbl( solver, A_drop_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetADropType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int A_drop_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetADropType_flt( solver, A_drop_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetADropType_dbl( solver, A_drop_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetADropType_long_dbl( solver, A_drop_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddLastLvl_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int add_last_lvl )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAddLastLvl_flt( solver, add_last_lvl );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAddLastLvl_dbl( solver, add_last_lvl );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAddLastLvl_long_dbl( solver, add_last_lvl );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int add_P_max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAddPMaxElmts_flt( solver, add_P_max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAddPMaxElmts_dbl( solver, add_P_max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAddPMaxElmts_long_dbl( solver, add_P_max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int add_rlx_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAddRelaxType_flt( solver, add_rlx_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAddRelaxType_dbl( solver, add_rlx_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAddRelaxType_long_dbl( solver, add_rlx_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double add_rlx_wt )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAddRelaxWt_flt( solver, add_rlx_wt );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAddRelaxWt_dbl( solver, add_rlx_wt );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAddRelaxWt_long_dbl( solver, add_rlx_wt );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAddTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double add_trunc_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAddTruncFactor_flt( solver, add_trunc_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAddTruncFactor_dbl( solver, add_trunc_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAddTruncFactor_long_dbl( solver, add_trunc_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAdditive_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int addlvl )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAdditive_flt( solver, addlvl );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAdditive_dbl( solver, addlvl );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAdditive_long_dbl( solver, addlvl );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_interp_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAggInterpType_flt( solver, agg_interp_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAggInterpType_dbl( solver, agg_interp_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAggInterpType_long_dbl( solver, agg_interp_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_num_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAggNumLevels_flt( solver, agg_num_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAggNumLevels_dbl( solver, agg_num_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAggNumLevels_long_dbl( solver, agg_num_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggP12MaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_P12_max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAggP12MaxElmts_flt( solver, agg_P12_max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAggP12MaxElmts_dbl( solver, agg_P12_max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAggP12MaxElmts_long_dbl( solver, agg_P12_max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggP12TruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double agg_P12_trunc_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAggP12TruncFactor_flt( solver, agg_P12_trunc_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAggP12TruncFactor_dbl( solver, agg_P12_trunc_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAggP12TruncFactor_long_dbl( solver, agg_P12_trunc_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_P_max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAggPMaxElmts_flt( solver, agg_P_max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAggPMaxElmts_dbl( solver, agg_P_max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAggPMaxElmts_long_dbl( solver, agg_P_max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetAggTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double agg_trunc_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetAggTruncFactor_flt( solver, agg_trunc_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetAggTruncFactor_dbl( solver, agg_trunc_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetAggTruncFactor_long_dbl( solver, agg_trunc_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCGCIts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCGCIts_flt( solver, its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCGCIts_dbl( solver, its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCGCIts_long_dbl( solver, its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCPoints_flt( solver, cpt_coarse_level, num_cpt_coarse, cpt_coarse_index );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCPoints_dbl( solver, cpt_coarse_level, num_cpt_coarse, cpt_coarse_index );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCPoints_long_dbl( solver, cpt_coarse_level, num_cpt_coarse, cpt_coarse_index );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCRRate_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double CR_rate )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCRRate_flt( solver, CR_rate );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCRRate_dbl( solver, CR_rate );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCRRate_long_dbl( solver, CR_rate );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCRStrongTh_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double CR_strong_th )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCRStrongTh_flt( solver, CR_strong_th );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCRStrongTh_dbl( solver, CR_strong_th );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCRStrongTh_long_dbl( solver, CR_strong_th );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCRUseCG_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int CR_use_CG )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCRUseCG_flt( solver, CR_use_CG );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCRUseCG_dbl( solver, CR_use_CG );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCRUseCG_long_dbl( solver, CR_use_CG );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyEigEst_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eig_est )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetChebyEigEst_flt( solver, eig_est );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetChebyEigEst_dbl( solver, eig_est );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetChebyEigEst_long_dbl( solver, eig_est );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyFraction_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double ratio )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetChebyFraction_flt( solver, ratio );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetChebyFraction_dbl( solver, ratio );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetChebyFraction_long_dbl( solver, ratio );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyOrder_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int order )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetChebyOrder_flt( solver, order );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetChebyOrder_dbl( solver, order );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetChebyOrder_long_dbl( solver, order );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyScale_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int scale )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetChebyScale_flt( solver, scale );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetChebyScale_dbl( solver, scale );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetChebyScale_long_dbl( solver, scale );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetChebyVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int variant )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetChebyVariant_flt( solver, variant );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetChebyVariant_dbl( solver, variant );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetChebyVariant_long_dbl( solver, variant );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCoarsenCutFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coarsen_cut_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCoarsenCutFactor_flt( solver, coarsen_cut_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCoarsenCutFactor_dbl( solver, coarsen_cut_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCoarsenCutFactor_long_dbl( solver, coarsen_cut_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCoarsenType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coarsen_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCoarsenType_flt( solver, coarsen_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCoarsenType_dbl( solver, coarsen_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCoarsenType_long_dbl( solver, coarsen_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetConvergeType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetConvergeType_flt( solver, type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetConvergeType_dbl( solver, type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetConvergeType_long_dbl( solver, type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCoordDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coorddim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCoordDim_flt( solver, coorddim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCoordDim_dbl( solver, coorddim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCoordDim_long_dbl( solver, coorddim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCoordinates_pre( HYPRE_Precision precision, HYPRE_Solver solver, float *coordinates )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCoordinates_flt( solver, coordinates );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCoordinates_dbl( solver, coordinates );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCoordinates_long_dbl( solver, coordinates );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCpointsToKeep_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCpointsToKeep_flt( solver, cpt_coarse_level, num_cpt_coarse, cpt_coarse_index );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCpointsToKeep_dbl( solver, cpt_coarse_level, num_cpt_coarse, cpt_coarse_index );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCpointsToKeep_long_dbl( solver, cpt_coarse_level, num_cpt_coarse, cpt_coarse_index );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCumNnzAP_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cum_nnz_AP )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCumNnzAP_flt( solver, cum_nnz_AP );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCumNnzAP_dbl( solver, cum_nnz_AP );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCumNnzAP_long_dbl( solver, cum_nnz_AP );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCycleNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCycleNumSweeps_flt( solver, num_sweeps, k );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCycleNumSweeps_dbl( solver, num_sweeps, k );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCycleNumSweeps_long_dbl( solver, num_sweeps, k );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCycleRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCycleRelaxType_flt( solver, relax_type, k );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCycleRelaxType_dbl( solver, relax_type, k );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCycleRelaxType_long_dbl( solver, relax_type, k );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetCycleType_flt( solver, cycle_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetCycleType_dbl( solver, cycle_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetCycleType_long_dbl( solver, cycle_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetDebugFlag_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int debug_flag )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetDebugFlag_flt( solver, debug_flag );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetDebugFlag_dbl( solver, debug_flag );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetDebugFlag_long_dbl( solver, debug_flag );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetDofFunc_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *dof_func )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetDofFunc_flt( solver, dof_func );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetDofFunc_dbl( solver, dof_func );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetDofFunc_long_dbl( solver, dof_func );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetDomainType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int domain_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetDomainType_flt( solver, domain_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetDomainType_dbl( solver, domain_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetDomainType_long_dbl( solver, domain_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetDropTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double drop_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetDropTol_flt( solver, drop_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetDropTol_dbl( solver, drop_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetDropTol_long_dbl( solver, drop_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetEuBJ_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eu_bj )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetEuBJ_flt( solver, eu_bj );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetEuBJ_dbl( solver, eu_bj );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetEuBJ_long_dbl( solver, eu_bj );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetEuLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eu_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetEuLevel_flt( solver, eu_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetEuLevel_dbl( solver, eu_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetEuLevel_long_dbl( solver, eu_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetEuSparseA_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double eu_sparse_A )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetEuSparseA_flt( solver, eu_sparse_A );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetEuSparseA_dbl( solver, eu_sparse_A );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetEuSparseA_long_dbl( solver, eu_sparse_A );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetEuclidFile_pre( HYPRE_Precision precision, HYPRE_Solver solver, char *euclidfile )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetEuclidFile_flt( solver, euclidfile );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetEuclidFile_dbl( solver, euclidfile );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetEuclidFile_long_dbl( solver, euclidfile );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFCycle_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int fcycle )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFCycle_flt( solver, fcycle );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFCycle_dbl( solver, fcycle );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFCycle_long_dbl( solver, fcycle );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_fpt, HYPRE_BigInt *fpt_index )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFPoints_flt( solver, num_fpt, fpt_index );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFPoints_dbl( solver, num_fpt, fpt_index );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFPoints_long_dbl( solver, num_fpt, fpt_index );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIAlgoType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int algo_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFSAIAlgoType_flt( solver, algo_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFSAIAlgoType_dbl( solver, algo_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFSAIAlgoType_long_dbl( solver, algo_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIEigMaxIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eig_max_iters )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFSAIEigMaxIters_flt( solver, eig_max_iters );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFSAIEigMaxIters_dbl( solver, eig_max_iters );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFSAIEigMaxIters_long_dbl( solver, eig_max_iters );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIKapTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double kap_tolerance )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFSAIKapTolerance_flt( solver, kap_tolerance );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFSAIKapTolerance_dbl( solver, kap_tolerance );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFSAIKapTolerance_long_dbl( solver, kap_tolerance );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAILocalSolveType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int local_solve_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFSAILocalSolveType_flt( solver, local_solve_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFSAILocalSolveType_dbl( solver, local_solve_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFSAILocalSolveType_long_dbl( solver, local_solve_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxNnzRow_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_nnz_row )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFSAIMaxNnzRow_flt( solver, max_nnz_row );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFSAIMaxNnzRow_dbl( solver, max_nnz_row );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFSAIMaxNnzRow_long_dbl( solver, max_nnz_row );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxStepSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_step_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFSAIMaxStepSize_flt( solver, max_step_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFSAIMaxStepSize_dbl( solver, max_step_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFSAIMaxStepSize_long_dbl( solver, max_step_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIMaxSteps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_steps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFSAIMaxSteps_flt( solver, max_steps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFSAIMaxSteps_dbl( solver, max_steps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFSAIMaxSteps_long_dbl( solver, max_steps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAINumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFSAINumLevels_flt( solver, num_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFSAINumLevels_dbl( solver, num_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFSAINumLevels_long_dbl( solver, num_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFSAIThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFSAIThreshold_flt( solver, threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFSAIThreshold_dbl( solver, threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFSAIThreshold_long_dbl( solver, threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFilter_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double filter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFilter_flt( solver, filter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFilter_dbl( solver, filter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFilter_long_dbl( solver, filter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFilterFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int filter_functions )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFilterFunctions_flt( solver, filter_functions );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFilterFunctions_dbl( solver, filter_functions );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFilterFunctions_long_dbl( solver, filter_functions );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetFilterThresholdR_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double filter_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetFilterThresholdR_flt( solver, filter_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetFilterThresholdR_dbl( solver, filter_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetFilterThresholdR_long_dbl( solver, filter_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetGMRESSwitchR_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int gmres_switch )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetGMRESSwitchR_flt( solver, gmres_switch );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetGMRESSwitchR_dbl( solver, gmres_switch );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetGMRESSwitchR_long_dbl( solver, gmres_switch );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetGSMG_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int gsmg )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetGSMG_flt( solver, gsmg );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetGSMG_dbl( solver, gsmg );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetGSMG_long_dbl( solver, gsmg );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int **grid_relax_points )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetGridRelaxPoints_flt( solver, grid_relax_points );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetGridRelaxPoints_dbl( solver, grid_relax_points );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetGridRelaxPoints_long_dbl( solver, grid_relax_points );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetGridRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *grid_relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetGridRelaxType_flt( solver, grid_relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetGridRelaxType_dbl( solver, grid_relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetGridRelaxType_long_dbl( solver, grid_relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUDroptol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double ilu_droptol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUDroptol_flt( solver, ilu_droptol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUDroptol_dbl( solver, ilu_droptol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUDroptol_long_dbl( solver, ilu_droptol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUIterSetupMaxIter_flt( solver, ilu_iter_setup_max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUIterSetupMaxIter_dbl( solver, ilu_iter_setup_max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUIterSetupMaxIter_long_dbl( solver, ilu_iter_setup_max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupOption_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_option )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUIterSetupOption_flt( solver, ilu_iter_setup_option );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUIterSetupOption_dbl( solver, ilu_iter_setup_option );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUIterSetupOption_long_dbl( solver, ilu_iter_setup_option );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double ilu_iter_setup_tolerance )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUIterSetupTolerance_flt( solver, ilu_iter_setup_tolerance );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUIterSetupTolerance_dbl( solver, ilu_iter_setup_tolerance );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUIterSetupTolerance_long_dbl( solver, ilu_iter_setup_tolerance );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUIterSetupType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_iter_setup_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUIterSetupType_flt( solver, ilu_iter_setup_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUIterSetupType_dbl( solver, ilu_iter_setup_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUIterSetupType_long_dbl( solver, ilu_iter_setup_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILULevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_lfil )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILULevel_flt( solver, ilu_lfil );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILULevel_dbl( solver, ilu_lfil );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILULevel_long_dbl( solver, ilu_lfil );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILULocalReordering_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_reordering_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILULocalReordering_flt( solver, ilu_reordering_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILULocalReordering_dbl( solver, ilu_reordering_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILULocalReordering_long_dbl( solver, ilu_reordering_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILULowerJacobiIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_lower_jacobi_iters )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILULowerJacobiIters_flt( solver, ilu_lower_jacobi_iters );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILULowerJacobiIters_dbl( solver, ilu_lower_jacobi_iters );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILULowerJacobiIters_long_dbl( solver, ilu_lower_jacobi_iters );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUMaxIter_flt( solver, ilu_max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUMaxIter_dbl( solver, ilu_max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUMaxIter_long_dbl( solver, ilu_max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUMaxRowNnz_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_max_row_nnz )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUMaxRowNnz_flt( solver, ilu_max_row_nnz );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUMaxRowNnz_dbl( solver, ilu_max_row_nnz );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUMaxRowNnz_long_dbl( solver, ilu_max_row_nnz );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUTriSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_tri_solve )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUTriSolve_flt( solver, ilu_tri_solve );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUTriSolve_dbl( solver, ilu_tri_solve );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUTriSolve_long_dbl( solver, ilu_tri_solve );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUType_flt( solver, ilu_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUType_dbl( solver, ilu_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUType_long_dbl( solver, ilu_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetILUUpperJacobiIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_upper_jacobi_iters )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetILUUpperJacobiIters_flt( solver, ilu_upper_jacobi_iters );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetILUUpperJacobiIters_dbl( solver, ilu_upper_jacobi_iters );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetILUUpperJacobiIters_long_dbl( solver, ilu_upper_jacobi_iters );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetISType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int IS_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetISType_flt( solver, IS_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetISType_dbl( solver, IS_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetISType_long_dbl( solver, IS_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpRefine_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_refine )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetInterpRefine_flt( solver, num_refine );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetInterpRefine_dbl( solver, num_refine );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetInterpRefine_long_dbl( solver, num_refine );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int interp_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetInterpType_flt( solver, interp_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetInterpType_dbl( solver, interp_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetInterpType_long_dbl( solver, interp_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecAbsQTrunc_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double q_trunc )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetInterpVecAbsQTrunc_flt( solver, q_trunc );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetInterpVecAbsQTrunc_dbl( solver, q_trunc );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetInterpVecAbsQTrunc_long_dbl( solver, q_trunc );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecQMax_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int q_max )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetInterpVecQMax_flt( solver, q_max );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetInterpVecQMax_dbl( solver, q_max );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetInterpVecQMax_long_dbl( solver, q_max );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpVecVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int var )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetInterpVecVariant_flt( solver, var );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetInterpVecVariant_dbl( solver, var );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetInterpVecVariant_long_dbl( solver, var );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetInterpVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_vectors, HYPRE_ParVector *interp_vectors )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetInterpVectors_flt( solver, num_vectors, interp_vectors );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetInterpVectors_dbl( solver, num_vectors, interp_vectors );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetInterpVectors_long_dbl( solver, num_vectors, interp_vectors );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetIsTriangular_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int is_triangular )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetIsTriangular_flt( solver, is_triangular );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetIsTriangular_dbl( solver, is_triangular );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetIsTriangular_long_dbl( solver, is_triangular );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetIsolatedFPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_isolated_fpt, HYPRE_BigInt *isolated_fpt_index )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetIsolatedFPoints_flt( solver, num_isolated_fpt, isolated_fpt_index );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetIsolatedFPoints_dbl( solver, num_isolated_fpt, isolated_fpt_index );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetIsolatedFPoints_long_dbl( solver, num_isolated_fpt, isolated_fpt_index );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetJacobiTruncThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double jacobi_trunc_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetJacobiTruncThreshold_flt( solver, jacobi_trunc_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetJacobiTruncThreshold_dbl( solver, jacobi_trunc_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetJacobiTruncThreshold_long_dbl( solver, jacobi_trunc_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetKeepSameSign_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int keep_same_sign )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetKeepSameSign_flt( solver, keep_same_sign );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetKeepSameSign_dbl( solver, keep_same_sign );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetKeepSameSign_long_dbl( solver, keep_same_sign );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetKeepTranspose_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int keepTranspose )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetKeepTranspose_flt( solver, keepTranspose );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetKeepTranspose_dbl( solver, keepTranspose );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetKeepTranspose_long_dbl( solver, keepTranspose );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLevelNonGalerkinTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double nongalerkin_tol, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetLevelNonGalerkinTol_flt( solver, nongalerkin_tol, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetLevelNonGalerkinTol_dbl( solver, nongalerkin_tol, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetLevelNonGalerkinTol_long_dbl( solver, nongalerkin_tol, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLevelOuterWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double omega, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetLevelOuterWt_flt( solver, omega, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetLevelOuterWt_dbl( solver, omega, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetLevelOuterWt_long_dbl( solver, omega, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLevelRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_weight, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetLevelRelaxWt_flt( solver, relax_weight, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetLevelRelaxWt_dbl( solver, relax_weight, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetLevelRelaxWt_long_dbl( solver, relax_weight, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_coarse_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMaxCoarseSize_flt( solver, max_coarse_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMaxCoarseSize_dbl( solver, max_coarse_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMaxCoarseSize_long_dbl( solver, max_coarse_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMaxLevels_flt( solver, max_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMaxLevels_dbl( solver, max_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMaxLevels_long_dbl( solver, max_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxNzPerRow_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_nz_per_row )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMaxNzPerRow_flt( solver, max_nz_per_row );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMaxNzPerRow_dbl( solver, max_nz_per_row );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMaxNzPerRow_long_dbl( solver, max_nz_per_row );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMaxRowSum_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double max_row_sum )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMaxRowSum_flt( solver, max_row_sum );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMaxRowSum_dbl( solver, max_row_sum );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMaxRowSum_long_dbl( solver, max_row_sum );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMeasureType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int measure_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMeasureType_flt( solver, measure_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMeasureType_dbl( solver, measure_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMeasureType_long_dbl( solver, measure_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMinCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_coarse_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMinCoarseSize_flt( solver, min_coarse_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMinCoarseSize_dbl( solver, min_coarse_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMinCoarseSize_long_dbl( solver, min_coarse_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetModuleRAP2_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int mod_rap2 )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetModuleRAP2_flt( solver, mod_rap2 );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetModuleRAP2_dbl( solver, mod_rap2 );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetModuleRAP2_long_dbl( solver, mod_rap2 );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMultAddPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int add_P_max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMultAddPMaxElmts_flt( solver, add_P_max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMultAddPMaxElmts_dbl( solver, add_P_max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMultAddPMaxElmts_long_dbl( solver, add_P_max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMultAddTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double add_trunc_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMultAddTruncFactor_flt( solver, add_trunc_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMultAddTruncFactor_dbl( solver, add_trunc_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMultAddTruncFactor_long_dbl( solver, add_trunc_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetMultAdditive_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int addlvl )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetMultAdditive_flt( solver, addlvl );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetMultAdditive_dbl( solver, addlvl );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetMultAdditive_long_dbl( solver, addlvl );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNodal_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nodal )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNodal_flt( solver, nodal );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNodal_dbl( solver, nodal );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNodal_long_dbl( solver, nodal );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNodalDiag_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nodal_diag )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNodalDiag_flt( solver, nodal_diag );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNodalDiag_dbl( solver, nodal_diag );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNodalDiag_long_dbl( solver, nodal_diag );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNodalLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nodal_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNodalLevels_flt( solver, nodal_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNodalLevels_dbl( solver, nodal_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNodalLevels_long_dbl( solver, nodal_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nongalerk_num_tol, void *nongalerk_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNonGalerkTol_flt( solver, nongalerk_num_tol, nongalerk_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNonGalerkTol_dbl( solver, nongalerk_num_tol, nongalerk_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNonGalerkTol_long_dbl( solver, nongalerk_num_tol, nongalerk_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNonGalerkinTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double nongalerkin_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNonGalerkinTol_flt( solver, nongalerkin_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNonGalerkinTol_dbl( solver, nongalerkin_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNonGalerkinTol_long_dbl( solver, nongalerkin_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumCRRelaxSteps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_CR_relax_steps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNumCRRelaxSteps_flt( solver, num_CR_relax_steps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNumCRRelaxSteps_dbl( solver, num_CR_relax_steps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNumCRRelaxSteps_long_dbl( solver, num_CR_relax_steps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_functions )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNumFunctions_flt( solver, num_functions );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNumFunctions_dbl( solver, num_functions );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNumFunctions_long_dbl( solver, num_functions );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumGridSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNumGridSweeps_flt( solver, num_grid_sweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNumGridSweeps_dbl( solver, num_grid_sweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNumGridSweeps_long_dbl( solver, num_grid_sweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumPaths_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_paths )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNumPaths_flt( solver, num_paths );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNumPaths_dbl( solver, num_paths );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNumPaths_long_dbl( solver, num_paths );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumSamples_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_samples )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNumSamples_flt( solver, num_samples );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNumSamples_dbl( solver, num_samples );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNumSamples_long_dbl( solver, num_samples );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetNumSweeps_flt( solver, num_sweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetNumSweeps_dbl( solver, num_sweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetNumSweeps_long_dbl( solver, num_sweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetOldDefault_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetOldDefault_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetOldDefault_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetOldDefault_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetOmega_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *omega )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetOmega_flt( solver, omega );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetOmega_dbl( solver, omega );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetOmega_long_dbl( solver, omega );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetOuterWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double omega )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetOuterWt_flt( solver, omega );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetOuterWt_dbl( solver, omega );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetOuterWt_long_dbl( solver, omega );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetOverlap_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int overlap )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetOverlap_flt( solver, overlap );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetOverlap_dbl( solver, overlap );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetOverlap_long_dbl( solver, overlap );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int P_max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetPMaxElmts_flt( solver, P_max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetPMaxElmts_dbl( solver, P_max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetPMaxElmts_long_dbl( solver, P_max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPlotFileName_pre( HYPRE_Precision precision, HYPRE_Solver solver, const char *plotfilename )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetPlotFileName_flt( solver, plotfilename );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetPlotFileName_dbl( solver, plotfilename );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetPlotFileName_long_dbl( solver, plotfilename );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPlotGrids_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int plotgrids )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetPlotGrids_flt( solver, plotgrids );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetPlotGrids_dbl( solver, plotgrids );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetPlotGrids_long_dbl( solver, plotgrids );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPostInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int post_interp_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetPostInterpType_flt( solver, post_interp_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetPostInterpType_dbl( solver, post_interp_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetPostInterpType_long_dbl( solver, post_interp_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPrintFileName_pre( HYPRE_Precision precision, HYPRE_Solver solver, const char *print_file_name )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetPrintFileName_flt( solver, print_file_name );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetPrintFileName_dbl( solver, print_file_name );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetPrintFileName_long_dbl( solver, print_file_name );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRAP2_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int rap2 )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetRAP2_flt( solver, rap2 );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetRAP2_dbl( solver, rap2 );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetRAP2_long_dbl( solver, rap2 );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRedundant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int redundant )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetRedundant_flt( solver, redundant );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetRedundant_dbl( solver, redundant );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetRedundant_long_dbl( solver, redundant );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRelaxOrder_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_order )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetRelaxOrder_flt( solver, relax_order );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetRelaxOrder_dbl( solver, relax_order );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetRelaxOrder_long_dbl( solver, relax_order );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetRelaxType_flt( solver, relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetRelaxType_dbl( solver, relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetRelaxType_long_dbl( solver, relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRelaxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *relax_weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetRelaxWeight_flt( solver, relax_weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetRelaxWeight_dbl( solver, relax_weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetRelaxWeight_long_dbl( solver, relax_weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetRelaxWt_flt( solver, relax_weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetRelaxWt_dbl( solver, relax_weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetRelaxWt_long_dbl( solver, relax_weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetRestriction_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int restr_par )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetRestriction_flt( solver, restr_par );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetRestriction_dbl( solver, restr_par );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetRestriction_long_dbl( solver, restr_par );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSCommPkgSwitch_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double S_commpkg_switch )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSCommPkgSwitch_flt( solver, S_commpkg_switch );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSCommPkgSwitch_dbl( solver, S_commpkg_switch );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSCommPkgSwitch_long_dbl( solver, S_commpkg_switch );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSabs_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int Sabs )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSabs_flt( solver, Sabs );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSabs_dbl( solver, Sabs );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSabs_long_dbl( solver, Sabs );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSchwarzRlxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double schwarz_rlx_weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSchwarzRlxWeight_flt( solver, schwarz_rlx_weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSchwarzRlxWeight_dbl( solver, schwarz_rlx_weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSchwarzRlxWeight_long_dbl( solver, schwarz_rlx_weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSchwarzUseNonSymm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int use_nonsymm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSchwarzUseNonSymm_flt( solver, use_nonsymm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSchwarzUseNonSymm_dbl( solver, use_nonsymm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSchwarzUseNonSymm_long_dbl( solver, use_nonsymm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSepWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int sep_weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSepWeight_flt( solver, sep_weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSepWeight_dbl( solver, sep_weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSepWeight_long_dbl( solver, sep_weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSeqThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int seq_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSeqThreshold_flt( solver, seq_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSeqThreshold_dbl( solver, seq_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSeqThreshold_long_dbl( solver, seq_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSetupType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int setup_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSetupType_flt( solver, setup_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSetupType_dbl( solver, setup_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSetupType_long_dbl( solver, setup_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSimple_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int addlvl )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSimple_flt( solver, addlvl );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSimple_dbl( solver, addlvl );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSimple_long_dbl( solver, addlvl );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSmoothInterpVectors_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_interp_vectors )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSmoothInterpVectors_flt( solver, smooth_interp_vectors );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSmoothInterpVectors_dbl( solver, smooth_interp_vectors );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSmoothInterpVectors_long_dbl( solver, smooth_interp_vectors );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_num_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSmoothNumLevels_flt( solver, smooth_num_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSmoothNumLevels_dbl( solver, smooth_num_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSmoothNumLevels_long_dbl( solver, smooth_num_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSmoothNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_num_sweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSmoothNumSweeps_flt( solver, smooth_num_sweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSmoothNumSweeps_dbl( solver, smooth_num_sweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSmoothNumSweeps_long_dbl( solver, smooth_num_sweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSmoothType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSmoothType_flt( solver, smooth_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSmoothType_dbl( solver, smooth_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSmoothType_long_dbl( solver, smooth_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetStrongThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double strong_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetStrongThreshold_flt( solver, strong_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetStrongThreshold_dbl( solver, strong_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetStrongThreshold_long_dbl( solver, strong_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetStrongThresholdR_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double strong_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetStrongThresholdR_flt( solver, strong_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetStrongThresholdR_dbl( solver, strong_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetStrongThresholdR_long_dbl( solver, strong_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetSym_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int sym )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetSym_flt( solver, sym );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetSym_dbl( solver, sym );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetSym_long_dbl( solver, sym );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetThreshold_flt( solver, threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetThreshold_dbl( solver, threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetThreshold_long_dbl( solver, threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double trunc_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetTruncFactor_flt( solver, trunc_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetTruncFactor_dbl( solver, trunc_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetTruncFactor_long_dbl( solver, trunc_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int variant )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetVariant_flt( solver, variant );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetVariant_dbl( solver, variant );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetVariant_long_dbl( solver, variant );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_BoomerAMGSolveT_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_BoomerAMGSolveT_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_BoomerAMGSolveT_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_BoomerAMGSolveT_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetBJ_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int bj )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetBJ_flt( solver, bj );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetBJ_dbl( solver, bj );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetBJ_long_dbl( solver, bj );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetILUT_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double drop_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetILUT_flt( solver, drop_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetILUT_dbl( solver, drop_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetILUT_long_dbl( solver, drop_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetMem_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eu_mem )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetMem_flt( solver, eu_mem );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetMem_dbl( solver, eu_mem );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetMem_long_dbl( solver, eu_mem );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetParams_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int argc, char *argv[] )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetParams_flt( solver, argc, argv );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetParams_dbl( solver, argc, argv );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetParams_long_dbl( solver, argc, argv );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetParamsFromFile_pre( HYPRE_Precision precision, HYPRE_Solver solver, char *filename )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetParamsFromFile_flt( solver, filename );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetParamsFromFile_dbl( solver, filename );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetParamsFromFile_long_dbl( solver, filename );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetRowScale_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int row_scale )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetRowScale_flt( solver, row_scale );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetRowScale_dbl( solver, row_scale );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetRowScale_long_dbl( solver, row_scale );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetSparseA_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double sparse_A )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetSparseA_flt( solver, sparse_A );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetSparseA_dbl( solver, sparse_A );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetSparseA_long_dbl( solver, sparse_A );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetStats_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eu_stats )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetStats_flt( solver, eu_stats );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetStats_dbl( solver, eu_stats );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetStats_long_dbl( solver, eu_stats );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_EuclidSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_EuclidSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_EuclidSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_EuclidSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAICreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAICreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAICreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAICreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAIDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAIDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAIDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAIDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetAlgoType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int algo_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetAlgoType_flt( solver, algo_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetAlgoType_dbl( solver, algo_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetAlgoType_long_dbl( solver, algo_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetEigMaxIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int eig_max_iters )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetEigMaxIters_flt( solver, eig_max_iters );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetEigMaxIters_dbl( solver, eig_max_iters );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetEigMaxIters_long_dbl( solver, eig_max_iters );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetKapTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double kap_tolerance )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetKapTolerance_flt( solver, kap_tolerance );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetKapTolerance_dbl( solver, kap_tolerance );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetKapTolerance_long_dbl( solver, kap_tolerance );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetLocalSolveType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int local_solve_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetLocalSolveType_flt( solver, local_solve_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetLocalSolveType_dbl( solver, local_solve_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetLocalSolveType_long_dbl( solver, local_solve_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetMaxIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetMaxIterations_flt( solver, max_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetMaxIterations_dbl( solver, max_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetMaxIterations_long_dbl( solver, max_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetMaxNnzRow_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_nnz_row )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetMaxNnzRow_flt( solver, max_nnz_row );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetMaxNnzRow_dbl( solver, max_nnz_row );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetMaxNnzRow_long_dbl( solver, max_nnz_row );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetMaxStepSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_step_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetMaxStepSize_flt( solver, max_step_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetMaxStepSize_dbl( solver, max_step_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetMaxStepSize_long_dbl( solver, max_step_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetMaxSteps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_steps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetMaxSteps_flt( solver, max_steps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetMaxSteps_dbl( solver, max_steps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetMaxSteps_long_dbl( solver, max_steps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetNumLevels_flt( solver, num_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetNumLevels_dbl( solver, num_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetNumLevels_long_dbl( solver, num_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetOmega_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double omega )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetOmega_flt( solver, omega );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetOmega_dbl( solver, omega );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetOmega_long_dbl( solver, omega );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetThreshold_flt( solver, threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetThreshold_dbl( solver, threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetThreshold_long_dbl( solver, threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tolerance )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetTolerance_flt( solver, tolerance );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetTolerance_dbl( solver, tolerance );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetTolerance_long_dbl( solver, tolerance );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetZeroGuess_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int zero_guess )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetZeroGuess_flt( solver, zero_guess );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetZeroGuess_dbl( solver, zero_guess );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetZeroGuess_long_dbl( solver, zero_guess );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_FSAISolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_FSAISolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_FSAISolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_FSAISolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUCreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUCreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUCreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *res_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUGetFinalRelativeResidualNorm_flt( solver, res_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUGetFinalRelativeResidualNorm_dbl( solver, res_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUGetFinalRelativeResidualNorm_long_dbl( solver, res_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetDropThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetDropThreshold_flt( solver, threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetDropThreshold_dbl( solver, threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetDropThreshold_long_dbl( solver, threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetDropThresholdArray_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetDropThresholdArray_flt( solver, threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetDropThresholdArray_dbl( solver, threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetDropThresholdArray_long_dbl( solver, threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetIterativeSetupMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int iter_setup_max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetIterativeSetupMaxIter_flt( solver, iter_setup_max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetIterativeSetupMaxIter_dbl( solver, iter_setup_max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetIterativeSetupMaxIter_long_dbl( solver, iter_setup_max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetIterativeSetupOption_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int iter_setup_option )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetIterativeSetupOption_flt( solver, iter_setup_option );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetIterativeSetupOption_dbl( solver, iter_setup_option );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetIterativeSetupOption_long_dbl( solver, iter_setup_option );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetIterativeSetupTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double iter_setup_tolerance )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetIterativeSetupTolerance_flt( solver, iter_setup_tolerance );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetIterativeSetupTolerance_dbl( solver, iter_setup_tolerance );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetIterativeSetupTolerance_long_dbl( solver, iter_setup_tolerance );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetIterativeSetupType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int iter_setup_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetIterativeSetupType_flt( solver, iter_setup_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetIterativeSetupType_dbl( solver, iter_setup_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetIterativeSetupType_long_dbl( solver, iter_setup_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetLevelOfFill_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int lfil )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetLevelOfFill_flt( solver, lfil );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetLevelOfFill_dbl( solver, lfil );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetLevelOfFill_long_dbl( solver, lfil );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetLocalReordering_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int reordering_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetLocalReordering_flt( solver, reordering_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetLocalReordering_dbl( solver, reordering_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetLocalReordering_long_dbl( solver, reordering_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetLowerJacobiIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int lower_jacobi_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetLowerJacobiIters_flt( solver, lower_jacobi_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetLowerJacobiIters_dbl( solver, lower_jacobi_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetLowerJacobiIters_long_dbl( solver, lower_jacobi_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetMaxNnzPerRow_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nzmax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetMaxNnzPerRow_flt( solver, nzmax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetMaxNnzPerRow_dbl( solver, nzmax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetMaxNnzPerRow_long_dbl( solver, nzmax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetNSHDropThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetNSHDropThreshold_flt( solver, threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetNSHDropThreshold_dbl( solver, threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetNSHDropThreshold_long_dbl( solver, threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetNSHDropThresholdArray_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetNSHDropThresholdArray_flt( solver, threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetNSHDropThresholdArray_dbl( solver, threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetNSHDropThresholdArray_long_dbl( solver, threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetSchurMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ss_max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetSchurMaxIter_flt( solver, ss_max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetSchurMaxIter_dbl( solver, ss_max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetSchurMaxIter_long_dbl( solver, ss_max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetTriSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int tri_solve )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetTriSolve_flt( solver, tri_solve );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetTriSolve_dbl( solver, tri_solve );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetTriSolve_long_dbl( solver, tri_solve );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int ilu_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetType_flt( solver, ilu_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetType_dbl( solver, ilu_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetType_long_dbl( solver, ilu_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetUpperJacobiIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int upper_jacobi_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetUpperJacobiIters_flt( solver, upper_jacobi_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetUpperJacobiIters_dbl( solver, upper_jacobi_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetUpperJacobiIters_long_dbl( solver, upper_jacobi_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ILUSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ILUSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ILUSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ILUSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRBuildAff_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix A, HYPRE_Int *CF_marker, HYPRE_Int debug_flag, HYPRE_ParCSRMatrix *A_ff )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRBuildAff_flt( A, CF_marker, debug_flag, A_ff );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRBuildAff_dbl( A, CF_marker, debug_flag, A_ff );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRBuildAff_long_dbl( A, CF_marker, debug_flag, A_ff );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRCreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRCreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRCreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRGetCoarseGridConvergenceFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *conv_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRGetCoarseGridConvergenceFactor_flt( solver, conv_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRGetCoarseGridConvergenceFactor_dbl( solver, conv_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRGetCoarseGridConvergenceFactor_long_dbl( solver, conv_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *res_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRGetFinalRelativeResidualNorm_flt( solver, res_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRGetFinalRelativeResidualNorm_dbl( solver, res_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRGetFinalRelativeResidualNorm_long_dbl( solver, res_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetBlockJacobiBlockSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int blk_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetBlockJacobiBlockSize_flt( solver, blk_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetBlockJacobiBlockSize_dbl( solver, blk_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetBlockJacobiBlockSize_long_dbl( solver, blk_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetBlockSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int bsize )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetBlockSize_flt( solver, bsize );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetBlockSize_dbl( solver, bsize );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetBlockSize_long_dbl( solver, bsize );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCoarseGridMethod_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *cg_method )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetCoarseGridMethod_flt( solver, cg_method );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetCoarseGridMethod_dbl( solver, cg_method );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetCoarseGridMethod_long_dbl( solver, cg_method );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCoarseGridPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetCoarseGridPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetCoarseGridPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetCoarseGridPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCoarseSolver_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn coarse_grid_solver_solve, HYPRE_PtrToParSolverFcn coarse_grid_solver_setup, HYPRE_Solver coarse_grid_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetCoarseSolver_flt( solver, coarse_grid_solver_solve, coarse_grid_solver_setup, coarse_grid_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetCoarseSolver_dbl( solver, coarse_grid_solver_solve, coarse_grid_solver_setup, coarse_grid_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetCoarseSolver_long_dbl( solver, coarse_grid_solver_solve, coarse_grid_solver_setup, coarse_grid_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCpointsByBlock_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetCpointsByBlock_flt( solver, block_size, max_num_levels, num_block_coarse_points, block_coarse_indexes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetCpointsByBlock_dbl( solver, block_size, max_num_levels, num_block_coarse_points, block_coarse_indexes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetCpointsByBlock_long_dbl( solver, block_size, max_num_levels, num_block_coarse_points, block_coarse_indexes );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCpointsByContiguousBlock_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_BigInt *idx_array, HYPRE_Int *num_block_coarse_points, HYPRE_Int **block_coarse_indexes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetCpointsByContiguousBlock_flt( solver, block_size, max_num_levels, idx_array, num_block_coarse_points, block_coarse_indexes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetCpointsByContiguousBlock_dbl( solver, block_size, max_num_levels, idx_array, num_block_coarse_points, block_coarse_indexes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetCpointsByContiguousBlock_long_dbl( solver, block_size, max_num_levels, idx_array, num_block_coarse_points, block_coarse_indexes );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetCpointsByPointMarkerArray_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *num_block_coarse_points, HYPRE_Int **lvl_block_coarse_indexes, HYPRE_Int *point_marker_array )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetCpointsByPointMarkerArray_flt( solver, block_size, max_num_levels, num_block_coarse_points, lvl_block_coarse_indexes, point_marker_array );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetCpointsByPointMarkerArray_dbl( solver, block_size, max_num_levels, num_block_coarse_points, lvl_block_coarse_indexes, point_marker_array );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetCpointsByPointMarkerArray_long_dbl( solver, block_size, max_num_levels, num_block_coarse_points, lvl_block_coarse_indexes, point_marker_array );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetFRelaxMethod_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_method )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetFRelaxMethod_flt( solver, relax_method );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetFRelaxMethod_dbl( solver, relax_method );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetFRelaxMethod_long_dbl( solver, relax_method );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetFSolver_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn fine_grid_solver_solve, HYPRE_PtrToParSolverFcn fine_grid_solver_setup, HYPRE_Solver fsolver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetFSolver_flt( solver, fine_grid_solver_solve, fine_grid_solver_setup, fsolver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetFSolver_dbl( solver, fine_grid_solver_solve, fine_grid_solver_setup, fsolver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetFSolver_long_dbl( solver, fine_grid_solver_solve, fine_grid_solver_setup, fsolver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetFSolverAtLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver fsolver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetFSolverAtLevel_flt( solver, fsolver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetFSolverAtLevel_dbl( solver, fsolver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetFSolverAtLevel_long_dbl( solver, fsolver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetFrelaxPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetFrelaxPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetFrelaxPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetFrelaxPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetGlobalSmoothCycle_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int global_smooth_cycle )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetGlobalSmoothCycle_flt( solver, global_smooth_cycle );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetGlobalSmoothCycle_dbl( solver, global_smooth_cycle );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetGlobalSmoothCycle_long_dbl( solver, global_smooth_cycle );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetGlobalSmoothType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetGlobalSmoothType_flt( solver, smooth_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetGlobalSmoothType_dbl( solver, smooth_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetGlobalSmoothType_long_dbl( solver, smooth_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetGlobalSmootherAtLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver smoother, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetGlobalSmootherAtLevel_flt( solver, smoother, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetGlobalSmootherAtLevel_dbl( solver, smoother, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetGlobalSmootherAtLevel_long_dbl( solver, smoother, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int interp_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetInterpType_flt( solver, interp_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetInterpType_dbl( solver, interp_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetInterpType_long_dbl( solver, interp_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelFRelaxMethod_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *relax_method )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelFRelaxMethod_flt( solver, relax_method );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelFRelaxMethod_dbl( solver, relax_method );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelFRelaxMethod_long_dbl( solver, relax_method );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelFRelaxNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_functions )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelFRelaxNumFunctions_flt( solver, num_functions );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelFRelaxNumFunctions_dbl( solver, num_functions );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelFRelaxNumFunctions_long_dbl( solver, num_functions );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelFRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelFRelaxType_flt( solver, relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelFRelaxType_dbl( solver, relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelFRelaxType_long_dbl( solver, relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *interp_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelInterpType_flt( solver, interp_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelInterpType_dbl( solver, interp_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelInterpType_long_dbl( solver, interp_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelNonGalerkinMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelNonGalerkinMaxElmts_flt( solver, max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelNonGalerkinMaxElmts_dbl( solver, max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelNonGalerkinMaxElmts_long_dbl( solver, max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelNumRelaxSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *nsweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelNumRelaxSweeps_flt( solver, nsweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelNumRelaxSweeps_dbl( solver, nsweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelNumRelaxSweeps_long_dbl( solver, nsweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *P_max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelPMaxElmts_flt( solver, P_max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelPMaxElmts_dbl( solver, P_max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelPMaxElmts_long_dbl( solver, P_max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelRestrictType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *restrict_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelRestrictType_flt( solver, restrict_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelRestrictType_dbl( solver, restrict_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelRestrictType_long_dbl( solver, restrict_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelSmoothIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_iters )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelSmoothIters_flt( solver, smooth_iters );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelSmoothIters_dbl( solver, smooth_iters );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelSmoothIters_long_dbl( solver, smooth_iters );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLevelSmoothType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *smooth_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLevelSmoothType_flt( solver, smooth_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLevelSmoothType_dbl( solver, smooth_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLevelSmoothType_long_dbl( solver, smooth_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetMaxCoarseLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int maxlev )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetMaxCoarseLevels_flt( solver, maxlev );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetMaxCoarseLevels_dbl( solver, maxlev );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetMaxCoarseLevels_long_dbl( solver, maxlev );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetMaxGlobalSmoothIters_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int smooth_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetMaxGlobalSmoothIters_flt( solver, smooth_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetMaxGlobalSmoothIters_dbl( solver, smooth_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetMaxGlobalSmoothIters_long_dbl( solver, smooth_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNonCpointsToFpoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nonCptToFptFlag )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetNonCpointsToFpoints_flt( solver, nonCptToFptFlag );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetNonCpointsToFpoints_dbl( solver, nonCptToFptFlag );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetNonCpointsToFpoints_long_dbl( solver, nonCptToFptFlag );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNonGalerkinMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetNonGalerkinMaxElmts_flt( solver, max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetNonGalerkinMaxElmts_dbl( solver, max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetNonGalerkinMaxElmts_long_dbl( solver, max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNumInterpSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nsweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetNumInterpSweeps_flt( solver, nsweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetNumInterpSweeps_dbl( solver, nsweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetNumInterpSweeps_long_dbl( solver, nsweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNumRelaxSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nsweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetNumRelaxSweeps_flt( solver, nsweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetNumRelaxSweeps_dbl( solver, nsweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetNumRelaxSweeps_long_dbl( solver, nsweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetNumRestrictSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nsweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetNumRestrictSweeps_flt( solver, nsweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetNumRestrictSweeps_dbl( solver, nsweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetNumRestrictSweeps_long_dbl( solver, nsweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int P_max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetPMaxElmts_flt( solver, P_max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetPMaxElmts_dbl( solver, P_max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetPMaxElmts_long_dbl( solver, P_max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetRelaxType_flt( solver, relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetRelaxType_dbl( solver, relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetRelaxType_long_dbl( solver, relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetReservedCoarseNodes_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int reserved_coarse_size, HYPRE_BigInt *reserved_coarse_nodes )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetReservedCoarseNodes_flt( solver, reserved_coarse_size, reserved_coarse_nodes );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetReservedCoarseNodes_dbl( solver, reserved_coarse_size, reserved_coarse_nodes );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetReservedCoarseNodes_long_dbl( solver, reserved_coarse_size, reserved_coarse_nodes );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetReservedCpointsLevelToKeep_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetReservedCpointsLevelToKeep_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetReservedCpointsLevelToKeep_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetReservedCpointsLevelToKeep_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetRestrictType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int restrict_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetRestrictType_flt( solver, restrict_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetRestrictType_dbl( solver, restrict_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetRestrictType_long_dbl( solver, restrict_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetTruncateCoarseGridThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetTruncateCoarseGridThreshold_flt( solver, threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetTruncateCoarseGridThreshold_dbl( solver, threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetTruncateCoarseGridThreshold_long_dbl( solver, threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_MGRSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_MGRSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_MGRSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_MGRSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABGetPrecond_flt( solver, precond_data );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABGetPrecond_dbl( solver, precond_data );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABGetPrecond_long_dbl( solver, precond_data );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSetAbsoluteTol_flt( solver, a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSetAbsoluteTol_dbl( solver, a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSetAbsoluteTol_long_dbl( solver, a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRBiCGSTABSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRBiCGSTABSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRBiCGSTABSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRBiCGSTABSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRGetPrecond_flt( solver, precond_data );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRGetPrecond_dbl( solver, precond_data );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRGetPrecond_long_dbl( solver, precond_data );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precondT, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRSetPrecond_flt( solver, precond, precondT, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRSetPrecond_dbl( solver, precond, precondT, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRSetPrecond_long_dbl( solver, precond, precondT, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCGNRSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCGNRSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCGNRSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCGNRSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESGetPrecond_flt( solver, precond_data );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESGetPrecond_dbl( solver, precond_data );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESGetPrecond_long_dbl( solver, precond_data );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetAbsoluteTol_flt( solver, a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetAbsoluteTol_dbl( solver, a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetAbsoluteTol_long_dbl( solver, a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetCGS_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cgs )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetCGS_flt( solver, cgs );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetCGS_dbl( solver, cgs );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetCGS_long_dbl( solver, cgs );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetUnroll_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int unroll )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetUnroll_flt( solver, unroll );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetUnroll_dbl( solver, unroll );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetUnroll_long_dbl( solver, unroll );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRCOGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRCOGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRCOGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRCOGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRDiagScale_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRDiagScale_flt( solver, HA, Hy, Hx );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRDiagScale_dbl( solver, HA, Hy, Hx );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRDiagScale_long_dbl( solver, HA, Hy, Hx );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRDiagScaleSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector y, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRDiagScaleSetup_flt( solver, A, y, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRDiagScaleSetup_dbl( solver, A, y, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRDiagScaleSetup_long_dbl( solver, A, y, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESGetPrecond_flt( solver, precond_data );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESGetPrecond_dbl( solver, precond_data );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESGetPrecond_long_dbl( solver, precond_data );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetAbsoluteTol_flt( solver, a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetAbsoluteTol_dbl( solver, a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetAbsoluteTol_long_dbl( solver, a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetModifyPC_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetModifyPC_flt( solver, modify_pc );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetModifyPC_dbl( solver, modify_pc );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetModifyPC_long_dbl( solver, modify_pc );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRFlexGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRFlexGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRFlexGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRFlexGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESGetPrecond_flt( solver, precond_data );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESGetPrecond_dbl( solver, precond_data );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESGetPrecond_long_dbl( solver, precond_data );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetRefSolution_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *ref_solution )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESGetRefSolution_flt( solver, ref_solution );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESGetRefSolution_dbl( solver, ref_solution );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESGetRefSolution_long_dbl( solver, ref_solution );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetAbsoluteTol_flt( solver, a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetAbsoluteTol_dbl( solver, a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetAbsoluteTol_long_dbl( solver, a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetRefSolution_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector ref_solution )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetRefSolution_flt( solver, ref_solution );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetRefSolution_dbl( solver, ref_solution );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetRefSolution_long_dbl( solver, ref_solution );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridCreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridCreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridCreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetDSCGNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *dscg_num_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridGetDSCGNumIterations_flt( solver, dscg_num_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridGetDSCGNumIterations_dbl( solver, dscg_num_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridGetDSCGNumIterations_long_dbl( solver, dscg_num_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridGetNumIterations_flt( solver, num_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridGetNumIterations_dbl( solver, num_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridGetNumIterations_long_dbl( solver, num_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetPCGNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *pcg_num_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridGetPCGNumIterations_flt( solver, pcg_num_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridGetPCGNumIterations_dbl( solver, pcg_num_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridGetPCGNumIterations_long_dbl( solver, pcg_num_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *recompute_residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridGetRecomputeResidual_flt( solver, recompute_residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridGetRecomputeResidual_dbl( solver, recompute_residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridGetRecomputeResidual_long_dbl( solver, recompute_residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetRecomputeResidualP_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *recompute_residual_p )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridGetRecomputeResidualP_flt( solver, recompute_residual_p );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridGetRecomputeResidualP_dbl( solver, recompute_residual_p );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridGetRecomputeResidualP_long_dbl( solver, recompute_residual_p );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridGetSetupSolveTime_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *time )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridGetSetupSolveTime_flt( solver, time );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridGetSetupSolveTime_dbl( solver, time );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridGetSetupSolveTime_long_dbl( solver, time );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetAggInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_interp_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetAggInterpType_flt( solver, agg_interp_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetAggInterpType_dbl( solver, agg_interp_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetAggInterpType_long_dbl( solver, agg_interp_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetAggNumLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int agg_num_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetAggNumLevels_flt( solver, agg_num_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetAggNumLevels_dbl( solver, agg_num_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetAggNumLevels_long_dbl( solver, agg_num_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetCoarsenType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int coarsen_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetCoarsenType_flt( solver, coarsen_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetCoarsenType_dbl( solver, coarsen_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetCoarsenType_long_dbl( solver, coarsen_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetConvergenceTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetConvergenceTol_flt( solver, cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetConvergenceTol_dbl( solver, cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetConvergenceTol_long_dbl( solver, cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetCycleNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps, HYPRE_Int k )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetCycleNumSweeps_flt( solver, num_sweeps, k );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetCycleNumSweeps_dbl( solver, num_sweeps, k );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetCycleNumSweeps_long_dbl( solver, num_sweeps, k );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetCycleRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type, HYPRE_Int k )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetCycleRelaxType_flt( solver, relax_type, k );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetCycleRelaxType_dbl( solver, relax_type, k );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetCycleRelaxType_long_dbl( solver, relax_type, k );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetCycleType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int cycle_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetCycleType_flt( solver, cycle_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetCycleType_dbl( solver, cycle_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetCycleType_long_dbl( solver, cycle_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetDSCGMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int dscg_max_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetDSCGMaxIter_flt( solver, dscg_max_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetDSCGMaxIter_dbl( solver, dscg_max_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetDSCGMaxIter_long_dbl( solver, dscg_max_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetDofFunc_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *dof_func )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetDofFunc_flt( solver, dof_func );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetDofFunc_dbl( solver, dof_func );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetDofFunc_long_dbl( solver, dof_func );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxPoints_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int **grid_relax_points )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetGridRelaxPoints_flt( solver, grid_relax_points );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetGridRelaxPoints_dbl( solver, grid_relax_points );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetGridRelaxPoints_long_dbl( solver, grid_relax_points );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetGridRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *grid_relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetGridRelaxType_flt( solver, grid_relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetGridRelaxType_dbl( solver, grid_relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetGridRelaxType_long_dbl( solver, grid_relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetInterpType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int interp_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetInterpType_flt( solver, interp_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetInterpType_dbl( solver, interp_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetInterpType_long_dbl( solver, interp_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetKeepTranspose_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int keepT )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetKeepTranspose_flt( solver, keepT );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetKeepTranspose_dbl( solver, keepT );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetKeepTranspose_long_dbl( solver, keepT );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetLevelOuterWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double outer_wt, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetLevelOuterWt_flt( solver, outer_wt, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetLevelOuterWt_dbl( solver, outer_wt, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetLevelOuterWt_long_dbl( solver, outer_wt, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetLevelRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_wt, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetLevelRelaxWt_flt( solver, relax_wt, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetLevelRelaxWt_dbl( solver, relax_wt, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetLevelRelaxWt_long_dbl( solver, relax_wt, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMaxCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_coarse_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetMaxCoarseSize_flt( solver, max_coarse_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetMaxCoarseSize_dbl( solver, max_coarse_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetMaxCoarseSize_long_dbl( solver, max_coarse_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMaxLevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetMaxLevels_flt( solver, max_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetMaxLevels_dbl( solver, max_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetMaxLevels_long_dbl( solver, max_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMaxRowSum_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double max_row_sum )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetMaxRowSum_flt( solver, max_row_sum );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetMaxRowSum_dbl( solver, max_row_sum );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetMaxRowSum_long_dbl( solver, max_row_sum );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMeasureType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int measure_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetMeasureType_flt( solver, measure_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetMeasureType_dbl( solver, measure_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetMeasureType_long_dbl( solver, measure_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetMinCoarseSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_coarse_size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetMinCoarseSize_flt( solver, min_coarse_size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetMinCoarseSize_dbl( solver, min_coarse_size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetMinCoarseSize_long_dbl( solver, min_coarse_size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNodal_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nodal )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetNodal_flt( solver, nodal );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetNodal_dbl( solver, nodal );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetNodal_long_dbl( solver, nodal );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNonGalerkinTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_levels, void *nongalerkin_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetNonGalerkinTol_flt( solver, num_levels, nongalerkin_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetNonGalerkinTol_dbl( solver, num_levels, nongalerkin_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetNonGalerkinTol_long_dbl( solver, num_levels, nongalerkin_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_functions )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetNumFunctions_flt( solver, num_functions );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetNumFunctions_dbl( solver, num_functions );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetNumFunctions_long_dbl( solver, num_functions );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNumGridSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_grid_sweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetNumGridSweeps_flt( solver, num_grid_sweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetNumGridSweeps_dbl( solver, num_grid_sweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetNumGridSweeps_long_dbl( solver, num_grid_sweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNumPaths_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_paths )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetNumPaths_flt( solver, num_paths );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetNumPaths_dbl( solver, num_paths );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetNumPaths_long_dbl( solver, num_paths );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetNumSweeps_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_sweeps )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetNumSweeps_flt( solver, num_sweeps );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetNumSweeps_dbl( solver, num_sweeps );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetNumSweeps_long_dbl( solver, num_sweeps );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetOmega_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *omega )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetOmega_flt( solver, omega );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetOmega_dbl( solver, omega );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetOmega_long_dbl( solver, omega );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetOuterWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double outer_wt )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetOuterWt_flt( solver, outer_wt );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetOuterWt_dbl( solver, outer_wt );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetOuterWt_long_dbl( solver, outer_wt );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetPCGMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int pcg_max_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetPCGMaxIter_flt( solver, pcg_max_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetPCGMaxIter_dbl( solver, pcg_max_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetPCGMaxIter_long_dbl( solver, pcg_max_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetPMaxElmts_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int P_max_elmts )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetPMaxElmts_flt( solver, P_max_elmts );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetPMaxElmts_dbl( solver, P_max_elmts );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetPMaxElmts_long_dbl( solver, P_max_elmts );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int recompute_residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetRecomputeResidual_flt( solver, recompute_residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetRecomputeResidual_dbl( solver, recompute_residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetRecomputeResidual_long_dbl( solver, recompute_residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRecomputeResidualP_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int recompute_residual_p )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetRecomputeResidualP_flt( solver, recompute_residual_p );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetRecomputeResidualP_dbl( solver, recompute_residual_p );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetRecomputeResidualP_long_dbl( solver, recompute_residual_p );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelChange_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxOrder_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_order )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetRelaxOrder_flt( solver, relax_order );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetRelaxOrder_dbl( solver, relax_order );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetRelaxOrder_long_dbl( solver, relax_order );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetRelaxType_flt( solver, relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetRelaxType_dbl( solver, relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetRelaxType_long_dbl( solver, relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *relax_weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetRelaxWeight_flt( solver, relax_weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetRelaxWeight_dbl( solver, relax_weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetRelaxWeight_long_dbl( solver, relax_weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetRelaxWt_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_wt )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetRelaxWt_flt( solver, relax_wt );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetRelaxWt_dbl( solver, relax_wt );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetRelaxWt_long_dbl( solver, relax_wt );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetSeqThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int seq_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetSeqThreshold_flt( solver, seq_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetSeqThreshold_dbl( solver, seq_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetSeqThreshold_long_dbl( solver, seq_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetSetupType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int setup_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetSetupType_flt( solver, setup_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetSetupType_dbl( solver, setup_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetSetupType_long_dbl( solver, setup_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetSolverType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int solver_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetSolverType_flt( solver, solver_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetSolverType_dbl( solver, solver_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetSolverType_long_dbl( solver, solver_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetStrongThreshold_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double strong_threshold )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetStrongThreshold_flt( solver, strong_threshold );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetStrongThreshold_dbl( solver, strong_threshold );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetStrongThreshold_long_dbl( solver, strong_threshold );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetTruncFactor_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double trunc_factor )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetTruncFactor_flt( solver, trunc_factor );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetTruncFactor_dbl( solver, trunc_factor );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetTruncFactor_long_dbl( solver, trunc_factor );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetTwoNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int two_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetTwoNorm_flt( solver, two_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetTwoNorm_dbl( solver, two_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetTwoNorm_long_dbl( solver, two_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRHybridSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRHybridSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRHybridSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRHybridSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESGetPrecond_flt( solver, precond_data );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESGetPrecond_dbl( solver, precond_data );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESGetPrecond_long_dbl( solver, precond_data );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double a_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetAbsoluteTol_flt( solver, a_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetAbsoluteTol_dbl( solver, a_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetAbsoluteTol_long_dbl( solver, a_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetAugDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int aug_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetAugDim_flt( solver, aug_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetAugDim_dbl( solver, aug_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetAugDim_long_dbl( solver, aug_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetMinIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int min_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetMinIter_flt( solver, min_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetMinIter_dbl( solver, min_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetMinIter_long_dbl( solver, min_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRLGMRESSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRLGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRLGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRLGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMultiVectorPrint_pre( HYPRE_Precision precision, void *x_, const char *fileName )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMultiVectorPrint_flt( x_, fileName );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMultiVectorPrint_dbl( x_, fileName );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMultiVectorPrint_long_dbl( x_, fileName );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

void *
HYPRE_ParCSRMultiVectorRead_pre( HYPRE_Precision precision, MPI_Comm comm, void *ii_, const char *fileName )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMultiVectorRead_flt( comm, ii_, fileName );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMultiVectorRead_dbl( comm, ii_, fileName );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMultiVectorRead_long_dbl( comm, ii_, fileName );
      default:
         { void * value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSROnProcTriSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSROnProcTriSetup_flt( solver, HA, Hy, Hx );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSROnProcTriSetup_dbl( solver, HA, Hy, Hx );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSROnProcTriSetup_long_dbl( solver, HA, Hy, Hx );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSROnProcTriSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix HA, HYPRE_ParVector Hy, HYPRE_ParVector Hx )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSROnProcTriSolve_flt( solver, HA, Hy, Hx );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSROnProcTriSolve_dbl( solver, HA, Hy, Hx );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSROnProcTriSolve_long_dbl( solver, HA, Hy, Hx );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGGetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver *precond_data )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGGetPrecond_flt( solver, precond_data );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGGetPrecond_dbl( solver, precond_data );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGGetPrecond_long_dbl( solver, precond_data );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGGetResidual_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParVector *residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetPrecond_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_PtrToParSolverFcn precond, HYPRE_PtrToParSolverFcn precond_setup, HYPRE_Solver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetPreconditioner_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Solver precond )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetPreconditioner_flt( solver, precond );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetPreconditioner_dbl( solver, precond );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetPreconditioner_long_dbl( solver, precond );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetRelChange_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetStopCrit_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetTol_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetTwoNorm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int two_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetTwoNorm_flt( solver, two_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetTwoNorm_dbl( solver, two_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetTwoNorm_long_dbl( solver, two_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPCGSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPCGSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPCGSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPCGSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetFilter_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double filter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsSetFilter_flt( solver, filter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsSetFilter_dbl( solver, filter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsSetFilter_long_dbl( solver, filter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetLoadbal_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double loadbal )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsSetLoadbal_flt( solver, loadbal );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsSetLoadbal_dbl( solver, loadbal );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsSetLoadbal_long_dbl( solver, loadbal );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetParams_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsSetParams_flt( solver, thresh, nlevels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsSetParams_dbl( solver, thresh, nlevels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsSetParams_long_dbl( solver, thresh, nlevels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetReuse_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int reuse )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsSetReuse_flt( solver, reuse );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsSetReuse_dbl( solver, reuse );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsSetReuse_long_dbl( solver, reuse );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetSym_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int sym )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsSetSym_flt( solver, sym );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsSetSym_dbl( solver, sym );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsSetSym_long_dbl( solver, sym );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRParaSailsSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRParaSailsSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRParaSailsSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRParaSailsSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPilutCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPilutCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPilutCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPilutDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPilutDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPilutDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetDropTolerance_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPilutSetDropTolerance_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPilutSetDropTolerance_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPilutSetDropTolerance_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetFactorRowSize_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int size )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPilutSetFactorRowSize_flt( solver, size );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPilutSetFactorRowSize_dbl( solver, size );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPilutSetFactorRowSize_long_dbl( solver, size );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPilutSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPilutSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPilutSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetMaxIter_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPilutSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPilutSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPilutSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPilutSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPilutSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPilutSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRPilutSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRPilutSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRPilutSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRPilutSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRSetupInterpreter_pre( HYPRE_Precision precision, mv_InterfaceInterpreter *i )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRSetupInterpreter_flt( i );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRSetupInterpreter_dbl( i );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRSetupInterpreter_long_dbl( i );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRSetupMatvec_pre( HYPRE_Precision precision, HYPRE_MatvecFunctions *mv )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRSetupMatvec_flt( mv );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRSetupMatvec_dbl( mv );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRSetupMatvec_long_dbl( mv );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsBuildIJMatrix_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_IJMatrix *pij_A )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsBuildIJMatrix_flt( solver, pij_A );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsBuildIJMatrix_dbl( solver, pij_A );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsBuildIJMatrix_long_dbl( solver, pij_A );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetFilter_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *filter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsGetFilter_flt( solver, filter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsGetFilter_dbl( solver, filter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsGetFilter_long_dbl( solver, filter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetLoadbal_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *loadbal )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsGetLoadbal_flt( solver, loadbal );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsGetLoadbal_dbl( solver, loadbal );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsGetLoadbal_long_dbl( solver, loadbal );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsGetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsGetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsGetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetNlevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *nlevels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsGetNlevels_flt( solver, nlevels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsGetNlevels_dbl( solver, nlevels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsGetNlevels_long_dbl( solver, nlevels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetReuse_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *reuse )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsGetReuse_flt( solver, reuse );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsGetReuse_dbl( solver, reuse );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsGetReuse_long_dbl( solver, reuse );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetSym_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *sym )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsGetSym_flt( solver, sym );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsGetSym_dbl( solver, sym );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsGetSym_long_dbl( solver, sym );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsGetThresh_pre( HYPRE_Precision precision, HYPRE_Solver solver, void *thresh )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsGetThresh_flt( solver, thresh );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsGetThresh_dbl( solver, thresh );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsGetThresh_long_dbl( solver, thresh );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetFilter_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double filter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSetFilter_flt( solver, filter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSetFilter_dbl( solver, filter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSetFilter_long_dbl( solver, filter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetLoadbal_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double loadbal )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSetLoadbal_flt( solver, loadbal );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSetLoadbal_dbl( solver, loadbal );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSetLoadbal_long_dbl( solver, loadbal );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetLogging_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetNlevels_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int nlevels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSetNlevels_flt( solver, nlevels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSetNlevels_dbl( solver, nlevels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSetNlevels_long_dbl( solver, nlevels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetParams_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double thresh, HYPRE_Int nlevels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSetParams_flt( solver, thresh, nlevels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSetParams_dbl( solver, thresh, nlevels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSetParams_long_dbl( solver, thresh, nlevels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetReuse_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int reuse )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSetReuse_flt( solver, reuse );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSetReuse_dbl( solver, reuse );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSetReuse_long_dbl( solver, reuse );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetSym_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int sym )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSetSym_flt( solver, sym );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSetSym_dbl( solver, sym );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSetSym_long_dbl( solver, sym );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetThresh_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double thresh )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSetThresh_flt( solver, thresh );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSetThresh_dbl( solver, thresh );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSetThresh_long_dbl( solver, thresh );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParaSailsSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParaSailsSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParaSailsSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParaSailsSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzCreate_pre( HYPRE_Precision precision, HYPRE_Solver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzCreate_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzCreate_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzCreate_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzDestroy_pre( HYPRE_Precision precision, HYPRE_Solver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetDofFunc_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int *dof_func )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSetDofFunc_flt( solver, dof_func );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSetDofFunc_dbl( solver, dof_func );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSetDofFunc_long_dbl( solver, dof_func );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetDomainStructure_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_CSRMatrix domain_structure )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSetDomainStructure_flt( solver, domain_structure );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSetDomainStructure_dbl( solver, domain_structure );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSetDomainStructure_long_dbl( solver, domain_structure );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetDomainType_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int domain_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSetDomainType_flt( solver, domain_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSetDomainType_dbl( solver, domain_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSetDomainType_long_dbl( solver, domain_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetNonSymm_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int use_nonsymm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSetNonSymm_flt( solver, use_nonsymm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSetNonSymm_dbl( solver, use_nonsymm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSetNonSymm_long_dbl( solver, use_nonsymm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetNumFunctions_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int num_functions )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSetNumFunctions_flt( solver, num_functions );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSetNumFunctions_dbl( solver, num_functions );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSetNumFunctions_long_dbl( solver, num_functions );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetOverlap_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int overlap )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSetOverlap_flt( solver, overlap );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSetOverlap_dbl( solver, overlap );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSetOverlap_long_dbl( solver, overlap );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetRelaxWeight_pre( HYPRE_Precision precision, HYPRE_Solver solver, hypre_long_double relax_weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSetRelaxWeight_flt( solver, relax_weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSetRelaxWeight_dbl( solver, relax_weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSetRelaxWeight_long_dbl( solver, relax_weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetVariant_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_Int variant )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSetVariant_flt( solver, variant );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSetVariant_dbl( solver, variant );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSetVariant_long_dbl( solver, variant );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSetup_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_SchwarzSolve_pre( HYPRE_Precision precision, HYPRE_Solver solver, HYPRE_ParCSRMatrix A, HYPRE_ParVector b, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_SchwarzSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_SchwarzSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_SchwarzSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_TempParCSRSetupInterpreter_pre( HYPRE_Precision precision, mv_InterfaceInterpreter *i )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_TempParCSRSetupInterpreter_flt( i );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_TempParCSRSetupInterpreter_dbl( i );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_TempParCSRSetupInterpreter_long_dbl( i );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

