/* SPDX-FileCopyrightText: 2012 Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Author: Sébastien Wilmet
 */

using Gtk;

public class BottomPanel : Grid
{
    public BottomPanel (Gtex.BuildView build_view, Toolbar toolbar)
    {
        set_orientation (Orientation.HORIZONTAL);

        ScrolledWindow scrolled_window = Utils.add_scrollbar (build_view);

        scrolled_window.expand = true;
        scrolled_window.show_all ();
        scrolled_window.set_shadow_type (ShadowType.IN);
        add (scrolled_window);

        Grid grid = new Grid ();
        grid.orientation = Orientation.VERTICAL;
        grid.add (get_close_button ());

        toolbar.vexpand = true;
        grid.add (toolbar);

        grid.show_all ();
        add (grid);
    }

    private Button get_close_button ()
    {
        Button close_button = Tepl.utils_create_close_button () as Button;
        close_button.tooltip_text = _("Hide panel");
        close_button.margin = 3;

        close_button.clicked.connect (() => this.hide ());

        return close_button;
    }
}
