// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// DO NOT EDIT THIS FILE! IT IS AUTOGENERATED
// FROM /src/coreclr/tools/Common/JitInterface/ThunkGenerator/InstructionSetDesc.txt
// using /src/coreclr/tools/Common/JitInterface/ThunkGenerator/gen.bat

#ifndef CORINFOINSTRUCTIONSET_H
#define CORINFOINSTRUCTIONSET_H

#include "readytoruninstructionset.h"
#include <stdint.h>

enum CORINFO_InstructionSet
{
    InstructionSet_ILLEGAL = 0,
    InstructionSet_NONE = 127,
#ifdef TARGET_ARM64
    InstructionSet_ArmBase=1,
    InstructionSet_AdvSimd=2,
    InstructionSet_Aes=3,
    InstructionSet_Crc32=4,
    InstructionSet_Dp=5,
    InstructionSet_Rdm=6,
    InstructionSet_Sha1=7,
    InstructionSet_Sha256=8,
    InstructionSet_Atomics=9,
    InstructionSet_Vector64=10,
    InstructionSet_Vector128=11,
    InstructionSet_Dczva=12,
    InstructionSet_Rcpc=13,
    InstructionSet_VectorT128=14,
    InstructionSet_Rcpc2=15,
    InstructionSet_Sve=16,
    InstructionSet_ArmBase_Arm64=17,
    InstructionSet_AdvSimd_Arm64=18,
    InstructionSet_Aes_Arm64=19,
    InstructionSet_Crc32_Arm64=20,
    InstructionSet_Dp_Arm64=21,
    InstructionSet_Rdm_Arm64=22,
    InstructionSet_Sha1_Arm64=23,
    InstructionSet_Sha256_Arm64=24,
    InstructionSet_Sve_Arm64=25,
#endif // TARGET_ARM64
#ifdef TARGET_AMD64
    InstructionSet_X86Base=1,
    InstructionSet_SSE=2,
    InstructionSet_SSE2=3,
    InstructionSet_SSE3=4,
    InstructionSet_SSSE3=5,
    InstructionSet_SSE41=6,
    InstructionSet_SSE42=7,
    InstructionSet_AVX=8,
    InstructionSet_AVX2=9,
    InstructionSet_AES=10,
    InstructionSet_BMI1=11,
    InstructionSet_BMI2=12,
    InstructionSet_FMA=13,
    InstructionSet_LZCNT=14,
    InstructionSet_PCLMULQDQ=15,
    InstructionSet_POPCNT=16,
    InstructionSet_Vector128=17,
    InstructionSet_Vector256=18,
    InstructionSet_Vector512=19,
    InstructionSet_AVXVNNI=20,
    InstructionSet_MOVBE=21,
    InstructionSet_X86Serialize=22,
    InstructionSet_EVEX=23,
    InstructionSet_AVX512F=24,
    InstructionSet_AVX512F_VL=25,
    InstructionSet_AVX512BW=26,
    InstructionSet_AVX512BW_VL=27,
    InstructionSet_AVX512CD=28,
    InstructionSet_AVX512CD_VL=29,
    InstructionSet_AVX512DQ=30,
    InstructionSet_AVX512DQ_VL=31,
    InstructionSet_AVX512VBMI=32,
    InstructionSet_AVX512VBMI_VL=33,
    InstructionSet_AVX10v1=34,
    InstructionSet_AVX10v1_V512=35,
    InstructionSet_VectorT128=36,
    InstructionSet_VectorT256=37,
    InstructionSet_VectorT512=38,
    InstructionSet_X86Base_X64=39,
    InstructionSet_SSE_X64=40,
    InstructionSet_SSE2_X64=41,
    InstructionSet_SSE3_X64=42,
    InstructionSet_SSSE3_X64=43,
    InstructionSet_SSE41_X64=44,
    InstructionSet_SSE42_X64=45,
    InstructionSet_AVX_X64=46,
    InstructionSet_AVX2_X64=47,
    InstructionSet_AES_X64=48,
    InstructionSet_BMI1_X64=49,
    InstructionSet_BMI2_X64=50,
    InstructionSet_FMA_X64=51,
    InstructionSet_LZCNT_X64=52,
    InstructionSet_PCLMULQDQ_X64=53,
    InstructionSet_POPCNT_X64=54,
    InstructionSet_AVXVNNI_X64=55,
    InstructionSet_MOVBE_X64=56,
    InstructionSet_X86Serialize_X64=57,
    InstructionSet_EVEX_X64=58,
    InstructionSet_AVX512F_X64=59,
    InstructionSet_AVX512F_VL_X64=60,
    InstructionSet_AVX512BW_X64=61,
    InstructionSet_AVX512BW_VL_X64=62,
    InstructionSet_AVX512CD_X64=63,
    InstructionSet_AVX512CD_VL_X64=64,
    InstructionSet_AVX512DQ_X64=65,
    InstructionSet_AVX512DQ_VL_X64=66,
    InstructionSet_AVX512VBMI_X64=67,
    InstructionSet_AVX512VBMI_VL_X64=68,
    InstructionSet_AVX10v1_X64=69,
    InstructionSet_AVX10v1_V512_X64=70,
#endif // TARGET_AMD64
#ifdef TARGET_X86
    InstructionSet_X86Base=1,
    InstructionSet_SSE=2,
    InstructionSet_SSE2=3,
    InstructionSet_SSE3=4,
    InstructionSet_SSSE3=5,
    InstructionSet_SSE41=6,
    InstructionSet_SSE42=7,
    InstructionSet_AVX=8,
    InstructionSet_AVX2=9,
    InstructionSet_AES=10,
    InstructionSet_BMI1=11,
    InstructionSet_BMI2=12,
    InstructionSet_FMA=13,
    InstructionSet_LZCNT=14,
    InstructionSet_PCLMULQDQ=15,
    InstructionSet_POPCNT=16,
    InstructionSet_Vector128=17,
    InstructionSet_Vector256=18,
    InstructionSet_Vector512=19,
    InstructionSet_AVXVNNI=20,
    InstructionSet_MOVBE=21,
    InstructionSet_X86Serialize=22,
    InstructionSet_EVEX=23,
    InstructionSet_AVX512F=24,
    InstructionSet_AVX512F_VL=25,
    InstructionSet_AVX512BW=26,
    InstructionSet_AVX512BW_VL=27,
    InstructionSet_AVX512CD=28,
    InstructionSet_AVX512CD_VL=29,
    InstructionSet_AVX512DQ=30,
    InstructionSet_AVX512DQ_VL=31,
    InstructionSet_AVX512VBMI=32,
    InstructionSet_AVX512VBMI_VL=33,
    InstructionSet_AVX10v1=34,
    InstructionSet_AVX10v1_V512=35,
    InstructionSet_VectorT128=36,
    InstructionSet_VectorT256=37,
    InstructionSet_VectorT512=38,
    InstructionSet_X86Base_X64=39,
    InstructionSet_SSE_X64=40,
    InstructionSet_SSE2_X64=41,
    InstructionSet_SSE3_X64=42,
    InstructionSet_SSSE3_X64=43,
    InstructionSet_SSE41_X64=44,
    InstructionSet_SSE42_X64=45,
    InstructionSet_AVX_X64=46,
    InstructionSet_AVX2_X64=47,
    InstructionSet_AES_X64=48,
    InstructionSet_BMI1_X64=49,
    InstructionSet_BMI2_X64=50,
    InstructionSet_FMA_X64=51,
    InstructionSet_LZCNT_X64=52,
    InstructionSet_PCLMULQDQ_X64=53,
    InstructionSet_POPCNT_X64=54,
    InstructionSet_AVXVNNI_X64=55,
    InstructionSet_MOVBE_X64=56,
    InstructionSet_X86Serialize_X64=57,
    InstructionSet_EVEX_X64=58,
    InstructionSet_AVX512F_X64=59,
    InstructionSet_AVX512F_VL_X64=60,
    InstructionSet_AVX512BW_X64=61,
    InstructionSet_AVX512BW_VL_X64=62,
    InstructionSet_AVX512CD_X64=63,
    InstructionSet_AVX512CD_VL_X64=64,
    InstructionSet_AVX512DQ_X64=65,
    InstructionSet_AVX512DQ_VL_X64=66,
    InstructionSet_AVX512VBMI_X64=67,
    InstructionSet_AVX512VBMI_VL_X64=68,
    InstructionSet_AVX10v1_X64=69,
    InstructionSet_AVX10v1_V512_X64=70,
#endif // TARGET_X86

};

struct CORINFO_InstructionSetFlags
{
private:
    static const int32_t FlagsFieldCount = 2;
    static const int32_t BitsPerFlagsField = sizeof(uint64_t) * 8;
    uint64_t _flags[FlagsFieldCount] = { };


    static uint32_t GetFlagsFieldIndex(CORINFO_InstructionSet instructionSet)
    {
        uint32_t bitIndex = (uint32_t)instructionSet;
        return (uint32_t)(bitIndex / (uint32_t)BitsPerFlagsField);
    }

    static uint64_t GetRelativeBitMask(CORINFO_InstructionSet instructionSet)
    {
        return ((uint64_t)1) << (instructionSet & 0x3F);
    }

public:

    const int GetInstructionFlagsFieldCount() const
    {
        return FlagsFieldCount;
    }

    void AddInstructionSet(CORINFO_InstructionSet instructionSet)
    {
        uint32_t index = GetFlagsFieldIndex(instructionSet);
        _flags[index] |= GetRelativeBitMask(instructionSet);
    }

    void RemoveInstructionSet(CORINFO_InstructionSet instructionSet)
    {
        uint32_t index = GetFlagsFieldIndex(instructionSet);
        uint64_t bitIndex = GetRelativeBitMask(instructionSet);
        _flags[index] &= ~bitIndex;
    }

    bool HasInstructionSet(CORINFO_InstructionSet instructionSet) const
    {
        uint32_t index = GetFlagsFieldIndex(instructionSet);
        uint64_t bitIndex = GetRelativeBitMask(instructionSet);
        return ((_flags[index] & bitIndex) != 0);
    }

    bool Equals(CORINFO_InstructionSetFlags other) const
    {
        for (int i = 0; i < FlagsFieldCount; i++)
        {
            if (_flags[i] != other._flags[i])
            {
                return false;
            }

        }
        return true;
    }

    void Add(CORINFO_InstructionSetFlags other)
    {
        for (int i = 0; i < FlagsFieldCount; i++)
        {
            _flags[i] |= other._flags[i];
        }
    }

    bool IsEmpty() const
    {
        for (int i = 0; i < FlagsFieldCount; i++)
        {
            if (_flags[i] != 0)
            {
                return false;
            }

        }
        return true;
    }

    void Reset()
    {
        for (int i = 0; i < FlagsFieldCount; i++)
        {
            _flags[i] = 0;
        }
    }

    void Set64BitInstructionSetVariants()
    {
#ifdef TARGET_ARM64
        if (HasInstructionSet(InstructionSet_ArmBase))
            AddInstructionSet(InstructionSet_ArmBase_Arm64);
        if (HasInstructionSet(InstructionSet_AdvSimd))
            AddInstructionSet(InstructionSet_AdvSimd_Arm64);
        if (HasInstructionSet(InstructionSet_Aes))
            AddInstructionSet(InstructionSet_Aes_Arm64);
        if (HasInstructionSet(InstructionSet_Crc32))
            AddInstructionSet(InstructionSet_Crc32_Arm64);
        if (HasInstructionSet(InstructionSet_Dp))
            AddInstructionSet(InstructionSet_Dp_Arm64);
        if (HasInstructionSet(InstructionSet_Rdm))
            AddInstructionSet(InstructionSet_Rdm_Arm64);
        if (HasInstructionSet(InstructionSet_Sha1))
            AddInstructionSet(InstructionSet_Sha1_Arm64);
        if (HasInstructionSet(InstructionSet_Sha256))
            AddInstructionSet(InstructionSet_Sha256_Arm64);
        if (HasInstructionSet(InstructionSet_Sve))
            AddInstructionSet(InstructionSet_Sve_Arm64);
#endif // TARGET_ARM64
#ifdef TARGET_AMD64
        if (HasInstructionSet(InstructionSet_X86Base))
            AddInstructionSet(InstructionSet_X86Base_X64);
        if (HasInstructionSet(InstructionSet_SSE))
            AddInstructionSet(InstructionSet_SSE_X64);
        if (HasInstructionSet(InstructionSet_SSE2))
            AddInstructionSet(InstructionSet_SSE2_X64);
        if (HasInstructionSet(InstructionSet_SSE3))
            AddInstructionSet(InstructionSet_SSE3_X64);
        if (HasInstructionSet(InstructionSet_SSSE3))
            AddInstructionSet(InstructionSet_SSSE3_X64);
        if (HasInstructionSet(InstructionSet_SSE41))
            AddInstructionSet(InstructionSet_SSE41_X64);
        if (HasInstructionSet(InstructionSet_SSE42))
            AddInstructionSet(InstructionSet_SSE42_X64);
        if (HasInstructionSet(InstructionSet_AVX))
            AddInstructionSet(InstructionSet_AVX_X64);
        if (HasInstructionSet(InstructionSet_AVX2))
            AddInstructionSet(InstructionSet_AVX2_X64);
        if (HasInstructionSet(InstructionSet_AES))
            AddInstructionSet(InstructionSet_AES_X64);
        if (HasInstructionSet(InstructionSet_BMI1))
            AddInstructionSet(InstructionSet_BMI1_X64);
        if (HasInstructionSet(InstructionSet_BMI2))
            AddInstructionSet(InstructionSet_BMI2_X64);
        if (HasInstructionSet(InstructionSet_FMA))
            AddInstructionSet(InstructionSet_FMA_X64);
        if (HasInstructionSet(InstructionSet_LZCNT))
            AddInstructionSet(InstructionSet_LZCNT_X64);
        if (HasInstructionSet(InstructionSet_PCLMULQDQ))
            AddInstructionSet(InstructionSet_PCLMULQDQ_X64);
        if (HasInstructionSet(InstructionSet_POPCNT))
            AddInstructionSet(InstructionSet_POPCNT_X64);
        if (HasInstructionSet(InstructionSet_AVXVNNI))
            AddInstructionSet(InstructionSet_AVXVNNI_X64);
        if (HasInstructionSet(InstructionSet_MOVBE))
            AddInstructionSet(InstructionSet_MOVBE_X64);
        if (HasInstructionSet(InstructionSet_X86Serialize))
            AddInstructionSet(InstructionSet_X86Serialize_X64);
        if (HasInstructionSet(InstructionSet_EVEX))
            AddInstructionSet(InstructionSet_EVEX_X64);
        if (HasInstructionSet(InstructionSet_AVX512F))
            AddInstructionSet(InstructionSet_AVX512F_X64);
        if (HasInstructionSet(InstructionSet_AVX512F_VL))
            AddInstructionSet(InstructionSet_AVX512F_VL_X64);
        if (HasInstructionSet(InstructionSet_AVX512BW))
            AddInstructionSet(InstructionSet_AVX512BW_X64);
        if (HasInstructionSet(InstructionSet_AVX512BW_VL))
            AddInstructionSet(InstructionSet_AVX512BW_VL_X64);
        if (HasInstructionSet(InstructionSet_AVX512CD))
            AddInstructionSet(InstructionSet_AVX512CD_X64);
        if (HasInstructionSet(InstructionSet_AVX512CD_VL))
            AddInstructionSet(InstructionSet_AVX512CD_VL_X64);
        if (HasInstructionSet(InstructionSet_AVX512DQ))
            AddInstructionSet(InstructionSet_AVX512DQ_X64);
        if (HasInstructionSet(InstructionSet_AVX512DQ_VL))
            AddInstructionSet(InstructionSet_AVX512DQ_VL_X64);
        if (HasInstructionSet(InstructionSet_AVX512VBMI))
            AddInstructionSet(InstructionSet_AVX512VBMI_X64);
        if (HasInstructionSet(InstructionSet_AVX512VBMI_VL))
            AddInstructionSet(InstructionSet_AVX512VBMI_VL_X64);
        if (HasInstructionSet(InstructionSet_AVX10v1))
            AddInstructionSet(InstructionSet_AVX10v1_X64);
        if (HasInstructionSet(InstructionSet_AVX10v1_V512))
            AddInstructionSet(InstructionSet_AVX10v1_V512_X64);
#endif // TARGET_AMD64
#ifdef TARGET_X86
#endif // TARGET_X86

    }

    uint64_t* GetFlagsRaw()
    {
        return _flags;
    }
};

inline CORINFO_InstructionSetFlags EnsureInstructionSetFlagsAreValid(CORINFO_InstructionSetFlags input)
{
    CORINFO_InstructionSetFlags oldflags = input;
    CORINFO_InstructionSetFlags resultflags = input;
    do
    {
        oldflags = resultflags;
#ifdef TARGET_ARM64
        if (resultflags.HasInstructionSet(InstructionSet_ArmBase) && !resultflags.HasInstructionSet(InstructionSet_ArmBase_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_ArmBase);
        if (resultflags.HasInstructionSet(InstructionSet_ArmBase_Arm64) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_ArmBase_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_AdvSimd) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_AdvSimd);
        if (resultflags.HasInstructionSet(InstructionSet_AdvSimd_Arm64) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_AdvSimd_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Aes) && !resultflags.HasInstructionSet(InstructionSet_Aes_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Aes);
        if (resultflags.HasInstructionSet(InstructionSet_Aes_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Aes))
            resultflags.RemoveInstructionSet(InstructionSet_Aes_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Crc32) && !resultflags.HasInstructionSet(InstructionSet_Crc32_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Crc32);
        if (resultflags.HasInstructionSet(InstructionSet_Crc32_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Crc32))
            resultflags.RemoveInstructionSet(InstructionSet_Crc32_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Dp) && !resultflags.HasInstructionSet(InstructionSet_Dp_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Dp);
        if (resultflags.HasInstructionSet(InstructionSet_Dp_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Dp))
            resultflags.RemoveInstructionSet(InstructionSet_Dp_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Rdm) && !resultflags.HasInstructionSet(InstructionSet_Rdm_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Rdm);
        if (resultflags.HasInstructionSet(InstructionSet_Rdm_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Rdm))
            resultflags.RemoveInstructionSet(InstructionSet_Rdm_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Sha1) && !resultflags.HasInstructionSet(InstructionSet_Sha1_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Sha1);
        if (resultflags.HasInstructionSet(InstructionSet_Sha1_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Sha1))
            resultflags.RemoveInstructionSet(InstructionSet_Sha1_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Sha256) && !resultflags.HasInstructionSet(InstructionSet_Sha256_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Sha256);
        if (resultflags.HasInstructionSet(InstructionSet_Sha256_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Sha256))
            resultflags.RemoveInstructionSet(InstructionSet_Sha256_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_Sve) && !resultflags.HasInstructionSet(InstructionSet_Sve_Arm64))
            resultflags.RemoveInstructionSet(InstructionSet_Sve);
        if (resultflags.HasInstructionSet(InstructionSet_Sve_Arm64) && !resultflags.HasInstructionSet(InstructionSet_Sve))
            resultflags.RemoveInstructionSet(InstructionSet_Sve_Arm64);
        if (resultflags.HasInstructionSet(InstructionSet_AdvSimd) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_AdvSimd);
        if (resultflags.HasInstructionSet(InstructionSet_Aes) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_Aes);
        if (resultflags.HasInstructionSet(InstructionSet_Crc32) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_Crc32);
        if (resultflags.HasInstructionSet(InstructionSet_Dp) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Dp);
        if (resultflags.HasInstructionSet(InstructionSet_Rdm) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Rdm);
        if (resultflags.HasInstructionSet(InstructionSet_Sha1) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_Sha1);
        if (resultflags.HasInstructionSet(InstructionSet_Sha256) && !resultflags.HasInstructionSet(InstructionSet_ArmBase))
            resultflags.RemoveInstructionSet(InstructionSet_Sha256);
        if (resultflags.HasInstructionSet(InstructionSet_Vector64) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Vector64);
        if (resultflags.HasInstructionSet(InstructionSet_Vector128) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Vector128);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT128) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT128);
        if (resultflags.HasInstructionSet(InstructionSet_Sve) && !resultflags.HasInstructionSet(InstructionSet_AdvSimd))
            resultflags.RemoveInstructionSet(InstructionSet_Sve);
#endif // TARGET_ARM64
#ifdef TARGET_AMD64
        if (resultflags.HasInstructionSet(InstructionSet_X86Base) && !resultflags.HasInstructionSet(InstructionSet_X86Base_X64))
            resultflags.RemoveInstructionSet(InstructionSet_X86Base);
        if (resultflags.HasInstructionSet(InstructionSet_X86Base_X64) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_X86Base_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SSE) && !resultflags.HasInstructionSet(InstructionSet_SSE_X64))
            resultflags.RemoveInstructionSet(InstructionSet_SSE);
        if (resultflags.HasInstructionSet(InstructionSet_SSE_X64) && !resultflags.HasInstructionSet(InstructionSet_SSE))
            resultflags.RemoveInstructionSet(InstructionSet_SSE_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SSE2) && !resultflags.HasInstructionSet(InstructionSet_SSE2_X64))
            resultflags.RemoveInstructionSet(InstructionSet_SSE2);
        if (resultflags.HasInstructionSet(InstructionSet_SSE2_X64) && !resultflags.HasInstructionSet(InstructionSet_SSE2))
            resultflags.RemoveInstructionSet(InstructionSet_SSE2_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SSE3) && !resultflags.HasInstructionSet(InstructionSet_SSE3_X64))
            resultflags.RemoveInstructionSet(InstructionSet_SSE3);
        if (resultflags.HasInstructionSet(InstructionSet_SSE3_X64) && !resultflags.HasInstructionSet(InstructionSet_SSE3))
            resultflags.RemoveInstructionSet(InstructionSet_SSE3_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SSSE3) && !resultflags.HasInstructionSet(InstructionSet_SSSE3_X64))
            resultflags.RemoveInstructionSet(InstructionSet_SSSE3);
        if (resultflags.HasInstructionSet(InstructionSet_SSSE3_X64) && !resultflags.HasInstructionSet(InstructionSet_SSSE3))
            resultflags.RemoveInstructionSet(InstructionSet_SSSE3_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SSE41) && !resultflags.HasInstructionSet(InstructionSet_SSE41_X64))
            resultflags.RemoveInstructionSet(InstructionSet_SSE41);
        if (resultflags.HasInstructionSet(InstructionSet_SSE41_X64) && !resultflags.HasInstructionSet(InstructionSet_SSE41))
            resultflags.RemoveInstructionSet(InstructionSet_SSE41_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SSE42) && !resultflags.HasInstructionSet(InstructionSet_SSE42_X64))
            resultflags.RemoveInstructionSet(InstructionSet_SSE42);
        if (resultflags.HasInstructionSet(InstructionSet_SSE42_X64) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_SSE42_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX) && !resultflags.HasInstructionSet(InstructionSet_AVX_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX);
        if (resultflags.HasInstructionSet(InstructionSet_AVX_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX2) && !resultflags.HasInstructionSet(InstructionSet_AVX2_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX2);
        if (resultflags.HasInstructionSet(InstructionSet_AVX2_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVX2_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AES) && !resultflags.HasInstructionSet(InstructionSet_AES_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AES);
        if (resultflags.HasInstructionSet(InstructionSet_AES_X64) && !resultflags.HasInstructionSet(InstructionSet_AES))
            resultflags.RemoveInstructionSet(InstructionSet_AES_X64);
        if (resultflags.HasInstructionSet(InstructionSet_BMI1) && !resultflags.HasInstructionSet(InstructionSet_BMI1_X64))
            resultflags.RemoveInstructionSet(InstructionSet_BMI1);
        if (resultflags.HasInstructionSet(InstructionSet_BMI1_X64) && !resultflags.HasInstructionSet(InstructionSet_BMI1))
            resultflags.RemoveInstructionSet(InstructionSet_BMI1_X64);
        if (resultflags.HasInstructionSet(InstructionSet_BMI2) && !resultflags.HasInstructionSet(InstructionSet_BMI2_X64))
            resultflags.RemoveInstructionSet(InstructionSet_BMI2);
        if (resultflags.HasInstructionSet(InstructionSet_BMI2_X64) && !resultflags.HasInstructionSet(InstructionSet_BMI2))
            resultflags.RemoveInstructionSet(InstructionSet_BMI2_X64);
        if (resultflags.HasInstructionSet(InstructionSet_FMA) && !resultflags.HasInstructionSet(InstructionSet_FMA_X64))
            resultflags.RemoveInstructionSet(InstructionSet_FMA);
        if (resultflags.HasInstructionSet(InstructionSet_FMA_X64) && !resultflags.HasInstructionSet(InstructionSet_FMA))
            resultflags.RemoveInstructionSet(InstructionSet_FMA_X64);
        if (resultflags.HasInstructionSet(InstructionSet_LZCNT) && !resultflags.HasInstructionSet(InstructionSet_LZCNT_X64))
            resultflags.RemoveInstructionSet(InstructionSet_LZCNT);
        if (resultflags.HasInstructionSet(InstructionSet_LZCNT_X64) && !resultflags.HasInstructionSet(InstructionSet_LZCNT))
            resultflags.RemoveInstructionSet(InstructionSet_LZCNT_X64);
        if (resultflags.HasInstructionSet(InstructionSet_PCLMULQDQ) && !resultflags.HasInstructionSet(InstructionSet_PCLMULQDQ_X64))
            resultflags.RemoveInstructionSet(InstructionSet_PCLMULQDQ);
        if (resultflags.HasInstructionSet(InstructionSet_PCLMULQDQ_X64) && !resultflags.HasInstructionSet(InstructionSet_PCLMULQDQ))
            resultflags.RemoveInstructionSet(InstructionSet_PCLMULQDQ_X64);
        if (resultflags.HasInstructionSet(InstructionSet_POPCNT) && !resultflags.HasInstructionSet(InstructionSet_POPCNT_X64))
            resultflags.RemoveInstructionSet(InstructionSet_POPCNT);
        if (resultflags.HasInstructionSet(InstructionSet_POPCNT_X64) && !resultflags.HasInstructionSet(InstructionSet_POPCNT))
            resultflags.RemoveInstructionSet(InstructionSet_POPCNT_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNI) && !resultflags.HasInstructionSet(InstructionSet_AVXVNNI_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNI);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNI_X64) && !resultflags.HasInstructionSet(InstructionSet_AVXVNNI))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNI_X64);
        if (resultflags.HasInstructionSet(InstructionSet_MOVBE) && !resultflags.HasInstructionSet(InstructionSet_MOVBE_X64))
            resultflags.RemoveInstructionSet(InstructionSet_MOVBE);
        if (resultflags.HasInstructionSet(InstructionSet_MOVBE_X64) && !resultflags.HasInstructionSet(InstructionSet_MOVBE))
            resultflags.RemoveInstructionSet(InstructionSet_MOVBE_X64);
        if (resultflags.HasInstructionSet(InstructionSet_X86Serialize) && !resultflags.HasInstructionSet(InstructionSet_X86Serialize_X64))
            resultflags.RemoveInstructionSet(InstructionSet_X86Serialize);
        if (resultflags.HasInstructionSet(InstructionSet_X86Serialize_X64) && !resultflags.HasInstructionSet(InstructionSet_X86Serialize))
            resultflags.RemoveInstructionSet(InstructionSet_X86Serialize_X64);
        if (resultflags.HasInstructionSet(InstructionSet_EVEX) && !resultflags.HasInstructionSet(InstructionSet_EVEX_X64))
            resultflags.RemoveInstructionSet(InstructionSet_EVEX);
        if (resultflags.HasInstructionSet(InstructionSet_EVEX_X64) && !resultflags.HasInstructionSet(InstructionSet_EVEX))
            resultflags.RemoveInstructionSet(InstructionSet_EVEX_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512F) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512F);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512F_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512F_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512F_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512F_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512F_VL_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512F_VL_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW_VL_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD_VL_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ_VL_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI_VL_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_X64);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512_X64))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512_X64) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512_X64);
        if (resultflags.HasInstructionSet(InstructionSet_SSE) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_SSE);
        if (resultflags.HasInstructionSet(InstructionSet_SSE2) && !resultflags.HasInstructionSet(InstructionSet_SSE))
            resultflags.RemoveInstructionSet(InstructionSet_SSE2);
        if (resultflags.HasInstructionSet(InstructionSet_SSE3) && !resultflags.HasInstructionSet(InstructionSet_SSE2))
            resultflags.RemoveInstructionSet(InstructionSet_SSE3);
        if (resultflags.HasInstructionSet(InstructionSet_SSSE3) && !resultflags.HasInstructionSet(InstructionSet_SSE3))
            resultflags.RemoveInstructionSet(InstructionSet_SSSE3);
        if (resultflags.HasInstructionSet(InstructionSet_SSE41) && !resultflags.HasInstructionSet(InstructionSet_SSSE3))
            resultflags.RemoveInstructionSet(InstructionSet_SSE41);
        if (resultflags.HasInstructionSet(InstructionSet_SSE42) && !resultflags.HasInstructionSet(InstructionSet_SSE41))
            resultflags.RemoveInstructionSet(InstructionSet_SSE42);
        if (resultflags.HasInstructionSet(InstructionSet_POPCNT) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_POPCNT);
        if (resultflags.HasInstructionSet(InstructionSet_AVX) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_AVX);
        if (resultflags.HasInstructionSet(InstructionSet_AVX2) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX2);
        if (resultflags.HasInstructionSet(InstructionSet_BMI1) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_BMI1);
        if (resultflags.HasInstructionSet(InstructionSet_BMI2) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_BMI2);
        if (resultflags.HasInstructionSet(InstructionSet_FMA) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_FMA);
        if (resultflags.HasInstructionSet(InstructionSet_LZCNT) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_LZCNT);
        if (resultflags.HasInstructionSet(InstructionSet_MOVBE) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_MOVBE);
        if (resultflags.HasInstructionSet(InstructionSet_EVEX) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_EVEX);
        if (resultflags.HasInstructionSet(InstructionSet_EVEX) && !resultflags.HasInstructionSet(InstructionSet_FMA))
            resultflags.RemoveInstructionSet(InstructionSet_EVEX);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512F) && !resultflags.HasInstructionSet(InstructionSet_EVEX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512F);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512F_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512F_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AES) && !resultflags.HasInstructionSet(InstructionSet_SSE2))
            resultflags.RemoveInstructionSet(InstructionSet_AES);
        if (resultflags.HasInstructionSet(InstructionSet_PCLMULQDQ) && !resultflags.HasInstructionSet(InstructionSet_SSE2))
            resultflags.RemoveInstructionSet(InstructionSet_PCLMULQDQ);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNI) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNI);
        if (resultflags.HasInstructionSet(InstructionSet_X86Serialize) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_X86Serialize);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1) && !resultflags.HasInstructionSet(InstructionSet_EVEX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_Vector128) && !resultflags.HasInstructionSet(InstructionSet_SSE))
            resultflags.RemoveInstructionSet(InstructionSet_Vector128);
        if (resultflags.HasInstructionSet(InstructionSet_Vector256) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_Vector256);
        if (resultflags.HasInstructionSet(InstructionSet_Vector512) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_Vector512);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT128) && !resultflags.HasInstructionSet(InstructionSet_SSE2))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT128);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT256) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT256);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT512) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT512);
#endif // TARGET_AMD64
#ifdef TARGET_X86
        if (resultflags.HasInstructionSet(InstructionSet_SSE) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_SSE);
        if (resultflags.HasInstructionSet(InstructionSet_SSE2) && !resultflags.HasInstructionSet(InstructionSet_SSE))
            resultflags.RemoveInstructionSet(InstructionSet_SSE2);
        if (resultflags.HasInstructionSet(InstructionSet_SSE3) && !resultflags.HasInstructionSet(InstructionSet_SSE2))
            resultflags.RemoveInstructionSet(InstructionSet_SSE3);
        if (resultflags.HasInstructionSet(InstructionSet_SSSE3) && !resultflags.HasInstructionSet(InstructionSet_SSE3))
            resultflags.RemoveInstructionSet(InstructionSet_SSSE3);
        if (resultflags.HasInstructionSet(InstructionSet_SSE41) && !resultflags.HasInstructionSet(InstructionSet_SSSE3))
            resultflags.RemoveInstructionSet(InstructionSet_SSE41);
        if (resultflags.HasInstructionSet(InstructionSet_SSE42) && !resultflags.HasInstructionSet(InstructionSet_SSE41))
            resultflags.RemoveInstructionSet(InstructionSet_SSE42);
        if (resultflags.HasInstructionSet(InstructionSet_POPCNT) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_POPCNT);
        if (resultflags.HasInstructionSet(InstructionSet_AVX) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_AVX);
        if (resultflags.HasInstructionSet(InstructionSet_AVX2) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX2);
        if (resultflags.HasInstructionSet(InstructionSet_BMI1) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_BMI1);
        if (resultflags.HasInstructionSet(InstructionSet_BMI2) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_BMI2);
        if (resultflags.HasInstructionSet(InstructionSet_FMA) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_FMA);
        if (resultflags.HasInstructionSet(InstructionSet_LZCNT) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_LZCNT);
        if (resultflags.HasInstructionSet(InstructionSet_MOVBE) && !resultflags.HasInstructionSet(InstructionSet_SSE42))
            resultflags.RemoveInstructionSet(InstructionSet_MOVBE);
        if (resultflags.HasInstructionSet(InstructionSet_EVEX) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_EVEX);
        if (resultflags.HasInstructionSet(InstructionSet_EVEX) && !resultflags.HasInstructionSet(InstructionSet_FMA))
            resultflags.RemoveInstructionSet(InstructionSet_EVEX);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512F) && !resultflags.HasInstructionSet(InstructionSet_EVEX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512F);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512F_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512F_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512BW_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512CD_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512DQ_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX512VBMI_VL);
        if (resultflags.HasInstructionSet(InstructionSet_AES) && !resultflags.HasInstructionSet(InstructionSet_SSE2))
            resultflags.RemoveInstructionSet(InstructionSet_AES);
        if (resultflags.HasInstructionSet(InstructionSet_PCLMULQDQ) && !resultflags.HasInstructionSet(InstructionSet_SSE2))
            resultflags.RemoveInstructionSet(InstructionSet_PCLMULQDQ);
        if (resultflags.HasInstructionSet(InstructionSet_AVXVNNI) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_AVXVNNI);
        if (resultflags.HasInstructionSet(InstructionSet_X86Serialize) && !resultflags.HasInstructionSet(InstructionSet_X86Base))
            resultflags.RemoveInstructionSet(InstructionSet_X86Serialize);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1) && !resultflags.HasInstructionSet(InstructionSet_EVEX))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX10v1))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512F_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512CD_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512BW_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512DQ_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_AVX10v1_V512) && !resultflags.HasInstructionSet(InstructionSet_AVX512VBMI_VL))
            resultflags.RemoveInstructionSet(InstructionSet_AVX10v1_V512);
        if (resultflags.HasInstructionSet(InstructionSet_Vector128) && !resultflags.HasInstructionSet(InstructionSet_SSE))
            resultflags.RemoveInstructionSet(InstructionSet_Vector128);
        if (resultflags.HasInstructionSet(InstructionSet_Vector256) && !resultflags.HasInstructionSet(InstructionSet_AVX))
            resultflags.RemoveInstructionSet(InstructionSet_Vector256);
        if (resultflags.HasInstructionSet(InstructionSet_Vector512) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_Vector512);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT128) && !resultflags.HasInstructionSet(InstructionSet_SSE2))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT128);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT256) && !resultflags.HasInstructionSet(InstructionSet_AVX2))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT256);
        if (resultflags.HasInstructionSet(InstructionSet_VectorT512) && !resultflags.HasInstructionSet(InstructionSet_AVX512F))
            resultflags.RemoveInstructionSet(InstructionSet_VectorT512);
#endif // TARGET_X86

    } while (!oldflags.Equals(resultflags));
    return resultflags;
}

inline const char *InstructionSetToString(CORINFO_InstructionSet instructionSet)
{
#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable: 4065) // disable warning for switch statement with only default label.
#endif

    switch (instructionSet)
    {
#ifdef TARGET_ARM64
        case InstructionSet_ArmBase :
            return "ArmBase";
        case InstructionSet_ArmBase_Arm64 :
            return "ArmBase_Arm64";
        case InstructionSet_AdvSimd :
            return "AdvSimd";
        case InstructionSet_AdvSimd_Arm64 :
            return "AdvSimd_Arm64";
        case InstructionSet_Aes :
            return "Aes";
        case InstructionSet_Aes_Arm64 :
            return "Aes_Arm64";
        case InstructionSet_Crc32 :
            return "Crc32";
        case InstructionSet_Crc32_Arm64 :
            return "Crc32_Arm64";
        case InstructionSet_Dp :
            return "Dp";
        case InstructionSet_Dp_Arm64 :
            return "Dp_Arm64";
        case InstructionSet_Rdm :
            return "Rdm";
        case InstructionSet_Rdm_Arm64 :
            return "Rdm_Arm64";
        case InstructionSet_Sha1 :
            return "Sha1";
        case InstructionSet_Sha1_Arm64 :
            return "Sha1_Arm64";
        case InstructionSet_Sha256 :
            return "Sha256";
        case InstructionSet_Sha256_Arm64 :
            return "Sha256_Arm64";
        case InstructionSet_Atomics :
            return "Atomics";
        case InstructionSet_Vector64 :
            return "Vector64";
        case InstructionSet_Vector128 :
            return "Vector128";
        case InstructionSet_Dczva :
            return "Dczva";
        case InstructionSet_Rcpc :
            return "Rcpc";
        case InstructionSet_VectorT128 :
            return "VectorT128";
        case InstructionSet_Rcpc2 :
            return "Rcpc2";
        case InstructionSet_Sve :
            return "Sve";
        case InstructionSet_Sve_Arm64 :
            return "Sve_Arm64";
#endif // TARGET_ARM64
#ifdef TARGET_AMD64
        case InstructionSet_X86Base :
            return "X86Base";
        case InstructionSet_X86Base_X64 :
            return "X86Base_X64";
        case InstructionSet_SSE :
            return "SSE";
        case InstructionSet_SSE_X64 :
            return "SSE_X64";
        case InstructionSet_SSE2 :
            return "SSE2";
        case InstructionSet_SSE2_X64 :
            return "SSE2_X64";
        case InstructionSet_SSE3 :
            return "SSE3";
        case InstructionSet_SSE3_X64 :
            return "SSE3_X64";
        case InstructionSet_SSSE3 :
            return "SSSE3";
        case InstructionSet_SSSE3_X64 :
            return "SSSE3_X64";
        case InstructionSet_SSE41 :
            return "SSE41";
        case InstructionSet_SSE41_X64 :
            return "SSE41_X64";
        case InstructionSet_SSE42 :
            return "SSE42";
        case InstructionSet_SSE42_X64 :
            return "SSE42_X64";
        case InstructionSet_AVX :
            return "AVX";
        case InstructionSet_AVX_X64 :
            return "AVX_X64";
        case InstructionSet_AVX2 :
            return "AVX2";
        case InstructionSet_AVX2_X64 :
            return "AVX2_X64";
        case InstructionSet_AES :
            return "AES";
        case InstructionSet_AES_X64 :
            return "AES_X64";
        case InstructionSet_BMI1 :
            return "BMI1";
        case InstructionSet_BMI1_X64 :
            return "BMI1_X64";
        case InstructionSet_BMI2 :
            return "BMI2";
        case InstructionSet_BMI2_X64 :
            return "BMI2_X64";
        case InstructionSet_FMA :
            return "FMA";
        case InstructionSet_FMA_X64 :
            return "FMA_X64";
        case InstructionSet_LZCNT :
            return "LZCNT";
        case InstructionSet_LZCNT_X64 :
            return "LZCNT_X64";
        case InstructionSet_PCLMULQDQ :
            return "PCLMULQDQ";
        case InstructionSet_PCLMULQDQ_X64 :
            return "PCLMULQDQ_X64";
        case InstructionSet_POPCNT :
            return "POPCNT";
        case InstructionSet_POPCNT_X64 :
            return "POPCNT_X64";
        case InstructionSet_Vector128 :
            return "Vector128";
        case InstructionSet_Vector256 :
            return "Vector256";
        case InstructionSet_Vector512 :
            return "Vector512";
        case InstructionSet_AVXVNNI :
            return "AVXVNNI";
        case InstructionSet_AVXVNNI_X64 :
            return "AVXVNNI_X64";
        case InstructionSet_MOVBE :
            return "MOVBE";
        case InstructionSet_MOVBE_X64 :
            return "MOVBE_X64";
        case InstructionSet_X86Serialize :
            return "X86Serialize";
        case InstructionSet_X86Serialize_X64 :
            return "X86Serialize_X64";
        case InstructionSet_EVEX :
            return "EVEX";
        case InstructionSet_EVEX_X64 :
            return "EVEX_X64";
        case InstructionSet_AVX512F :
            return "AVX512F";
        case InstructionSet_AVX512F_X64 :
            return "AVX512F_X64";
        case InstructionSet_AVX512F_VL :
            return "AVX512F_VL";
        case InstructionSet_AVX512F_VL_X64 :
            return "AVX512F_VL_X64";
        case InstructionSet_AVX512BW :
            return "AVX512BW";
        case InstructionSet_AVX512BW_X64 :
            return "AVX512BW_X64";
        case InstructionSet_AVX512BW_VL :
            return "AVX512BW_VL";
        case InstructionSet_AVX512BW_VL_X64 :
            return "AVX512BW_VL_X64";
        case InstructionSet_AVX512CD :
            return "AVX512CD";
        case InstructionSet_AVX512CD_X64 :
            return "AVX512CD_X64";
        case InstructionSet_AVX512CD_VL :
            return "AVX512CD_VL";
        case InstructionSet_AVX512CD_VL_X64 :
            return "AVX512CD_VL_X64";
        case InstructionSet_AVX512DQ :
            return "AVX512DQ";
        case InstructionSet_AVX512DQ_X64 :
            return "AVX512DQ_X64";
        case InstructionSet_AVX512DQ_VL :
            return "AVX512DQ_VL";
        case InstructionSet_AVX512DQ_VL_X64 :
            return "AVX512DQ_VL_X64";
        case InstructionSet_AVX512VBMI :
            return "AVX512VBMI";
        case InstructionSet_AVX512VBMI_X64 :
            return "AVX512VBMI_X64";
        case InstructionSet_AVX512VBMI_VL :
            return "AVX512VBMI_VL";
        case InstructionSet_AVX512VBMI_VL_X64 :
            return "AVX512VBMI_VL_X64";
        case InstructionSet_AVX10v1 :
            return "AVX10v1";
        case InstructionSet_AVX10v1_X64 :
            return "AVX10v1_X64";
        case InstructionSet_AVX10v1_V512 :
            return "AVX10v1_V512";
        case InstructionSet_AVX10v1_V512_X64 :
            return "AVX10v1_V512_X64";
        case InstructionSet_VectorT128 :
            return "VectorT128";
        case InstructionSet_VectorT256 :
            return "VectorT256";
        case InstructionSet_VectorT512 :
            return "VectorT512";
#endif // TARGET_AMD64
#ifdef TARGET_X86
        case InstructionSet_X86Base :
            return "X86Base";
        case InstructionSet_SSE :
            return "SSE";
        case InstructionSet_SSE2 :
            return "SSE2";
        case InstructionSet_SSE3 :
            return "SSE3";
        case InstructionSet_SSSE3 :
            return "SSSE3";
        case InstructionSet_SSE41 :
            return "SSE41";
        case InstructionSet_SSE42 :
            return "SSE42";
        case InstructionSet_AVX :
            return "AVX";
        case InstructionSet_AVX2 :
            return "AVX2";
        case InstructionSet_AES :
            return "AES";
        case InstructionSet_BMI1 :
            return "BMI1";
        case InstructionSet_BMI2 :
            return "BMI2";
        case InstructionSet_FMA :
            return "FMA";
        case InstructionSet_LZCNT :
            return "LZCNT";
        case InstructionSet_PCLMULQDQ :
            return "PCLMULQDQ";
        case InstructionSet_POPCNT :
            return "POPCNT";
        case InstructionSet_Vector128 :
            return "Vector128";
        case InstructionSet_Vector256 :
            return "Vector256";
        case InstructionSet_Vector512 :
            return "Vector512";
        case InstructionSet_AVXVNNI :
            return "AVXVNNI";
        case InstructionSet_MOVBE :
            return "MOVBE";
        case InstructionSet_X86Serialize :
            return "X86Serialize";
        case InstructionSet_EVEX :
            return "EVEX";
        case InstructionSet_AVX512F :
            return "AVX512F";
        case InstructionSet_AVX512F_VL :
            return "AVX512F_VL";
        case InstructionSet_AVX512BW :
            return "AVX512BW";
        case InstructionSet_AVX512BW_VL :
            return "AVX512BW_VL";
        case InstructionSet_AVX512CD :
            return "AVX512CD";
        case InstructionSet_AVX512CD_VL :
            return "AVX512CD_VL";
        case InstructionSet_AVX512DQ :
            return "AVX512DQ";
        case InstructionSet_AVX512DQ_VL :
            return "AVX512DQ_VL";
        case InstructionSet_AVX512VBMI :
            return "AVX512VBMI";
        case InstructionSet_AVX512VBMI_VL :
            return "AVX512VBMI_VL";
        case InstructionSet_AVX10v1 :
            return "AVX10v1";
        case InstructionSet_AVX10v1_V512 :
            return "AVX10v1_V512";
        case InstructionSet_VectorT128 :
            return "VectorT128";
        case InstructionSet_VectorT256 :
            return "VectorT256";
        case InstructionSet_VectorT512 :
            return "VectorT512";
#endif // TARGET_X86

        default:
            return "UnknownInstructionSet";
    }
#ifdef _MSC_VER
#pragma warning(pop)
#endif
}

inline CORINFO_InstructionSet InstructionSetFromR2RInstructionSet(ReadyToRunInstructionSet r2rSet)
{
#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable: 4065) // disable warning for switch statement with only default label.
#endif

    switch (r2rSet)
    {
#ifdef TARGET_ARM64
        case READYTORUN_INSTRUCTION_ArmBase: return InstructionSet_ArmBase;
        case READYTORUN_INSTRUCTION_AdvSimd: return InstructionSet_AdvSimd;
        case READYTORUN_INSTRUCTION_Aes: return InstructionSet_Aes;
        case READYTORUN_INSTRUCTION_Crc32: return InstructionSet_Crc32;
        case READYTORUN_INSTRUCTION_Dp: return InstructionSet_Dp;
        case READYTORUN_INSTRUCTION_Rdm: return InstructionSet_Rdm;
        case READYTORUN_INSTRUCTION_Sha1: return InstructionSet_Sha1;
        case READYTORUN_INSTRUCTION_Sha256: return InstructionSet_Sha256;
        case READYTORUN_INSTRUCTION_Atomics: return InstructionSet_Atomics;
        case READYTORUN_INSTRUCTION_Rcpc: return InstructionSet_Rcpc;
        case READYTORUN_INSTRUCTION_VectorT128: return InstructionSet_VectorT128;
        case READYTORUN_INSTRUCTION_Rcpc2: return InstructionSet_Rcpc2;
        case READYTORUN_INSTRUCTION_Sve: return InstructionSet_Sve;
#endif // TARGET_ARM64
#ifdef TARGET_AMD64
        case READYTORUN_INSTRUCTION_X86Base: return InstructionSet_X86Base;
        case READYTORUN_INSTRUCTION_Sse: return InstructionSet_SSE;
        case READYTORUN_INSTRUCTION_Sse2: return InstructionSet_SSE2;
        case READYTORUN_INSTRUCTION_Sse3: return InstructionSet_SSE3;
        case READYTORUN_INSTRUCTION_Ssse3: return InstructionSet_SSSE3;
        case READYTORUN_INSTRUCTION_Sse41: return InstructionSet_SSE41;
        case READYTORUN_INSTRUCTION_Sse42: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Avx: return InstructionSet_AVX;
        case READYTORUN_INSTRUCTION_Avx2: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Aes: return InstructionSet_AES;
        case READYTORUN_INSTRUCTION_Bmi1: return InstructionSet_BMI1;
        case READYTORUN_INSTRUCTION_Bmi2: return InstructionSet_BMI2;
        case READYTORUN_INSTRUCTION_Fma: return InstructionSet_FMA;
        case READYTORUN_INSTRUCTION_Lzcnt: return InstructionSet_LZCNT;
        case READYTORUN_INSTRUCTION_Pclmulqdq: return InstructionSet_PCLMULQDQ;
        case READYTORUN_INSTRUCTION_Popcnt: return InstructionSet_POPCNT;
        case READYTORUN_INSTRUCTION_AvxVnni: return InstructionSet_AVXVNNI;
        case READYTORUN_INSTRUCTION_Movbe: return InstructionSet_MOVBE;
        case READYTORUN_INSTRUCTION_X86Serialize: return InstructionSet_X86Serialize;
        case READYTORUN_INSTRUCTION_EVEX: return InstructionSet_EVEX;
        case READYTORUN_INSTRUCTION_Avx512F: return InstructionSet_AVX512F;
        case READYTORUN_INSTRUCTION_Avx512F_VL: return InstructionSet_AVX512F_VL;
        case READYTORUN_INSTRUCTION_Avx512BW: return InstructionSet_AVX512BW;
        case READYTORUN_INSTRUCTION_Avx512BW_VL: return InstructionSet_AVX512BW_VL;
        case READYTORUN_INSTRUCTION_Avx512CD: return InstructionSet_AVX512CD;
        case READYTORUN_INSTRUCTION_Avx512CD_VL: return InstructionSet_AVX512CD_VL;
        case READYTORUN_INSTRUCTION_Avx512DQ: return InstructionSet_AVX512DQ;
        case READYTORUN_INSTRUCTION_Avx512DQ_VL: return InstructionSet_AVX512DQ_VL;
        case READYTORUN_INSTRUCTION_Avx512Vbmi: return InstructionSet_AVX512VBMI;
        case READYTORUN_INSTRUCTION_Avx512Vbmi_VL: return InstructionSet_AVX512VBMI_VL;
        case READYTORUN_INSTRUCTION_Avx10v1: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx10v1_V512: return InstructionSet_AVX10v1_V512;
        case READYTORUN_INSTRUCTION_VectorT128: return InstructionSet_VectorT128;
        case READYTORUN_INSTRUCTION_VectorT256: return InstructionSet_VectorT256;
        case READYTORUN_INSTRUCTION_VectorT512: return InstructionSet_VectorT512;
#endif // TARGET_AMD64
#ifdef TARGET_X86
        case READYTORUN_INSTRUCTION_X86Base: return InstructionSet_X86Base;
        case READYTORUN_INSTRUCTION_Sse: return InstructionSet_SSE;
        case READYTORUN_INSTRUCTION_Sse2: return InstructionSet_SSE2;
        case READYTORUN_INSTRUCTION_Sse3: return InstructionSet_SSE3;
        case READYTORUN_INSTRUCTION_Ssse3: return InstructionSet_SSSE3;
        case READYTORUN_INSTRUCTION_Sse41: return InstructionSet_SSE41;
        case READYTORUN_INSTRUCTION_Sse42: return InstructionSet_SSE42;
        case READYTORUN_INSTRUCTION_Avx: return InstructionSet_AVX;
        case READYTORUN_INSTRUCTION_Avx2: return InstructionSet_AVX2;
        case READYTORUN_INSTRUCTION_Aes: return InstructionSet_AES;
        case READYTORUN_INSTRUCTION_Bmi1: return InstructionSet_BMI1;
        case READYTORUN_INSTRUCTION_Bmi2: return InstructionSet_BMI2;
        case READYTORUN_INSTRUCTION_Fma: return InstructionSet_FMA;
        case READYTORUN_INSTRUCTION_Lzcnt: return InstructionSet_LZCNT;
        case READYTORUN_INSTRUCTION_Pclmulqdq: return InstructionSet_PCLMULQDQ;
        case READYTORUN_INSTRUCTION_Popcnt: return InstructionSet_POPCNT;
        case READYTORUN_INSTRUCTION_AvxVnni: return InstructionSet_AVXVNNI;
        case READYTORUN_INSTRUCTION_Movbe: return InstructionSet_MOVBE;
        case READYTORUN_INSTRUCTION_X86Serialize: return InstructionSet_X86Serialize;
        case READYTORUN_INSTRUCTION_EVEX: return InstructionSet_EVEX;
        case READYTORUN_INSTRUCTION_Avx512F: return InstructionSet_AVX512F;
        case READYTORUN_INSTRUCTION_Avx512F_VL: return InstructionSet_AVX512F_VL;
        case READYTORUN_INSTRUCTION_Avx512BW: return InstructionSet_AVX512BW;
        case READYTORUN_INSTRUCTION_Avx512BW_VL: return InstructionSet_AVX512BW_VL;
        case READYTORUN_INSTRUCTION_Avx512CD: return InstructionSet_AVX512CD;
        case READYTORUN_INSTRUCTION_Avx512CD_VL: return InstructionSet_AVX512CD_VL;
        case READYTORUN_INSTRUCTION_Avx512DQ: return InstructionSet_AVX512DQ;
        case READYTORUN_INSTRUCTION_Avx512DQ_VL: return InstructionSet_AVX512DQ_VL;
        case READYTORUN_INSTRUCTION_Avx512Vbmi: return InstructionSet_AVX512VBMI;
        case READYTORUN_INSTRUCTION_Avx512Vbmi_VL: return InstructionSet_AVX512VBMI_VL;
        case READYTORUN_INSTRUCTION_Avx10v1: return InstructionSet_AVX10v1;
        case READYTORUN_INSTRUCTION_Avx10v1_V512: return InstructionSet_AVX10v1_V512;
        case READYTORUN_INSTRUCTION_VectorT128: return InstructionSet_VectorT128;
        case READYTORUN_INSTRUCTION_VectorT256: return InstructionSet_VectorT256;
        case READYTORUN_INSTRUCTION_VectorT512: return InstructionSet_VectorT512;
#endif // TARGET_X86

        default:
            return InstructionSet_ILLEGAL;
    }
#ifdef _MSC_VER
#pragma warning(pop)
#endif
}

#endif // CORINFOINSTRUCTIONSET_H
