---
name: Internal Compiler Error
about: Create a report for an internal compiler error in Clippy.
labels: L-bug, L-crash
---
<!--
Thank you for finding an Internal Compiler Error! 🧊  If possible, try to provide
a minimal verifiable example. You can read "Rust Bug Minimization Patterns" for
how to create smaller examples.

http://blog.pnkfx.org/blog/2019/11/18/rust-bug-minimization-patterns/

-->

### Code

```rust
<code>
```

### Meta

- `cargo clippy -V`: e.g. clippy 0.0.212 (f455e46 2020-06-20)
- `rustc -Vv`:
  ```
  rustc 1.46.0-nightly (f455e46ea 2020-06-20)
  binary: rustc
  commit-hash: f455e46eae1a227d735091091144601b467e1565
  commit-date: 2020-06-20
  host: x86_64-unknown-linux-gnu
  release: 1.46.0-nightly
  LLVM version: 10.0
  ```

### Error output

```
<output>
```

<!--
Include a backtrace in the code block by setting `RUST_BACKTRACE=1` in your
environment. E.g. `RUST_BACKTRACE=1 cargo clippy`.
-->
<details><summary>Backtrace</summary>
  <p>
  
  ```
  <backtrace>
  ```
  
  </p>
</details>
