/* pwl.c generated by valac 0.56.17, the Vala compiler
 * generated from pwl.vala, do not modify */

/* enchant
 * Copyright (C) 2003, 2004 Dom Lachowicz
 * Copyright (C) 2016-2024 Reuben Thomas <rrt@sc3d.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib.h>
#include <stdio.h>
#include <sys/file.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include <sys/types.h>
#include <gobject/gvaluecollector.h>

#define BOM ((gunichar) 0xfeff)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ENCHANT_PWL (enchant_pwl_get_type ())
#define ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENCHANT_PWL, EnchantPWL))
#define ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENCHANT_PWL, EnchantPWLClass))
#define IS_ENCHANT_PWL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENCHANT_PWL))
#define IS_ENCHANT_PWL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENCHANT_PWL))
#define ENCHANT_PWL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENCHANT_PWL, EnchantPWLClass))

typedef struct _EnchantPWL EnchantPWL;
typedef struct _EnchantPWLClass EnchantPWLClass;
typedef struct _EnchantPWLPrivate EnchantPWLPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecEnchantPWL ParamSpecEnchantPWL;

struct _EnchantPWL {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EnchantPWLPrivate * priv;
	gchar* filename;
	GHashTable* words;
};

struct _EnchantPWLClass {
	GTypeClass parent_class;
	void (*finalize) (EnchantPWL *self);
};

struct _ParamSpecEnchantPWL {
	GParamSpec parent_instance;
};

static gpointer enchant_pwl_parent_class = NULL;

VALA_EXTERN void lock_file (FILE* f);
VALA_EXTERN void unlock_file (FILE* f);
VALA_EXTERN gchar* utf8_strtitle (const gchar* str);
VALA_EXTERN gboolean is_all_caps (const gchar* word);
VALA_EXTERN gboolean is_title_case (const gchar* word);
VALA_EXTERN gpointer enchant_pwl_ref (gpointer instance);
VALA_EXTERN void enchant_pwl_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_enchant_pwl (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_enchant_pwl (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_enchant_pwl (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_enchant_pwl (const GValue* value);
VALA_EXTERN GType enchant_pwl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EnchantPWL, enchant_pwl_unref)
static EnchantPWL* enchant_pwl_new (void);
static EnchantPWL* enchant_pwl_construct (GType object_type);
VALA_EXTERN EnchantPWL* enchant_pwl_init (void);
static void _g_free0_ (gpointer var);
VALA_EXTERN EnchantPWL* enchant_pwl_init_with_file (const gchar* file);
static void enchant_pwl_refresh_from_file (EnchantPWL* self);
static void enchant_pwl_add_to_table (EnchantPWL* self,
                               const gchar* word);
VALA_EXTERN void enchant_pwl_add (EnchantPWL* self,
                      const gchar* word_buf,
                      ssize_t len);
VALA_EXTERN gchar* buf_to_utf8_string (const gchar* str_buf,
                           gssize len);
VALA_EXTERN void enchant_pwl_remove (EnchantPWL* self,
                         const gchar* word_buf,
                         ssize_t len);
VALA_EXTERN gint enchant_pwl_check (EnchantPWL* self,
                        const gchar* word_buf,
                        ssize_t len);
static void enchant_pwl_finalize (EnchantPWL * obj);
static GType enchant_pwl_get_type_once (void);

void
lock_file (FILE* f)
{
#line 41 "pwl.vala"
	g_return_if_fail (f != NULL);
#line 42 "pwl.vala"
	flock (fileno (f), LOCK_EX);
#line 147 "pwl.c"
}

void
unlock_file (FILE* f)
{
#line 45 "pwl.vala"
	g_return_if_fail (f != NULL);
#line 46 "pwl.vala"
	flock (fileno (f), LOCK_UN);
#line 157 "pwl.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 171 "pwl.c"
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1122 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 1122 "glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 1123 "glib-2.0.vapi"
	g_unichar_to_utf8 (self, str);
#line 1124 "glib-2.0.vapi"
	result = str;
#line 1124 "glib-2.0.vapi"
	return result;
#line 190 "pwl.c"
}

gchar*
utf8_strtitle (const gchar* str)
{
	gchar* upper_str = NULL;
	gchar* _tmp0_;
	gchar* lower_tail = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gunichar title_case_char = 0U;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
#line 49 "pwl.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 50 "pwl.vala"
	_tmp0_ = g_utf8_strup (str, (gssize) -1);
#line 50 "pwl.vala"
	upper_str = _tmp0_;
#line 51 "pwl.vala"
	_tmp1_ = g_utf8_next_char (upper_str);
#line 51 "pwl.vala"
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) -1);
#line 51 "pwl.vala"
	lower_tail = _tmp2_;
#line 52 "pwl.vala"
	title_case_char = g_unichar_totitle (string_get_char (upper_str, (glong) 0));
#line 53 "pwl.vala"
	_tmp3_ = g_unichar_to_string (title_case_char);
#line 53 "pwl.vala"
	_tmp4_ = _tmp3_;
#line 53 "pwl.vala"
	_tmp5_ = g_strdup_printf ("%s%s", _tmp4_, lower_tail);
#line 53 "pwl.vala"
	_tmp6_ = _tmp5_;
#line 53 "pwl.vala"
	_g_free0 (_tmp4_);
#line 53 "pwl.vala"
	result = _tmp6_;
#line 53 "pwl.vala"
	_g_free0 (lower_tail);
#line 53 "pwl.vala"
	_g_free0 (upper_str);
#line 53 "pwl.vala"
	return result;
#line 239 "pwl.c"
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
#line 1302 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1303 "glib-2.0.vapi"
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1304 "glib-2.0.vapi"
	if (_vala_c != ((gunichar) 0)) {
#line 255 "pwl.c"
		gchar* _tmp0_;
#line 1305 "glib-2.0.vapi"
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
#line 1305 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1306 "glib-2.0.vapi"
		result = TRUE;
#line 1306 "glib-2.0.vapi"
		if (c) {
#line 1306 "glib-2.0.vapi"
			*c = _vala_c;
#line 267 "pwl.c"
		}
#line 1306 "glib-2.0.vapi"
		return result;
#line 271 "pwl.c"
	} else {
#line 1308 "glib-2.0.vapi"
		result = FALSE;
#line 1308 "glib-2.0.vapi"
		if (c) {
#line 1308 "glib-2.0.vapi"
			*c = _vala_c;
#line 279 "pwl.c"
		}
#line 1308 "glib-2.0.vapi"
		return result;
#line 283 "pwl.c"
	}
}

gboolean
is_all_caps (const gchar* word)
{
	gboolean has_cap = FALSE;
	gunichar c = 0U;
	gboolean result;
#line 56 "pwl.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 57 "pwl.vala"
	has_cap = FALSE;
#line 297 "pwl.c"
	{
		gint i = 0;
#line 59 "pwl.vala"
		i = 0;
#line 302 "pwl.c"
		{
			gboolean _tmp0_ = FALSE;
#line 59 "pwl.vala"
			_tmp0_ = TRUE;
#line 59 "pwl.vala"
			while (TRUE) {
#line 309 "pwl.c"
				gunichar _tmp1_ = 0U;
				gboolean _tmp2_;
				GUnicodeType type = 0;
#line 59 "pwl.vala"
				if (!_tmp0_) {
#line 315 "pwl.c"
				}
#line 59 "pwl.vala"
				_tmp0_ = FALSE;
#line 59 "pwl.vala"
				_tmp2_ = string_get_next_char (word, &i, &_tmp1_);
#line 59 "pwl.vala"
				c = _tmp1_;
#line 59 "pwl.vala"
				if (!_tmp2_) {
#line 59 "pwl.vala"
					break;
#line 327 "pwl.c"
				}
#line 60 "pwl.vala"
				type = g_unichar_type (c);
#line 61 "pwl.vala"
				switch (type) {
#line 61 "pwl.vala"
					case G_UNICODE_UPPERCASE_LETTER:
#line 335 "pwl.c"
					{
#line 63 "pwl.vala"
						has_cap = TRUE;
#line 64 "pwl.vala"
						break;
#line 341 "pwl.c"
					}
#line 61 "pwl.vala"
					case G_UNICODE_TITLECASE_LETTER:
#line 61 "pwl.vala"
					case G_UNICODE_LOWERCASE_LETTER:
#line 347 "pwl.c"
					{
#line 67 "pwl.vala"
						result = FALSE;
#line 67 "pwl.vala"
						return result;
#line 353 "pwl.c"
					}
					default:
#line 61 "pwl.vala"
					case G_UNICODE_CONTROL:
#line 61 "pwl.vala"
					case G_UNICODE_FORMAT:
#line 61 "pwl.vala"
					case G_UNICODE_UNASSIGNED:
#line 61 "pwl.vala"
					case G_UNICODE_PRIVATE_USE:
#line 61 "pwl.vala"
					case G_UNICODE_SURROGATE:
#line 61 "pwl.vala"
					case G_UNICODE_MODIFIER_LETTER:
#line 61 "pwl.vala"
					case G_UNICODE_OTHER_LETTER:
#line 61 "pwl.vala"
					case G_UNICODE_COMBINING_MARK:
#line 61 "pwl.vala"
					case G_UNICODE_ENCLOSING_MARK:
#line 61 "pwl.vala"
					case G_UNICODE_NON_SPACING_MARK:
#line 61 "pwl.vala"
					case G_UNICODE_DECIMAL_NUMBER:
#line 61 "pwl.vala"
					case G_UNICODE_LETTER_NUMBER:
#line 61 "pwl.vala"
					case G_UNICODE_OTHER_NUMBER:
#line 61 "pwl.vala"
					case G_UNICODE_CONNECT_PUNCTUATION:
#line 61 "pwl.vala"
					case G_UNICODE_DASH_PUNCTUATION:
#line 61 "pwl.vala"
					case G_UNICODE_CLOSE_PUNCTUATION:
#line 61 "pwl.vala"
					case G_UNICODE_FINAL_PUNCTUATION:
#line 61 "pwl.vala"
					case G_UNICODE_INITIAL_PUNCTUATION:
#line 61 "pwl.vala"
					case G_UNICODE_OTHER_PUNCTUATION:
#line 61 "pwl.vala"
					case G_UNICODE_OPEN_PUNCTUATION:
#line 61 "pwl.vala"
					case G_UNICODE_CURRENCY_SYMBOL:
#line 61 "pwl.vala"
					case G_UNICODE_MODIFIER_SYMBOL:
#line 61 "pwl.vala"
					case G_UNICODE_MATH_SYMBOL:
#line 61 "pwl.vala"
					case G_UNICODE_OTHER_SYMBOL:
#line 61 "pwl.vala"
					case G_UNICODE_LINE_SEPARATOR:
#line 61 "pwl.vala"
					case G_UNICODE_PARAGRAPH_SEPARATOR:
#line 61 "pwl.vala"
					case G_UNICODE_SPACE_SEPARATOR:
#line 410 "pwl.c"
					{
#line 97 "pwl.vala"
						break;
#line 414 "pwl.c"
					}
				}
			}
		}
	}
#line 101 "pwl.vala"
	result = has_cap;
#line 101 "pwl.vala"
	return result;
#line 424 "pwl.c"
}

gboolean
is_title_case (const gchar* word)
{
	gint i = 0;
	gunichar c = 0U;
	gunichar _tmp0_ = 0U;
	GUnicodeType type = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
#line 104 "pwl.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 105 "pwl.vala"
	i = 0;
#line 107 "pwl.vala"
	string_get_next_char (word, &i, &_tmp0_);
#line 107 "pwl.vala"
	c = _tmp0_;
#line 108 "pwl.vala"
	type = g_unichar_type (c);
#line 109 "pwl.vala"
	if (type != G_UNICODE_UPPERCASE_LETTER) {
#line 109 "pwl.vala"
		_tmp2_ = type != G_UNICODE_TITLECASE_LETTER;
#line 451 "pwl.c"
	} else {
#line 109 "pwl.vala"
		_tmp2_ = FALSE;
#line 455 "pwl.c"
	}
#line 109 "pwl.vala"
	if (_tmp2_) {
#line 109 "pwl.vala"
		_tmp1_ = TRUE;
#line 461 "pwl.c"
	} else {
#line 110 "pwl.vala"
		_tmp1_ = c != g_unichar_totitle (c);
#line 465 "pwl.c"
	}
#line 109 "pwl.vala"
	if (_tmp1_) {
#line 111 "pwl.vala"
		result = FALSE;
#line 111 "pwl.vala"
		return result;
#line 473 "pwl.c"
	}
#line 113 "pwl.vala"
	while (TRUE) {
#line 477 "pwl.c"
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		gboolean _tmp5_ = FALSE;
#line 113 "pwl.vala"
		_tmp4_ = string_get_next_char (word, &i, &_tmp3_);
#line 113 "pwl.vala"
		c = _tmp3_;
#line 113 "pwl.vala"
		if (!_tmp4_) {
#line 113 "pwl.vala"
			break;
#line 489 "pwl.c"
		}
#line 114 "pwl.vala"
		type = g_unichar_type (c);
#line 115 "pwl.vala"
		if (type == G_UNICODE_UPPERCASE_LETTER) {
#line 115 "pwl.vala"
			_tmp5_ = TRUE;
#line 497 "pwl.c"
		} else {
#line 115 "pwl.vala"
			_tmp5_ = type == G_UNICODE_TITLECASE_LETTER;
#line 501 "pwl.c"
		}
#line 115 "pwl.vala"
		if (_tmp5_) {
#line 116 "pwl.vala"
			result = FALSE;
#line 116 "pwl.vala"
			return result;
#line 509 "pwl.c"
		}
	}
#line 119 "pwl.vala"
	result = TRUE;
#line 119 "pwl.vala"
	return result;
#line 516 "pwl.c"
}

static EnchantPWL*
enchant_pwl_construct (GType object_type)
{
	EnchantPWL* self = NULL;
#line 126 "pwl.vala"
	self = (EnchantPWL*) g_type_create_instance (object_type);
#line 126 "pwl.vala"
	return self;
#line 527 "pwl.c"
}

static EnchantPWL*
enchant_pwl_new (void)
{
#line 126 "pwl.vala"
	return enchant_pwl_construct (TYPE_ENCHANT_PWL);
#line 535 "pwl.c"
}

/**
 * Create and initialise a new, empty PWL
 *
 * Returns: a new PWL object used to store/check/suggest words.
 */
static void
_g_free0_ (gpointer var)
{
#line 134 "pwl.vala"
	var = (g_free (var), NULL);
#line 548 "pwl.c"
}

EnchantPWL*
enchant_pwl_init (void)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	EnchantPWL* _tmp3_ = NULL;
	EnchantPWL* result;
#line 134 "pwl.vala"
	_tmp0_ = g_str_hash;
#line 134 "pwl.vala"
	_tmp1_ = g_str_equal;
#line 134 "pwl.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
#line 134 "pwl.vala"
	_tmp3_ = enchant_pwl_new ();
#line 134 "pwl.vala"
	_g_hash_table_unref0 (_tmp3_->words);
#line 134 "pwl.vala"
	_tmp3_->words = _tmp2_;
#line 134 "pwl.vala"
	result = _tmp3_;
#line 134 "pwl.vala"
	return result;
#line 575 "pwl.c"
}

/**
 * Create a PWL and initialize it from a file.
 *
 * Returns: a new PWL object used to store/check words
 * or NULL if the file cannot be opened or created
 */
EnchantPWL*
enchant_pwl_init_with_file (const gchar* file)
{
	FILE* f = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	EnchantPWL* pwl = NULL;
	EnchantPWL* _tmp2_;
	EnchantPWL* _tmp3_;
	gchar* _tmp4_;
	EnchantPWL* _tmp5_;
	EnchantPWL* result;
#line 146 "pwl.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 147 "pwl.vala"
	_tmp0_ = g_fopen (file, "a+");
#line 147 "pwl.vala"
	f = _tmp0_;
#line 148 "pwl.vala"
	_tmp1_ = f;
#line 148 "pwl.vala"
	if (_tmp1_ == NULL) {
#line 149 "pwl.vala"
		result = NULL;
#line 149 "pwl.vala"
		_fclose0 (f);
#line 149 "pwl.vala"
		return result;
#line 612 "pwl.c"
	}
#line 150 "pwl.vala"
	_tmp2_ = enchant_pwl_new ();
#line 150 "pwl.vala"
	pwl = _tmp2_;
#line 151 "pwl.vala"
	_tmp3_ = pwl;
#line 151 "pwl.vala"
	_tmp4_ = g_strdup (file);
#line 151 "pwl.vala"
	_g_free0 (_tmp3_->filename);
#line 151 "pwl.vala"
	_tmp3_->filename = _tmp4_;
#line 153 "pwl.vala"
	_tmp5_ = pwl;
#line 153 "pwl.vala"
	enchant_pwl_refresh_from_file (_tmp5_);
#line 154 "pwl.vala"
	result = pwl;
#line 154 "pwl.vala"
	_fclose0 (f);
#line 154 "pwl.vala"
	return result;
#line 636 "pwl.c"
}

static void
enchant_pwl_add_to_table (EnchantPWL* self,
                          const gchar* word)
{
	gchar* normalized_word = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
#line 157 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 157 "pwl.vala"
	g_return_if_fail (word != NULL);
#line 158 "pwl.vala"
	_tmp0_ = g_utf8_normalize (word, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 158 "pwl.vala"
	normalized_word = _tmp0_;
#line 159 "pwl.vala"
	_tmp1_ = self->words;
#line 159 "pwl.vala"
	_tmp2_ = normalized_word;
#line 159 "pwl.vala"
	if (!g_hash_table_contains (_tmp1_, _tmp2_)) {
#line 661 "pwl.c"
		GHashTable* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 160 "pwl.vala"
		_tmp3_ = self->words;
#line 160 "pwl.vala"
		_tmp4_ = normalized_word;
#line 160 "pwl.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 160 "pwl.vala"
		_tmp6_ = g_strdup (word);
#line 160 "pwl.vala"
		g_hash_table_insert (_tmp3_, _tmp5_, _tmp6_);
#line 676 "pwl.c"
	}
#line 157 "pwl.vala"
	_g_free0 (normalized_word);
#line 680 "pwl.c"
}

void
enchant_pwl_add (EnchantPWL* self,
                 const gchar* word_buf,
                 ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
#line 163 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 163 "pwl.vala"
	g_return_if_fail (word_buf != NULL);
#line 164 "pwl.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 164 "pwl.vala"
	word = _tmp0_;
#line 166 "pwl.vala"
	enchant_pwl_refresh_from_file (self);
#line 167 "pwl.vala"
	_tmp1_ = word;
#line 167 "pwl.vala"
	enchant_pwl_add_to_table (self, _tmp1_);
#line 169 "pwl.vala"
	_tmp2_ = self->filename;
#line 169 "pwl.vala"
	if (_tmp2_ != NULL) {
#line 710 "pwl.c"
		FILE* f = NULL;
		const gchar* _tmp3_;
		FILE* _tmp4_;
		FILE* _tmp5_;
#line 170 "pwl.vala"
		_tmp3_ = self->filename;
#line 170 "pwl.vala"
		_tmp4_ = g_fopen (_tmp3_, "a+");
#line 170 "pwl.vala"
		f = _tmp4_;
#line 171 "pwl.vala"
		_tmp5_ = f;
#line 171 "pwl.vala"
		if (_tmp5_ != NULL) {
#line 725 "pwl.c"
			FILE* _tmp6_;
			FILE* _tmp7_;
			FILE* _tmp11_;
			const gchar* _tmp12_;
			FILE* _tmp14_;
#line 174 "pwl.vala"
			_tmp6_ = f;
#line 174 "pwl.vala"
			lock_file (_tmp6_);
#line 177 "pwl.vala"
			_tmp7_ = f;
#line 177 "pwl.vala"
			if (fseek (_tmp7_, (glong) -1, SEEK_END) == 0) {
#line 739 "pwl.c"
				gint c = 0;
				FILE* _tmp8_;
				FILE* _tmp9_;
#line 178 "pwl.vala"
				_tmp8_ = f;
#line 178 "pwl.vala"
				c = fgetc (_tmp8_);
#line 179 "pwl.vala"
				_tmp9_ = f;
#line 179 "pwl.vala"
				fseek (_tmp9_, (glong) 0, SEEK_CUR);
#line 180 "pwl.vala"
				if (c != ((gint) '\n')) {
#line 753 "pwl.c"
					FILE* _tmp10_;
#line 181 "pwl.vala"
					_tmp10_ = f;
#line 181 "pwl.vala"
					fputc ('\n', _tmp10_);
#line 759 "pwl.c"
				}
			}
#line 184 "pwl.vala"
			_tmp11_ = f;
#line 184 "pwl.vala"
			_tmp12_ = word;
#line 184 "pwl.vala"
			if (fputs (_tmp12_, _tmp11_) != EOF) {
#line 768 "pwl.c"
				FILE* _tmp13_;
#line 185 "pwl.vala"
				_tmp13_ = f;
#line 185 "pwl.vala"
				fputc ('\n', _tmp13_);
#line 774 "pwl.c"
			}
#line 186 "pwl.vala"
			_tmp14_ = f;
#line 186 "pwl.vala"
			unlock_file (_tmp14_);
#line 780 "pwl.c"
		}
#line 169 "pwl.vala"
		_fclose0 (f);
#line 784 "pwl.c"
	}
#line 163 "pwl.vala"
	_g_free0 (word);
#line 788 "pwl.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 812 "pwl.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 820 "pwl.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 826 "pwl.c"
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1501 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1501 "glib-2.0.vapi"
	end = _tmp0_;
#line 1502 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1502 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1503 "glib-2.0.vapi"
		result = maxlen;
#line 1503 "glib-2.0.vapi"
		return result;
#line 850 "pwl.c"
	} else {
		gchar* _tmp2_;
#line 1505 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1505 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1505 "glib-2.0.vapi"
		return result;
#line 859 "pwl.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1512 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1514 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 878 "pwl.c"
	} else {
#line 1514 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 882 "pwl.c"
	}
#line 1514 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1516 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 888 "pwl.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1518 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1518 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1518 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 898 "pwl.c"
	}
#line 1521 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1522 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1523 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 906 "pwl.c"
	} else {
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 910 "pwl.c"
	}
#line 1527 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1528 "glib-2.0.vapi"
		len = string_length - offset;
#line 916 "pwl.c"
	}
#line 1530 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1531 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1531 "glib-2.0.vapi"
	result = _tmp3_;
#line 1531 "glib-2.0.vapi"
	return result;
#line 926 "pwl.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 943 "pwl.c"
}

void
enchant_pwl_remove (EnchantPWL* self,
                    const gchar* word_buf,
                    ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
#line 191 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 191 "pwl.vala"
	g_return_if_fail (word_buf != NULL);
#line 193 "pwl.vala"
	if (enchant_pwl_check (self, word_buf, len) == 1) {
#line 194 "pwl.vala"
		return;
#line 967 "pwl.c"
	}
#line 196 "pwl.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 196 "pwl.vala"
	word = _tmp0_;
#line 197 "pwl.vala"
	_tmp1_ = self->words;
#line 197 "pwl.vala"
	_tmp2_ = word;
#line 197 "pwl.vala"
	_tmp3_ = g_utf8_normalize (_tmp2_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 197 "pwl.vala"
	_tmp4_ = _tmp3_;
#line 197 "pwl.vala"
	g_hash_table_remove (_tmp1_, _tmp4_);
#line 197 "pwl.vala"
	_g_free0 (_tmp4_);
#line 199 "pwl.vala"
	_tmp5_ = self->filename;
#line 199 "pwl.vala"
	if (_tmp5_ != NULL) {
#line 989 "pwl.c"
		gchar* contents = NULL;
		gsize length = 0UL;
		FILE* f = NULL;
		const gchar* _tmp9_;
		FILE* _tmp10_;
		FILE* _tmp11_;
		{
			const gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			gsize _tmp8_ = 0UL;
#line 203 "pwl.vala"
			_tmp6_ = self->filename;
#line 203 "pwl.vala"
			g_file_get_contents (_tmp6_, &_tmp7_, &_tmp8_, &_inner_error0_);
#line 203 "pwl.vala"
			_g_free0 (contents);
#line 203 "pwl.vala"
			contents = _tmp7_;
#line 203 "pwl.vala"
			length = _tmp8_;
#line 203 "pwl.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 203 "pwl.vala"
				if (_inner_error0_->domain == G_FILE_ERROR) {
#line 1014 "pwl.c"
					goto __catch0_g_file_error;
				}
#line 203 "pwl.vala"
				_g_free0 (contents);
#line 203 "pwl.vala"
				_g_free0 (word);
#line 203 "pwl.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 203 "pwl.vala"
				g_clear_error (&_inner_error0_);
#line 203 "pwl.vala"
				return;
#line 1027 "pwl.c"
			}
		}
		goto __finally0;
		__catch0_g_file_error:
		{
#line 202 "pwl.vala"
			g_clear_error (&_inner_error0_);
#line 205 "pwl.vala"
			_g_free0 (contents);
#line 205 "pwl.vala"
			_g_free0 (word);
#line 205 "pwl.vala"
			return;
#line 1041 "pwl.c"
		}
		__finally0:
#line 202 "pwl.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 202 "pwl.vala"
			_g_free0 (contents);
#line 202 "pwl.vala"
			_g_free0 (word);
#line 202 "pwl.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 202 "pwl.vala"
			g_clear_error (&_inner_error0_);
#line 202 "pwl.vala"
			return;
#line 1056 "pwl.c"
		}
#line 208 "pwl.vala"
		_tmp9_ = self->filename;
#line 208 "pwl.vala"
		_tmp10_ = g_fopen (_tmp9_, "wb");
#line 208 "pwl.vala"
		f = _tmp10_;
#line 209 "pwl.vala"
		_tmp11_ = f;
#line 209 "pwl.vala"
		if (_tmp11_ != NULL) {
#line 1068 "pwl.c"
			FILE* _tmp12_;
			glong filestart = 0L;
			const gchar* _tmp13_;
			FILE* _tmp60_;
#line 210 "pwl.vala"
			_tmp12_ = f;
#line 210 "pwl.vala"
			lock_file (_tmp12_);
#line 211 "pwl.vala"
			filestart = (glong) 0;
#line 214 "pwl.vala"
			_tmp13_ = contents;
#line 214 "pwl.vala"
			if (BOM == string_get_char (_tmp13_, filestart)) {
#line 1083 "pwl.c"
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				FILE* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
#line 215 "pwl.vala"
				_tmp14_ = contents;
#line 215 "pwl.vala"
				_tmp15_ = g_utf8_next_char (_tmp14_);
#line 215 "pwl.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 215 "pwl.vala"
				_g_free0 (contents);
#line 215 "pwl.vala"
				contents = _tmp16_;
#line 216 "pwl.vala"
				_tmp17_ = f;
#line 216 "pwl.vala"
				_tmp18_ = g_unichar_to_string (BOM);
#line 216 "pwl.vala"
				_tmp19_ = _tmp18_;
#line 216 "pwl.vala"
				fputs (_tmp19_, _tmp17_);
#line 216 "pwl.vala"
				_g_free0 (_tmp19_);
#line 1110 "pwl.c"
			}
			{
				gint start_index = 0;
#line 219 "pwl.vala"
				start_index = 0;
#line 1116 "pwl.c"
				{
					gboolean _tmp20_ = FALSE;
#line 219 "pwl.vala"
					_tmp20_ = TRUE;
#line 219 "pwl.vala"
					while (TRUE) {
#line 1123 "pwl.c"
						gint word_pos = 0;
						const gchar* _tmp21_;
						const gchar* _tmp22_;
#line 219 "pwl.vala"
						if (!_tmp20_) {
#line 1129 "pwl.c"
						}
#line 219 "pwl.vala"
						_tmp20_ = FALSE;
#line 221 "pwl.vala"
						_tmp21_ = contents;
#line 221 "pwl.vala"
						_tmp22_ = word;
#line 221 "pwl.vala"
						word_pos = string_index_of (_tmp21_, _tmp22_, start_index);
#line 222 "pwl.vala"
						if (word_pos == -1) {
#line 1141 "pwl.c"
							FILE* _tmp23_;
							const gchar* _tmp24_;
							gchar* _tmp25_;
							gchar* _tmp26_;
#line 223 "pwl.vala"
							_tmp23_ = f;
#line 223 "pwl.vala"
							_tmp24_ = contents;
#line 223 "pwl.vala"
							_tmp25_ = string_substring (_tmp24_, (glong) start_index, (glong) -1);
#line 223 "pwl.vala"
							_tmp26_ = _tmp25_;
#line 223 "pwl.vala"
							fputs (_tmp26_, _tmp23_);
#line 223 "pwl.vala"
							_g_free0 (_tmp26_);
#line 224 "pwl.vala"
							break;
#line 1160 "pwl.c"
						} else {
							gboolean _tmp27_ = FALSE;
							gboolean _tmp28_ = FALSE;
							gboolean _tmp29_ = FALSE;
#line 226 "pwl.vala"
							if (word_pos == 0) {
#line 226 "pwl.vala"
								_tmp29_ = TRUE;
#line 1169 "pwl.c"
							} else {
								const gchar* _tmp30_;
#line 226 "pwl.vala"
								_tmp30_ = contents;
#line 226 "pwl.vala"
								_tmp29_ = string_get (_tmp30_, (glong) (word_pos - 1)) == '\n';
#line 1176 "pwl.c"
							}
#line 226 "pwl.vala"
							if (_tmp29_) {
#line 226 "pwl.vala"
								_tmp28_ = TRUE;
#line 1182 "pwl.c"
							} else {
								const gchar* _tmp31_;
#line 226 "pwl.vala"
								_tmp31_ = contents;
#line 226 "pwl.vala"
								_tmp28_ = string_get (_tmp31_, (glong) (word_pos - 1)) == '\r';
#line 1189 "pwl.c"
							}
#line 226 "pwl.vala"
							if (_tmp28_) {
#line 1193 "pwl.c"
								gboolean _tmp32_ = FALSE;
								gboolean _tmp33_ = FALSE;
								const gchar* _tmp34_;
								gint _tmp35_;
								gint _tmp36_;
#line 227 "pwl.vala"
								_tmp34_ = contents;
#line 227 "pwl.vala"
								_tmp35_ = strlen (_tmp34_);
#line 227 "pwl.vala"
								_tmp36_ = _tmp35_;
#line 227 "pwl.vala"
								if (word_pos == _tmp36_) {
#line 227 "pwl.vala"
									_tmp33_ = TRUE;
#line 1209 "pwl.c"
								} else {
									const gchar* _tmp37_;
									const gchar* _tmp38_;
									gint _tmp39_;
									gint _tmp40_;
#line 227 "pwl.vala"
									_tmp37_ = contents;
#line 227 "pwl.vala"
									_tmp38_ = word;
#line 227 "pwl.vala"
									_tmp39_ = strlen (_tmp38_);
#line 227 "pwl.vala"
									_tmp40_ = _tmp39_;
#line 227 "pwl.vala"
									_tmp33_ = string_get (_tmp37_, (glong) (word_pos + _tmp40_)) == '\n';
#line 1225 "pwl.c"
								}
#line 227 "pwl.vala"
								if (_tmp33_) {
#line 227 "pwl.vala"
									_tmp32_ = TRUE;
#line 1231 "pwl.c"
								} else {
									const gchar* _tmp41_;
									const gchar* _tmp42_;
									gint _tmp43_;
									gint _tmp44_;
#line 227 "pwl.vala"
									_tmp41_ = contents;
#line 227 "pwl.vala"
									_tmp42_ = word;
#line 227 "pwl.vala"
									_tmp43_ = strlen (_tmp42_);
#line 227 "pwl.vala"
									_tmp44_ = _tmp43_;
#line 227 "pwl.vala"
									_tmp32_ = string_get (_tmp41_, (glong) (word_pos + _tmp44_)) == '\r';
#line 1247 "pwl.c"
								}
#line 227 "pwl.vala"
								_tmp27_ = _tmp32_;
#line 1251 "pwl.c"
							} else {
#line 226 "pwl.vala"
								_tmp27_ = FALSE;
#line 1255 "pwl.c"
							}
#line 226 "pwl.vala"
							if (_tmp27_) {
#line 1259 "pwl.c"
								FILE* _tmp45_;
								const gchar* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								const gchar* _tmp49_;
								gint _tmp50_;
								gint _tmp51_;
#line 228 "pwl.vala"
								_tmp45_ = f;
#line 228 "pwl.vala"
								_tmp46_ = contents;
#line 228 "pwl.vala"
								_tmp47_ = string_substring (_tmp46_, (glong) start_index, (glong) (word_pos - start_index));
#line 228 "pwl.vala"
								_tmp48_ = _tmp47_;
#line 228 "pwl.vala"
								fputs (_tmp48_, _tmp45_);
#line 228 "pwl.vala"
								_g_free0 (_tmp48_);
#line 229 "pwl.vala"
								_tmp49_ = word;
#line 229 "pwl.vala"
								_tmp50_ = strlen (_tmp49_);
#line 229 "pwl.vala"
								_tmp51_ = _tmp50_;
#line 229 "pwl.vala"
								start_index = word_pos + _tmp51_;
#line 230 "pwl.vala"
								while (TRUE) {
#line 1289 "pwl.c"
									gboolean _tmp52_ = FALSE;
									const gchar* _tmp53_;
									gint _tmp55_;
#line 230 "pwl.vala"
									_tmp53_ = contents;
#line 230 "pwl.vala"
									if (string_get (_tmp53_, (glong) start_index) == '\n') {
#line 230 "pwl.vala"
										_tmp52_ = TRUE;
#line 1299 "pwl.c"
									} else {
										const gchar* _tmp54_;
#line 230 "pwl.vala"
										_tmp54_ = contents;
#line 230 "pwl.vala"
										_tmp52_ = string_get (_tmp54_, (glong) start_index) == '\r';
#line 1306 "pwl.c"
									}
#line 230 "pwl.vala"
									if (!_tmp52_) {
#line 230 "pwl.vala"
										break;
#line 1312 "pwl.c"
									}
#line 231 "pwl.vala"
									start_index = start_index + 1;
#line 231 "pwl.vala"
									_tmp55_ = start_index;
#line 1318 "pwl.c"
								}
							} else {
								FILE* _tmp56_;
								const gchar* _tmp57_;
								gchar* _tmp58_;
								gchar* _tmp59_;
#line 233 "pwl.vala"
								_tmp56_ = f;
#line 233 "pwl.vala"
								_tmp57_ = contents;
#line 233 "pwl.vala"
								_tmp58_ = string_substring (_tmp57_, (glong) start_index, (glong) ((word_pos - start_index) + 1));
#line 233 "pwl.vala"
								_tmp59_ = _tmp58_;
#line 233 "pwl.vala"
								fputs (_tmp59_, _tmp56_);
#line 233 "pwl.vala"
								_g_free0 (_tmp59_);
#line 234 "pwl.vala"
								start_index = word_pos + 1;
#line 1339 "pwl.c"
							}
						}
					}
				}
			}
#line 239 "pwl.vala"
			_tmp60_ = f;
#line 239 "pwl.vala"
			unlock_file (_tmp60_);
#line 1349 "pwl.c"
		}
#line 199 "pwl.vala"
		_fclose0 (f);
#line 199 "pwl.vala"
		_g_free0 (contents);
#line 1355 "pwl.c"
	}
#line 191 "pwl.vala"
	_g_free0 (word);
#line 1359 "pwl.c"
}

gint
enchant_pwl_check (EnchantPWL* self,
                   const gchar* word_buf,
                   ssize_t len)
{
	gchar* word = NULL;
	gchar* _tmp0_;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean all_caps = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gint result;
#line 244 "pwl.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 244 "pwl.vala"
	g_return_val_if_fail (word_buf != NULL, 0);
#line 245 "pwl.vala"
	_tmp0_ = buf_to_utf8_string (word_buf, (gssize) len);
#line 245 "pwl.vala"
	word = _tmp0_;
#line 246 "pwl.vala"
	enchant_pwl_refresh_from_file (self);
#line 248 "pwl.vala"
	_tmp1_ = self->words;
#line 248 "pwl.vala"
	_tmp2_ = word;
#line 248 "pwl.vala"
	_tmp3_ = g_utf8_normalize (_tmp2_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 248 "pwl.vala"
	_tmp4_ = _tmp3_;
#line 248 "pwl.vala"
	_tmp5_ = g_hash_table_contains (_tmp1_, _tmp4_);
#line 248 "pwl.vala"
	_g_free0 (_tmp4_);
#line 248 "pwl.vala"
	if (_tmp5_) {
#line 249 "pwl.vala"
		result = 0;
#line 249 "pwl.vala"
		_g_free0 (word);
#line 249 "pwl.vala"
		return result;
#line 1408 "pwl.c"
	}
#line 251 "pwl.vala"
	all_caps = FALSE;
#line 252 "pwl.vala"
	_tmp7_ = word;
#line 252 "pwl.vala"
	if (is_title_case (_tmp7_)) {
#line 252 "pwl.vala"
		_tmp6_ = TRUE;
#line 1418 "pwl.c"
	} else {
		const gchar* _tmp8_;
#line 252 "pwl.vala"
		_tmp8_ = word;
#line 252 "pwl.vala"
		all_caps = is_all_caps (_tmp8_);
#line 252 "pwl.vala"
		_tmp6_ = all_caps;
#line 1427 "pwl.c"
	}
#line 252 "pwl.vala"
	if (_tmp6_) {
#line 1431 "pwl.c"
		gchar* lower_case_word = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		GHashTable* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean _tmp15_;
#line 253 "pwl.vala"
		_tmp9_ = word;
#line 253 "pwl.vala"
		_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
#line 253 "pwl.vala"
		lower_case_word = _tmp10_;
#line 254 "pwl.vala"
		_tmp11_ = self->words;
#line 254 "pwl.vala"
		_tmp12_ = lower_case_word;
#line 254 "pwl.vala"
		_tmp13_ = g_utf8_normalize (_tmp12_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 254 "pwl.vala"
		_tmp14_ = _tmp13_;
#line 254 "pwl.vala"
		_tmp15_ = g_hash_table_contains (_tmp11_, _tmp14_);
#line 254 "pwl.vala"
		_g_free0 (_tmp14_);
#line 254 "pwl.vala"
		if (_tmp15_) {
#line 255 "pwl.vala"
			result = 0;
#line 255 "pwl.vala"
			_g_free0 (lower_case_word);
#line 255 "pwl.vala"
			_g_free0 (word);
#line 255 "pwl.vala"
			return result;
#line 1468 "pwl.c"
		}
#line 257 "pwl.vala"
		if (all_caps) {
#line 1472 "pwl.c"
			gchar* title_case_word = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			GHashTable* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gboolean _tmp22_;
#line 258 "pwl.vala"
			_tmp16_ = word;
#line 258 "pwl.vala"
			_tmp17_ = utf8_strtitle (_tmp16_);
#line 258 "pwl.vala"
			title_case_word = _tmp17_;
#line 259 "pwl.vala"
			_tmp18_ = self->words;
#line 259 "pwl.vala"
			_tmp19_ = title_case_word;
#line 259 "pwl.vala"
			_tmp20_ = g_utf8_normalize (_tmp19_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 259 "pwl.vala"
			_tmp21_ = _tmp20_;
#line 259 "pwl.vala"
			_tmp22_ = g_hash_table_contains (_tmp18_, _tmp21_);
#line 259 "pwl.vala"
			_g_free0 (_tmp21_);
#line 259 "pwl.vala"
			if (_tmp22_) {
#line 260 "pwl.vala"
				result = 0;
#line 260 "pwl.vala"
				_g_free0 (title_case_word);
#line 260 "pwl.vala"
				_g_free0 (lower_case_word);
#line 260 "pwl.vala"
				_g_free0 (word);
#line 260 "pwl.vala"
				return result;
#line 1511 "pwl.c"
			}
#line 257 "pwl.vala"
			_g_free0 (title_case_word);
#line 1515 "pwl.c"
		}
#line 252 "pwl.vala"
		_g_free0 (lower_case_word);
#line 1519 "pwl.c"
	}
#line 264 "pwl.vala"
	result = 1;
#line 264 "pwl.vala"
	_g_free0 (word);
#line 264 "pwl.vala"
	return result;
#line 1527 "pwl.c"
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
#line 4109 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 4111 "glib-2.0.vapi"
	ret = NULL;
#line 4112 "glib-2.0.vapi"
	while (TRUE) {
#line 1543 "pwl.c"
		GString* _tmp0_;
		GString* _tmp2_;
#line 4112 "glib-2.0.vapi"
		c = fgetc (self);
#line 4112 "glib-2.0.vapi"
		if (!(c != EOF)) {
#line 4112 "glib-2.0.vapi"
			break;
#line 1552 "pwl.c"
		}
#line 4113 "glib-2.0.vapi"
		_tmp0_ = ret;
#line 4113 "glib-2.0.vapi"
		if (_tmp0_ == NULL) {
#line 1558 "pwl.c"
			GString* _tmp1_;
#line 4114 "glib-2.0.vapi"
			_tmp1_ = g_string_new ("");
#line 4114 "glib-2.0.vapi"
			_g_string_free0 (ret);
#line 4114 "glib-2.0.vapi"
			ret = _tmp1_;
#line 1566 "pwl.c"
		}
#line 4116 "glib-2.0.vapi"
		if (c == ((gint) '\n')) {
#line 4117 "glib-2.0.vapi"
			break;
#line 1572 "pwl.c"
		}
#line 4119 "glib-2.0.vapi"
		_tmp2_ = ret;
#line 4119 "glib-2.0.vapi"
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
#line 1578 "pwl.c"
	}
#line 4121 "glib-2.0.vapi"
	_tmp3_ = ret;
#line 4121 "glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 4122 "glib-2.0.vapi"
		result = NULL;
#line 4122 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4122 "glib-2.0.vapi"
		return result;
#line 1590 "pwl.c"
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
#line 4124 "glib-2.0.vapi"
		_tmp4_ = ret;
#line 4124 "glib-2.0.vapi"
		_tmp5_ = ((GString*) _tmp4_)->str;
#line 4124 "glib-2.0.vapi"
		((GString*) _tmp4_)->str = NULL;
#line 4124 "glib-2.0.vapi"
		result = _tmp5_;
#line 4124 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4124 "glib-2.0.vapi"
		return result;
#line 1606 "pwl.c"
	}
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1397 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1398 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1398 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1399 "glib-2.0.vapi"
	g_strchomp (_result_);
#line 1400 "glib-2.0.vapi"
	result = _result_;
#line 1400 "glib-2.0.vapi"
	return result;
#line 1628 "pwl.c"
}

static void
enchant_pwl_refresh_from_file (EnchantPWL* self)
{
	const gchar* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	FILE* f = NULL;
	const gchar* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	FILE* _tmp7_;
	gsize line_number = 0UL;
	gchar* line = NULL;
	FILE* _tmp26_;
#line 267 "pwl.vala"
	g_return_if_fail (self != NULL);
#line 268 "pwl.vala"
	_tmp0_ = self->filename;
#line 268 "pwl.vala"
	if (_tmp0_ == NULL) {
#line 269 "pwl.vala"
		return;
#line 1654 "pwl.c"
	}
#line 271 "pwl.vala"
	_tmp1_ = g_str_hash;
#line 271 "pwl.vala"
	_tmp2_ = g_str_equal;
#line 271 "pwl.vala"
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
#line 271 "pwl.vala"
	_g_hash_table_unref0 (self->words);
#line 271 "pwl.vala"
	self->words = _tmp3_;
#line 273 "pwl.vala"
	_tmp4_ = self->filename;
#line 273 "pwl.vala"
	_tmp5_ = g_fopen (_tmp4_, "r");
#line 273 "pwl.vala"
	f = _tmp5_;
#line 274 "pwl.vala"
	_tmp6_ = f;
#line 274 "pwl.vala"
	if (_tmp6_ == NULL) {
#line 275 "pwl.vala"
		_fclose0 (f);
#line 275 "pwl.vala"
		return;
#line 1680 "pwl.c"
	}
#line 277 "pwl.vala"
	_tmp7_ = f;
#line 277 "pwl.vala"
	lock_file (_tmp7_);
#line 279 "pwl.vala"
	line_number = (gsize) 1;
#line 1688 "pwl.c"
	{
		gboolean _tmp8_ = FALSE;
#line 281 "pwl.vala"
		_tmp8_ = TRUE;
#line 281 "pwl.vala"
		while (TRUE) {
#line 1695 "pwl.c"
			FILE* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_ = FALSE;
			const gchar* _tmp21_;
#line 281 "pwl.vala"
			if (!_tmp8_) {
#line 1706 "pwl.c"
				gsize _tmp9_;
#line 281 "pwl.vala"
				line_number = line_number + 1;
#line 281 "pwl.vala"
				_tmp9_ = line_number;
#line 1712 "pwl.c"
			}
#line 281 "pwl.vala"
			_tmp8_ = FALSE;
#line 281 "pwl.vala"
			_tmp10_ = f;
#line 281 "pwl.vala"
			_tmp11_ = g_file_stream_read_line (_tmp10_);
#line 281 "pwl.vala"
			_g_free0 (line);
#line 281 "pwl.vala"
			line = _tmp11_;
#line 281 "pwl.vala"
			_tmp12_ = line;
#line 281 "pwl.vala"
			if (!(_tmp12_ != NULL)) {
#line 281 "pwl.vala"
				break;
#line 1730 "pwl.c"
			}
#line 282 "pwl.vala"
			if (line_number == ((gsize) 1)) {
#line 1734 "pwl.c"
				const gchar* _tmp14_;
#line 282 "pwl.vala"
				_tmp14_ = line;
#line 282 "pwl.vala"
				_tmp13_ = BOM == string_get_char (_tmp14_, (glong) 0);
#line 1740 "pwl.c"
			} else {
#line 282 "pwl.vala"
				_tmp13_ = FALSE;
#line 1744 "pwl.c"
			}
#line 282 "pwl.vala"
			if (_tmp13_) {
#line 1748 "pwl.c"
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
#line 283 "pwl.vala"
				_tmp15_ = line;
#line 283 "pwl.vala"
				_tmp16_ = g_utf8_next_char (_tmp15_);
#line 283 "pwl.vala"
				_tmp17_ = g_strdup (_tmp16_);
#line 283 "pwl.vala"
				_g_free0 (line);
#line 283 "pwl.vala"
				line = _tmp17_;
#line 1762 "pwl.c"
			}
#line 285 "pwl.vala"
			_tmp18_ = line;
#line 285 "pwl.vala"
			_tmp19_ = string_chomp (_tmp18_);
#line 285 "pwl.vala"
			_g_free0 (line);
#line 285 "pwl.vala"
			line = _tmp19_;
#line 286 "pwl.vala"
			_tmp21_ = line;
#line 286 "pwl.vala"
			if (string_get (_tmp21_, (glong) 0) != '\0') {
#line 1776 "pwl.c"
				const gchar* _tmp22_;
#line 286 "pwl.vala"
				_tmp22_ = line;
#line 286 "pwl.vala"
				_tmp20_ = string_get (_tmp22_, (glong) 0) != '#';
#line 1782 "pwl.c"
			} else {
#line 286 "pwl.vala"
				_tmp20_ = FALSE;
#line 1786 "pwl.c"
			}
#line 286 "pwl.vala"
			if (_tmp20_) {
#line 1790 "pwl.c"
				const gchar* _tmp23_;
#line 287 "pwl.vala"
				_tmp23_ = line;
#line 287 "pwl.vala"
				if (g_utf8_validate (_tmp23_, (gssize) -1, NULL)) {
#line 1796 "pwl.c"
					const gchar* _tmp24_;
#line 288 "pwl.vala"
					_tmp24_ = line;
#line 288 "pwl.vala"
					enchant_pwl_add_to_table (self, _tmp24_);
#line 1802 "pwl.c"
				} else {
					const gchar* _tmp25_;
#line 290 "pwl.vala"
					_tmp25_ = self->filename;
#line 290 "pwl.vala"
					g_warning ("pwl.vala:290: Bad UTF-8 sequence in %s at line:%zu", _tmp25_, line_number);
#line 1809 "pwl.c"
				}
			}
		}
	}
#line 294 "pwl.vala"
	_tmp26_ = f;
#line 294 "pwl.vala"
	unlock_file (_tmp26_);
#line 267 "pwl.vala"
	_g_free0 (line);
#line 267 "pwl.vala"
	_fclose0 (f);
#line 1822 "pwl.c"
}

static void
value_enchant_pwl_init (GValue* value)
{
#line 122 "pwl.vala"
	value->data[0].v_pointer = NULL;
#line 1830 "pwl.c"
}

static void
value_enchant_pwl_free_value (GValue* value)
{
#line 122 "pwl.vala"
	if (value->data[0].v_pointer) {
#line 122 "pwl.vala"
		enchant_pwl_unref (value->data[0].v_pointer);
#line 1840 "pwl.c"
	}
}

static void
value_enchant_pwl_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
#line 122 "pwl.vala"
	if (src_value->data[0].v_pointer) {
#line 122 "pwl.vala"
		dest_value->data[0].v_pointer = enchant_pwl_ref (src_value->data[0].v_pointer);
#line 1852 "pwl.c"
	} else {
#line 122 "pwl.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1856 "pwl.c"
	}
}

static gpointer
value_enchant_pwl_peek_pointer (const GValue* value)
{
#line 122 "pwl.vala"
	return value->data[0].v_pointer;
#line 1865 "pwl.c"
}

static gchar*
value_enchant_pwl_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
#line 122 "pwl.vala"
	if (collect_values[0].v_pointer) {
#line 1876 "pwl.c"
		EnchantPWL * object;
		object = collect_values[0].v_pointer;
#line 122 "pwl.vala"
		if (object->parent_instance.g_class == NULL) {
#line 122 "pwl.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1883 "pwl.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 122 "pwl.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1887 "pwl.c"
		}
#line 122 "pwl.vala"
		value->data[0].v_pointer = enchant_pwl_ref (object);
#line 1891 "pwl.c"
	} else {
#line 122 "pwl.vala"
		value->data[0].v_pointer = NULL;
#line 1895 "pwl.c"
	}
#line 122 "pwl.vala"
	return NULL;
#line 1899 "pwl.c"
}

static gchar*
value_enchant_pwl_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	EnchantPWL ** object_p;
	object_p = collect_values[0].v_pointer;
#line 122 "pwl.vala"
	if (!object_p) {
#line 122 "pwl.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1914 "pwl.c"
	}
#line 122 "pwl.vala"
	if (!value->data[0].v_pointer) {
#line 122 "pwl.vala"
		*object_p = NULL;
#line 1920 "pwl.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 122 "pwl.vala"
		*object_p = value->data[0].v_pointer;
#line 1924 "pwl.c"
	} else {
#line 122 "pwl.vala"
		*object_p = enchant_pwl_ref (value->data[0].v_pointer);
#line 1928 "pwl.c"
	}
#line 122 "pwl.vala"
	return NULL;
#line 1932 "pwl.c"
}

GParamSpec*
param_spec_enchant_pwl (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecEnchantPWL* spec;
#line 122 "pwl.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENCHANT_PWL), NULL);
#line 122 "pwl.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 122 "pwl.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 122 "pwl.vala"
	return G_PARAM_SPEC (spec);
#line 1951 "pwl.c"
}

gpointer
value_get_enchant_pwl (const GValue* value)
{
#line 122 "pwl.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PWL), NULL);
#line 122 "pwl.vala"
	return value->data[0].v_pointer;
#line 1961 "pwl.c"
}

void
value_set_enchant_pwl (GValue* value,
                       gpointer v_object)
{
	EnchantPWL * old;
#line 122 "pwl.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PWL));
#line 122 "pwl.vala"
	old = value->data[0].v_pointer;
#line 122 "pwl.vala"
	if (v_object) {
#line 122 "pwl.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PWL));
#line 122 "pwl.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 122 "pwl.vala"
		value->data[0].v_pointer = v_object;
#line 122 "pwl.vala"
		enchant_pwl_ref (value->data[0].v_pointer);
#line 1983 "pwl.c"
	} else {
#line 122 "pwl.vala"
		value->data[0].v_pointer = NULL;
#line 1987 "pwl.c"
	}
#line 122 "pwl.vala"
	if (old) {
#line 122 "pwl.vala"
		enchant_pwl_unref (old);
#line 1993 "pwl.c"
	}
}

void
value_take_enchant_pwl (GValue* value,
                        gpointer v_object)
{
	EnchantPWL * old;
#line 122 "pwl.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENCHANT_PWL));
#line 122 "pwl.vala"
	old = value->data[0].v_pointer;
#line 122 "pwl.vala"
	if (v_object) {
#line 122 "pwl.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENCHANT_PWL));
#line 122 "pwl.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 122 "pwl.vala"
		value->data[0].v_pointer = v_object;
#line 2014 "pwl.c"
	} else {
#line 122 "pwl.vala"
		value->data[0].v_pointer = NULL;
#line 2018 "pwl.c"
	}
#line 122 "pwl.vala"
	if (old) {
#line 122 "pwl.vala"
		enchant_pwl_unref (old);
#line 2024 "pwl.c"
	}
}

static void
enchant_pwl_class_init (EnchantPWLClass * klass,
                        gpointer klass_data)
{
#line 122 "pwl.vala"
	enchant_pwl_parent_class = g_type_class_peek_parent (klass);
#line 122 "pwl.vala"
	((EnchantPWLClass *) klass)->finalize = enchant_pwl_finalize;
#line 2036 "pwl.c"
}

static void
enchant_pwl_instance_init (EnchantPWL * self,
                           gpointer klass)
{
#line 122 "pwl.vala"
	self->ref_count = 1;
#line 2045 "pwl.c"
}

static void
enchant_pwl_finalize (EnchantPWL * obj)
{
	EnchantPWL * self;
#line 122 "pwl.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENCHANT_PWL, EnchantPWL);
#line 122 "pwl.vala"
	g_signal_handlers_destroy (self);
#line 123 "pwl.vala"
	_g_free0 (self->filename);
#line 124 "pwl.vala"
	_g_hash_table_unref0 (self->words);
#line 2060 "pwl.c"
}

static GType
enchant_pwl_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_enchant_pwl_init, value_enchant_pwl_free_value, value_enchant_pwl_copy_value, value_enchant_pwl_peek_pointer, "p", value_enchant_pwl_collect_value, "p", value_enchant_pwl_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EnchantPWLClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enchant_pwl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnchantPWL), 0, (GInstanceInitFunc) enchant_pwl_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType enchant_pwl_type_id;
	enchant_pwl_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EnchantPWL", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return enchant_pwl_type_id;
}

GType
enchant_pwl_get_type (void)
{
	static volatile gsize enchant_pwl_type_id__once = 0;
	if (g_once_init_enter (&enchant_pwl_type_id__once)) {
		GType enchant_pwl_type_id;
		enchant_pwl_type_id = enchant_pwl_get_type_once ();
		g_once_init_leave (&enchant_pwl_type_id__once, enchant_pwl_type_id);
	}
	return enchant_pwl_type_id__once;
}

gpointer
enchant_pwl_ref (gpointer instance)
{
	EnchantPWL * self;
	self = instance;
#line 122 "pwl.vala"
	g_atomic_int_inc (&self->ref_count);
#line 122 "pwl.vala"
	return instance;
#line 2095 "pwl.c"
}

void
enchant_pwl_unref (gpointer instance)
{
	EnchantPWL * self;
	self = instance;
#line 122 "pwl.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 122 "pwl.vala"
		ENCHANT_PWL_GET_CLASS (self)->finalize (self);
#line 122 "pwl.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2109 "pwl.c"
	}
}

