#!/bin/sh
#
# BIG BROTHER OVERALL EVENT LOGS HISTORY DISPLAY SCRIPT
# Robert-Andre Croteau
# Version 1.9
# Mar 13th, 2002
#
# (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
#

#
# This script should be called within mkbb.sh or mkbb2.sh
#

NUMACKS=25
SHOWMSG=TRUE		# Set to TRUE if you want to first $MSGLEN characters to be displayed
MSGLEN=30		# Only use the first $MSGLEN of the message

LASTMINUTES=240		# How far back do you wand displayed

TIME=`$BBHOME/bin/touchtime -e -$LASTMINUTES`; export TIME

$TAIL -$NUMACKS $BBACKS/acklog 2>/dev/null | $AWK '$1 > '${TIME}'  { print } ' | $AWK '{x[NR] = $0} END { for (i = NR; i > 0; i--) print x[i] }' > $BBHOME/tmp/acklog.$$

ACKCNT=`$CAT $BBHOME/tmp/acklog.$$ | $WC`
ACKCNT=`echo $ACKCNT`

if test "$ACKCNT" = "0"
then
	EVENTSTITLE="No events acknowledged in the last $LASTMINUTES minutes"
elif test "$ACKCNT" = "1"
then
	EVENTSTITLE="1 event acknowledged in the last $LASTMINUTES minutes"
elif test "$ACKCNT" = "$NUMACKS"
then
	EVENTSTITLE="$ACKCNT events (or more)  acknowledged in the last $LASTMINUTES minutes"
else
	EVENTSTITLE="$ACKCNT events acknowledged in the last $LASTMINUTES minutes"
fi

echo "<BR><BR>
<TABLE SUMMARY=\"$EVENTSTITLE\" BORDER=0>
<TR BGCOLOR=\"333333\">
<TD ALIGN=CENTER COLSPAN=6><FONT SIZE=-1 COLOR=\"teal\">$EVENTSTITLE</FONT></TD></TR>"

$CAT $BBHOME/tmp/acklog.$$ |
while read line
do
	if [ "$line" = "" ]
	then
		continue
	fi

	OUT=""
	OUT="${OUT}
<TR BGCOLOR=#000000>"

	set $line
	if [ "$#" -lt 7 ]
	then
		OUT="${OUT}
<TD COLSPAN=6>Invalid line in 'acks/acklog'</TD>"
		continue
	fi

	ACKMSG=""
	ACKTIME=`echo "$1" | $SED 's/[^0-9]//g'`
	if [ "$ACKTIME" = "" ]
	then
		continue
	fi
	if [ "$ACKTIME" -lt 900000000 ]
	then
		continue
	fi

	ACKGIF="-ack";

	# Does the tag file still exists ?
	ACKEVENT="$6"
	if [ ! -f "$BBACKS/ack.$ACKEVENT" ]
	then
		# SMM continue
		ACKGIF="";
	fi

	# Has the ACK expire ? Just in case the file wasn't removed
	TIMENOW=`$BBHOME/bin/touchtime -e`
	ACKDURATION=`$EXPR "$3" \* 60`
	ACKEXPIRES=`$EXPR "$ACKTIME" + "$ACKDURATION"`
	if [ "$ACKEXPIRES" -lt "$TIMENOW" ]
	then
		# SMM continue
		ACKGIF="";
	fi

	ACKDATE="`$BBHOME/bin/touchtime -c $ACKTIME`"
	ACKNPID="$2"
	ACKNUMBER="$4"
	ACKRCPT=`echo "$5" | $SED -e 's/^np_//g' -e 's/_[^_]*$//g'`
	COLOR=$7
	shift 7
	if [ "$#" -gt 0 -a "$SHOWMSG" = "TRUE" ]
	then
		ACKMSG="`echo $* | $AWK '{printf "%.*s",'$MSGLEN',$0}' | $SED -e 's!%20! !g' -e 's/%21/!/g' -e 's!%22!\"!g' -e 's!%23!#!g' -e 's!%24!\$!g' -e 's!%25!\%!g' -e 's!%26!\&!g' -e \"s!%27!\'!g\" -e 's!%28!\(!g' -e 's!%29!\)!g' -e 's!%2[aA]!\*!g' -e 's!%2[bB]!+!g' -e 's!%2[cC]!,!g' -e 's!%2[dD]!\-!g' -e 's!%2[eE]!.!g' -e 's!%2[fF]!/!g' -e 's!%40!@!g' -e 's!%5[eE]!^!g'`"
	fi

	OLDIFS=$IFS
	IFS="."
	set $ACKEVENT
	IFS=$OLDIFS
	ACKHOST="$1"
	SVCNAME="???"
	shift
	while [ "$#" -gt 1 ]
	do
		ACKHOST="${ACKHOST}.$1"
		shift
	done
	if [ "$#" -ne 0 ]
	then
		SVCNAME="$1"
	fi

	OUT="${OUT}
<TD ALIGN=CENTER><FONT COLOR=white>$ACKDATE</FONT></TD>"

	OUT="${OUT}
<TD ALIGN=CENTER BGCOLOR=$COLOR><FONT COLOR=black>$ACKHOST</FONT></TD>"

	OUT="${OUT}
<TD ALIGN=CENTER><FONT COLOR=white>$SVCNAME</FONT></TD>"

	if [ "$COLOR" != "black" ]
	then
		OUT="${OUT}
<TD ALIGN=CENTER><IMG SRC="$BBSKIN/${COLOR}${ACKGIF}.gif"></TD>"
	else
		OUT="${OUT}
<TD ALIGN=CENTER><FONT COLOR=white>&nbsp;</FONT></TD>"
	fi

	OUT="${OUT}
<TD ALIGN=LEFT BGCOLOR=#000033>$ACKRCPT</TD>"

	OUT="${OUT}
<TD ALIGN=LEFT>$ACKMSG</TD></TR>"

	echo "${OUT}"
done

echo "</TABLE>"

$RM -f $BBHOME/tmp/acklog.$$

exit 0
