#!/usr/bin/perl
# $Id: hello.pl,v 1.6.2.2 2002/01/22 19:49:34 tm Exp $
#
# PDFlib client: hello example in Perl
#

use pdflib_pl 4.0;

$p = PDF_new();

die "Couldn't open PDF file" if (PDF_open_file($p, "hello.pdf") == -1);

PDF_set_info($p, "Creator", "hello.pl");
PDF_set_info($p, "Author", "Thomas Merz");
PDF_set_info($p, "Title", "Hello world (Perl)");

PDF_begin_page($p, 595, 842);

# Change "host" encoding to "winansi" or whatever you need!
$font = PDF_findfont($p, "Helvetica-Bold", "host", 0);

PDF_setfont($p, $font, 18.0);

PDF_set_text_pos($p, 50, 700);
PDF_show($p, "Hello world!");
PDF_continue_text($p, "(says Perl)");

PDF_end_page($p);
PDF_close($p);

PDF_delete($p);
