#!/bin/sh
# $Id: quickreference.tcl,v 1.7.2.1 2002/01/28 17:25:48 rp Exp $
#
# PDFlib/PDI client: mini imposition demo
#

# Hide the exec to Tcl but not to the shell by appending a backslash\
exec tclsh "$0" ${1+"$@"}

# The lappend line is unnecessary if PDFlib has been installed
# in the Tcl package directory
set auto_path [linsert $auto_path 0 .libs .]

package require pdflib 4.0

set maxrow	2
set maxcol	2
set startpage	128
set endpage	131
set width	500
set height	770
set infile	"../../doc/PDFlib-manual.pdf"

set p [PDF_new]

if {[PDF_open_file $p "quickreference.pdf"] == -1} {
    puts stderr "Couldn't open PDF file 'quickreference.pdf'!"
    exit
}

PDF_set_info $p "Creator" "quickreference.tcl"
PDF_set_info $p "Author" "Thomas Merz"
PDF_set_info $p "Title" "Mini Imposition Demo (Tcl)"

set manual [PDF_open_pdi $p $infile "" 0]
if {$manual == -1} {
    puts stderr "Couldn't open input file '$infile'."
    exit
}

set row 0
set col 0

for {set pageno $startpage} {$pageno <= $endpage} \
					{set pageno [expr $pageno + 1]} {
    if {$row == 0 && $col == 0} {
	PDF_begin_page $p $width $height
	set font [PDF_findfont $p "Helvetica-Bold" "host" 0]
	PDF_setfont $p $font 18
	PDF_set_text_pos $p 25 [expr $height-24]
	PDF_show $p "PDFlib 4.0 Quick Reference"
    }

    set page [PDF_open_pdi_page $p $manual $pageno ""]

    if {$page == -1} {
	puts stderr "Couldn't open page $pageno in '$infile'."
	exit
    }

    PDF_place_pdi_page $p $manual [expr $width/$maxcol * $col] \
	    [expr $height - ($row + 1) * $height/$maxrow] [expr 1.0/$maxrow] \
	    [expr 1.0/$maxrow]

    PDF_close_pdi_page $p $page

    set col [expr $col + 1]
    if {$col == $maxcol} {
	set col 0
	set row [expr $row + 1]
    }
    if {$row == $maxrow} {
	set row 0
	PDF_end_page $p
    }
}

# finish the last partial page
if {$row != 0 || $col != 0} {
    PDF_end_page $p
}
PDF_close $p
PDF_close_pdi $p $manual
PDF_delete $p
