/*
 * touchtime.c 
 * BIG BROTHER TOUCHTIME PROGRAM
 * Sean MacGuire
 * Version 1.9
 * Mar 13th, 2002
 *
 * (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
 *
 * Create a file with the given name half an hour old...
 * Default creates a file 30 minutes old. (-30)
 * -e returns the current tick
 *
 * Format: touchtime [offset-time] filename
 *	   touchtime -e <offset>
 *	   touchtime -a <offset>
 *	   touchtime -c <timetick>
 */

/* DYNIX also require <time.h> */
/* Thanks to <stephencouch@hotmail.com> */

#include "bb.h"
#include <stdio.h>
#include <sys/types.h>
#ifdef TIMEH
#include <time.h>
#else
#include <sys/time.h>
#endif
#include <utime.h>

char bbprog[] = "touchtime";

#define NOYEAR 1		/* FOR NOW */


/*
 * NEW CODE WARNING HERE...
 * LOW RISK FUNCTION... SHOULDN'T BE A PROBLEM
 */
int getmonth(month)
char *month;
{
        int mnum=-1;
        if (strcmp(month,"Jan") == 0) mnum=0;
        else if (strcmp(month,"Feb") == 0) mnum=1;
        else if (strcmp(month,"Mar") == 0) mnum=2;
        else if (strcmp(month,"Apr") == 0) mnum=3;
        else if (strcmp(month,"May") == 0) mnum=4;
        else if (strcmp(month,"Jun") == 0) mnum=5;
        else if (strcmp(month,"Jul") == 0) mnum=6;
        else if (strcmp(month,"Aug") == 0) mnum=7;
        else if (strcmp(month,"Sep") == 0) mnum=8;
        else if (strcmp(month,"Oct") == 0) mnum=9;
        else if (strcmp(month,"Nov") == 0) mnum=10;
        else if (strcmp(month,"Dec") == 0) mnum=11;
#if DEBUG
        debug("Month number set to %d\n", mnum);
#endif
        return(mnum);
}


int main(argc, argv)
int argc;
char *argv[];
{
	FILE *fp;
        time_t ticks,dateticks;
	struct tm *ta;
	struct utimbuf *tb;
	int howlong;
	char *touchfile = (char *)malloc(256);
	char *mon = (char *)malloc(256);
	char time_asc[32];

	if (argc == 3 && strcmp(argv[1],"-e") && strcmp(argv[1],"-a") && strcmp(argv[1],"-c") ) {	
		sscanf(argv[1], "%d", &howlong);
		sscanf(argv[2], "%s", touchfile);
	}
	else if (argc == 3 && (!strcmp(argv[1],"-e") || !strcmp(argv[1],"-a")) ) {	
		sscanf(argv[2], "%d", &howlong);
	}
	else if (argc == 3 && (!strcmp(argv[1],"-c")) ) {
		/* Check if time_t is an 8-byte long */
		if( sizeof(dateticks) > 4 ) {
			sscanf(argv[2], "%ld", &dateticks);
		}
		else {
			sscanf(argv[2], "%d", &dateticks);
		}
	}
	else if (argc == 2) {
		if ( !strcmp(argv[1],"-e") || !strcmp(argv[1],"-a") ) {
			howlong = 0;
		}
		else {
			howlong = -30;		/* DEFAULT 30 MINUTES AGO */
			sscanf(argv[1], "%s", touchfile);
		}
	}
	else {
		fprintf(stderr, "Format: %s [offset] filename\n", argv[0]);
		exit(1);
	}

	howlong *= 60;			/* NOW IN SECONDS */

        ticks = time(&ticks) + howlong;

	/* Display the date in ASCII based on the time tick given as argument */
	if ( !strcmp(argv[1],"-c") ) {
		sprintf(time_asc,"%s",ctime(&dateticks));
		time_asc[strlen(time_asc)-1] = '\0';
		printf("%s",time_asc);
		exit(0);
	}

	/* Display the time tick value associated */
	if ( !strcmp(argv[1],"-e") ) {
		printf("%d",ticks);
		exit(0);
	}

	/* Display the date in ASCII based on the offset given as argument */
	if ( !strcmp(argv[1],"-a") ) {
		sprintf(time_asc,"%s",ctime(&ticks));
		time_asc[strlen(time_asc)-1] = '\0';
		printf("%s",time_asc);
		exit(0);
	}

/* 
 * NEW CODE WARNING SECTION... IF THERE'S A PROBLEM... IT'S HERE
 */
	/*
	 * SMM WEB-DATE MANIPULATION
	 * -d SENDS BACK DIFF BETWEEN THEN AND NOW
	 * -x RETURN THE EPOCH TIME (AT MIDNIGHT) GIVEN AN ASCII DATE
	 * 	of the form Mon Day Year (apr 13 2000)
	 */
	if ( !strcmp(argv[1],"-d") || !strcmp(argv[1],"-x") ) {	/* SMM */
		ta=(struct tm *)malloc(sizeof (struct tm));
		if (argc != 3) {
			fprintf(stderr, "Format: %s -d|e  WEB-TIME\n", argv[0]);
			exit(2);
		}
#if DEBUG
		debug("ARGV 2: %s\n", argv[2]);
#endif
		sscanf(argv[2], "%s %d %d", mon, &ta->tm_mday, &ta->tm_year);
		ta->tm_mon=getmonth(mon);		/* SMM */
		ta->tm_year-=1900;	/* ADJUST YEAR */
		ta->tm_hour=0;
		ta->tm_min=0;
		ta->tm_sec=0;
		ta->tm_isdst=-1;

#if DEBUG
		debug("DAY  : %d\n", ta->tm_mday);
		debug("MON  : %d\n", ta->tm_mon);
		debug("YEAR : %d\n", ta->tm_year);
		debug("HOUR : %d\n", ta->tm_hour);
		debug("MIN  : %d\n", ta->tm_min);
		debug("SEC  : %d\n", ta->tm_sec);
#endif
		ticks=time(&ticks);		/* TIME NOW */
#if DEBUG
		debug("TICKS: %d\n", ticks);
		debug("ASCII TIME: %s\n", ctime(&ticks));
#endif
		if ( !strcmp(argv[1],"-x") ) {
			/* PRINT THE EPOCH OF THE WEBTIME IN SECONDS */
			printf("%d\n", mktime(ta));
		}
		else if ( !strcmp(argv[1],"-d") ) {
			/* PRINT THE DIFFERENCE IN SECONDS */
			printf("%d\n",ticks-mktime(ta));
		}
		exit(0);
	}

/*
 * END NEW CODE WARNING SECTION
 */

	tb=(struct utimbuf *)malloc(sizeof (struct utimbuf));

	tb->actime=ticks;
	tb->modtime=ticks;

	/*
	 * NOW CREATE THE TOUCHFILE
	 * OR JUST CHANGE THE MODIFICATION TIME IF IT ALREADY EXISTS
	 */
	if( (fp=fopen(touchfile, "a")) != NULL ){
		fclose(fp);
	}
	else {
		fprintf(stderr, "%s: Can't open filename %s\n", argv[0], touchfile);
		exit(2);
	}
	utime(touchfile, tb);

	exit(0);
}

