#!/bin/sh
#
# bbinc.sh
#
# Sean MacGuire
# Version 1.9c
# May 15th, 2002
#
# (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
#

BBREL="1.9c"
BBRELDATE="Wed, 15 May 2002 11:00:00 GMT"
export BBREL BBRELDATE

# --------------------------------------------------
# Big Brother - Pager codes and system definitions
#
# NO CHANGES SHOULD BE NEEDED HERE
# --------------------------------------------------
#
if [ "$BBHOME" = "" ]
then
	echo "bbinc.sh: BBHOME not set !"
	exit 1
fi

BB="${BBHOME}/bin/bb"			# WHERE bb LIVES
BBHOSTS="${BBHOME}/etc/bb-hosts"        # BIG BROTHER HOSTS FILE
BBDFTAB="${BBHOME}/etc/bb-dftab"	# LEVELS BY DISK PARTITION
BBCPUTAB="${BBHOME}/etc/bb-cputab"	# LEVELS BY DISK PARTITION
BBPROCTAB="${BBHOME}/etc/bb-proctab"	# LEVELS BY DISK PARTITION
BBEXTTAB="${BBHOME}/etc/bb-bbexttab"	# EXTERNAL SCRIPTS TO RUN LOCALLY
BBMSGSTAB="${BBHOME}/etc/bb-msgstab"	# MSGS KEYWORDS/PHRASES TO CHECK
BBREP="${BBHOME}/www/rep"		# WHERE GENERATED REPORTS LIVE
BBNOTES="${BBHOME}/www/notes"           # WHERE THE SYSTEM NOTES LIVE

#
OLDIFS=$IFS
IFS="/" 
set $BBHOME
IFS=$OLDIFS

# Usually the BB saved logs lives in the directory on top the BBHOME
BBTOP=""
while [ "$#" -gt 1 ]
do
	# Don't accept empty args
	if [ "$1" != "" ]
	then
		BBTOP="$BBTOP/$1"
	fi
	shift
done

BBVAR=$BBTOP/bbvar
# If you want a different BBVAR just modify the next line and uncomment
# BBVAR=/some/directory/structure

BBLOGS="${BBVAR}/logs"		# WHERE THE LOG FILES LIVE
BBHISTLOGS="${BBVAR}/histlogs"	# WHERE THE HISTLOG FILES LIVE
BBHIST="${BBVAR}/hist"		# WHERE THE HIST FILES LIVE
BBDATA="${BBVAR}/data"		# WHERE THE DATA FILES LIVE (data message type)
BBACKS="${BBVAR}/acks"		# WHERE THE ACKS/NOTIF LOGS  LIVE
BBDISABLED="${BBVAR}/disabled"	# WHERE THE DISABLE TAG FILES  LIVE

export BB BBHOSTS BBDFTAB BBCPUTAB BBPROCTAB BBEXTTAB BBMSGSTAB BBNOTES
export BBREP BBTOP BBVAR BBLOGS BBHISTLOGS BBHIST BBDATA BBACKS BBDISABLED

NETERR="7"				# NETWORK ERROR 7 + PORT NUMBER
					# KEEP FOR BACKWARD COMPATABILITY
export NETERR

# --------------------------------------------------
# SMM NEW IN 1.3
# TITLES FOR DISPLAY ELEMENTS USED BY mkbb.sh
# THIS IS TO FACILITATE CHANGES AND TRANSLATION
# --------------------------------------------------
MKBBLOCAL="<B><I>Pages Hosted Locally</I></B>"
MKBBSUBLOCAL="<B><I>Subpages Hosted Locally</I></B>"
MKBBREMOTE="<B><I>Remote Status Display</I></B>"
export MKBBLOCAL MKBBREMOTE MKBBSUBLOCAL

# YOU CAN CHANGE FONT ATTRIBUTES FOR ROWS AND COLUMNS HERE
# THIS IS USED AS TITLES FOR THE TABLES
MKBBTITLE="COLOR=ivory SIZE=+1"

# THIS IS USED FOR THE MACHINE NAMES
MKBBROWFONT="SIZE=+1 COLOR=\"#FFFFCC\" FACE=\"Tahoma, Arial, Helvetica\""

# THIS IS USED FOR COLUMN HEADINGS ACROSS THE TOP
MKBBCOLFONT="COLOR=teal SIZE=-1"

# THIS IS USED FOR THE ACK MESSAGE AT THE BOOTOM OF A STATUS
MKBBACKFONT="COLOR=silver SIZE=-1"

export MKBBROWFONT MKBBCOLFONT MKBBTITLE MKBBACKFONT

MKBBMANAGE="<B><I>Managed Instances</I></B>"
export MKBBMANAGE # 2.0

DAYS="days"
HOURS="hours"
MINS="minutes"
STATUNCHMSG="Status unchanged in"
RECVFROMMSG="Status message received from"
export RECVFROMMSG STATUNCHMSG DAYS HOURS MINS

MKBBEMPTYPAGE="<FONT ${MKBBROWFONT}>There are no hosts defined on this page</FONT>"
export MKBBEMPTYPAGE

# You can change the colored dots HEIGHT and WIDTH here
DOTHEIGHT=16
DOTWIDTH=16
export DOTHEIGHT DOTWIDTH

# You can change the entire look by changing the default gifs
BBSKIN="${BBWEB}/gifs"; export BBSKIN
#BBSKIN="${BBWEB}/gifs-bb13"; export BBSKIN	# OLD 1.3 STYLE GIFS
#
# FIGURE OUT THE LOCAL MACHINE NAME
# USE FULLY QUALIFIED MACHINE NAMES?
# DOT -> COMMA -> DOT FOR WEB DISPLAY
#

if [ -f "$BBHOME/etc/bbaliasname" ]; then
        MACHINE=`$CAT $BBHOME/etc/bbaliasname`
else
        MACHINE=`uname -n`
fi

# New code 1.09 - RAC
#
# Extract the host part if not FQDN
if test "$FQDN" != "TRUE"
then
	set `echo $MACHINE | $SED "s/\./ /"` >/dev/null 2>&1
	MACHINE=$1
fi

set ""		# force a set or it will keep the old $* if it failed

# Do we match: "255.255.255.255 ${MACHINE}" ?
set `$GREP -i "^[0-9][0-9\.]*[ 	][ 	]*${MACHINE}$" $BBHOSTS` >/dev/null 2>&1
if [ "$#" -lt 2 -o "$2" = "" ]
then
	# Do we match: "255.255.255.255 ${MACHINE} # blah blah blah" ?
	# Do we match: "255.255.255.255 ${MACHINE}.domain.com # blah blah blah" ?
	set `$GREP -i "^[0-9][0-9\.]*[ 	][ 	]*${MACHINE}[\. 	].*$" $BBHOSTS` >/dev/null 2>&1
fi

if [ "$#" -lt 2 -o "$2" = "" ]
then
	echo "This host <${MACHINE}> was not found in the etc/bb-hosts file"
	echo "Please use the same name from 'uname -n'"
	exit 1
fi
# End of new code 1.09 - RAC

# SMM 1.09 - OFFLOAD CODE FROM RUNBB.SH 
# CHECK IF THIS MACHINE IS A BBDISPLAY

# echo "TESTING RESULTS FROM $*"

echo "$*" | $GREP BBDISPLAY > /dev/null 2>&1 
if test "$?" = "0"
then
	BBDISPLAY="TRUE"
	BBSERVER="TRUE"
fi

echo "$*" | $GREP BBPAGER > /dev/null 2>&1 
if test "$?" = "0"
then
	BBPAGER="TRUE"
	BBSERVER="TRUE"
fi

echo "$*" | $GREP BBNET > /dev/null 2>&1 
if test "$?" = "0"
then
	BBNET="TRUE"
fi

relayline=`echo "$*" | $GREP "BBRELAY:" 2>/dev/null`

export BBDISPLAY BBPAGER BBNET

MACHINE=$2				# GET FQDN NAME FROM etc/bb-hosts
MACHIP=`echo $1 | $SED "s/\.//g"`	# IP ADDRESS FOR PAGER DISPLAY

#
# MACHINEADDR REPRESENTS THE IP or THE NAME OF THE LOCAL HOST
# USE NAME IF IP = 0.0.0.0
#
if [ "$1" = "0.0.0.0" ]
then
	MACHINEADDR="$2"
else
	MACHINEADDR="$1"
fi
export MACHINEADDR

if test "$FQDN" = "TRUE"
then
	MACHINEDOTS=$MACHINE
	MACHINE=`echo $MACHINE | $SED "s/\./,/g"`
else
	set `echo $MACHINE | $SED "s/\./ /"`
	MACHINE=$1
	MACHINEDOTS=$MACHINE
fi

export MACHINE MACHIP MACHINEDOTS

#
# WHERE THE BIG BROTHER SERVERS LIVE
# LOOK IN bb-hosts FOR DISPLAY AND PAGER HOSTS
# SMM ADD SUPPORT FOR MULTIPLE BBDISPLAYS
#

bbline=`$GREP BBDISPLAY $BBHOSTS | $GREP "^[0-9]" | $GREP -v "^\#" | \
		$AWK '{print $1 " " $2}'` 2>/dev/null
if [ -z "$bbline" ]
then
	echo "*** FATAL ERROR: BBDISPLAY not set in etc/bb-hosts!"
	exit 2
fi

set $bbline
BBDISPLAYS=""

while [ "$#" -ne 0 ]
do
	if test "$1" = "0.0.0.0"		# SMM 1.10 DDNS SUPPORT
	then
		BBDISPLAYS="${BBDISPLAYS} $2" 	# USE THE NAME
	else	
		BBDISPLAYS="${BBDISPLAYS} $1"	# USE THE IP ADDR
	fi
	shift;shift				# Advance to next BBDISPLAY
done

BBDISPLAYS=`echo $BBDISPLAYS`

set $BBDISPLAYS
if test "$#" -eq 1
then
	BBDISP="$1"			# ORIGINAL FLAVOR...
	BBDISPLAYS=""
else
	BBDISP="0.0.0.0"		# DUMMY - DON'T USE...
fi

export BBDISP
export BBDISPLAYS		# bb EXECUTABLE USE THIS INSTEAD IF BBDISP = 0.0.0.0


# SMM ADD SUPPORT FOR MULTIPLE BBPAGERS

bbline=`$GREP BBPAGER $BBHOSTS | $GREP "^[0-9]" | $GREP -v "^\#" | \
		$AWK '{print $1 " " $2}'` 2>/dev/null
if [ -z "$bbline" ]
then
	# DEFAULT TO THE SAME THING AS BBDISPLAY
	BBPAGE=$BBDISP
	BBPAGERS=$BBDISPLAYS
else
	set $bbline
	BBPAGERS=""

	while [ "$#" -ne 0 ]
	do
		if test "$1" = "0.0.0.0"		# SMM 1.10 DDNS SUPPORT
		then
			BBPAGERS="${BBPAGERS} $2" 	# USE THE NAME
		else	
			BBPAGERS="${BBPAGERS} $1"	# USE THE IP ADDR
		fi
		shift;shift				# Advance to next BBPAGER
	done

	BBPAGERS=`echo $BBPAGERS`
	set $BBPAGERS
	if test "$#" -eq 1
	then
		BBPAGE="$1"			# ORIGINAL FLAVOR...
		BBPAGERS=""
	else
		BBPAGE="0.0.0.0"		# DUMMY - DON'T USE...
	fi
fi

unset bbline

export BBPAGE
export BBPAGERS		# bb EXECUTABLE USE THIS INSTEAD IF BBPAGE = 0.0.0.0

#
# Determine if any relay host has been defined
#
BBRELAYS=""
for relay in $relayline
do
	case $relay
	in
		BBRELAY:* )
			OLDIFS=$IFS
			IFS=':'
			set $relay
			IFS=$OLDIFS
			shift		# Remove BBRELAY from arg list
			if [ "$#" -eq 1 -a "$1" != "0.0.0.0" -a "$1" != "" ]
			then
				if [ "$BBRELAYS" = "" ]
				then
					BBRELAYS="$1"
				else
					echo "$BBRELAYS" | $GREP "$1" >/dev/null 2>&1
					if [ "$?" -ne 0 ]
					then
						BBRELAYS="$BBRELAYS $1"
					fi
				fi
			fi
			;;
		* )
			;;
	esac
done

if [ "$BBRELAYS" != "" ]
then
	BBSERVER="TRUE"
fi

export BBRELAYS

unset relayline


export BBSERVER 


#
# GET PAGELEVELS FROM etc/bbwarnsetup.cfg. IT CONTAINS THE COLOR
# ON WHICH A NOTIFICATION SHOULD BE SENT
# IF YOU CHANGE THE VALUE pagelevels IN etc/bbwarnsetup.cfg YOU
# MUST RESTART BB.  MAKE SURE THE pagelevels VALUE IS
# IDENTICAL ON ALL CLIENTS
# Default colors are in bbdef.sh

pagelevelsline=`$GREP "^pagelevels:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
if [ "$?" -eq 0 ]
then
        set $pagelevelsline >/dev/null 2>&1
        if [ "$#" -gt 1 ]
        then
                shift           # remove pagelevels token from line
                param="$*"

                # Check if it's a valid parameter, remove bad values

                PAGELEVELS=""
                for color in $param
                do
                        case $color in  
      
                        yellow | red | purple )

                                PAGELEVELS="$PAGELEVELS $color"
                                ;;

                        * )
                                ;;

                        esac
                done
		unset param
        fi
fi
export PAGELEVELS

unset pagelevelsline
unset OLDIFS

#echo "=====> 1) $MACHINE 2) $MACHIP 3) $BBDISP 4) $BBPAGE 5) $BBDISPLAYS 6) $BBPAGERS"
