;
;     Free DOS Alternative Kernel;  FDBOOT v. 1.10 (01-06-98)
;
;     =           Kernel Heading Sector (Loader)            =
;
;               by Yury Semenov (yury@ultra.paco.net)
;

INCLUDE		FDBOOT.INC
INCLUDE		FDFUNC.INC

BOOT SEGMENT AT 0
ASSUME CS:BOOT, DS:BOOT
        ORG 0
        jmp near ptr BEGIN

BootRecord BOOTR <"FDLOADER",512,1,1,2,224,2880,0f0h,9,18,2,0,0,0,29h,0,"Free DOS","FAT12">

BEGIN:  DB 2 DUP(0)
        ; Align to paragraph boundary :-(
        ; If this segment ends not just at paragraph boundary then VAL
        ; makes incorrect data relocation fixups

BOOT ENDS

HEAD		SEGMENT
	ASSUME	CS:HEAD,DS:BOOT
        	ORG	0
IFDEF XBOOTHEAD
 DATA_WINDOW	EQU	XBOOTADDR
		int	19h
                DB	"XB"
		jmp short START
ELSE
 DATA_WINDOW	EQU	DATAWIN
              	;jmp	START
                DB	0eah
                DW	DATA_WINDOW + START, 0
ENDIF

 FileSys_FAT12	DB	"FAT12   "
 FileSys_FAT16	DB	"FAT16   "
 FAT12_Flag	DB	0
 REG_CLUST	DW	0fff0h
 FATSector	DW	-1
 HIPTR		LABEL	DWORD
 HIPTRlo	DW	0fffeh
 HIPTRhi	DW	0

 START:
; * Create stack frame
		mov	cs:S_SP[DATA_WINDOW], sp
		mov	cs:S_SS[DATA_WINDOW], ss
                push	es
                push	ds
                push	bp
                push	di
                push	si
                push	dx
                push	cx
                push	bx
                push	ax
; * and preserve starting cluster
                push	di ; Starting kernel (or xboot) cluster
; * Query for File System ID
                cmp	BootRecord.ExtBoot[LOADED],0
                jz	NoExt
                mov	si,offset BootRecord.FileSysID[LOADED]
                mov	di,offset FileSys_FAT16[DATA_WINDOW]
                mov	cx,8
                cld
                push	si
                push	cx
                rep	cmpsb
                pop	cx
                pop	si
                jz	ID_16
                mov	di,offset FileSys_FAT12[DATA_WINDOW]
                rep	cmpsb
                jz	ID_12
 NoExt:		cmp	BootRecord.TotSec[LOADED],20740
                ja	ID_16
	ASSUME	DS:HEAD
 ID_12:         mov	FAT12_Flag[DATA_WINDOW],1
                and	byte ptr REG_CLUST[DATA_WINDOW+1],0fh
        ASSUME	DS:BOOT
 ID_16:
; * Initializing pointers to upper conventional memory 64k segment
                int	12h
                sub	ax,40h
                jc	NoMem
                mov	cl,6
                shl	ax,cl
                cmp	ax,80h
                jae	MemOk
 NoMem:		int	19h
	ASSUME	DS:HEAD
 MemOk:         mov	HIPTRhi[DATA_WINDOW],ax
	ASSUME	DS:BOOT
; 		mov	bx,KernOfs
;                mov	ax,[bx].F_cluster
                pop	ax ; Starting kernel cluster
; * Cluster Chain processing; AX - starting cluster
 Cont:
                push	ax
                mov	si,TransLS
                push	[si]                      ;-( Damned hacking burden
                mov	byte ptr [si], 0c3h       ; RETN
                call	TransCl                   ; *Now* TransCl returns
                pop	[si]                      ; logical sector in DX:AX
                mov	cl,BootRecord.ClustSz[LOADED]
                xor	ch,ch
 ClustLoop:     push	cx
                push	dx
                push	ax
                call	TransLS
                push	es
	ASSUME	DS:HEAD
                les	di,HIPTR[DATA_WINDOW]
                std
                mov	ax,cx
                stosw
                mov	ax,dx
                stosw
                mov	HIPTRlo[DATA_WINDOW],di
                xor	ax,ax
                stosw
	ASSUME	DS:BOOT
                pop	es

                pop	ax
                pop	dx
                add	ax,1
                adc	dx,0
                pop	cx
                loop	ClustLoop
                pop	ax
                call	GetFAT
	ASSUME	DS:HEAD
                cmp	ax,REG_CLUST[DATA_WINDOW]
                jb	Cont

                mov	si,offset LOADER_BEG[DATA_WINDOW]
                les	di,HIPTR[DATA_WINDOW]
                mov	dx,es
                sub	di, 2 + LOADER_END - LOADER_BEG
                mov	ax,di
                and	ax,0fffeh
                mov	ss,dx
                mov	sp,ax
                mov	cx, 18 ; stack frame size
                sub	sp, cx ; skip stack frame
                mov	ax,sp
                push	ds
                push	si
                push	di
                mov	di,ax
                mov	ds,cs:S_SS[DATA_WINDOW]
                mov	si,cs:S_SP[DATA_WINDOW]
                sub	si,cx
                cld
                rep	movsb
                pop	di
                pop	si
                pop	ds
                push	es
                push	di
                mov	cx, LOADER_END - LOADER_BEG
                cld
                rep	movsb
                retf

	ASSUME	DS:BOOT

; * FAT processing procedures

GetFAT		PROC NEAR             ; AX - Cluster #
		cmp	FAT12_Flag[DATA_WINDOW],0
                jz	Prep16
                push	ax
                shr	ax,1
                pop	ax
                pushf
                mov	cx,3
                mul	cx
                dec	cx
                div	cx
                xor	dx,dx
                jmp	OffsOk
 Prep16:        mov	cx,2
                mul	cx
 OffsOk:        div	BootRecord.SectSz[LOADED]
                call	GetFATPage
                mov	bx,dx
                cmp	bx,1ffh
                jnz	NoOverrun
                mov	cl,byte ptr [bx + DIRWIN]
                push	cx
                inc	ax
                call	GetFATPage
                pop	ax
                mov	ah,byte ptr ds:[DIRWIN]
 Norm12:        popf
 		jc	OddCluster
                and	ah,0fh
                ret
 OddCluster:    mov	cl,4
 		shr	ax,cl
                ret
 NoOverrun:     mov	ax,[bx + DIRWIN]
 		cmp	FAT12_Flag[DATA_WINDOW],0
                jnz	Norm12
		ret
GetFAT		ENDP

GetFATPage	PROC NEAR             ; AX - FAT sector
		cmp	ax,FATSector[DATA_WINDOW]
                jz	PageOk
                mov	FATSector[DATA_WINDOW],ax
                push	ax
                push	dx
                mov	ax,word ptr BootRecord.Hidden[LOADED]
                mov	dx,word ptr BootRecord.Hidden[LOADED+2]
                add	ax,word ptr BootRecord.ResSec[LOADED]
                adc	dx,0
                add	ax,FATSector[DATA_WINDOW]
                adc	dx,0
                call	TransLS
                mov	bx,DIRWIN
                call	ReadSector
                pop	dx
                pop	ax
 PageOk:	ret
GetFATPage	ENDP


LOADER_BEG:

IFDEF XBOOTHEAD
 INCLUDE		XBOOTLDR.INC
ELSE
 INCLUDE		KRNLOAD.INC
ENDIF

		CALL	ERRORMSG
		DB	"Boot Failed",13,10,0
		INT	19H

ERRORMSG	PROC NEAR
		POP	BX
 NEXTCH:	MOV	AL,CS:[BX]
                INC	BX
                OR	AL,AL
                JZ	WKEY
                MOV	AH,0EH
                INT	10H
                JMP	NEXTCH
 WKEY:		PUSH	BX
 		XOR	AH,AH
                INT	16H
                RET
ERRORMSG	ENDP

IFNDEF	XBOOTHEAD
 S_SP	DW	0
 S_SS	DW	0
ENDIF

LOADER_END:


		ORG 511     ; Yet Another VAL bug :-(
		DB  0       ; ORG as last directive in source truncate dest.
                            ; file at N-th byte instead appending N zeros

HEAD		ENDS

	END 	START
