(*
$Id: tools.pas 1.2 2001/09/04 15:40:44 tony Exp tony $
$Log: tools.pas $
Revision 1.2  2001/09/04 15:40:44  tony
Fixed menu bar, status bar, cleaned up code

Revision 1.1  2001/08/13 16:03:51  tony
Initial revision


        Tony's Full Screen Editor
        Version 1.00

        Copyright (C) AGE Software
        All rights reserved

        Purpose: Full screen multi-purpose editor.
        FILENAME: TOOLS.PAS

        Contains procedures and functions related to DOS,
        Windows, and hardware detection.

*)

unit Tools;

interface
{$IFNDEF TOOLS}
{$ENDIF}
{$DEFINE TOOLS15}

function IsSmartDrv4Installed : boolean;
function GetOEMNumber : byte;
function GetSmartDrvVer : word;
function Is4DOS : boolean;
function Get4DOSVer : word;
function GetDOSInfo : byte;
function Is_DrDOS : word;

implementation

uses dos;

function Is4DOS;
(*
    This function detects whether 4DOS is the current shell under which
    a program is running
*)
var r : registers;

begin
  r.ax := $D44D;
  r.bx := 0;
  intr ($2f, r);
  Is4DOS := (r.ax = $44DD);
end;

function Get4DOSVer;

begin
  asm
    mov ax, 0D44DH
    mov bx, 0
    int 2fH
    mov @Result, bx
  end;
end;

function GetOEMNumber;
var
  r : registers;

begin
  r.ah := $30;
  r.al := 0;
  msdos(r);
  GetOEMNumber := r.bh;
end;

function GetDOSInfo;

var
  r : registers;

begin
  if lo(DosVersion) = 6 then begin
    r.ax := $3306;  { Get real MS-DOS version }
    msdos (r);
    GetDOSInfo := r.dh { DX register contains revision number and version flags }
  end
    else GetDOSInfo := 0; { DOS doesn't support this function }
end;

function IsSmartDrv4Installed;

var r : registers;

begin
  r.ax := $4A10;
  r.bx := 0;
  r.cx := $EBAB;
  intr($2f, r);
  IsSmartDrv4Installed := (r.ax = $BABE);
end;

function GetSmartDrvVer : word;

var r : registers;

begin
  r.ax := $4A10;
  r.bx := 0;
  r.cx := $EBAB;
  intr($2f, r);
  if r.ax = $EBAB then
    GetSmartDrvVer := r.bp
end;
function Is_DrDOS; external;
{$L IS_DRDOS.OBJ}

end.
