/* REBOOT - reboots the computer.  can do either a cold boot or a
   warm boot.  a warm boot will skip the memory test. */

/* most of the code you see here was actually written by Mike
   O'Carroll, lena!mike@relay.EU.net */

/* no copyright was placed on Mike O'Carroll's original code, and I
   (Jim Hall) am assuming the code was in the public domain.  To
   protect both Mike O'Carroll's rights, and mine, I am now
   (25 May 1998) placing the code under the GNU GPL.  See the file
   COPYING for details. */

/* Copyright (C) Mike O'Carroll */

/* Copyright (C) 1994--1998 Jim Hall, jhall1@isd.net.  This copyright
   statement only applies to the "larger work", which is the REBOOT
   program that was derived from Mike O'Carroll's original code. */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <stdlib.h>				/* Borland: for exit */
#include <conio.h>				/* Borland: for getch */
#include "getopt.h"


/* Symbolic constants */

#define COLD 0					/* for cold restart */
#define WARM 0x1234				/* for warm restart */

#define BOOT_SEG        0xffffL
#define BOOT_OFF        0x0000L
#define BOOT_ADR        ((BOOT_SEG << 16) | BOOT_OFF)

#define DOS_SEG         0x0040L
#define RESET_FLAG      0x0072L
#define RESET_ADR       ((DOS_SEG << 16) | RESET_FLAG)


/* Functions */

void usage (void);


/* the program */

int
main (int argc, char **argv)
{
  int ask_first = 0;				/* bool: ask before reboot */
  int c, magic = COLD;
  void ((far * fp) ()) = (void (far *) ()) BOOT_ADR;

  /* Scan the command line */

  while ((c = getopt (argc, argv, "cCwWvV?")) != EOF) {
    switch (c) {
    case 'c':
    case 'C':
      magic = COLD;
      break;

    case 'w':
    case 'W':
      magic = WARM;
      break;

    case 'v':
    case 'V':
      /* Turn on verify */
      ask_first = 1;
      break;

    default:
      usage ();
      exit (0);
      break;
    }
  }

  if (optind < argc) {
    usage ();
    exit (1);
  }

  /* Reboot */

  if (ask_first) {
    fprintf (stderr, "Really reboot the computer (Y/N)? ");
    ask_first = getch();

    if ((ask_first != 'y') && (ask_first != 'Y')) {
      fprintf (stderr, "No\n");
      exit (0);
    }
  }

  *(int far *) RESET_ADR = magic;
  (*fp) ();

  /* Never gets here, but keeps compiler happy */

  exit (0);
}

/* usage - prints information on how to use the program */

void
usage (void)
{
  fprintf (stderr, "REBOOT - Immediately reboot the computer\n");
  fprintf (stderr, "Usage:\n");
  fprintf (stderr, "\tREBOOT [/V] [/W | /C]\n");

  fprintf (stderr, "\t\t/V - Verify before rebooting, as in a batch file\n");
  fprintf (stderr, "\t\t/W - Perform a warm boot (skip the memory test)\n");
  fprintf (stderr, "\t\t/C - Perform a cold boot (do the memory test)\n");
}
