#ifndef LONG_LONG_H_
#define LONG_LONG_H_

struct LongLongStruct {
   unsigned long hi;
   unsigned long lo;
};

typedef struct LongLongStruct long_long;

long_long ull_add(long_long term1, long_long term2);
long_long ull_sub(long_long subtractnumber, long_long subtracter);
long_long ull_mul(long_long factor1, long_long factor2);
long_long ull_div(long_long dividenumber, long_long divider);

long_long ultoll(unsigned long number);
long_long utoll(unsigned number);

#define lltoul(number) number.lo
#define lltou(number) ((unsigned) number.lo)

long_long atoull(char* number);
char*     ulltoa(long_long number, char* result);

int is_ull_smaller(long_long num1, long_long num2);
int is_ull_larger(long_long num1, long_long num2);

long_long ull_max(void);

#define is_ll_null(number) ((number.lo == 0) && (number.hi == 0))
#define is_ull_null is_ll_null

#define is_ll_equal(num1, num2) ((num1.hi == num2.hi) && (num1.lo == num2.lo))
#define is_ull_equal is_ll_equal

long_long hextoull(char* hex);
char* ulltohex(long_long num, char* result);

long_long ull_inc(long_long term);
long_long ull_dec(long_long term);

long_long ull_mul2(long_long fact);
long_long ull_mul256(long_long fact);
long_long ull_div2(long_long divnum);

/* Basic error handling. */
#define LNGLNG_OK        0  /* No error encountered.              */
#define LNGLNG_OVERFLOW  1  /* Overflow detected.                 */
#define LNGLNG_UNDERFLOW 2  /* Underflow detected.                */
#define LNGLNG_DIVBY0    3  /* Division by zero.                  */
#define LNGLNG_INVALID   4  /* Invalid character in input string. */

int Read_ll_status(void);   /* Read & Clear error status.         */

#endif
