#!/usr/bin/python
# $Id: image.py,v 1.6.2.1 2001/05/16 12:25:50 york Exp $
#
# PDFlib client: image example in Python
#

from sys import *
from pdflib_py import *

p = PDF_new()

if PDF_open_file(p, "image.pdf") == -1:
    print "Couldn't open PDF file 'image.pdf'\n"
    exit(2)

PDF_set_info(p, "Author", "Thomas Merz")
PDF_set_info(p, "Creator", "image.py")
PDF_set_info(p, "Title", "image sample (Python)")

imgfile = "../../test/nesrin.jpg"
image = PDF_open_image_file(p, "jpeg", imgfile, "", 0)

if image == -1:
    print "Couldn't open image file '" + imgfile + "'\n"
    exit(3)

# See the PDFlib manual for more advanced image size calculations
width = PDF_get_value(p, "imagewidth", image)
height = PDF_get_value(p, "imageheight", image)

# We generate a page with the image's dimensions
PDF_begin_page(p, width, height)
PDF_place_image(p, image, 0, 0, 1)
PDF_close_image(p, image)
PDF_end_page(p)

PDF_close(p)
PDF_delete(p)
