#
# Copyright (c) 1992 Universities Research Association, Inc.
#			 All Rights Reserved
#
#
# This material resulted from work developed under a Government Contract and
# is subject to the following license:	The Government retains a paid-up,
# nonexclusive, irrevocable worldwide license to reproduce, prepare derivative
# works, perform publicly and display publicly by or for the Government,
# including the right to distribute to other Government contractors.	Neither
# the United States nor the United States Department of Energy, nor any of
# their employees, makes any warrenty, express or implied, or assumes any
# legal liability or responsibility for the accuracy, completeness, or
# usefulness of any information, apparatus, product, or process disclosed, or
# represents that its use would not infringe privately owned rights.

# @(#) fermi.profile 1.40 Delta: 96/03/22 11:28:47 Extraction 96/03/26 10:56:29 @(#)

# fermi.profile settings for all users; called by the user bourne/korn .profile
# Set the umask so that newly created files and directories will be readable
# by others, but writable only by the user.
umask 022
MACH_ID="`/usr/local/bin/funame -n`"
MACH_TYPE="`/usr/local/bin/funame -m`"
MACH_OS="`/usr/local/bin/funame -s`"
MACH_REL="`/usr/local/bin/funame -r`"
#
# Set the PATH appropriately
#
if [ -r /usr/local/etc/setpath.sh ]
then
  . /usr/local/etc/setpath.sh
fi

#
# Set a respectable MANPATH
#
MANPATH=""
for DIR in /usr/products/catman \
	/usr/products/man \
	/afs/fnal/products/catman \
	/afs/fnal/products/man \
	/usr/catman \
	/usr/man \
	/usr/share/catman \
	/usr/share/man \
	/usr/local/catman \
	/usr/local/man \
	/usr/afsws/man \
	/opt/SUNWspro/man
do
	if [ -d ${DIR} ]
	then
		MANPATH=${MANPATH}${DIR}:
	fi
done
#
# Following put in to handle NQS
# Only do rest if non-interactive session
#
if [ "$ENVIRONMENT" != "BATCH" ] && [ "x`logname`" != "x" ]
then
#
# Determine the terminal type
#
TTYPE=`echo $TERM | cut -c1`
case $TERM in
""|arpanet|net|network|dialup|unknown|dumb)
	TERM=vt100
	if  tty -s
	then
		stty erase '^?'
	fi
;;
*)
	if [ -r /usr/lib/terminfo/$TTYPE/$TERM -o -r /usr/share/lib/terminfo/$TTYPE/$TERM ]
	then
		case $TERM in
		iris-ansi*)
			if tty -s
			then
				stty erase '^h'
			fi
		;;
		sun|ibm5081)
			TTYNAME=`tty | cut -c6-`
			#space after TTYNAME is important to get unique match
			modem=`who|grep "$TTYNAME "| grep -c modem`
			if [ "$modem" = "1" ]
			then
				TERM=vt100
			fi
			if tty -s
			then
				stty erase '^?'
			fi
		;;
		hp)
			if tty -s
			then
				stty erase '^h'
			fi
			TTYNAME=`tty | cut -c6-`
			#space after TTYNAME is important to get unique match
			modem=`who|grep "$TTYNAME "| grep -c pty/`
			if [ "$modem" = "1" ]
			then
				TERM=vt100
				stty erase '^?'
			fi
		;;
		*)
			if tty -s
			then
				stty erase '^?'
			fi
		;;
		esac
	else
		BTERM=`echo $TERM | cut -c1-3`
		if [ -r /usr/lib/terminfo/$TTYPE/$BTERM -o -r /usr/share/lib/terminfo/$TTYPE/$BTERM ]
		then
			TERM=$BTERM
			if tty -s
			then
				stty erase '^?'
			fi
		else
			case $MACH_OS in
			IRIX|SunOS|AIX)
				case $BTERM in
				vt[2|3])
					TERM=vt220
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				*)
					TERM=vt100
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				esac
			;;
			ULTRIX)
				case $BTERM in
				vt3)
					TERM=vt300
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				vt2)
					TERM=vt200
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				*)
					TERM=vt100
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				esac
			;;
			OSF1)
				case $BTERM in
				vt[2|3])
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				*)
					TERM=vt100
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				esac
			;;
			HP-UX)
				case $BTERM in
				vt3)
					TERM=vt320
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				vt2)
					TERM=vt200
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				*)
					TERM=vt100
					if tty -s
					then
						stty erase '^?'
					fi
				;;
				esac

			;;
			*)
				TERM=vt100
				if tty -s
				then
					stty erase '^?'
				fi
			;;
			esac
		fi
	fi
;;
esac
#
# Set the DISPLAY
#
if [ x"$DISPLAY" = x ]
then
	TTYPORT=`tty` 
	if [ "$TTYPORT" = "/dev/console" ]
	then
		DISPLAY="localhost:0"
	elif [ "$REMOTEHOST" = "" ]
	then
		TTYNAME=`echo $TTYPORT | cut -c6-`
		#Note space after TTYNAME is important to make sure you get
		#a unique match
		REMOTEHOST=`who|grep "$TTYNAME "|awk '{print $6}'|sed 's/(//'|sed 's/)//'`
		if [ x"$REMOTEHOST" != x ]
		then
			DISPLAY="${REMOTEHOST}:0"
		fi
	else
		DISPLAY="${REMOTEHOST}:0"
	fi
fi
#
# Who are you?
#
if [ "x$LOGNAME" = "x" ]
then
	if [ "x$USER" = "x" ]
	then
	if [ "x$REMOTEUSER" != "x" ]
	then
		LOGNAME="$REMOTEUSER"
	fi
	else
		LOGNAME="$USER"
	fi
fi
#
# The case statement is to set the mail variable
# based on machine type.  Also motd and news are
# dependent on system type. Some systems automatically
# display motd (and thus shouldn't be repeated here.
# Others don't have news.
#
case $MACH_OS in
IRIX)
	TZ=CST6CDT
	if [ "`funame -r | cut -c1`" = "3" ]
	then
		MAIL=/usr/mail/$LOGNAME
		/bin/mail -e
		if [ $? = 0 ]
		then
			echo 'You have mail.'
		fi
	fi
	if [ -d /usr/news ]
	then
		/usr/bin/news
	fi
;;
SunOS)
	TZ=CST6CDT
	if [ `echo $MACH_REL |cut -c1` -ge "5" ]
	then
		MAIL=/usr/mail/$LOGNAME
	else
		MAIL=/usr/spool/mail/$LOGNAME
	fi
;;
AIX)
	TZ=CST6CDT
	/bin/news
	MAIL="/usr/spool/mail/$LOGNAME"
	export MAILMESG;MAILMESG="[YOU HAVE NEW MAIL]"
	if [ -s $MAIL ]
	then
		echo 'You have mail.'
	fi
	EMULATE=none
	export EMULATE
;;
ULTRIX)
	MAIL=/usr/spool/mail/$USER
;;
OSF1)
	/usr/bin/news
	MAIL=/usr/spool/mail/$USER
;;
HP_UX)
	TZ=CST6CDT
	cat -s /etc/motd
	MAIL=/usr/mail/$LOGNAME
	/bin/mail -e
	if [ $? = 0 ]
	then
		echo 'You have mail.'
	fi
	/usr/bin/news
;;
"")
	# Catch for the "funame returns null" bug
	:
;;
*)
	cat -s /etc/motd
	if [ -x /usr/bin/news ]
	then
		/usr/bin/news
	fi
	if [ -x /bin/news ]
	then
		/bin/news
	fi
	if [ -d /usr/spool/mail	]
	then
		MAIL=/usr/spool/mail/$LOGNAME
	fi
	if [	-d /usr/mail	]
	then
		MAIL=/usr/mail/$LOGNAME
	fi
	if [ -s $MAIL ]
	then
#		/bin/mail -e
#		if [ $? = 0 ]
#		then
			echo 'You have mail.'
#		fi
	fi
;;
esac
#
#  Establish PAGER
#
if [ -x /usr/local/bin/less ]
then
	PAGER=/usr/local/bin/less
else
	PAGER=more
fi
#
# Common terminal characteristics
#
if tty -s
then
	stty intr '^c'	# set interrupt key to <ctrl-c>
	stty kill '^x'	# set kill key to <ctrl-x>
	stty echoe	# erase ERASEd characters
fi
echo "Terminal Type is $TERM"
#if [ -x /usr/local/bin/Info ]
#then
#	 /usr/local/bin/Info -new
#fi
# Some systems the user doesn't own his tty device ( Sun OpenWindows) so
# redirect stderr
/bin/chmod 622 `tty` >/dev/null 2>&1
export DISPLAY MAIL TZ TERM PAGER MANPATH

fi	# This is end of if statement for interactive use.
#
# Check for existance of local.profile file. This is the file admins should
# put in any changes, additions, etc. so that they don't need to re-edit this
# file every release.
#
if [ -r /usr/local/etc/local.profile ]
then
  . /usr/local/etc/local.profile
fi
