#!/bin/sh

# mkbbwml.sh
# SHELL SCRIPT TO MAKE THE WML DISPLAY
# Robert-Andre Croteau
# Version 1.9
# Mar 13th, 2002
#
# (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
#

#
# Instructions
#
# 1) add in your web server's mime.types file:
#
#    mime.types:text/vnd.wap.wml             wml
#
#    then stop/start your web server
#
# 2) create a $BBHOME/www/wml directory
#    make sure BB has permissions to read/write in it
#
# 3) insert in bin/bb-display.sh right after the creation of bb2.html:
#
#    $BBHOME/web/mkbbwml.sh
#
# It'll create .wml files in www/wml
# There should be an bb.wml and a bb2.wml file
#
# Bugs and comments should be sent to robert@bb4.com


if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

BBWMLDIR=$BBHOME/www/wml
INDEXWML=$BBWMLDIR/index.wml
ACKWML=$BBWMLDIR/ack.wml

if [ ! -d "$BBWMLDIR" ]
then
	mkdir "$BBWMLDIR"
fi

OLDIFS=$IFS

#
# IF WE'RE CALLED WITH AN ARGUMENT, WE'RE IN A SUBPAGE
# THE ARGUMENT IS THE BACKGROUND COLOR OF THIS PAGE
# THE USEABLE PORTION OF THE etc/bb-hosts FILE NOW
# LIVES IN $BBTMP
#
if test "$#" -gt "1"
then
	if [ \( "$#" -eq 1 \) -o \( "$2" != "page" -a "$2" != "subpage" \) ]
	then
		echo "mkbb.sh: Called with missing or invalid arguments"
		echo "usage: mkbb.sh <color> <page|subpage>"
		exit 0
	fi
	
	BBBKG=$1
	# Subpage type: page or subpage
	BBSUBPAGE=$2; export BBSUBPAGE
	BBHOSTS="$BBTMP/bb-hosts.${BBPAGENAME}.${PARPID}"; export BBHOSTS
else
	BBPAGENAME="bb";export BBPAGENAME
	PARPID="$$"
	export PARPID
	thisdir=`pwd`

	cd $BBWMLDIR
	$RM -f ./timenow
	$BBHOME/bin/touchtime -60 ./timenow
	$FIND . -name "*.wml" ! -name ack.wml ! -newer ./timenow -exec $RM -f {} \;
	$RM -f ./timenow

	$FIND $BBWMLDIR/. -name "*.ok" -exec $RM -f {} \;

	cd $thisdir
	BBDATE=`${DATE}`			# SET THE DATE
	set $BBDATE >/dev/null 2>&1
	shift
	BBDATE="$1 $2 $3 $5";export BBDATE
	BBCNT=1;export BBCNT
	BB2CNT=1;export BB2CNT
	BB2WML=$BBWMLDIR/bb2.wml;export BB2WML
	echo "$BB2WML" > $BBTMP/bb2wml.lastname
	$RM -f $BBTMP/bb2wml.fnames
	$TOUCH $BBTMP/bb2wml.fnames
fi

BBWML=$BBWMLDIR/$BBPAGENAME.wml
echo "$BBWML" > $BBTMP/bbwml.$BBPAGENAME.lastname

BBSKIP2="."

if test "$BBSUBPAGE" = ""
then
	BBBKG=`$CAT ${BBLOGS}/.bkg`		# GET THE BACKGROUND COLOR
fi


# WML header
echo "<?xml version=\"1.0\"?>
<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">
<wml>
<head>
<meta http-equiv=\"Cache-Control\" content=\"max-age=0\"/>
</head>
<card id=\"card${BBCNT}\" title=\"BigBrother\">" > $BBWML

if test "$BBSUBPAGE" = ""
then
	echo "<p align=\"center\">" >> $BBWML
	echo "<anchor title=\"BB2\">Summary<go href=\"bb2.wml\"/></anchor><br/>" >> $BBWML
	echo "<anchor title=\"ACK\">Ack<go href=\"ack.wml\"/></anchor><br/>$BBDATE</p>" >> $BBWML
	echo "<p align=\"center\" mode=\"nowrap\">" >> $BBWML
	echo "Overall Status<br/><b>$BBBKG</b><br/><br/>" >> $BBWML
	echo "<?xml version=\"1.0\"?>
<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">
<wml>
<head>
<meta http-equiv=\"Cache-Control\" content=\"max-age=0\"/>
</head>
<card id=\"card${BB2CNT}\" title=\"BigBrother\">" > $BB2WML
	echo "<p align=\"center\">" >> $BB2WML
	echo "<anchor title=\"BB\">Overall<go href=\"bb.wml\"/></anchor><br/>" >> $BB2WML
	echo "<anchor title=\"ACK\">Ack<go href=\"ack.wml\"/></anchor><br/>$BBDATE</p>" >> $BB2WML
	echo "<p align=\"center\" mode=\"nowrap\">" >> $BB2WML
	echo "Summary Status<br/><b>$BBBKG</b><br/><br/>" >> $BB2WML
else
	echo "<p align=\"center\">" >> $BBWML
	echo "<anchor title=\"BB\">Overall<go href=\"bb.wml\"/></anchor><br/>" >> $BBWML
	echo "<anchor title=\"ACK\">Ack<go href=\"ack.wml\"/></anchor><br/>$BBDATE</p>" >> $BBWML
	echo "<p align=\"center\" mode=\"nowrap\">" >> $BBWML
	echo "Subpage Status<br/><b>$BBBKG</b><br/><br/>" >> $BBWML
fi

TAGLINES="";export TAGLINES

$CAT $BBHOSTS | 
while read line
do
	TAGLINES="${TAGLINES}."
	if [ "$TAGLINES" != "$BBSKIP2" ]
	then
		continue
	fi

	# Also update BBSKIP2, we're doing another line
	# in may also be updated in the page case statement
	BBSKIP2="${BBSKIP2}."

	#
	# FIX THIS LINE SOONER OR LATER - THE > /dev/null BREAKS ON
	# DEC ULTRIX.  GREAT EH?
	#
	set -f
	set bogus $line > /dev/null			# SMM 1.06a ENV DISPLAY BUG!
	shift
	set +f

	# Only check for lines that aren't empty or comments
	if [ "$#" -eq 0 -o "$1" = "#" ]
	then
		# Don't do empty lines or comments
		continue
	#else
		# For a lower level instance, Don't print our own host
		#if [ "$BBGROUP" != "" ]
		#then
		#	for item in $*
		#	do
		#		DONTDO="FALSE"
		#		case $item
		#		in
		#			BBDISPLAY )
		#				DONTDO="TRUE"
		#				break
		#				;;

		#			BBPAGER )
		#				DONTDO="TRUE"
		#				break
		#				;;

		#			BBNET )
		#				DONTDO="TRUE"
		#				break
		#				;;
		#		esac
		#	done
		#	if [ "$DONTDO" = "TRUE" ]
		#	then
		#		continue
		#	fi
		#fi
	fi

	case $1
	in
		[0-9]* )

			#
			# SMM 1.06a
			# WE MAY NOT HAVE A group DIRECTIVE THAT CREATED
			# THE TABLE.  HANDLE IT HERE.
			#
			if test "$TOP" = ""		# TOP LINE NOT DONE
			then
				TOP="DONE"
			fi
			;;

		group | group-compress | group-only )

			#
			# SMM 1.06a SUPPORT FOR GROUPING THINGS TOGETHER
			# IF THE LINE STARTS WITH THE WORD group THEN
			# A NEW TABLE IS CREATED WITH THE REST OF THE LINE
			# AS THE CENTERED LABEL, i.e.
			# group Web and Mail Servers
			#
			# SMM 1.08 SUPPORT FOR COMPRESSED GROUPINGS
			# IF THERE IS ONLY ONE COLUMN IN THE GROUP, DISPLAY THEM
			# ACROSS THE SCREEN, OTHERWISE JUST ELIMINATE UNNEEDED COLUMNS
			#
			# RAC 1.4f SUPPORT FOR LIMITING COLUMNS
			# IF A LINE STARTS WITH THE WORD group  THEN
			# ONLY THE COLUMNS APPEARING IN THE DIRECTIVES
			# WILL BE SHOWN. THIS DIRECTIVE IS VALID UNTIL
			# THE NEXT group/group-compress/group-only/page DIRECTIVE
			#

			case $1
			in
				group-compress )

					shift                  # GET RID OF group-compress
					;;

				group-only )
					shift;shift            # GET RID OF group-only + columns
					;;

				* )
					shift;                  # GET RID OF group
					;;
			esac

			if test "$NAME" != ""		# CLOSE OFF TABLE
			then
				echo "<br/>" >> $BBWML
			fi

			TITLE=`echo $* | $SED 's/<[^<]*>/ /g'`
			#TITLE=`echo $* | $SED -e :a -e 's/<[^<]*>/ /g;/</{N;s/\n/ /;ba;}'`
			echo "<b>$TITLE</b><br/>" >> $BBWML

			TOP="DONE"			# SMM FOR TOP LINE DISP
			continue
			;;


		#
		# SMM 1.10 SUPPORT FOR MULTIPLE DISPLAY PAGES
		# FORMAT page NAME
		#

		page | subpage )
			# THE ONLY WAY OUT OF A SUBPAGE IS EOF
			# THE mkbb.page SCRIPT ENSURES THIS.
			PAGETYPE="$1"
			export PAGETYPE
			if [ \( "$BBSUBPAGE" = "" -a "$PAGETYPE" = "page" \) -o \( "$BBSUBPAGE" = "page" -a "$PAGETYPE" = "subpage" \) ]
			then
                                BBPAGENAME=`echo "$2" | $SED -e 's/^.*\/\([^\/]*$\)/\1/g' -e 's/\.\.//g'`
				if [ "$PAGETYPE" = "page" ]
				then
					TOPBBPAGENAME="$BBPAGENAME"
					export TOPBBPAGENAME
				else
					BBPAGENAME="${TOPBBPAGENAME}--${BBPAGENAME}"
				fi
                               	export BBPAGENAME
				shift;shift;
				BBHOSTLINE=`$EXPR "$TAGLINES" : ".*"`
				BK=`$BBHOME/web/mkbb.page $BBHOSTLINE 2>/dev/null`

				if test "$NAME" != ""		# CLOSE OFF TABLE
				then
					echo "<br/>" >> $BBWML
					NAME=""
				fi

				#
				# IF THIS IS OUR FIRST PAGE OR SUBPAGE, MAKE THE TABLE
				#
				if [ \( "$PAGETYPE" = "page" -a  "$FIRSTPG" = "" \) -o \( "$PAGETYPE" = "subpage" -a  "$FIRSTSUBPG" = "" \) ]
				then
					if [ "$PAGETYPE" = "page" ]
					then
						FIRSTPG="DONE"
						export FIRSTPG
						MKBBLOCALVAL="$MKBBLOCAL"
					else
						FIRSTSUBPG="DONE"
						export FIRSTSUBPG
						MKBBLOCALVAL="$MKBBSUBLOCAL"
					fi
					TITLE=`echo $MKBBLOCALVAL | $SED 's/<[^<]*>/ /g'`
					#TITLE=`echo $MKBBLOCALVAL | $SED -e :a -e 's/<[^<]*>/ /g;/</{N;s/\n/ /;ba;}'`
					echo "<b>$TITLE</b><br/><br/>" >> $BBWML
				fi
				TITLE=`echo $* | $SED 's/<[^<]*>/ /g'`
				#TITLE=`echo $* | $SED -e :a -e 's/<[^<]*>/ /g;/</{N;s/\n/ /;ba;}'`
				case $BK in
					red ) COLOR=RE;;
					green ) COLOR=GR;;
					yellow ) COLOR=YE;;
					purple ) COLOR=PU;;
					clear ) COLOR=CL;;
					blue ) COLOR=BL;;
					* ) COLOR="??"
				    		;;
				esac
				echo "<b><anchor title=\"$TITLE\">$COLOR<go href=\"$BBPAGENAME.wml\"/></anchor></b> <i>$TITLE</i><br/>" >> $BBWML

                                OLDTAGLINES=$TAGLINES
                                unset TAGLINES
				$BBHOME/web/mkbbwml.sh $BK $PAGETYPE
                                TAGLINES=$OLDTAGLINES
                                BBSKIP2="${TAGLINES}`$CAT $BBTMP/BBSKIP2.${BBPAGENAME}.${PARPID}`"

                                $RM -f $BBTMP/bb-hosts.${BBPAGENAME}.${PARPID}
                                $RM -f $BBTMP/BBSKIP2.${BBPAGENAME}.${PARPID}

				BBPAGENAME=""
				continue
			fi
			;;

		* )
			continue
			;;
	esac

	#
	# NEW FOR 1.04 - SUPPORT FOR FQDN's
	# NOT CENTERED...
	#
	FNAME=$2
	IFS='.'
	set -f
	set $2 >/dev/null 2>&1
	set +f
	IFS=$OLDIFS
	if test "$FQDN" = "TRUE"
	then
		NAME=$1
		shift
		for arg in $*
		do
			NAME="$NAME,$arg"
		done
	else
		NAME=$1
	fi

	BBWMLHOST=$BBWMLDIR/$FNAME.wml

	DOWMLHOST=FALSE
	if [ ! -f "${BBWMLHOST}.ok" ]
	then
		DOWMLHOST=TRUE
		$TOUCH ${BBWMLHOST}.ok
		$RM -f ${BBWMLHOST}
	fi

	if [ "$DOWMLHOST" = "TRUE" ]
	then
		# WML Create Host WML cardset
		echo "<?xml version=\"1.0\"?>
<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">
<wml> 
<head>
<meta http-equiv=\"Cache-Control\" content=\"max-age=0\"/>
</head>
<card id=\"name1\" title=\"BigBrother\">
<p align=\"center\">" > $BBWMLHOST

if test "$BBSUBPAGE" = ""
then
	echo "<anchor title=\"BB\">Overall<go href=\"bb.wml\"/></anchor><br/>" >> $BBWMLHOST
	echo "<anchor title=\"ACK\">Ack<go href=\"ack.wml\"/></anchor><br/>$BBDATE</p>" >> $BBWMLHOST
	echo "<p align=\"left\" mode=\"nowrap\">" >> $BBWMLHOST
else
	echo "<anchor title=\"$BBPAGENAME\">$BBPAGENAME<go href=\"$BBPAGENAME.wml\"/></anchor><br/>$BBDATE<br/>" >> $BBWMLHOST
fi

echo "<b>$FNAME</b><br/><br/>" >> $BBWMLHOST
	fi

	WORST="GR"
	#
	# FOR EACH OF THE THINGS WE MONITOR...
	#
	CURRPWD=`pwd`
	cd $BBLOGS
	logfiles="`$LS ${NAME}.* 2>/dev/null`"
	for log in $logfiles
	do
		IFS='.'
		set -f
		set $log
		set +f
		IFS=$OLDIFS
		column=$2

		set -f
		set `$HEAD -1 ${BBLOGS}/${NAME}.${column}` >/dev/null 2>&1
		set +f
		case $1 in
			red ) COLOR=RE;ICON="cross1";;
			green ) COLOR=GR;ICON="smileyface";;
			yellow ) COLOR=YE;ICON="sparkle";;
			purple ) COLOR=PU;ICON="question2";;
			clear ) COLOR=CL;ICON="plug";;
			blue ) COLOR=BL;ICON="wrench";;
			* ) continue
			    ;;
		esac
		if [ -f "${BBACKS}/ack.${FNAME}.${column}" ] && [ "$1" = "red" -o "$1" = "yellow" -o "$1" = "purple" ]
		then
			ACKED="x"
		else
			ACKED=""
		fi
		if [ "$DOWMLHOST" = "TRUE" ]
		then
			BBWMLLOG=$BBWMLDIR/${FNAME}.${column}.wml
			echo "<b><anchor title=\"${column}\">${COLOR}${ACKED}<go href=\"${FNAME}.${column}.wml\"/></anchor></b> ${column}<br/>" >> $BBWMLHOST
			# WML Create Host log WML cardset
			echo "<?xml version=\"1.0\"?>
<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">
<wml> 
<head>
<meta http-equiv=\"Cache-Control\" content=\"max-age=0\"/>
</head>
<card id=\"name1\" title=\"BigBrother\">
<p align=\"center\">" > $BBWMLLOG

			echo "<anchor title=\"BB\">Host<go href=\"${FNAME}.wml\"/></anchor><br/>" >> $BBWMLLOG
			echo "<anchor title=\"ACK\">Ack<go href=\"ack.wml\"/></anchor><br/>$BBDATE</p>" >> $BBWMLLOG
			echo "<p align=\"left\" mode=\"nowrap\">" >> $BBWMLLOG
			echo "<b>$FNAME.${column}</b><br/></p><p mode=\"nowrap\">" >> $BBWMLLOG
			$CAT ${BBLOGS}/${NAME}.${column} | $GREP -v "^[ 	]*$" | $HEAD -14 | $GREP -v DOCTYPE | $SED -e 's/http:\/\///g' -e 's/<[tT][rR]>/TRTR/g' -e 's/<[^<]*>/ /g' -e 's/TRTR/<br\/>/g' -e 's/</\&lt;/g' -e 's/>/\&gt;/g' -e 's/&red/<b>red<\/b>/g' -e 's/&green/<b>green<\/b>/g' -e 's/&purple/<b>purple<\/b>/g' -e 's/&yellow/<b>yellow<\/b>/g' -e 's/&clear/<b>clear<\/b>/g' -e 's/&blue/<b>blue<\/b>/g' -e 's/\&/\&amp;/g' -e "s/'/\&apos;/g" -e 's/\"/\&quot;/g' -e 'a\
<br/>' >> $BBWMLLOG
			echo "<br/> </p> </card> </wml>" >> $BBWMLLOG
		fi
		if [ "$COLOR" = "RE" ]
		then
			WORST=$COLOR
		elif [ "$COLOR" = "YE" ]
		then
			if [ "$WORST" != "RE" ]
			then
				WORST=$COLOR
			fi
		elif [ "$COLOR" = "PU" ]
		then
			if [ "$WORST" != "RE" -a "$WORST" != "YE" ]
			then
				WORST=$COLOR
			fi
		fi
	done

	if [ "$DOWMLHOST" = "TRUE" ]
	then
		# WML footer
		echo "
</p> </card> </wml>" >> $BBWMLHOST
	fi

	echo "<b><anchor title=\"$FNAME\">$WORST<go href=\"$FNAME.wml\"/></anchor></b> $FNAME<br/>" >> $BBWML

	$CAT $BBTMP/bb2wml.fnames | $GREP "$FNAME" >/dev/null 2>&1
	if [ "$?" -ne 0 -a "$WORST" != "GR" ]
	then
		echo "<b><anchor title=\"$FNAME\">$WORST<go href=\"$FNAME.wml\"/></anchor></b> $FNAME<br/>" >> $BB2WML
		echo "$FNAME" >> $BBTMP/bb2wml.fnames
	fi

	# Break bb.wml file over multiple 'cause some phones can't handle
	# more than 1750 chars
	set bogus `$WC -c $BBWML` 2>/dev/null
	shift
	if [ "$#" -gt 2 ]
	then
		if [ "$1" -gt "$2" ]
		then
			CHARS=$1
		else
			CHARS=$2
		fi
		if [ "$CHARS" -gt $WMLMAXCHARS ]
		then
			# Get the next card number
			BBCNT=`$EXPR "$BBCNT" + 1`
			OLDBBPAGENAME=`echo $BBWML | $SED "s!$BBWMLDIR/!!g" 2>/dev/null`

			# Close off current card
			# Add WML footer
			echo "<br /><b><anchor title=\"Next\">Next<go href=\"${BBPAGENAME}-${BBCNT}.wml\"/></anchor></b>" >> $BBWML
			echo "</p> </card> </wml>" >> $BBWML

			BBWML=$BBWMLDIR/${BBPAGENAME}-${BBCNT}.wml;export BBWML
			echo "$BBWML" > $BBTMP/bbwml.$BBPAGENAME.lastname

			# WML header
			echo "<?xml version=\"1.0\"?>
<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">
<wml>
<head>
<meta http-equiv=\"Cache-Control\" content=\"max-age=0\"/>
</head>
<card id=\"card${BBCNT}\" title=\"BigBrother\">" > $BBWML

			echo "<p align=\"center\">" >> $BBWML
			echo "<anchor title=\"Prev\">Previous<go href=\"$OLDBBPAGENAME\"/></anchor><br/>" >> $BBWML

			if test "$BBSUBPAGE" = ""
			then
				echo "<anchor title=\"BB2\">Summary<go href=\"bb2.wml\"/></anchor><br/>" >> $BBWML
				echo "<anchor title=\"ACK\">Ack<go href=\"ack.wml\"/></anchor><br/>$BBDATE</p>" >> $BBWML
				echo "<p align=\"center\" mode=\"nowrap\">" >> $BBWML
				echo "Overall Status<br/><b>$BBBKG</b><br/><br/>" >> $BBWML
			else
				echo "<anchor title=\"BB\">Overall<go href=\"bb.wml\"/></anchor><br/>" >> $BBWML
				echo "<anchor title=\"ACK\">Ack<go href=\"ack.wml\"/></anchor><br/>$BBDATE</p>" >> $BBWML
				echo "<p align=\"center\" mode=\"nowrap\">" >> $BBWML
				echo "Subpage Status<br/><b>$BBBKG</b><br/><br/>" >> $BBWML
			fi
		fi
	fi
	# Break bb2.wml file over multiple 'cause some phones can't handle
	# more than 1750 chars
	set bogus `$WC -c $BB2WML` 2>/dev/null
	shift
	if [ "$#" -eq 2 ]
	then
		if [ "$1" -gt "$2" ]
		then
			CHARS=$1
		else
			CHARS=$2
		fi
		if [ "$CHARS" -gt $WMLMAXCHARS ]
		then
			# Open a new card
			BB2CNT=`$EXPR "$BB2CNT" + 1`
			OLDBB2PAGENAME=`echo $BB2WML | $SED "s!$BBWMLDIR/!!g" 2>/dev/null`

			# Close off current card
			# Add WML footer
			echo "<br /><b><anchor title=\"Next\">Next<go href=\"bb2-${BB2CNT}.wml\"/></anchor></b>" >> $BB2WML
			echo "</p> </card> </wml>" >> $BB2WML

			BB2WML=$BBWMLDIR/bb2-${BB2CNT}.wml;export BB2WML
			echo "$BB2WML" > $BBTMP/bb2wml.lastname

	echo "<?xml version=\"1.0\"?>
<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">
<wml>
<head>
<meta http-equiv=\"Cache-Control\" content=\"max-age=0\"/>
</head>
<card id=\"card${BB2CNT}\" title=\"BigBrother\">" > $BB2WML
	echo "<p align=\"center\">" >> $BB2WML
	echo "<anchor title=\"Prev\">Previous<go href=\"$OLDBB2PAGENAME\"/></anchor><br/>" >> $BB2WML
	echo "<anchor title=\"BB\">Overall<go href=\"bb.wml\"/></anchor><br/>" >> $BB2WML
	echo "<anchor title=\"ACK\">Ack<go href=\"ack.wml\"/></anchor><br/>$BBDATE</p>" >> $BB2WML
	echo "<p align=\"center\" mode=\"nowrap\">" >> $BB2WML
	echo "Summary Status<br/><b>$BBBKG</b><br/><br/>" >> $BB2WML
		fi
	fi
done

if test "$BBSUBPAGE" = ""
then
	# Deal with multi-file bb2.wml ...
	if [ -f "$BBTMP/bb2wml.lastname" ]
	then
		BBWML=`$CAT $BBTMP/bb2wml.lastname`
	else
		# Tag file missing, use default
		BBWML=$BBWMLDIR/bb2.wml
	fi
	if [ "$BBBKG" = "green" ]
	then
		echo "All is OK<br/>" >> $BB2WML
	fi
	echo "</p> </card> </wml>" >> $BB2WML

	$RM -f $INDEXWML
	$LN -s $BBWML $INDEXWML

	$RM -f $ACKWML

	case "$CGIBINURL" in
		http* )
			FULLCGIBINURL="$CGIBINURL"
			;;
		* )
			FULLCGIBINURL="${BBWEBHOST}${CGIBINURL}"
			;;
	esac
	echo "<?xml version=\"1.0\"?>
<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">
<wml> 
<head>
<meta http-equiv=\"Cache-Control\" content=\"max-age=0\"/>
</head> 
<card id=\"ack1\" title=\"BB Ack\">
<p align=\"center\">
<anchor title=\"BB\">Overall<go href=\"$BBWAP/bb.wml\"/></anchor><br/>
<anchor title=\"BB2\">Summary<go href=\"$BBWAP/bb2.wml\"/></anchor><br/>
$BBDATE<br />
Ack Event<br /></p>
<p align=\"left\">
AckID:<input id=\"id\" type=\"text\" name=\"ackid\" format=\"7N\" /><br />  
Duration:<input id=\"dur\" type=\"text\" name=\"duration\" maxlength=\"7\" format=\"N*N\" />mins<br />
Msg:<input id=\"msg\" type=\"text\" name=\"message\" maxlength=\"50\" format=\"*f\" /><br />    
<br />
<anchor title=\"Ack\">Send
<go href=\"${FULLCGIBINURL}/bb-ack.sh\">
<postfield name=\"ACTION\" value=\"WapAck\"/>
<postfield name=\"NUMBER\" value=\"\$(ackid)\"/>
<postfield name=\"DELAY\" value=\"\$(duration)\"/>
<postfield name=\"MESSAGE\" value=\"\$(message)\"/>
</go></anchor><br />
<anchor title=\"BB\">Overall<go href=\"$BBWAP/bb.wml\"/></anchor><br/>
<anchor title=\"BB2\">Summary<go href=\"$BBWAP/bb2.wml\"/></anchor><br/>
</p>  
</card>
</wml>
" > $ACKWML
fi

# Deal with multi-file bb.wml ...
if [ -f "$BBTMP/bbwml.$BBPAGENAME.lastname" ]
then
	BBWML=`$CAT $BBTMP/bbwml.$BBPAGENAME.lastname`
else
	# Tag file missing, use default
	BBWML=$BBWMLDIR/bb.wml
fi
# WML footer
echo "</p> </card> </wml>" >> $BBWML

$RM -f $BBTMP/bbwml.$BBPAGENAME.lastname $BBTMP/bb2wml.lastname

#
# Remove file containing the list of hosts in bb2.wml
#
if [ "$BBSUBPAGE" = "" ]
then
	$RM -f $BBTMP/bb2wml.fnames
	$FIND $BBWMLDIR/. -name "*.ok" -exec $RM -f {} \;
fi
exit 0
