#!/bin/sh

# bb-local.sh
#
# BIG BROTHER MONITORING SCRIPT
# Sean MacGuire
# Version 1.9
# Mar 13th, 2002
#
# (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
#
# For each system we monitor we watch
#	disk	USES df 
#	cpu	USES uptime
# 	msgs	LOOKS FOR WARNINGS
#	procs	CHECKS A LIST
#
# For the network we care about
#	telnet	USES telnet and checks the results
#	http	USES lynx to check for valid output
#
# THEN SEND THE RESULTS TO THE DISPLAY SERVER USING bb

# echo "***** BBHOME IS SET TO $BBHOME"
# echo "***** BBTMP IS SET TO $BBTMP"

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
	 # echo "*** LOADING BBDEF ***"
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

# Setup the name of the local host
# Save a version of the machine name with '.' instead of ',', if any are there
MACHINEDOTS=`echo $MACHINE | $SED 's/,/\./g'`
if [ "$FQDN" != "TRUE" ]
then
	OLDIFS=$IFS
	IFS='.'
	set $MACHINEDOTS >/dev/null
	IFS=$OLDIFS
	MACHINEMASK="${1}"
else
	MACHINEMASK="${MACHINEDOTS}"
fi
export MACHINEDOTS MACHINEMASK

BBCOMBOID="$$"
export BBCOMBOID

$BBHOME/bin/bb-combo.sh start

if [ "$DODISK" = TRUE ]
then
	. $BBHOME/bin/bb-disk.sh	# THE DISK TEST
else
	# Do we still send out a dummy message ?
	# If NODISKCOLOR is not empty then use the contents as
	# the color of the message
	if [ "$NODISKCOLOR" != "" ]
	then
		$BBHOME/bin/bb-combo.sh add "status $MACHINE.disk $NODISKCOLOR `date`  Disk test disabled"
	fi
fi

if [ "$DOCPU" = TRUE ]
then
	. $BBHOME/bin/bb-cpu.sh		# THE CPU TEST
else
	# Do we still send out a dummy message ?
	# If NOCPUCOLOR is not empty then use the contents as
	# the color of the message
	if [ "$NOCPUCOLOR" != "" ]
	then
		$BBHOME/bin/bb-combo.sh add "status $MACHINE.cpu $NOCPUCOLOR `date`  Cpu test disabled"
	fi
fi

if [ "$DOMSGS" = TRUE ]
then
	. $BBHOME/bin/bb-msgs.sh	# THE MESSAGES TEST
else
	# Do we still send out a dummy message ?
	# If NOMSGSCOLOR is not empty then use the contents as
	# the color of the message
	if [ "$NOMSGSCOLOR" != "" ]
	then
		$BBHOME/bin/bb-combo.sh add "status $MACHINE.msgs $NOMSGSCOLOR `date`  Msgs test disabled"
	fi
fi

if [ "$DOPROCS" = TRUE ]
then
	. $BBHOME/bin/bb-procs.sh	# THE PROCESSES TEST
else
	# Do we still send out a dummy message ?
	# If NOPROCSCOLOR is not empty then use the contents as
	# the color of the message
	if [ "$NOPROCSCOLOR" != "" ]
	then
		$BBHOME/bin/bb-combo.sh add "status $MACHINE.procs $NOPROCSCOLOR `date`  Procs test disabled"
	fi
fi

$BBHOME/bin/bb-combo.sh end
