if [ -f locations.include ] ; then
 . ./locations.include
else
  if [ -f ../locations.include ] ; then
    . ../locations.include
  fi
fi

UPDATES=/tmp/updates.img
MNTPOINT=/tmp/rhupdates
RHupdates=$TREE/$SITEDIR/RHupdates
if [ ! -d $RHupdates ] ; then
   echo "There is no $RHupdates directory so not making updates.img"
   if [ -f $TREE/$SITEDIR/base/updates.img ] ; then
      rm $TREE/$SITEDIR/base/updates.img
   fi
   exit
fi
IMAGESIZE=`du -s $RHupdates | cut -f1`
if [ $IMAGESIZE -le 65 ] ; then
	echo "Image was too small so had to make it bigger"
	IMAGESIZE=65
fi
IMAGESIZE=`expr $IMAGESIZE + 1`
echo "IMAGESIZE IS $IMAGESIZE"
INODES=`find $RHupdates -print | wc -l`
INODES=`expr $INODES + 10`
echo "INODES is $INODES"
dd if=/dev/zero of=$UPDATES bs=1k count=$IMAGESIZE 
/sbin/mke2fs -F -m 0 -q -N $INODES -b 1024 $UPDATES $IMAGESIZE
rm -rf $MNTPOINT
mkdir $MNTPOINT
mount -o loop -t ext2 $UPDATES $MNTPOINT
/bin/rm -r $MNTPOINT/lost+found
(cd $RHupdates ; find . | cpio -pvdum $MNTPOINT)
df -k $MNTPOINT
df -i $MNTPOINT
umount $MNTPOINT
cp -v $UPDATES $TREE/$SITEDIR/base
