require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_SURFACE_AGGREGATOR_DTX_H)) {
    eval 'sub _LINUX_SURFACE_AGGREGATOR_DTX_H () {1;}' unless defined(&_LINUX_SURFACE_AGGREGATOR_DTX_H);
    require 'linux/ioctl.ph';
    require 'linux/types.ph';
    eval 'sub SDTX_CATEGORY_STATUS () {0x;}' unless defined(&SDTX_CATEGORY_STATUS);
    eval 'sub SDTX_CATEGORY_RUNTIME_ERROR () {0x1000;}' unless defined(&SDTX_CATEGORY_RUNTIME_ERROR);
    eval 'sub SDTX_CATEGORY_HARDWARE_ERROR () {0x2000;}' unless defined(&SDTX_CATEGORY_HARDWARE_ERROR);
    eval 'sub SDTX_CATEGORY_UNKNOWN () {0xf000;}' unless defined(&SDTX_CATEGORY_UNKNOWN);
    eval 'sub SDTX_CATEGORY_MASK () {0xf000;}' unless defined(&SDTX_CATEGORY_MASK);
    eval 'sub SDTX_CATEGORY {
        my($value) = @_;
	    eval q((($value) &  &SDTX_CATEGORY_MASK));
    }' unless defined(&SDTX_CATEGORY);
    eval 'sub SDTX_STATUS {
        my($code) = @_;
	    eval q((($code) |  &SDTX_CATEGORY_STATUS));
    }' unless defined(&SDTX_STATUS);
    eval 'sub SDTX_ERR_RT {
        my($code) = @_;
	    eval q((($code) |  &SDTX_CATEGORY_RUNTIME_ERROR));
    }' unless defined(&SDTX_ERR_RT);
    eval 'sub SDTX_ERR_HW {
        my($code) = @_;
	    eval q((($code) |  &SDTX_CATEGORY_HARDWARE_ERROR));
    }' unless defined(&SDTX_ERR_HW);
    eval 'sub SDTX_UNKNOWN {
        my($code) = @_;
	    eval q((($code) |  &SDTX_CATEGORY_UNKNOWN));
    }' unless defined(&SDTX_UNKNOWN);
    eval 'sub SDTX_SUCCESS {
        my($value) = @_;
	    eval q(( &SDTX_CATEGORY($value) ==  &SDTX_CATEGORY_STATUS));
    }' unless defined(&SDTX_SUCCESS);
    eval 'sub SDTX_LATCH_CLOSED () { &SDTX_STATUS(0x);}' unless defined(&SDTX_LATCH_CLOSED);
    eval 'sub SDTX_LATCH_OPENED () { &SDTX_STATUS(0x1);}' unless defined(&SDTX_LATCH_OPENED);
    eval 'sub SDTX_BASE_DETACHED () { &SDTX_STATUS(0x);}' unless defined(&SDTX_BASE_DETACHED);
    eval 'sub SDTX_BASE_ATTACHED () { &SDTX_STATUS(0x1);}' unless defined(&SDTX_BASE_ATTACHED);
    eval 'sub SDTX_DETACH_NOT_FEASIBLE () { &SDTX_ERR_RT(0x1);}' unless defined(&SDTX_DETACH_NOT_FEASIBLE);
    eval 'sub SDTX_DETACH_TIMEDOUT () { &SDTX_ERR_RT(0x2);}' unless defined(&SDTX_DETACH_TIMEDOUT);
    eval 'sub SDTX_ERR_FAILED_TO_OPEN () { &SDTX_ERR_HW(0x1);}' unless defined(&SDTX_ERR_FAILED_TO_OPEN);
    eval 'sub SDTX_ERR_FAILED_TO_REMAIN_OPEN () { &SDTX_ERR_HW(0x2);}' unless defined(&SDTX_ERR_FAILED_TO_REMAIN_OPEN);
    eval 'sub SDTX_ERR_FAILED_TO_CLOSE () { &SDTX_ERR_HW(0x3);}' unless defined(&SDTX_ERR_FAILED_TO_CLOSE);
    eval 'sub SDTX_DEVICE_TYPE_HID () {0x100;}' unless defined(&SDTX_DEVICE_TYPE_HID);
    eval 'sub SDTX_DEVICE_TYPE_SSH () {0x200;}' unless defined(&SDTX_DEVICE_TYPE_SSH);
    eval 'sub SDTX_DEVICE_TYPE_MASK () {0xf00;}' unless defined(&SDTX_DEVICE_TYPE_MASK);
    eval 'sub SDTX_DEVICE_TYPE {
        my($value) = @_;
	    eval q((($value) &  &SDTX_DEVICE_TYPE_MASK));
    }' unless defined(&SDTX_DEVICE_TYPE);
    eval 'sub SDTX_BASE_TYPE_HID {
        my($id) = @_;
	    eval q((($id) |  &SDTX_DEVICE_TYPE_HID));
    }' unless defined(&SDTX_BASE_TYPE_HID);
    eval 'sub SDTX_BASE_TYPE_SSH {
        my($id) = @_;
	    eval q((($id) |  &SDTX_DEVICE_TYPE_SSH));
    }' unless defined(&SDTX_BASE_TYPE_SSH);
    eval("sub SDTX_DEVICE_MODE_TABLET () { 0x00; }") unless defined(&SDTX_DEVICE_MODE_TABLET);
    eval("sub SDTX_DEVICE_MODE_LAPTOP () { 0x01; }") unless defined(&SDTX_DEVICE_MODE_LAPTOP);
    eval("sub SDTX_DEVICE_MODE_STUDIO () { 0x02; }") unless defined(&SDTX_DEVICE_MODE_STUDIO);
    eval("sub SDTX_EVENT_REQUEST () { 1; }") unless defined(&SDTX_EVENT_REQUEST);
    eval("sub SDTX_EVENT_CANCEL () { 2; }") unless defined(&SDTX_EVENT_CANCEL);
    eval("sub SDTX_EVENT_BASE_CONNECTION () { 3; }") unless defined(&SDTX_EVENT_BASE_CONNECTION);
    eval("sub SDTX_EVENT_LATCH_STATUS () { 4; }") unless defined(&SDTX_EVENT_LATCH_STATUS);
    eval("sub SDTX_EVENT_DEVICE_MODE () { 5; }") unless defined(&SDTX_EVENT_DEVICE_MODE);
    eval 'sub SDTX_IOCTL_EVENTS_ENABLE () { &_IO(0xa5, 0x21);}' unless defined(&SDTX_IOCTL_EVENTS_ENABLE);
    eval 'sub SDTX_IOCTL_EVENTS_DISABLE () { &_IO(0xa5, 0x22);}' unless defined(&SDTX_IOCTL_EVENTS_DISABLE);
    eval 'sub SDTX_IOCTL_LATCH_LOCK () { &_IO(0xa5, 0x23);}' unless defined(&SDTX_IOCTL_LATCH_LOCK);
    eval 'sub SDTX_IOCTL_LATCH_UNLOCK () { &_IO(0xa5, 0x24);}' unless defined(&SDTX_IOCTL_LATCH_UNLOCK);
    eval 'sub SDTX_IOCTL_LATCH_REQUEST () { &_IO(0xa5, 0x25);}' unless defined(&SDTX_IOCTL_LATCH_REQUEST);
    eval 'sub SDTX_IOCTL_LATCH_CONFIRM () { &_IO(0xa5, 0x26);}' unless defined(&SDTX_IOCTL_LATCH_CONFIRM);
    eval 'sub SDTX_IOCTL_LATCH_HEARTBEAT () { &_IO(0xa5, 0x27);}' unless defined(&SDTX_IOCTL_LATCH_HEARTBEAT);
    eval 'sub SDTX_IOCTL_LATCH_CANCEL () { &_IO(0xa5, 0x28);}' unless defined(&SDTX_IOCTL_LATCH_CANCEL);
    eval 'sub SDTX_IOCTL_GET_BASE_INFO () { &_IOR(0xa5, 0x29, \'struct sdtx_base_info\');}' unless defined(&SDTX_IOCTL_GET_BASE_INFO);
    eval 'sub SDTX_IOCTL_GET_DEVICE_MODE () { &_IOR(0xa5, 0x2a,  &__u16);}' unless defined(&SDTX_IOCTL_GET_DEVICE_MODE);
    eval 'sub SDTX_IOCTL_GET_LATCH_STATUS () { &_IOR(0xa5, 0x2b,  &__u16);}' unless defined(&SDTX_IOCTL_GET_LATCH_STATUS);
}
1;
