#include "rmixcheckbox.h"
#include "mixerhandle.h"
#include <QMouseEvent>

rmixCheckBox::rmixCheckBox(snd_hctl_elem_t *elem, ushort channel, bool isLed, rmixCheckBox *prev) {
	m_elem= elem;
	m_channel= channel;
	m_isLed = isLed;
	m_prev= prev;
	snd_ctl_elem_value_malloc(&m_val);
	snd_hctl_elem_set_callback_private(elem, new mixerHandle::callbackData{ mixerHandle::CB, this });
	snd_hctl_elem_set_callback(elem, callback);
	if(isLed)
		setDisabled(1);
	else
		connect(this, SIGNAL(toggled(bool)), this, SLOT(changeVal(bool)));
	updat();
}

rmixCheckBox::~rmixCheckBox() {
	snd_ctl_elem_value_free(m_val);
	snd_hctl_elem_set_callback(m_elem, nullptr);
	snd_hctl_elem_set_callback_private(m_elem, nullptr);
}

void rmixCheckBox::changeVal(bool newVal) {
	snd_hctl_elem_read(m_elem, m_val);
	snd_ctl_elem_value_set_boolean(m_val, m_channel, newVal);
	snd_hctl_elem_write(m_elem, m_val);
}

void rmixCheckBox::updat() {
	if(m_prev != nullptr)
		m_prev->updat();
	snd_hctl_elem_read(m_elem, m_val);
	blockSignals(1);
	setChecked(snd_ctl_elem_value_get_boolean(m_val, m_channel));
	blockSignals(0);
}
