#!/bin/sh


BASEDIR=../panel-plugin
WDIR=`pwd`


echo -n 'Preparing desktop file...'
cd ${BASEDIR}
rm -f dxreminders.desktop.in
cp dxreminders.desktop dxreminders.desktop.in
sed -e '/Name\[/ d' \
    -e '/Comment\[/ d' \
    -e '/Icon/ d' \
    -i dxreminders.desktop.in
cd ${WDIR}
echo ' DONE'


echo -n 'Extracting messages...'
# Sort alphabetically to match cmake
xgettext --from-code=UTF-8 --language=C --keyword=_ --keyword=N_ --sort-output \
    --package-name='dxreminders plugin' --copyright-holder='David Vachulka' \
    --output=xfce4-dxreminders-plugin.pot ${BASEDIR}/*.c ${BASEDIR}/*.h
xgettext --from-code=UTF-8 --join-existing --sort-output \
    --package-name='dxreminders plugin' --copyright-holder='David Vachulka' \
    --output=xfce4-dxreminders-plugin.pot ${BASEDIR}/*.desktop.in
echo ' DONE'


echo -n 'Cleaning up...'
cd ${BASEDIR}
rm -f dxreminders.desktop.in
echo ' DONE'
