/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.util.Collection;
import javax.media.jai.CollectionImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.SequentialImage;

public class ImageSequence
extends CollectionImage {
    protected ImageSequence() {
    }

    public ImageSequence(Collection images) {
        super(images);
    }

    public PlanarImage getImage(float ts) {
        for (SequentialImage si : this) {
            if (si.timeStamp != ts) continue;
            return si.image;
        }
        return null;
    }

    public PlanarImage getImage(Object cp) {
        if (cp != null) {
            for (SequentialImage si : this) {
                if (!si.cameraPosition.equals(cp)) continue;
                return si.image;
            }
        }
        return null;
    }

    public float getTimeStamp(PlanarImage pi) {
        if (pi != null) {
            for (SequentialImage si : this) {
                if (!si.image.equals(pi)) continue;
                return si.timeStamp;
            }
        }
        return -3.4028235E38f;
    }

    public Object getCameraPosition(PlanarImage pi) {
        if (pi != null) {
            for (SequentialImage si : this) {
                if (!si.image.equals(pi)) continue;
                return si.cameraPosition;
            }
        }
        return null;
    }

    @Override
    public boolean add(Object o) {
        if (o != null && o instanceof SequentialImage) {
            return super.add(o);
        }
        return false;
    }

    public boolean remove(PlanarImage pi) {
        if (pi != null) {
            for (SequentialImage si : this) {
                if (!si.image.equals(pi)) continue;
                return super.remove(si);
            }
        }
        return false;
    }

    public boolean remove(float ts) {
        for (SequentialImage si : this) {
            if (si.timeStamp != ts) continue;
            return super.remove(si);
        }
        return false;
    }

    @Override
    public boolean remove(Object cp) {
        if (cp != null) {
            for (SequentialImage si : this) {
                if (!si.cameraPosition.equals(cp)) continue;
                return super.remove(si);
            }
        }
        return false;
    }
}

