/***************************************************************
 * Name:      dxcalendarctrl.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef DXCALENDARCTRL_H
#define DXCALENDARCTRL_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/calctrl.h>
#ifdef wxHAS_NATIVE_CALENDARCTRL
    #include <wx/generic/calctrlg.h>
#endif
#include "data/engine.h"

class dxCalendarCtrl: public wxGenericCalendarCtrl
{
    DECLARE_EVENT_TABLE()
public:
    dxCalendarCtrl(wxWindow *parent, const wxWindowID id, bool smaller = false, bool markDays = true);

    void updateColors();
    void updateFonts();
    bool SetDate(const wxDateTime& date);
    wxDateTime GetDate() const { return m_datum; }
    wxCalendarHitTestResult HitTest(const wxPoint& pos, wxDateTime *date = nullptr, wxDateTime::WeekDay *wd = nullptr);
    void markDays(bool refresh, bool showhidden);
    void Resize();
    void setEventID(long id);
    wxUint8 daytypeForDay() const;
    bool hasEventForDay() const;
    bool hasEventForDay(long id) const;
protected:
    wxSize DoGetBestSize() const;
private:
    long m_eventID;
    wxDateTime m_datum;
    wxDateTime m_datumForMove;
    wxString m_weekdays[7];
    wxDateTime m_lowdate;
    wxDateTime m_highdate;
    wxCoord m_widthCol, m_heightRow, m_rowOffset, m_widthToday, m_calendarWeekWidth;
    wxRect m_leftArrowRect, m_rightArrowRect, m_todayRect;
    bool m_smaller;
    std::vector<Calendarday> m_calendardays;
    bool m_markDays;
    bool m_showhidden;

    void OnMouseMove(wxMouseEvent &event);
    void OnPaint(wxPaintEvent &event);
    void OnClick(wxMouseEvent& event);
    void OnRightClick(wxMouseEvent& event);
    wxDateTime startDate() const;
    void recalcGeometry();
    bool isDateInRange(const wxDateTime& date) const;
    void changeDay(const wxDateTime& date);
    void refreshDate(const wxDateTime &date);
    size_t week(const wxDateTime &date) const;
    void setDateAndNotify(const wxDateTime &date);
    wxString todayText();
    wxString headerText();
    void OnChar(wxKeyEvent &event);
    bool adjustDateToRange(wxDateTime *date) const;
    wxDateTime::WeekDay GetWeekStart() const;
    wxDateTime::WeekDay GetWeekEnd() const;
    wxString tooltipForDay(wxDateTime::wxDateTime_t day) const;
    wxUint8 daytypeForDay(wxDateTime::wxDateTime_t day) const;
    bool hasEventForDay(wxDateTime::wxDateTime_t day) const;
};

class dxCalendar: public wxPanel
{
    DECLARE_EVENT_TABLE()
public:
    dxCalendar(wxWindow *parent, const wxWindowID id, bool smaller = false, bool markDays = true);

    void updateCalendar();
    wxDateTime getValue() const;
    void setValue(const wxDateTime &date);
    void markDays(bool showhidden);
    void refreshFrame();
    void setEventID(long id);
    wxUint8 daytypeForDay() const;
    bool hasEventForDay() const;
    bool hasEventForDay(long id) const;
private:
    wxBoxSizer *m_mainSizer;
    dxCalendarCtrl *m_calendar;
};

#endif  /* DXCALENDARCTRL_H */

