/***************************************************************
 * Name:      phdialog.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2020
 * License:   GPL3
 **************************************************************/

#ifndef PHDIALOG_H
#define PHDIALOG_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include <wx/listctrl.h>
#include <wx/spinctrl.h>
#include "data/engine.h"
#include "widgets/dxtimepickerctrl.h"
#include "widgets/dxtoolbar.h"

class PublicholidayDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(PublicholidayDialog)
    DECLARE_EVENT_TABLE()
public:
    PublicholidayDialog() {}
    PublicholidayDialog(wxWindow *parent);
private:
    void OnOk(wxCommandEvent& event);
    void OnAdd(wxCommandEvent& event);
    void OnEdit(wxCommandEvent& event);
    void OnRemove(wxCommandEvent& event);
    void OnListRightClick(wxListEvent& event);
    void OnListActivated(wxListEvent& event);
    void OnListSelected(wxListEvent& event);
    void OnListDeselected(wxListEvent& event);
    void fillList();
    void enableTools();
    void updateHoliday(wxInt64 id, const wxString &name, int day, wxDateTime::Month month);
    void OnLoad(wxCommandEvent& event);
    void OnRemindHoliday(wxCommandEvent& event);

    std::vector<Holiday> m_holidays;
    wxListCtrl *m_list;
    long m_index;
    dxToolBar *m_bar;
    wxPanel *m_panel;
    wxCheckBox *m_easternMonday;
    wxCheckBox *m_easternFriday;
    wxCheckBox *m_remindHoliday;
    wxSpinCtrl *m_remindHolidayDays;
    dxTimePickerCtrl *m_remindHolidayTime;
};

class HolidayDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(HolidayDialog)
    DECLARE_EVENT_TABLE()
public:
    HolidayDialog() {}
    HolidayDialog(wxWindow *parent);
    HolidayDialog(wxWindow *parent, const Holiday &holiday);
    int day() const;
    wxDateTime::Month month() const;
    wxString name() const;
private:
    void createControls();
    void OnCombo(wxCommandEvent& event);
    void OnOk(wxCommandEvent& event);

    wxSpinCtrl *m_day;
    wxChoice *m_month;
    wxTextCtrl *m_name;
};

#endif  /* PHDIALOG_H */

