/***************************************************************
 * Name:      eventfilter.h
 * Author:    David Vachulka (arch_dvx@users.sourceforge.net)
 * Copyright: 2021
 * License:   GPL3
 **************************************************************/

#ifndef EVENTFILTER_H
#define EVENTFILTER_H

#ifndef WX_PRECOMP
    #include <wx/wx.h>
#endif
#include "widgets/dxcalendarpickerctrl.h"
#include <wx/spinctrl.h>
#include <wx/listbook.h>
#include "filter.h"
#include "dxreminders.h"

class EventFilter: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(EventFilter)
    DECLARE_EVENT_TABLE()
public:
    EventFilter() : m_mainSizer(nullptr), m_book(nullptr), m_dateAction(nullptr), m_dateValue(nullptr), m_dateUsage(nullptr),
        m_eventAction(nullptr), m_eventValue(nullptr), m_eventUsage(nullptr),
        m_reminderAction(nullptr), m_reminderDays(nullptr), m_reminderHours(nullptr), m_reminderMins(nullptr), m_reminderUsage(nullptr),
        m_recurrenceValue(nullptr), m_recurrenceUsage(nullptr),
        m_timefilterYears(nullptr), m_timefilterMonths(nullptr), m_timefilterWeeks(nullptr), m_timefilterDays(nullptr), m_timefilterHours(nullptr),
        m_timefilterMinutes(nullptr), m_timefilterUsage(nullptr), m_hiddenfilterUsage(nullptr) {}
    explicit EventFilter(wxWindow *parent);
    //Pro editaci
    EventFilter(wxWindow *parent, dxFilterArray filters);

    dxFilterArray filters() const;
private:
    dxremindersFrame *m_reminders;
    dxFilterArray m_filters;
    wxBoxSizer *m_mainSizer;
    wxListbook *m_book;
    wxChoice *m_dateAction;
    dxCalendarPickerCtrl *m_dateValue;
    wxCheckBox *m_dateUsage;
    wxChoice *m_eventAction;
    wxTextCtrl *m_eventValue;
    wxCheckBox *m_eventUsage;
    wxChoice *m_reminderAction;
    wxSpinCtrl *m_reminderDays;
    wxSpinCtrl *m_reminderHours;
    wxSpinCtrl *m_reminderMins;
    wxCheckBox *m_reminderUsage;
    wxChoice *m_recurrenceValue;
    wxCheckBox *m_recurrenceUsage;
    wxSpinCtrl *m_timefilterYears;
    wxSpinCtrl *m_timefilterMonths;
    wxSpinCtrl *m_timefilterWeeks;
    wxSpinCtrl *m_timefilterDays;
    wxSpinCtrl *m_timefilterHours;
    wxSpinCtrl *m_timefilterMinutes;
    wxCheckBox *m_timefilterUsage;
    wxCheckBox *m_hiddenfilterUsage;

    void createControls();
    void fillControls();
    void OnOk(wxCommandEvent& event);
    void OnCancel(wxCommandEvent& event);
    void OnApply(wxCommandEvent& event);
};

#endif  /* EVENTFILTER_H */

