/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.plan;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanAbstract;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanNodeJoin;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanNodePlain;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class MySQLPlanClassic
extends MySQLPlanAbstract {
    private List<MySQLPlanNodePlain> rootNodes;

    public MySQLPlanClassic(JDBCSession session, String query) throws DBCException {
        super((MySQLDataSource)session.getDataSource(), query);
        SQLDialect dialect = SQLUtils.getDialectFromObject((DBPObject)this.dataSource);
        String plainQuery = SQLUtils.stripComments((SQLDialect)dialect, (String)query).toUpperCase();
        if (!"SELECT".equalsIgnoreCase(SQLUtils.getFirstKeyword((SQLDialect)dialect, (String)plainQuery))) {
            throw new DBCException("Only SELECT statements could produce execution plan");
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement(this.getPlanQueryString());){
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    ArrayList<MySQLPlanNodePlain> nodes = new ArrayList<MySQLPlanNodePlain>();
                    while (dbResult.next()) {
                        MySQLPlanNodePlain node = new MySQLPlanNodePlain(null, (ResultSet)dbResult);
                        nodes.add(node);
                    }
                    this.rootNodes = nodes;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public MySQLPlanClassic(MySQLDataSource dataSource, String query, List<MySQLPlanNodePlain> rootNodes) {
        super(dataSource, query);
        this.rootNodes = rootNodes;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "EXPLAIN EXTENDED " + this.query;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }

    private List<MySQLPlanNodePlain> convertToPlanTree(List<MySQLPlanNodePlain> srcNodes) {
        ArrayList<MySQLPlanNodePlain> roots = new ArrayList<MySQLPlanNodePlain>();
        if (srcNodes.size() == 1) {
            roots.add(srcNodes.get(0));
        } else {
            List<MySQLPlanNodePlain> nodes;
            ArrayList<MySQLPlanNodePlain> parsed = new ArrayList<MySQLPlanNodePlain>();
            MySQLPlanNodePlain lastCompositeNode = null;
            int id = 1;
            while (!(nodes = this.getQueriesById(srcNodes, id)).isEmpty()) {
                if (nodes.size() == 1) {
                    MySQLPlanNodePlain firstNode = nodes.get(0);
                    if (lastCompositeNode != null) {
                        firstNode.setParent(lastCompositeNode);
                    } else {
                        roots.add(firstNode);
                    }
                    if (firstNode.isCompositeNode()) {
                        lastCompositeNode = firstNode;
                    }
                } else {
                    MySQLPlanNodePlain leftNode = lastCompositeNode;
                    if (leftNode == null) {
                        leftNode = nodes.get(0).getParent();
                    }
                    MySQLPlanNodePlain joinNode = this.joinNodes(srcNodes, leftNode, nodes);
                    if (leftNode == null) {
                        roots.add(joinNode);
                    }
                }
                parsed.addAll(nodes);
                ++id;
            }
            for (MySQLPlanNodePlain node : srcNodes) {
                if (node.getId() == null || parsed.contains((Object)node)) continue;
                roots.add(node);
            }
        }
        for (MySQLPlanNodePlain node : roots) {
            node.computeStats();
        }
        return roots;
    }

    private List<MySQLPlanNodePlain> getQueriesById(List<MySQLPlanNodePlain> srcNodes, int id) {
        ArrayList<MySQLPlanNodePlain> subList = new ArrayList<MySQLPlanNodePlain>();
        for (MySQLPlanNodePlain node : srcNodes) {
            if (node.getId() == null || node.getId() != id) continue;
            subList.add(node);
        }
        return subList;
    }

    private MySQLPlanNodePlain joinNodes(List<MySQLPlanNodePlain> srcNodes, MySQLPlanNodePlain parent, List<MySQLPlanNodePlain> nodes) {
        MySQLPlanNodePlain leftNode = nodes.get(0);
        int i = 1;
        while (i < nodes.size()) {
            MySQLPlanNodePlain rightNode = nodes.get(i);
            MySQLPlanNodeJoin nodeJoin = new MySQLPlanNodeJoin(parent, leftNode, rightNode);
            leftNode.setParent(nodeJoin);
            rightNode.setParent(nodeJoin);
            if (parent != null) {
                nodeJoin.setParent(parent);
            }
            leftNode = nodeJoin;
            ++i;
        }
        return leftNode;
    }
}

