/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPOverloadedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBPSystemInfoObject;
import org.jkiss.dbeaver.model.DBPToolTipObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.access.DBAObject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseObject;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.struct.rdb.DBSPackage;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public abstract class DBNDatabaseNode
extends DBNNode
implements DBNLazyNode,
DBSWrapper,
DBPContextProvider,
IDataSourceContainerProvider {
    private static final DBNDatabaseNode[] EMPTY_NODES = new DBNDatabaseNode[0];
    private volatile boolean locked;
    protected volatile DBNDatabaseNode[] childNodes;
    private boolean filtered;

    protected DBNDatabaseNode(DBNNode parentNode) {
        super(parentNode);
    }

    void registerNode() {
        DBNModel model = this.getModel();
        if (model != null) {
            model.addNode(this);
        }
    }

    void unregisterNode(boolean reflect) {
        DBNModel model = this.getModel();
        if (model != null) {
            model.removeNode(this, reflect);
        }
    }

    @Override
    protected void dispose(boolean reflect) {
        this.clearChildren(reflect);
        super.dispose(reflect);
    }

    @Override
    public String getNodeType() {
        if (this.getObject() == null) {
            return "";
        }
        DBXTreeNode meta = this.getMeta();
        return meta == null ? "" : meta.getNodeTypeLabel(this.getObject().getDataSource(), null);
    }

    @Override
    public String getNodeName() {
        return this.getPlainNodeName(false, true);
    }

    public String getPlainNodeName(boolean useSimpleName, boolean showDefaults) {
        DBSObject object = this.getObject();
        if (object == null) {
            return showDefaults ? "[NULL]" : null;
        }
        String objectName = !useSimpleName && object instanceof DBPOverloadedObject ? ((DBPOverloadedObject)((Object)object)).getOverloadedName() : object.getName();
        if (showDefaults && CommonUtils.isEmpty((String)objectName) && CommonUtils.isEmpty((String)(objectName = object.toString()))) {
            objectName = String.valueOf(object.getClass().getName()) + "@" + object.hashCode();
        }
        return objectName;
    }

    @Override
    public String getNodeBriefInfo() {
        if (this.getObject() instanceof DBPToolTipObject) {
            return ((DBPToolTipObject)((Object)this.getObject())).getObjectToolTip();
        }
        return super.getNodeBriefInfo();
    }

    @Override
    public String getNodeFullName() {
        if (this.getObject() instanceof DBPQualifiedObject) {
            return ((DBPQualifiedObject)((Object)this.getObject())).getFullyQualifiedName(DBPEvaluationContext.UI);
        }
        return super.getNodeFullName();
    }

    @Override
    public String getNodeDescription() {
        return this.getObject() == null ? null : this.getObject().getDescription();
    }

    @Override
    public DBPImage getNodeIcon() {
        DBXTreeNode meta;
        DBSObject object = this.getObject();
        DBPImage image = DBValueFormatting.getObjectImage(object, false);
        if (image == null && (meta = this.getMeta()) != null) {
            image = meta.getIcon(this);
        }
        if (image != null && object instanceof DBPStatefulObject) {
            image = DBNModel.getStateOverlayImage(image, ((DBPStatefulObject)((Object)object)).getObjectState());
        }
        return image;
    }

    @Override
    public boolean allowsChildren() {
        return !this.isDisposed() && this.getMeta().hasChildren(this);
    }

    @Override
    public boolean allowsNavigableChildren() {
        return !this.isDisposed() && this.getMeta() != null && this.getMeta().hasChildren(this, true);
    }

    public boolean hasChildren(DBRProgressMonitor monitor, DBXTreeNode childType) throws DBException {
        if (this.isDisposed()) {
            return false;
        }
        Object[] children = this.getChildren(monitor);
        if (!ArrayUtils.isEmpty((Object[])children)) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (((DBNDatabaseNode)child).getMeta() == childType) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBNDatabaseNode[] getChildren(DBRProgressMonitor monitor) throws DBException {
        boolean needsLoad;
        DBNDatabaseNode dBNDatabaseNode = this;
        synchronized (dBNDatabaseNode) {
            needsLoad = this.childNodes == null && this.hasChildren(false);
        }
        if (needsLoad && this.initializeNode(monitor, null)) {
            ArrayList<DBNDatabaseNode> tmpList = new ArrayList<DBNDatabaseNode>();
            this.loadChildren(monitor, this.getMeta(), null, tmpList, this, true);
            if (!monitor.isCanceled()) {
                DBNDatabaseNode dBNDatabaseNode2 = this;
                synchronized (dBNDatabaseNode2) {
                    this.childNodes = tmpList.isEmpty() ? EMPTY_NODES : tmpList.toArray(new DBNDatabaseNode[0]);
                }
                this.afterChildRead();
            }
        }
        return this.childNodes;
    }

    protected void afterChildRead() {
    }

    DBNDatabaseNode[] getChildNodes() {
        return this.childNodes;
    }

    boolean hasChildItem(DBSObject object) {
        if (this.childNodes != null) {
            DBNDatabaseNode[] dBNDatabaseNodeArray = this.childNodes;
            int n = this.childNodes.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                if (child.getObject() == object) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChildItem(DBSObject object) {
        DBXTreeNode metaChildren = this.getItemsMeta();
        if (metaChildren == null) {
            metaChildren = this.getFolderMeta(object.getClass());
        }
        if (metaChildren != null) {
            DBNDatabaseItem newChild = new DBNDatabaseItem(this, metaChildren, object, false);
            DBNDatabaseNode dBNDatabaseNode = this;
            synchronized (dBNDatabaseNode) {
                this.childNodes = (DBNDatabaseNode[])ArrayUtils.add(DBNDatabaseNode.class, (Object[])this.childNodes, (Object)newChild);
            }
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, DBNEvent.NodeChange.LOAD, newChild));
        } else {
            log.error("Cannot add child item to " + this.getNodeName() + ". Conditions doesn't met");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChildItem(DBSObject object) {
        DBNNode childNode = null;
        DBNDatabaseNode dBNDatabaseNode = this;
        synchronized (dBNDatabaseNode) {
            if (!ArrayUtils.isEmpty((Object[])this.childNodes)) {
                int i = 0;
                while (i < this.childNodes.length) {
                    DBNDatabaseNode child = this.childNodes[i];
                    if (child.getObject() == object) {
                        childNode = child;
                        this.childNodes = (DBNDatabaseNode[])ArrayUtils.remove(DBNDatabaseNode.class, (Object[])this.childNodes, (int)i);
                        break;
                    }
                    ++i;
                }
            }
        }
        if (childNode != null) {
            childNode.dispose(true);
        }
    }

    @Override
    void clearNode(boolean reflect) {
        this.clearChildren(reflect);
    }

    public void updateChildrenOrder(boolean reflect) {
        try {
            this.refreshNodeContent(new VoidProgressMonitor(), this.getObject(), this, reflect);
        }
        catch (DBException e) {
            log.error("Error reordering node children", e);
        }
    }

    @Override
    public boolean needsInitialization() {
        return this.childNodes == null && this.hasChildren(false);
    }

    @Override
    public boolean isLocked() {
        return this.locked || super.isLocked();
    }

    public boolean initializeNode(DBRProgressMonitor monitor, DBRProgressListener onFinish) throws DBException {
        if (onFinish != null) {
            onFinish.onTaskFinished(Status.OK_STATUS);
        }
        return true;
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        if (this.isLocked()) {
            log.warn("Attempt to refresh locked node '" + this.getNodeName() + "'");
            return null;
        }
        DBSObject object = this.getObject();
        if (object instanceof DBPRefreshableObject) {
            DBPDataSource dataSource = object.getDataSource();
            if (object.isPersisted() && dataSource != null) {
                DBSObject[] newObject = new DBSObject[1];
                DBExecUtils.tryExecuteRecover(monitor, dataSource, param -> {
                    try {
                        dBSObjectArray[0] = ((DBPRefreshableObject)object).refreshObject(monitor);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                if (newObject[0] == null) {
                    if (this.parentNode instanceof DBNDatabaseNode) {
                        ((DBNDatabaseNode)this.parentNode).removeChildItem(object);
                    }
                    return null;
                }
                this.refreshNodeContent(monitor, newObject[0], source, true);
                return this;
            }
            this.getModel().fireNodeUpdate(source, this, DBNEvent.NodeChange.REFRESH);
            return this;
        }
        return super.refreshNode(monitor, source);
    }

    private void refreshNodeContent(DBRProgressMonitor monitor, DBSObject newObject, Object source, boolean reflect) throws DBException {
        if (this.isDisposed()) {
            return;
        }
        this.locked = true;
        DBNModel model = this.getModel();
        try {
            if (newObject != this.getObject()) {
                this.reloadObject(monitor, newObject);
            }
            this.reloadChildren(monitor, source, reflect);
            if (reflect) {
                model.fireNodeUpdate(source, this, DBNEvent.NodeChange.REFRESH);
            }
        }
        finally {
            this.locked = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearChildren(boolean reflect) {
        DBNDatabaseNode[] childrenCopy;
        DBNDatabaseNode dBNDatabaseNode = this;
        synchronized (dBNDatabaseNode) {
            childrenCopy = this.childNodes == null ? null : Arrays.copyOf(this.childNodes, this.childNodes.length);
            this.childNodes = null;
        }
        if (childrenCopy != null) {
            DBNDatabaseNode[] dBNDatabaseNodeArray = childrenCopy;
            int n = childrenCopy.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                ((DBNNode)child).dispose(reflect);
                ++n2;
            }
        }
    }

    private void loadChildren(DBRProgressMonitor monitor, DBXTreeNode meta, DBNDatabaseNode[] oldList, List<DBNDatabaseNode> toList, Object source, boolean reflect) throws DBException {
        if (monitor.isCanceled()) {
            return;
        }
        this.filtered = false;
        List<DBXTreeNode> childMetas = meta.getChildren(this);
        if (CommonUtils.isEmpty(childMetas)) {
            return;
        }
        DBSObject object = this.getObject();
        if (object == null) {
            return;
        }
        monitor.beginTask(ModelMessages.model_navigator_load_items_, childMetas.size());
        DBNBrowseSettings navSettings = this.getDataSourceContainer().getNavigatorSettings();
        boolean showSystem = navSettings.isShowSystemObjects();
        boolean showOnlyEntities = navSettings.isShowOnlyEntities();
        boolean hideFolders = navSettings.isHideFolders();
        for (DBXTreeNode child : childMetas) {
            int n;
            int n2;
            DBNDatabaseNode[] dBNDatabaseNodeArray;
            if (monitor.isCanceled()) break;
            monitor.subTask(String.valueOf(ModelMessages.model_navigator_load_) + " " + child.getChildrenTypeLabel(object.getDataSource(), null));
            if (showOnlyEntities && !this.isEntityMeta(child)) continue;
            if (child instanceof DBXTreeItem) {
                DBXTreeItem item = (DBXTreeItem)child;
                boolean isLoaded = this.loadTreeItems(monitor, item, oldList, toList, source, showSystem, hideFolders, reflect);
                if (!isLoaded && item.isOptional() && item.getRecursiveLink() == null) {
                    this.loadChildren(monitor, item, oldList, toList, source, reflect);
                }
            } else if (child instanceof DBXTreeFolder) {
                if (hideFolders) {
                    if (child.isVirtual()) continue;
                    this.loadChildren(monitor, child, oldList, toList, source, reflect);
                } else if (oldList == null) {
                    toList.add(new DBNDatabaseFolder(this, (DBXTreeFolder)child));
                } else {
                    dBNDatabaseNodeArray = oldList;
                    n2 = oldList.length;
                    n = 0;
                    while (n < n2) {
                        DBNDatabaseNode oldFolder = dBNDatabaseNodeArray[n];
                        if (oldFolder.getMeta() == child) {
                            oldFolder.reloadChildren(monitor, source, reflect);
                            toList.add(oldFolder);
                            break;
                        }
                        ++n;
                    }
                }
            } else if (child instanceof DBXTreeObject) {
                if (hideFolders) continue;
                if (oldList == null) {
                    toList.add(new DBNDatabaseObject(this, (DBXTreeObject)child));
                } else {
                    dBNDatabaseNodeArray = oldList;
                    n2 = oldList.length;
                    n = 0;
                    while (n < n2) {
                        DBNDatabaseNode oldObject = dBNDatabaseNodeArray[n];
                        if (oldObject.getMeta() == child) {
                            oldObject.reloadChildren(monitor, source, reflect);
                            toList.add(oldObject);
                            break;
                        }
                        ++n;
                    }
                }
            } else {
                log.warn("Unsupported meta node type: " + child);
            }
            monitor.worked(1);
        }
        monitor.done();
        if (reflect && this.filtered) {
            this.getModel().fireNodeUpdate(this, this, DBNEvent.NodeChange.REFRESH);
        }
    }

    private boolean isEntityMeta(DBXTreeNode node) {
        Class<Object> nodeChildClass = null;
        if (node instanceof DBXTreeItem) {
            nodeChildClass = this.getChildrenClass((DBXTreeItem)node);
        } else if (node instanceof DBXTreeFolder) {
            nodeChildClass = DBNDatabaseNode.getFolderChildrenClass((DBXTreeFolder)node);
        }
        if (nodeChildClass == null) {
            return false;
        }
        return DBSObjectContainer.class.isAssignableFrom(nodeChildClass) && !DBSPackage.class.isAssignableFrom(nodeChildClass) || DBSEntity.class.isAssignableFrom(nodeChildClass) && !DBSDataType.class.isAssignableFrom(nodeChildClass) && !DBSSequence.class.isAssignableFrom(nodeChildClass) && !DBSPackage.class.isAssignableFrom(nodeChildClass) || DBSEntityAttribute.class.isAssignableFrom(nodeChildClass);
    }

    private boolean loadTreeItems(DBRProgressMonitor monitor, DBXTreeItem meta, DBNDatabaseNode[] oldList, List<DBNDatabaseNode> toList, Object source, boolean showSystem, boolean hideFolders, boolean reflect) throws DBException {
        if (this.isDisposed()) {
            return false;
        }
        Object valueObject = this.getValueObject();
        if (valueObject == null) {
            return false;
        }
        PropertyValueReader valueReader = new PropertyValueReader(monitor, meta, valueObject);
        DBExecUtils.tryExecuteRecover(monitor, this.getDataSource(), valueReader);
        Object propertyValue = valueReader.propertyValue;
        if (propertyValue == null) {
            return false;
        }
        if (!(propertyValue instanceof Collection)) {
            log.warn("Bad property '" + meta.getPropertyName() + "' value: " + propertyValue.getClass().getName());
            return false;
        }
        DBSObjectFilter filter = this.getNodeFilter(meta, false);
        this.filtered = filter != null && !filter.isNotApplicable();
        Collection itemList = (Collection)propertyValue;
        if (itemList.isEmpty()) {
            return false;
        }
        if (this.isDisposed()) {
            return false;
        }
        for (Object childItem : itemList) {
            if (childItem == null) continue;
            if (!(childItem instanceof DBSObject)) {
                log.warn("Bad item type: " + childItem.getClass().getName());
                continue;
            }
            if (DBUtils.isHiddenObject(childItem) || !showSystem && DBUtils.isSystemObject(childItem) || hideFolders && (childItem instanceof DBAObject || childItem instanceof DBPSystemInfoObject) || filter != null && !filter.matches(((DBSObject)childItem).getName())) continue;
            DBSObject object = (DBSObject)childItem;
            boolean added = false;
            if (oldList != null) {
                DBNDatabaseNode[] dBNDatabaseNodeArray = oldList;
                int n = oldList.length;
                int n2 = 0;
                while (n2 < n) {
                    DBNDatabaseNode oldChild = dBNDatabaseNodeArray[n2];
                    if (oldChild.getMeta() == meta && DBNDatabaseNode.equalObjects(oldChild.getObject(), object)) {
                        oldChild.reloadObject(monitor, object);
                        if (oldChild.hasChildren(false) && !oldChild.needsInitialization()) {
                            oldChild.reloadChildren(monitor, source, reflect);
                        }
                        if (reflect) {
                            this.getModel().fireNodeUpdate(source, oldChild, DBNEvent.NodeChange.REFRESH);
                        }
                        toList.add(oldChild);
                        added = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (added) continue;
            DBNDatabaseItem treeItem = new DBNDatabaseItem(this, meta, object, oldList != null);
            toList.add(treeItem);
        }
        if (oldList != null) {
            DBNDatabaseNode[] dBNDatabaseNodeArray = oldList;
            int n = oldList.length;
            int n3 = 0;
            while (n3 < n) {
                DBNDatabaseNode oldChild = dBNDatabaseNodeArray[n3];
                if (oldChild.getMeta() == meta) {
                    boolean found = false;
                    for (Object childItem : itemList) {
                        if (!(childItem instanceof DBSObject) || !DBNDatabaseNode.equalObjects(oldChild.getObject(), (DBSObject)childItem)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        oldChild.dispose(true);
                    }
                }
                ++n3;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return DBUtils.getDefaultContext(this.getObject(), true);
    }

    @Override
    @NotNull
    public DBPDataSourceContainer getDataSourceContainer() {
        DBNNode p = this.getParentNode();
        while (p != null) {
            if (p instanceof DBNDataSource) {
                return ((DBNDataSource)p).getDataSourceContainer();
            }
            p = p.getParentNode();
        }
        throw new IllegalStateException("No parent datasource node");
    }

    @Nullable
    public DBPDataSource getDataSource() {
        DBSObject object = this.getObject();
        if (object != null) {
            return object.getDataSource();
        }
        if (this.parentNode instanceof DBNDatabaseNode) {
            return ((DBNDatabaseNode)this.parentNode).getDataSource();
        }
        throw new IllegalStateException("No datasource is associated with database node " + this);
    }

    public DBSObjectFilter getNodeFilter(DBXTreeItem meta, boolean firstMatch) {
        Class<?> childrenClass;
        DBPDataSourceContainer dataSource = this.getDataSourceContainer();
        if (this instanceof DBNContainer && (childrenClass = this.getChildrenOrFolderClass(meta)) != null) {
            Object valueObject = this.getValueObject();
            DBSObject parentObject = null;
            if (valueObject instanceof DBSObject && !(valueObject instanceof DBPDataSource)) {
                parentObject = (DBSObject)valueObject;
            }
            return dataSource.getObjectFilter(childrenClass, parentObject, firstMatch);
        }
        return null;
    }

    public void setNodeFilter(DBXTreeItem meta, DBSObjectFilter filter) {
        DBPDataSourceContainer dataSource = this.getDataSourceContainer();
        if (this instanceof DBNContainer) {
            Class<?> childrenClass = this.getChildrenOrFolderClass(meta);
            if (childrenClass != null) {
                Object parentObject = this.getValueObject();
                if (parentObject instanceof DBPDataSource) {
                    parentObject = null;
                }
                dataSource.setObjectFilter(childrenClass, (DBSObject)parentObject, filter);
                dataSource.persistConfiguration();
            } else {
                log.error("Cannot detect child node type - can't save filter configuration");
            }
        } else {
            log.error("No active datasource - can't save filter configuration");
        }
    }

    @Override
    public boolean isFiltered() {
        return this.filtered;
    }

    @Override
    public String getNodeItemPath() {
        StringBuilder pathName = new StringBuilder(100);
        DBNNode node = this;
        while (node instanceof DBNDatabaseNode) {
            if (node instanceof DBNDataSource) {
                if (pathName.length() > 0) {
                    pathName.insert(0, '/');
                }
                pathName.insert(0, node.getNodeItemPath());
            } else if (node instanceof DBNDatabaseFolder) {
                DBXTreeFolder folderMeta;
                String type;
                if (pathName.length() > 0) {
                    pathName.insert(0, '/');
                }
                if (CommonUtils.isEmpty((String)(type = (folderMeta = ((DBNDatabaseFolder)node).getMeta()).getIdOrType()))) {
                    type = node.getName();
                }
                pathName.insert(0, type);
            }
            if (node instanceof DBNDatabaseItem || node instanceof DBNDatabaseObject) {
                if (pathName.length() > 0) {
                    pathName.insert(0, '/');
                }
                pathName.insert(0, node.getNodeName().replace('/', '_'));
            }
            node = node.getParentNode();
        }
        return pathName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadChildren(DBRProgressMonitor monitor, Object source, boolean reflect) throws DBException {
        DBNDatabaseNode[] oldChildren;
        DBNDatabaseNode dBNDatabaseNode = this;
        synchronized (dBNDatabaseNode) {
            if (this.childNodes == null) {
                return;
            }
            oldChildren = Arrays.copyOf(this.childNodes, this.childNodes.length);
        }
        ArrayList<DBNDatabaseNode> newChildren = new ArrayList<DBNDatabaseNode>();
        this.loadChildren(monitor, this.getMeta(), oldChildren, newChildren, source, reflect);
        DBNDatabaseNode dBNDatabaseNode2 = this;
        synchronized (dBNDatabaseNode2) {
            this.childNodes = newChildren.toArray(new DBNDatabaseNode[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean equalObjects(DBSObject object1, DBSObject object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 != null && object2 != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            if (object1.getClass() != object2.getClass() || !CommonUtils.equalObjects((Object)DBUtils.getObjectUniqueName(object1), (Object)DBUtils.getObjectUniqueName(object2))) {
                return false;
            }
            object1 = object1.getParentObject();
            object2 = object2.getParentObject();
lbl9:
            // 2 sources

            ** while (object1 != null && object2 != null)
        }
lbl10:
        // 1 sources

        return true;
    }

    public abstract Object getValueObject();

    public abstract DBXTreeNode getMeta();

    public DBXTreeItem getItemsMeta() {
        List<DBXTreeNode> metaChildren = this.getMeta().getChildren(this);
        if (metaChildren != null) {
            for (DBXTreeNode cn : metaChildren) {
                if (!(cn instanceof DBXTreeItem)) continue;
                return (DBXTreeItem)cn;
            }
        }
        return null;
    }

    public DBXTreeFolder getFolderMeta(Class<?> childType) {
        List<DBXTreeNode> metaChildren = this.getMeta().getChildren(this);
        if (metaChildren != null) {
            for (DBXTreeNode cn : metaChildren) {
                if (!(cn instanceof DBXTreeFolder) || !childType.getName().equals(((DBXTreeFolder)cn).getType())) continue;
                return (DBXTreeFolder)cn;
            }
        }
        return null;
    }

    protected abstract void reloadObject(DBRProgressMonitor var1, DBSObject var2);

    public List<Class<?>> getChildrenTypes(DBXTreeNode useMeta) {
        List<DBXTreeNode> childMetas;
        List<DBXTreeNode> list = childMetas = useMeta == null ? this.getMeta().getChildren(this) : Collections.singletonList(useMeta);
        if (CommonUtils.isEmpty(childMetas)) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (DBXTreeNode childMeta : childMetas) {
            Class<?> childrenType;
            if (!(childMeta instanceof DBXTreeItem) || (childrenType = this.getChildrenClass((DBXTreeItem)childMeta)) == null) continue;
            result.add(childrenType);
        }
        return result;
    }

    public Class<?> getChildrenClass(DBXTreeItem childMeta) {
        if (childMeta == null) {
            log.debug("Null child meta specified");
            return null;
        }
        Object valueObject = this.getValueObject();
        if (valueObject == null) {
            return null;
        }
        Method getter = childMeta.getPropertyReadMethod(valueObject.getClass());
        if (getter == null) {
            return null;
        }
        Type propType = getter.getGenericReturnType();
        return BeanUtils.getCollectionType((Type)propType);
    }

    private Class<?> getChildrenOrFolderClass(DBXTreeItem childMeta) {
        Class<?> childrenClass = this.getChildrenClass(childMeta);
        if (childrenClass == null && this instanceof DBNContainer) {
            childrenClass = ((DBNContainer)((Object)this)).getChildrenClass();
        }
        return childrenClass;
    }

    private static Object extractPropertyValue(DBRProgressMonitor monitor, Object object, DBXTreeItem meta) throws DBException {
        Method getter;
        String propertyName;
        block8: {
            if (object == null || meta == null) {
                return null;
            }
            propertyName = meta.getPropertyName();
            getter = meta.getPropertyReadMethod(object.getClass());
            if (getter != null) break block8;
            log.warn("Can't find property '" + propertyName + "' read method in '" + object.getClass().getName() + "'");
            return null;
        }
        try {
            Class<?>[] paramTypes = getter.getParameterTypes();
            if (paramTypes.length == 0) {
                return getter.invoke(object, new Object[0]);
            }
            if (paramTypes.length == 1 && paramTypes[0] == DBRProgressMonitor.class) {
                return getter.invoke(object, monitor);
            }
            log.warn("Can't read property '" + propertyName + "' - bad method signature: " + getter.toString());
            return null;
        }
        catch (IllegalAccessException ex) {
            log.warn("Error accessing items " + propertyName, ex);
            return null;
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof DBException) {
                throw (DBException)ex.getTargetException();
            }
            throw new DBException("Can't read " + propertyName + ": " + ex.getTargetException().getMessage(), ex.getTargetException());
        }
    }

    public boolean isVirtual() {
        DBNNode node = this;
        while (node != null) {
            DBXTreeNode meta;
            if (node instanceof DBNDatabaseNode && (meta = node.getMeta()) != null && meta.isVirtual()) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    private static class PropertyValueReader
    implements DBRRunnableParametrized<DBRProgressMonitor> {
        private final DBRProgressMonitor monitor;
        private final DBXTreeItem meta;
        private final Object valueObject;
        private Object propertyValue;

        PropertyValueReader(DBRProgressMonitor monitor, DBXTreeItem meta, Object valueObject) {
            this.monitor = monitor;
            this.meta = meta;
            this.valueObject = valueObject;
        }

        @Override
        public void run(DBRProgressMonitor param) throws InvocationTargetException, InterruptedException {
            try {
                this.propertyValue = DBNDatabaseNode.extractPropertyValue(this.monitor, this.valueObject, this.meta);
            }
            catch (DBException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

