/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.model;

import java.io.IOException;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewType;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRegistry;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.XMLBuilder;
import org.w3c.dom.Element;

public class DashboardItemViewConfiguration {
    private DashboardDescriptor dashboardDescriptor;
    private DashboardViewType viewType;
    private int index;
    private float widthRatio;
    private long updatePeriod;
    private int maxItems;
    private long maxAge;
    private boolean legendVisible;
    private boolean gridVisible;
    private boolean domainTicksVisible;
    private boolean rangeTicksVisible;
    private String description;

    public DashboardDescriptor getDashboardDescriptor() {
        return this.dashboardDescriptor;
    }

    public DashboardViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(DashboardViewType viewType) {
        this.viewType = viewType;
    }

    public float getWidthRatio() {
        return this.widthRatio;
    }

    public void setWidthRatio(float widthRatio) {
        this.widthRatio = widthRatio;
    }

    public long getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(long updatePeriod) {
        this.updatePeriod = updatePeriod;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    public void setLegendVisible(boolean legendVisible) {
        this.legendVisible = legendVisible;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean gridVisible) {
        this.gridVisible = gridVisible;
    }

    public boolean isDomainTicksVisible() {
        return this.domainTicksVisible;
    }

    public void setDomainTicksVisible(boolean domainTicksVisible) {
        this.domainTicksVisible = domainTicksVisible;
    }

    public boolean isRangeTicksVisible() {
        return this.rangeTicksVisible;
    }

    public void setRangeTicksVisible(boolean rangeTicksVisible) {
        this.rangeTicksVisible = rangeTicksVisible;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    DashboardItemViewConfiguration(DashboardDescriptor dashboardDescriptor, int index) {
        this.dashboardDescriptor = dashboardDescriptor;
        this.viewType = dashboardDescriptor.getDefaultViewType();
        this.index = index;
        this.widthRatio = dashboardDescriptor.getWidthRatio();
        this.updatePeriod = dashboardDescriptor.getUpdatePeriod();
        this.maxItems = dashboardDescriptor.getMaxItems();
        this.maxAge = dashboardDescriptor.getMaxAge();
        this.legendVisible = true;
        this.gridVisible = true;
        this.domainTicksVisible = true;
        this.rangeTicksVisible = true;
        this.description = dashboardDescriptor.getDescription();
    }

    public DashboardItemViewConfiguration(DashboardItemViewConfiguration source) {
        this.copyFrom(source);
    }

    void copyFrom(DashboardItemViewConfiguration source) {
        this.dashboardDescriptor = source.dashboardDescriptor;
        this.viewType = source.viewType;
        this.index = source.index;
        this.widthRatio = source.widthRatio;
        this.updatePeriod = source.updatePeriod;
        this.maxItems = source.maxItems;
        this.maxAge = source.maxAge;
        this.legendVisible = source.legendVisible;
        this.gridVisible = source.gridVisible;
        this.domainTicksVisible = source.domainTicksVisible;
        this.rangeTicksVisible = source.rangeTicksVisible;
        this.description = source.description;
    }

    void serialize(XMLBuilder xml) throws IOException {
        xml.addAttribute("id", this.dashboardDescriptor.getId());
        xml.addAttribute("viewType", this.viewType.getId());
        xml.addAttribute("index", this.index);
        xml.addAttribute("widthRatio", this.widthRatio);
        xml.addAttribute("updatePeriod", this.updatePeriod);
        xml.addAttribute("maxItems", this.maxItems);
        xml.addAttribute("maxAge", this.maxAge);
        xml.addAttribute("legendVisible", this.legendVisible);
        xml.addAttribute("gridVisible", this.gridVisible);
        xml.addAttribute("domainTicksVisible", this.domainTicksVisible);
        xml.addAttribute("rangeTicksVisible", this.rangeTicksVisible);
        if (!CommonUtils.isEmpty((String)this.description)) {
            xml.addAttribute("description", this.description);
        }
    }

    public DashboardItemViewConfiguration(DashboardDescriptor dashboard, Element element) {
        this.dashboardDescriptor = dashboard;
        String viewTypeId = element.getAttribute("viewType");
        if (viewTypeId != null) {
            this.viewType = DashboardRegistry.getInstance().getViewType(viewTypeId);
        }
        if (this.viewType == null) {
            this.viewType = dashboard.getDefaultViewType();
        }
        this.index = CommonUtils.toInt((Object)element.getAttribute("index"));
        this.widthRatio = (float)CommonUtils.toDouble((Object)element.getAttribute("widthRatio"), (double)this.dashboardDescriptor.getWidthRatio());
        this.updatePeriod = CommonUtils.toLong((Object)element.getAttribute("updatePeriod"), (long)this.dashboardDescriptor.getUpdatePeriod());
        this.maxItems = CommonUtils.toInt((Object)element.getAttribute("maxItems"), (int)this.dashboardDescriptor.getMaxItems());
        this.maxAge = CommonUtils.toLong((Object)element.getAttribute("maxAge"), (long)this.dashboardDescriptor.getMaxAge());
        this.legendVisible = CommonUtils.getBoolean((String)element.getAttribute("legendVisible"), (boolean)true);
        this.gridVisible = CommonUtils.getBoolean((String)element.getAttribute("gridVisible"), (boolean)true);
        this.domainTicksVisible = CommonUtils.getBoolean((String)element.getAttribute("domainTicksVisible"), (boolean)true);
        this.rangeTicksVisible = CommonUtils.getBoolean((String)element.getAttribute("rangeTicksVisible"), (boolean)true);
        this.description = element.getAttribute("description");
    }

    public String toString() {
        return String.valueOf(this.dashboardDescriptor.getId()) + ":" + this.index;
    }
}

