/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.folders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderState;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

class TabbedFoldersRegistry {
    private static final Log log = Log.getLog(TabbedFoldersRegistry.class);
    private static final String COLUMNS_CONFIG_FILE = "tabs_settings.xml";
    private static TabbedFoldersRegistry instance;
    private final Map<String, TabbedFolderState> savedStates = new HashMap<String, TabbedFolderState>();
    private volatile ConfigSaver saver = null;

    public static synchronized TabbedFoldersRegistry getInstance() {
        if (instance == null) {
            instance = new TabbedFoldersRegistry();
        }
        return instance;
    }

    public TabbedFoldersRegistry() {
        File savedStates = DBWorkbench.getPlatform().getConfigurationFile(COLUMNS_CONFIG_FILE);
        if (savedStates.exists()) {
            this.loadConfiguration(savedStates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    TabbedFolderState getFolderState(String objectId) {
        Map<String, TabbedFolderState> map = this.savedStates;
        synchronized (map) {
            TabbedFolderState folderState = this.savedStates.get(objectId);
            if (folderState == null) {
                folderState = new TabbedFolderState();
                this.savedStates.put(objectId, folderState);
            }
            return folderState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveConfig() {
        Map<String, TabbedFolderState> map = this.savedStates;
        synchronized (map) {
            if (this.saver == null) {
                this.saver = new ConfigSaver();
                this.saver.schedule(3000L);
            }
        }
    }

    private void loadConfiguration(File configFile) {
        this.savedStates.clear();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(configFile);){
                SAXReader parser = new SAXReader((InputStream)in);
                FolderStateParser dsp = new FolderStateParser();
                parser.parse((SAXListener)dsp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading columns configuration", (Throwable)e);
        }
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Tab folders configuration save");
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            Map map = TabbedFoldersRegistry.this.savedStates;
            synchronized (map) {
                this.flushConfig();
                TabbedFoldersRegistry.this.saver = null;
            }
            return Status.OK_STATUS;
        }

        private void flushConfig() {
            File configFile = DBWorkbench.getPlatform().getConfigurationFile(TabbedFoldersRegistry.COLUMNS_CONFIG_FILE);
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileOutputStream out = new FileOutputStream(configFile);){
                    XMLBuilder xml = new XMLBuilder((OutputStream)out, GeneralUtils.UTF8_ENCODING);
                    xml.setButify(true);
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (XMLBuilder.Element e = xml.startElement("folders");){
                        for (Map.Entry entry : TabbedFoldersRegistry.this.savedStates.entrySet()) {
                            Throwable throwable3 = null;
                            Object var12_18 = null;
                            try (XMLBuilder.Element e2 = xml.startElement("folder");){
                                xml.addAttribute("id", (String)entry.getKey());
                                for (Map.Entry<String, TabbedFolderState.TabState> tab : ((TabbedFolderState)entry.getValue()).getTabStates().entrySet()) {
                                    Throwable throwable4 = null;
                                    Object var17_25 = null;
                                    try (XMLBuilder.Element e3 = xml.startElement("tab");){
                                        xml.addAttribute("id", tab.getKey());
                                        xml.addAttribute("height", tab.getValue().height);
                                        xml.addAttribute("width", tab.getValue().width);
                                        xml.addAttribute("embedded", tab.getValue().embedded);
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable4 == null) {
                                            throwable4 = throwable5;
                                        } else if (throwable4 != throwable5) {
                                            throwable4.addSuppressed(throwable5);
                                        }
                                        throw throwable4;
                                    }
                                }
                            }
                            catch (Throwable throwable6) {
                                if (throwable3 == null) {
                                    throwable3 = throwable6;
                                } else if (throwable3 != throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                                throw throwable3;
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                        } else if (throwable2 != throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        throw throwable2;
                    }
                    xml.flush();
                }
                catch (Throwable throwable8) {
                    if (throwable == null) {
                        throwable = throwable8;
                    } else if (throwable != throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error saving tabs configuration", (Throwable)e);
            }
        }
    }

    private class FolderStateParser
    extends SAXListener.BaseListener {
        private TabbedFolderState curTabbedFolderState = null;

        private FolderStateParser() {
        }

        /*
         * Exception decompiling
         */
        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[5] lbl39 : CaseStatement: default:\u000a, @NONE, blocks:[5] lbl39 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

