/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ui.BooleanRenderer;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.utils.CommonUtils;

public class CustomCheckboxCellEditor
extends CellEditor {
    private static final boolean CHANGE_ON_ACTIVATE = false;
    private Label checkBox;
    private boolean checked;

    public CustomCheckboxCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        GridData gd;
        Composite ph = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        ph.setLayout((Layout)gl);
        ph.setBackground(parent.getBackground());
        this.checkBox = new Label(ph, 0);
        if ((this.getStyle() & 0x4000) == 16384) {
            gd = new GridData(16384, 4, true, true);
            if (BooleanRenderer.getDefaultStyle().isText()) {
                gd.horizontalIndent = 5;
            }
        } else {
            gd = new GridData(0x1000000, 4, true, true);
        }
        this.checkBox.setLayoutData((Object)gd);
        this.checkBox.setBackground(ph.getBackground());
        ph.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CustomCheckboxCellEditor.this.focusLost();
            }
        });
        ph.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case '\u001b': {
                        CustomCheckboxCellEditor.this.dispose();
                        break;
                    }
                    case ' ': {
                        CustomCheckboxCellEditor.this.checked = !CustomCheckboxCellEditor.this.checked;
                        CustomCheckboxCellEditor.this.setCheckIcon();
                        CustomCheckboxCellEditor.this.applyEditorValue();
                        break;
                    }
                    case '\r': {
                        CustomCheckboxCellEditor.this.applyEditorValue();
                        CustomCheckboxCellEditor.this.fireApplyEditorValue();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.checkBox.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CustomCheckboxCellEditor.this.checked = !CustomCheckboxCellEditor.this.checked;
                CustomCheckboxCellEditor.this.setCheckIcon();
                CustomCheckboxCellEditor.this.applyEditorValue();
            }
        });
        return ph;
    }

    private void setCheckIcon() {
        BooleanRenderer.Style booleanStyle = BooleanRenderer.getDefaultStyle();
        if (booleanStyle.isText()) {
            this.checkBox.setText(booleanStyle.getText(this.checked));
        } else {
            this.checkBox.setImage(DBeaverIcons.getImage(booleanStyle.getImage(this.checked)));
        }
    }

    protected Boolean doGetValue() {
        return this.checked;
    }

    protected void doSetFocus() {
        this.checkBox.getParent().setFocus();
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.checkBox != null && value instanceof Boolean ? 1 : 0) != 0);
        this.checked = CommonUtils.toBoolean((Object)value);
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if ((this.getStyle() & 0x4000) == 16384) {
            layoutData.grabHorizontal = true;
            layoutData.horizontalAlignment = 16384;
        } else {
            layoutData.grabHorizontal = true;
            layoutData.horizontalAlignment = 0x1000000;
        }
        return layoutData;
    }

    private void applyEditorValue() {
        Boolean newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        this.setCheckIcon();
    }

    protected int getDoubleClickTimeout() {
        return 0;
    }

    public void activate() {
        this.setCheckIcon();
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        super.activate(activationEvent);
    }
}

