/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.AbstractMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.jkiss.code.NotNull;
import org.jkiss.utils.CommonUtils;

public class DialogSettingsMap
extends AbstractMap<String, Object> {
    private final IDialogSettings settings;

    public DialogSettingsMap(IDialogSettings settings) {
        this.settings = settings;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        LinkedHashSet<Map.Entry<String, Object>> sectionSet = new LinkedHashSet<Map.Entry<String, Object>>();
        IDialogSettings[] sections = this.settings.getSections();
        if (sections != null) {
            IDialogSettings[] iDialogSettingsArray = sections;
            int n = sections.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogSettings section = iDialogSettingsArray[n2];
                sectionSet.add(new AbstractMap.SimpleEntry<String, DialogSettingsMap>(section.getName(), new DialogSettingsMap(section)));
                ++n2;
            }
        }
        return sectionSet;
    }

    @Override
    public Object get(Object key) {
        return this.getOrDefault(key, (Object)null);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        String keyValue = this.settings.get((String)key);
        if (keyValue != null) {
            return keyValue;
        }
        IDialogSettings section = this.settings.getSection((String)key);
        if (section != null) {
            return new DialogSettingsMap(section);
        }
        return defaultValue;
    }

    @Override
    public Object put(String key, Object value) {
        return this.putIfAbsent(key, value);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        if (value instanceof Map) {
            IDialogSettings section = this.settings.addNewSection(key);
            return this.fillSection(section, (Map)value);
        }
        this.settings.put(key, CommonUtils.toString((Object)value));
        return value;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return false;
    }

    private DialogSettingsMap fillSection(IDialogSettings section, Map<String, Object> value) {
        DialogSettingsMap settingsMap = new DialogSettingsMap(section);
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            settingsMap.put(entry.getKey(), entry.getValue());
        }
        return settingsMap;
    }

    @Override
    public int hashCode() {
        return this.settings.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DialogSettingsMap && this.settings.equals(((DialogSettingsMap)o).settings);
    }
}

