/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.stream;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamProducerSettings;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferProducer;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

public class StreamProducerPageSettings
extends ActiveWizardPage<DataTransferWizard> {
    private static final Log log = Log.getLog(StreamProducerPageSettings.class);
    private PropertyTreeViewer propsEditor;
    private PropertySourceCustom propertySource;
    private Table filesTable;

    public StreamProducerPageSettings() {
        super(DTMessages.data_transfer_wizard_page_input_files_name);
        this.setTitle(DTMessages.data_transfer_wizard_page_input_files_title);
        this.setDescription(DTMessages.data_transfer_wizard_page_input_files_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        SashForm settingsDivider = new SashForm(parent, 512);
        Group inputFilesGroup = UIUtils.createControlGroup((Composite)settingsDivider, (String)DTMessages.data_transfer_wizard_settings_group_input_files, (int)1, (int)1808, (int)0);
        this.filesTable = new Table((Composite)inputFilesGroup, 67588);
        this.filesTable.setLayoutData((Object)new GridData(1808));
        this.filesTable.setHeaderVisible(true);
        this.filesTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_source);
        UIUtils.createTableColumn((Table)this.filesTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_target);
        this.filesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (StreamProducerPageSettings.this.filesTable.getSelectionIndex() < 0) {
                    return;
                }
                TableItem item = StreamProducerPageSettings.this.filesTable.getItem(StreamProducerPageSettings.this.filesTable.getSelectionIndex());
                DataTransferPipe pipe = (DataTransferPipe)item.getData();
                StreamProducerPageSettings.this.chooseSourceFile(pipe);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group exporterSettings = UIUtils.createControlGroup((Composite)settingsDivider, (String)DTMessages.data_transfer_wizard_settings_group_importer, (int)1, (int)1808, (int)0);
        this.propsEditor = new PropertyTreeViewer((Composite)exporterSettings, 2048);
        settingsDivider.setWeights(new int[]{400, 600});
        this.setControl((Control)settingsDivider);
        this.updatePageCompletion();
    }

    private void chooseSourceFile(DataTransferPipe pipe) {
        ArrayList<String> extensions = new ArrayList<String>();
        String extensionProp = CommonUtils.toString((Object)this.propertySource.getPropertyValue(null, "extension"));
        String[] stringArray = extensionProp.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extensions.add("*." + ext);
            ++n2;
        }
        extensions.add("*");
        DBRRunnableWithProgress initializer = null;
        if (pipe.getConsumer() != null && pipe.getConsumer().getTargetObjectContainer() != null) {
            File[] files = DialogUtils.openFileList((Shell)this.getShell(), (String)"Select input files", (String[])extensions.toArray(new String[0]));
            if (files != null && files.length > 0) {
                initializer = monitor -> this.updateMultiConsumers(monitor, pipe, files);
            }
        } else {
            File file = DialogUtils.openFile((Shell)this.getShell(), (String[])extensions.toArray(new String[0]));
            if (file != null) {
                initializer = monitor -> this.updateSingleConsumer(monitor, pipe, file);
            }
        }
        if (initializer != null) {
            try {
                ((DataTransferWizard)this.getWizard()).getRunnableContext().run(true, true, initializer);
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Column mappings error", "Error reading column mappings from stream", e.getTargetException());
                return;
            }
            catch (InterruptedException interruptedException) {}
        }
        this.reloadPipes();
        this.updatePageCompletion();
    }

    private void updateSingleConsumer(DBRProgressMonitor monitor, DataTransferPipe pipe, File file) {
        StreamProducerSettings producerSettings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamProducerSettings.class);
        StreamTransferProducer oldProducer = pipe.getProducer() instanceof StreamTransferProducer ? (StreamTransferProducer)pipe.getProducer() : null;
        StreamTransferProducer newProducer = new StreamTransferProducer(new StreamEntityMapping(file));
        pipe.setProducer((IDataTransferProducer)newProducer);
        producerSettings.updateProducerSettingsFromStream(monitor, newProducer, ((DataTransferWizard)this.getWizard()).getSettings());
        IDataTransferSettings consumerSettings = ((DataTransferWizard)this.getWizard()).getSettings().getNodeSettings(((DataTransferWizard)this.getWizard()).getSettings().getConsumer());
        if (consumerSettings instanceof DatabaseConsumerSettings) {
            StreamEntityMapping oldEntityMapping;
            DatabaseMappingContainer oldMappingContainer;
            DatabaseConsumerSettings settings = (DatabaseConsumerSettings)consumerSettings;
            DatabaseMappingContainer mapping = new DatabaseMappingContainer(settings, (DBSDataContainer)newProducer.getDatabaseObject());
            if (pipe.getConsumer() != null && pipe.getConsumer().getDatabaseObject() instanceof DBSDataManipulator) {
                DBSDataManipulator databaseObject = (DBSDataManipulator)pipe.getConsumer().getDatabaseObject();
                DBNDatabaseNode databaseNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)databaseObject.getParentObject(), (boolean)false);
                if (databaseNode != null) {
                    settings.setContainerNode(databaseNode);
                }
                mapping.setTarget(databaseObject);
            } else {
                mapping.setTarget(null);
                mapping.setTargetName(this.generateTableName(newProducer.getInputFile()));
            }
            if (oldProducer != null && (oldMappingContainer = (DatabaseMappingContainer)settings.getDataMappings().remove(oldProducer.getDatabaseObject())) != null && oldMappingContainer.getSource() instanceof StreamEntityMapping && (oldEntityMapping = (StreamEntityMapping)oldMappingContainer.getSource()).isSameColumns(newProducer.getEntityMapping())) {
                StreamEntityMapping entityMapping = new StreamEntityMapping(file);
                settings.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), (DBSDataContainer)entityMapping, new DatabaseMappingContainer(oldMappingContainer, (DBSDataContainer)entityMapping));
                StreamTransferProducer producer = new StreamTransferProducer(entityMapping);
                pipe.setProducer((IDataTransferProducer)producer);
                producerSettings.updateProducerSettingsFromStream(monitor, producer, ((DataTransferWizard)this.getWizard()).getSettings());
                return;
            }
            settings.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), (DBSDataContainer)newProducer.getDatabaseObject(), mapping);
        }
    }

    private void updateMultiConsumers(DBRProgressMonitor monitor, DataTransferPipe pipe, File[] files) {
        StreamProducerSettings producerSettings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamProducerSettings.class);
        IDataTransferConsumer originalConsumer = pipe.getConsumer();
        DataTransferSettings dtSettings = ((DataTransferWizard)this.getWizard()).getSettings();
        ArrayList<DataTransferPipe> newPipes = new ArrayList<DataTransferPipe>(dtSettings.getDataPipes());
        newPipes.remove(pipe);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                File file = fileArray[n2];
                StreamTransferProducer producer = new StreamTransferProducer(new StreamEntityMapping(file));
                DatabaseTransferConsumer consumer = new DatabaseTransferConsumer();
                DataTransferPipe singlePipe = new DataTransferPipe((IDataTransferProducer)producer, (IDataTransferConsumer)consumer);
                try {
                    singlePipe.initPipe(dtSettings, newPipes.size(), newPipes.size());
                }
                catch (DBException e) {
                    log.error((Object)e);
                    break block5;
                }
                newPipes.add(singlePipe);
                producerSettings.updateProducerSettingsFromStream(monitor, producer, dtSettings);
                IDataTransferSettings consumerSettings = dtSettings.getNodeSettings(dtSettings.getConsumer());
                if (consumerSettings instanceof DatabaseConsumerSettings) {
                    DBNDatabaseNode containerNode;
                    DatabaseConsumerSettings dcs = (DatabaseConsumerSettings)consumerSettings;
                    if (originalConsumer != null && originalConsumer.getTargetObjectContainer() instanceof DBSObject && (containerNode = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)((DBSObject)originalConsumer.getTargetObjectContainer()), (boolean)false)) != null) {
                        dcs.setContainerNode(containerNode);
                    }
                    DatabaseMappingContainer mapping = new DatabaseMappingContainer(dcs, (DBSDataContainer)producer.getDatabaseObject());
                    mapping.setTargetName(this.generateTableName(producer.getInputFile()));
                    dcs.addDataMappings(((DataTransferWizard)this.getWizard()).getRunnableContext(), (DBSDataContainer)producer.getDatabaseObject(), mapping);
                }
            }
            ++n2;
        }
        dtSettings.setDataPipes(newPipes, false);
        dtSettings.setPipeChangeRestricted(true);
    }

    private void updateItemData(TableItem item, DataTransferPipe pipe) {
        if (this.isInvalidDataTransferNode((IDataTransferNode<?>)pipe.getProducer())) {
            item.setImage(0, null);
            item.setText(0, DTUIMessages.stream_consumer_page_settings_item_text_none);
        } else {
            item.setImage(0, DBeaverIcons.getImage((DBPImage)this.getProducerProcessor().getIcon()));
            item.setText(0, String.valueOf(pipe.getProducer().getObjectName()));
        }
        if (this.isInvalidDataTransferNode((IDataTransferNode<?>)pipe.getConsumer())) {
            item.setImage(1, null);
            item.setText(1, DTUIMessages.stream_consumer_page_settings_item_text_none);
        } else {
            item.setImage(1, DBeaverIcons.getImage((DBPImage)((DataTransferWizard)this.getWizard()).getSettings().getConsumer().getIcon()));
            item.setText(1, String.valueOf(pipe.getConsumer().getObjectName()));
        }
    }

    private boolean isInvalidDataTransferNode(IDataTransferNode<?> node) {
        return node == null || node.getObjectName() == null;
    }

    public void activatePage() {
        DataTransferProcessorDescriptor processor = this.getProducerProcessor();
        DBPPropertyDescriptor[] properties = processor == null ? new DBPPropertyDescriptor[]{} : processor.getProperties();
        this.propertySource = new PropertySourceCustom(properties, ((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
        this.propsEditor.loadProperties((DBPPropertySource)this.propertySource);
        this.reloadPipes();
        this.updatePageCompletion();
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.filesTable, (boolean)true));
    }

    public void deactivatePage() {
        this.propsEditor.saveEditorValues();
        Map processorProperties = this.propertySource.getPropertiesWithDefaults();
        DataTransferSettings dtSettings = ((DataTransferWizard)this.getWizard()).getSettings();
        dtSettings.setProcessorProperties(processorProperties);
        StreamProducerSettings producerSettings = ((DataTransferWizard)this.getWizard()).getPageSettings((IWizardPage)this, StreamProducerSettings.class);
        if (producerSettings != null) {
            producerSettings.setProcessorProperties(processorProperties);
        }
        IDataTransferSettings consumerSettings = ((DataTransferWizard)this.getWizard()).getSettings().getNodeSettings(((DataTransferWizard)this.getWizard()).getSettings().getConsumer());
        try {
            ((DataTransferWizard)this.getWizard()).getRunnableContext().run(true, true, monitor -> {
                for (DataTransferPipe pipe : dtSettings.getDataPipes()) {
                    DatabaseMappingContainer mapping;
                    if (!(pipe.getProducer() instanceof StreamTransferProducer)) continue;
                    StreamTransferProducer producer = (StreamTransferProducer)pipe.getProducer();
                    producerSettings.updateProducerSettingsFromStream(monitor, producer, dtSettings);
                    if (!(consumerSettings instanceof DatabaseConsumerSettings) || (mapping = ((DatabaseConsumerSettings)consumerSettings).getDataMapping((DBSDataContainer)producer.getDatabaseObject())) == null) continue;
                    mapping.getAttributeMappings(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Error updating stream settings", "Error updating settings", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {}
        super.deactivatePage();
    }

    protected boolean determinePageCompletion() {
        int i = 0;
        while (i < this.filesTable.getItemCount()) {
            DataTransferPipe pipe = (DataTransferPipe)this.filesTable.getItem(i).getData();
            if (this.isInvalidDataTransferNode((IDataTransferNode<?>)pipe.getConsumer()) || this.isInvalidDataTransferNode((IDataTransferNode<?>)pipe.getProducer())) {
                this.setMessage(DTUIMessages.stream_consumer_page_warning_not_enough_sources_chosen, 2);
                return false;
            }
            ++i;
        }
        this.setMessage(null);
        return true;
    }

    private void reloadPipes() {
        DataTransferPipe pipe2;
        boolean firstTime = this.filesTable.getItemCount() == 0;
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        this.filesTable.removeAll();
        List dataPipes = settings.getDataPipes();
        for (DataTransferPipe pipe2 : dataPipes) {
            TableItem item = new TableItem(this.filesTable, 0);
            item.setData((Object)pipe2);
            this.updateItemData(item, pipe2);
        }
        if (firstTime && !dataPipes.isEmpty() && (pipe2 = (DataTransferPipe)dataPipes.get(0)).getProducer() instanceof StreamTransferProducer && ((StreamTransferProducer)pipe2.getProducer()).getInputFile() == null) {
            UIUtils.asyncExec(() -> this.chooseSourceFile(pipe2));
        }
    }

    private DataTransferProcessorDescriptor getProducerProcessor() {
        return ((DataTransferWizard)this.getWizard()).getSettings().getProcessor();
    }

    @NotNull
    private String generateTableName(File file) {
        StringBuilder name = new StringBuilder();
        String fileName = file.getName();
        boolean lastCharSpecial = false;
        char lastChar = '\u0000';
        int i = 0;
        while (i < fileName.length()) {
            block7: {
                char c;
                block6: {
                    c = fileName.charAt(i);
                    if (!Character.isLetter(c) && lastCharSpecial) break;
                    boolean bl = lastCharSpecial = !Character.isLetterOrDigit(c);
                    if (!lastCharSpecial) break block6;
                    if (c != '_') {
                        c = '_';
                    }
                    if (lastChar == '_') break block7;
                }
                lastChar = c;
                name.append(c);
            }
            ++i;
        }
        if (name.length() > 0 && name.charAt(name.length() - 1) == '_') {
            name.deleteCharAt(name.length() - 1);
        }
        return name.toString();
    }
}

