/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class Orientation {
    public static final int CLOCKWISE = -1;
    public static final int RIGHT = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int COLLINEAR = 0;
    public static final int STRAIGHT = 0;

    public static int index(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithmsDD.orientationIndex(p1, p2, q);
    }

    public static boolean isCCW(Coordinate[] ring) {
        return Orientation.isCCW(new CoordinateArraySequence(ring, 2, 0));
    }

    public static boolean isCCW(CoordinateSequence ring) {
        int nPts = ring.size() - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 4 points, so orientation cannot be determined");
        }
        Coordinate upHiPt = ring.getCoordinate(0);
        double prevY = upHiPt.y;
        Coordinate upLowPt = null;
        int iUpHi = 0;
        for (int i = 1; i <= nPts; ++i) {
            double py = ring.getOrdinate(i, 1);
            if (py > prevY && py >= upHiPt.y) {
                upHiPt = ring.getCoordinate(i);
                iUpHi = i;
                upLowPt = ring.getCoordinate(i - 1);
            }
            prevY = py;
        }
        if (iUpHi == 0) {
            return false;
        }
        int iDownLow = iUpHi;
        while ((iDownLow = (iDownLow + 1) % nPts) != iUpHi && ring.getOrdinate(iDownLow, 1) == upHiPt.y) {
        }
        Coordinate downLowPt = ring.getCoordinate(iDownLow);
        int iDownHi = iDownLow > 0 ? iDownLow - 1 : nPts - 1;
        Coordinate downHiPt = ring.getCoordinate(iDownHi);
        if (upHiPt.equals2D(downHiPt)) {
            if (upLowPt.equals2D(upHiPt) || downLowPt.equals2D(upHiPt) || upLowPt.equals2D(downLowPt)) {
                return false;
            }
            int index = Orientation.index(upLowPt, upHiPt, downLowPt);
            return index == 1;
        }
        double delX = downHiPt.x - upHiPt.x;
        return delX < 0.0;
    }

    public static boolean isCCWArea(Coordinate[] ring) {
        return Area.ofRingSigned(ring) < 0.0;
    }
}

