/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.AbstractLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.sql.task.SQLToolStatistics;
import org.jkiss.dbeaver.tasks.ui.sql.SQLToolTaskWizard;
import org.jkiss.dbeaver.tasks.ui.sql.internal.TasksSQLUIMessages;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.navigator.itemlist.ObjectListControl;

class SQLToolTaskWizardPageStatus
extends ActiveWizardPage<SQLToolTaskWizard> {
    private static final Log log = Log.getLog(SQLToolTaskWizardPageStatus.class);
    private PrintStream writer;
    private MessageConsole console;
    private ObjectListControl<SQLToolStatistics> statusTable;
    private AbstractJob statusUpdateJob;
    private final List<SQLToolStatistics> toolStatistics = new ArrayList<SQLToolStatistics>();

    SQLToolTaskWizardPageStatus(SQLToolTaskWizard wizard) {
        super(TasksSQLUIMessages.sql_tool_task_wizard_page_status_name);
        this.setTitle(TasksSQLUIMessages.sql_tool_task_wizard_page_status_title);
        this.setDescription(TasksSQLUIMessages.sql_tool_task_wizard_page_status_description);
    }

    public void activatePage() {
        this.setTitle(NLS.bind((String)TasksSQLUIMessages.sql_tool_task_wizard_page_status_activate_page_title, (Object)((SQLToolTaskWizard)this.getWizard()).getTaskType().getName()));
        super.activatePage();
    }

    public boolean isPageComplete() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new FillLayout());
        SashForm partDivider = new SashForm(composite, 512);
        partDivider.setSashWidth(5);
        this.statusTable = new ObjectListControl<SQLToolStatistics>((Composite)partDivider, 0x10000000, (IContentProvider)new ListContentProvider()){

            @NotNull
            protected String getListConfigId(List<Class<?>> classList) {
                return "SQLToolStatus." + ((SQLToolTaskWizard)SQLToolTaskWizardPageStatus.this.getWizard()).getTaskType().getId();
            }

            protected DBPImage getObjectImage(SQLToolStatistics item) {
                return DBValueFormatting.getObjectImage((DBPObject)item.getObject());
            }

            protected LoadingJob<Collection<SQLToolStatistics>> createLoadService(boolean forUpdate) {
                return LoadingJob.createService((ILoadService)new DummyLoadService(), (ILoadVisualizer)new ObjectListControl.ObjectsLoadVisualizer((ObjectListControl)this));
            }
        };
        this.console = new MessageConsole(TasksSQLUIMessages.sql_tool_task_wizard_page_status_message_console_name_tool_log, null);
        new LogConsoleViewer((Composite)partDivider);
        this.console.setWaterMarks(0x300000, 0x400000);
        try {
            this.writer = new PrintStream((OutputStream)this.console.newMessageStream(), true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.writer = new PrintStream((OutputStream)this.console.newMessageStream(), true);
        }
        this.setControl((Control)composite);
    }

    PrintStream getLogWriter() {
        return this.writer;
    }

    void clearLog() {
        this.statusTable.clearListData();
        this.console.clearConsole();
    }

    public void appendLine(String line) {
        if (this.getShell().isDisposed()) {
            return;
        }
        this.writer.print(String.valueOf(line) + "\n");
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStatistics(DBPObject object, List<? extends SQLToolStatistics> statistics) {
        List<SQLToolStatistics> list = this.toolStatistics;
        synchronized (list) {
            this.toolStatistics.addAll(statistics);
        }
        if (this.statusUpdateJob == null) {
            this.statusUpdateJob = new AbstractJob(TasksSQLUIMessages.sql_tool_task_wizard_page_status_update_job_name_update_tool){
                {
                    this.setSystem(true);
                    this.setUser(false);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(DBRProgressMonitor monitor) {
                    ArrayList statsCopy;
                    List list = SQLToolTaskWizardPageStatus.this.toolStatistics;
                    synchronized (list) {
                        statsCopy = new ArrayList(SQLToolTaskWizardPageStatus.this.toolStatistics);
                        SQLToolTaskWizardPageStatus.this.toolStatistics.clear();
                    }
                    UIUtils.asyncExec(() -> {
                        SQLToolTaskWizardPageStatus.this.statusTable.appendListData((Collection)statsCopy);
                        SQLToolTaskWizardPageStatus.this.statusTable.repackColumns();
                    });
                    return Status.OK_STATUS;
                }
            };
        }
        this.statusUpdateJob.schedule(100L);
    }

    private class DummyLoadService
    extends AbstractLoadService<Collection<SQLToolStatistics>> {
        DummyLoadService() {
            super(TasksSQLUIMessages.sql_tool_task_wizard_page_status_dummy_load_service_name);
        }

        public Collection<SQLToolStatistics> evaluate(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                return Collections.emptyList();
            }
            catch (Throwable ex) {
                throw new InvocationTargetException(ex);
            }
        }

        public Object getFamily() {
            return ((SQLToolTaskWizard)SQLToolTaskWizardPageStatus.this.getWizard()).getTaskType();
        }
    }

    private class LogConsoleViewer
    extends TextConsoleViewer
    implements IDocumentListener {
        LogConsoleViewer(Composite composite) {
            super(composite, (TextConsole)SQLToolTaskWizardPageStatus.this.console);
        }

        public void setDocument(IDocument document) {
            IDocument oldDocument = this.getDocument();
            super.setDocument(document);
            if (oldDocument != null) {
                oldDocument.removeDocumentListener((IDocumentListener)this);
            }
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.revealEndOfDocument();
        }
    }
}

