/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLServerExecutionContext
extends JDBCExecutionContext
implements DBCExecutionContextDefaults<SQLServerDatabase, SQLServerSchema> {
    private static final Log log = Log.getLog(SQLServerExecutionContext.class);
    private String activeDatabaseName;
    private String activeSchemaName;
    private String currentUser;

    SQLServerExecutionContext(@NotNull JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @NotNull
    public SQLServerDataSource getDataSource() {
        return (SQLServerDataSource)super.getDataSource();
    }

    @NotNull
    public SQLServerExecutionContext getContextDefaults() {
        return this;
    }

    public String getActiveDatabaseName() {
        return this.activeDatabaseName;
    }

    public SQLServerDatabase getDefaultCatalog() {
        return this.getDataSource().getDatabase(this.activeDatabaseName);
    }

    public SQLServerSchema getDefaultSchema() {
        if (CommonUtils.isEmpty((String)this.activeSchemaName)) {
            return null;
        }
        try {
            SQLServerDatabase defaultCatalog = this.getDefaultCatalog();
            return defaultCatalog == null ? null : defaultCatalog.getSchema((DBRProgressMonitor)new VoidProgressMonitor(), this.activeSchemaName);
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }

    public boolean supportsCatalogChange() {
        return true;
    }

    public boolean supportsSchemaChange() {
        return false;
    }

    public void setDefaultCatalog(DBRProgressMonitor monitor, SQLServerDatabase catalog, SQLServerSchema schema) throws DBCException {
        if (this.activeDatabaseName != null && this.activeDatabaseName.equals(catalog.getName())) {
            return;
        }
        SQLServerDatabase oldActiveDatabase = this.getDefaultCatalog();
        if (!this.setCurrentDatabase(monitor, catalog)) {
            return;
        }
        try {
            catalog.getSchemas(monitor);
        }
        catch (DBException e) {
            log.debug((Object)"Error caching database schemas", (Throwable)e);
        }
        this.activeDatabaseName = catalog.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldActiveDatabase, (DBSObject)catalog);
        if (schema != null) {
            this.setDefaultSchema(monitor, schema);
        }
    }

    public void setDefaultSchema(DBRProgressMonitor monitor, SQLServerSchema schema) throws DBCException {
        if (this.activeSchemaName != null && this.activeSchemaName.equals(schema.getName())) {
            return;
        }
        SQLServerSchema oldActiveSchema = this.getDefaultSchema();
        this.activeSchemaName = schema.getName();
        DBUtils.fireObjectSelectionChange((DBSObject)oldActiveSchema, (DBSObject)schema);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query active schema and database");){
            DBPConnectionBootstrap bootstrap;
            String currentDatabase = null;
            try {
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCStatement dbStat = session.createStatement();){
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery("SELECT db_name(), schema_name(), original_login()");){
                        dbResult.next();
                        currentDatabase = dbResult.getString(1);
                        this.activeSchemaName = dbResult.getString(2);
                        this.currentUser = dbResult.getString(3);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                            throw throwable3;
                        }
                        if (throwable3 == throwable4) throw throwable3;
                        throwable3.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                        throw throwable2;
                    }
                    if (throwable2 == throwable5) throw throwable2;
                    throwable2.addSuppressed(throwable5);
                    throw throwable2;
                }
            }
            catch (Throwable e) {
                log.debug((Object)("Error getting current user: " + e.getMessage()));
            }
            if (CommonUtils.isEmpty((String)this.activeSchemaName)) {
                this.activeSchemaName = "dbo";
            }
            if (useBootstrapSettings && !CommonUtils.isEmpty((String)(bootstrap = this.getBootstrapSettings()).getDefaultCatalogName()) && this.supportsCatalogChange()) {
                this.setCurrentDatabase(monitor, bootstrap.getDefaultCatalogName());
            }
            if (CommonUtils.isEmpty(currentDatabase)) return false;
            if (CommonUtils.equalObjects(currentDatabase, (Object)this.activeDatabaseName)) return false;
            this.activeDatabaseName = currentDatabase;
            return true;
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
                throw throwable;
            }
            if (throwable == throwable7) throw throwable;
            throwable.addSuppressed(throwable7);
            throw throwable;
        }
    }

    boolean setCurrentDatabase(DBRProgressMonitor monitor, SQLServerDatabase object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current schema");
            return false;
        }
        String databaseName = object.getName();
        return this.setCurrentDatabase(monitor, databaseName);
    }

    private boolean setCurrentDatabase(DBRProgressMonitor monitor, String databaseName) {
        block12: {
            Throwable throwable = null;
            Object var4_6 = null;
            JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active database");
            try {
                SQLServerUtils.setCurrentDatabase(session, databaseName);
                this.activeDatabaseName = databaseName;
                if (session == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    log.error((Object)e);
                    return false;
                }
            }
            session.close();
        }
        return true;
    }
}

