/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergeManager;
import ancestris.modules.releve.merge.MergeTable;
import ancestris.modules.releve.merge.Proposal;
import ancestris.modules.releve.merge.SelectionManager;
import genj.gedcom.Property;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MergePanel
extends JPanel {
    private Proposal currentProposal = null;
    private JPopupMenu popupMenu;
    private JMenuItem menuItemImportClipboard = new JMenuItem(NbBundle.getMessage(MergePanel.class, (String)"MergePanel.menu.copyToClipboard"));
    private boolean firstPanel = true;
    private static ToolMouseAdapter mouseAdapter = new ToolMouseAdapter();
    private ButtonGroup buttonGroupChoiceModel;
    private JPanel jPanel1;
    private JPanel jPanelChoice;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane;
    private MergeTable mergeTable1;

    public MergePanel() {
        this.initComponents();
        ActionListener popupActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MergePanel.this.menuItemImportClipboard.equals(e.getSource())) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection sel = new StringSelection(MergePanel.this.currentProposal.getEventComment());
                    clipboard.setContents(sel, sel);
                }
            }
        };
        this.popupMenu = new JPopupMenu();
        this.menuItemImportClipboard.addActionListener(popupActionListener);
        this.popupMenu.add(this.menuItemImportClipboard);
        this.mergeTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    MergePanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    protected void initData(MergeManager.ProposalList proposalList, boolean firstPanel) {
        this.firstPanel = firstPanel;
        this.jPanelChoice.removeAll();
        String splitHeight = NbPreferences.forModule(MergePanel.class).get("MergeDialogSplitHeight" + (firstPanel ? "1" : "2"), "90");
        this.jSplitPane.setDividerLocation(Integer.parseInt(splitHeight));
        this.buttonGroupChoiceModel = new ButtonGroup();
        for (int i = 0; i < proposalList.getSize(); ++i) {
            this.addRadioButton(i, proposalList.getElementAt(i), proposalList.containsSelectedEntity(i));
        }
        if (this.buttonGroupChoiceModel.getButtonCount() > 0) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = this.buttonGroupChoiceModel.getButtonCount();
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weighty = 1.0;
            JLabel jLabelEnd = new JLabel();
            this.jPanelChoice.add((Component)jLabelEnd, gridBagConstraints);
            JRadioButton radioButton0 = (JRadioButton)this.buttonGroupChoiceModel.getElements().nextElement();
            radioButton0.doClick();
        }
        this.revalidate();
        this.repaint();
    }

    protected void componentClosed() {
        if (this.firstPanel) {
            NbPreferences.forModule(MergePanel.class).put("MergeDialogSplitHeight" + (this.firstPanel ? "1" : "2"), String.valueOf(this.jSplitPane.getDividerLocation()));
            this.mergeTable1.componentClosed();
        }
    }

    private void addRadioButton(int position, final Proposal proposal, boolean containsSelectedEntity) {
        String labelText = " " + Integer.toString(proposal.getDisplayRuleList().getNbEqual()) + " ";
        JLabel jLabelNbMatch = new JLabel();
        jLabelNbMatch.setText(labelText);
        jLabelNbMatch.setBorder(null);
        jLabelNbMatch.setVerticalTextPosition(1);
        jLabelNbMatch.setVerticalAlignment(1);
        if (proposal.getDisplayRuleList().getNbConflict() > 0) {
            jLabelNbMatch.setBackground(Color.PINK);
            jLabelNbMatch.setOpaque(true);
        }
        jLabelNbMatch.addMouseListener(new ToolMouseAdapter());
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setVerticalTextPosition(1);
        jRadioButton.setText(proposal.getSummary(false));
        if (!containsSelectedEntity) {
            jRadioButton.setFont(jRadioButton.getFont().deriveFont(2));
            jRadioButton.setForeground(Color.blue);
        }
        jRadioButton.setMargin(new Insets(0, 2, 0, 2));
        jRadioButton.setPreferredSize(null);
        jRadioButton.setSelected(false);
        jRadioButton.setToolTipText(proposal.getSummary(true));
        jRadioButton.addMouseListener(mouseAdapter);
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MergePanel.this.selectProposal(proposal, (JRadioButton)evt.getSource());
            }
        });
        this.buttonGroupChoiceModel.add(jRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = position;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanelChoice.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = position;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        this.jPanelChoice.add((Component)jLabelNbMatch, gridBagConstraints);
    }

    private void selectProposal(Proposal proposal, JRadioButton radioButton) {
        this.currentProposal = proposal;
        this.mergeTable1.setModel(this.currentProposal.getDisplayRuleList());
        this.currentProposal.getDisplayRuleList().fireTableDataChanged();
        SelectionManager.setRootEntity((Property)this.currentProposal.getMainEntity());
    }

    Proposal getCurrentProposal() {
        return this.currentProposal;
    }

    private void initComponents() {
        this.buttonGroupChoiceModel = new ButtonGroup();
        this.jSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanelChoice = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.mergeTable1 = new MergeTable();
        this.setLayout(new BorderLayout());
        this.jSplitPane.setOrientation(0);
        this.jPanel1.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setHorizontalScrollBar(null);
        this.jPanelChoice.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelChoice.setRequestFocusEnabled(false);
        this.jPanelChoice.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.jPanelChoice);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane.setTopComponent(this.jPanel1);
        this.jScrollPane2.setViewportView(this.mergeTable1);
        this.jSplitPane.setBottomComponent(this.jScrollPane2);
        this.add((Component)this.jSplitPane, "Center");
    }

    private static class ToolMouseAdapter
    extends MouseAdapter {
        final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        final int dismissDelayMinutes = (int)TimeUnit.MINUTES.toMillis(10L);

        private ToolMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            ToolTipManager.sharedInstance().setDismissDelay(this.dismissDelayMinutes);
        }

        @Override
        public void mouseExited(MouseEvent me) {
            ToolTipManager.sharedInstance().setDismissDelay(this.defaultDismissTimeout);
        }
    }
}

