/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.phonetics;

import ancestris.reports.phonetics.Phonetics;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Soundex
implements Phonetics {
    private static final Logger LOG = Logger.getLogger("ancestris.report");
    private static final String ACCENTS = "\u0160S \u017dZ \u0161s \u017ez \u0178Y \u00c0A \u00c1A \u00c2A \u00c3A \u00c4A \u00c5A \u00c7C \u00c8E \u00c9E \u00caE \u00cbE \u00ccI \u00cdI \u00ceI \u00cfI \u00d1N \u00d2O \u00d3O \u00d4O \u00d5O \u00d6O \u00d8O \u00d9U \u00daU \u00dbU \u00dcU \u00ddY \u00e0a \u00e1a \u00e2a \u00e3a \u00e4a \u00e5a \u00e7c \u00e8e \u00e9e \u00eae \u00ebe \u00eci \u00edi \u00eei \u00efi \u00f1n \u00f2o \u00f3o \u00f4o \u00f5o \u00f6o \u00f8o \u00f9u \u00fau \u00fbu \u00fcu \u00fdy \u00b5u \u00deTH \u00feth \u00d0DH \u00f0dh \u00dfss \u0152OE \u0153oe \u00c6AE \u00e6ae";
    public static final char[] US_ENGLISH_SOUNDEX_MAPPING = "01230120022455012623010202".toCharArray();
    private Map<Character, Character> accents;
    private char[] soundexMapping;

    public Soundex() {
        this(US_ENGLISH_SOUNDEX_MAPPING);
    }

    public Soundex(char[] mapping) {
        this.soundexMapping = mapping;
    }

    public String substituteAccents(String str) {
        if (this.accents == null) {
            this.accents = new HashMap<Character, Character>();
            try {
                StringTokenizer tokens = new StringTokenizer(ACCENTS);
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken();
                    Character unicode = Character.valueOf(token.charAt(0));
                    Character substitute = Character.valueOf(token.charAt(1));
                    this.accents.put(unicode, substitute);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.INFO, "Accents converison error", t);
            }
        }
        StringBuilder result = new StringBuilder(str.length() * 2);
        for (int i = 0; i < str.length(); ++i) {
            Character c = Character.valueOf(str.charAt(i));
            if (this.accents.get(c) != null) {
                result.append(this.accents.get(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public String encode(String s) {
        char mapped;
        if (s == null || s.length() == 0) {
            return null;
        }
        String str = this.substituteAccents(s);
        if (!Character.isLetter(str.charAt(0))) {
            return this.encode(str.substring(1));
        }
        char[] out = new char[]{'0', '0', '0', '0'};
        int incount = 1;
        int count = 1;
        out[0] = Character.toUpperCase(str.charAt(0));
        char last = this.getMappingCode(str.charAt(0));
        while (incount < str.length() && (mapped = this.getMappingCode(str.charAt(incount++))) != '\u0000' && count < 4) {
            if (mapped != '0' && mapped != last) {
                out[count++] = mapped;
            }
            last = mapped;
        }
        return new String(out);
    }

    private char getMappingCode(char c) {
        if (!Character.isLetter(c)) {
            return '0';
        }
        int loc = Character.toUpperCase(c) - 65;
        if (loc < 0 || loc > this.soundexMapping.length - 1) {
            return '0';
        }
        return this.soundexMapping[loc];
    }

    public String toString() {
        return "Soundex";
    }
}

