/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedcomstatistics;

import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Delta;
import genj.util.ReferenceSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndiStat {
    public static final int ROW_TOTAL = 0;
    public static final int NB_REFSETS = 3;
    public static final String[] REFSET_LABELS = new String[]{"nbFamilies", "nbMarriages", "nbDivorces"};
    private static final int FAMILIES = 0;
    private static final int MARRIAGES = 1;
    private static final int DIVORCES = 2;
    public int counter = 0;
    public int counterWithAge = 0;
    public Delta minAgeDelta = new Delta(0, 0, 0);
    public Delta maxAgeDelta = new Delta(0, 0, 0);
    public int percent = 0;
    public int percentWithAge = 0;
    public Delta avgAgeDelta = new Delta(0, 0, 0);
    public int counterMinAge = 0;
    public int counterMaxAge = 0;
    public Set<Property> minAgeSet = new HashSet<Property>();
    public Set<Property> maxAgeSet = new HashSet<Property>();
    private final ReferenceSet<Integer, Property> agesAtDeath = new ReferenceSet();
    public ReferenceSet<Integer, Property>[] refSets;
    public long sumAgeDays = 0L;
    public int minAgeDays = Integer.MAX_VALUE;
    public int maxAgeDays = Integer.MIN_VALUE;

    public IndiStat() {
        this.refSets = new ReferenceSet[]{new ReferenceSet(), new ReferenceSet(), new ReferenceSet()};
    }

    public void increment(Indi indi) {
        Fam[] fams;
        Delta ageDelta;
        ++this.counter;
        PropertyDate pDate = indi.getDeathDateOption();
        Delta delta = ageDelta = pDate != null ? indi.getAge(pDate.getStart()) : null;
        if (ageDelta != null) {
            ++this.counterWithAge;
            int ageNum = this.delta2days(ageDelta);
            this.sumAgeDays += (long)ageNum;
            if (ageNum < this.minAgeDays) {
                this.minAgeDays = ageNum;
                this.minAgeDelta = ageDelta;
            }
            if (ageNum > this.maxAgeDays) {
                this.maxAgeDays = ageNum;
                this.maxAgeDelta = ageDelta;
            }
            this.agesAtDeath.add((Object)ageNum, (Object)indi);
        }
        if ((fams = indi.getFamiliesWhereSpouse()).length > 0) {
            this.refSets[0].add((Object)fams.length, (Object)indi);
            this.refSets[0].add((Object)0, (Object)indi);
        }
        int marrCounter = 0;
        int divCounter = 0;
        for (Fam fam : fams) {
            boolean areMarried = fam.getProperty("MARR") != null;
            boolean areDivorced = fam.getProperty("DIV") != null;
            marrCounter += areMarried ? 1 : 0;
            divCounter += areDivorced ? 1 : 0;
        }
        if (marrCounter > 0) {
            this.refSets[1].add((Object)marrCounter, (Object)indi);
            this.refSets[1].add((Object)0, (Object)indi);
        }
        if (divCounter > 0) {
            this.refSets[2].add((Object)divCounter, (Object)indi);
            this.refSets[2].add((Object)0, (Object)indi);
        }
    }

    public void calculateTotals(int total) {
        this.percent = total == 0 ? 0 : 100 * this.counter / total;
        this.percentWithAge = this.counter == 0 ? 0 : 100 * this.counterWithAge / this.counter;
        this.avgAgeDelta = this.counterWithAge == 0 ? new Delta(0, 0, 0) : this.days2Delta((int)(this.sumAgeDays / (long)this.counterWithAge));
        List keys = this.agesAtDeath.getKeys();
        if (!keys.isEmpty()) {
            Collections.sort(keys);
            this.minAgeSet = this.agesAtDeath.getReferences((Object)((Integer)keys.get(0)));
            this.counterMinAge = this.minAgeSet.size();
            this.maxAgeSet = this.agesAtDeath.getReferences((Object)((Integer)keys.get(keys.size() - 1)));
            this.counterMaxAge = this.maxAgeSet.size();
        }
    }

    public void addSets(IndiStat stats) {
        this.addSet(this.agesAtDeath, stats.agesAtDeath);
        for (int i = 0; i < 3; ++i) {
            this.addSet(this.refSets[i], stats.refSets[i]);
        }
    }

    private void addSet(ReferenceSet<Integer, Property> to, ReferenceSet<Integer, Property> from) {
        List keys = from.getKeys();
        for (Integer key : keys) {
            for (Property o : from.getReferences((Object)key)) {
                to.add((Object)key, (Object)o);
            }
        }
    }

    public static int getMaxKey(ReferenceSet<Integer, Property> refSet) {
        List keys = refSet.getKeys();
        if (keys.isEmpty()) {
            return 0;
        }
        Collections.sort(keys);
        return (Integer)keys.get(keys.size() - 1);
    }

    private int delta2days(Delta age) {
        return age.getYears() * 360 + age.getMonths() * 30 + age.getDays();
    }

    private Delta days2Delta(int age) {
        int years = age / 360;
        int months = (age %= 360) / 30;
        int days = age % 30;
        return new Delta(days, months, years);
    }
}

