/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.SourceMatcherOptions;
import ancestris.util.GedcomUtilities;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyRepository;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SourceMatcher
extends EntityMatcher<Source, SourceMatcherOptions> {
    private final Map<Source, Values> sourceValuesMap;
    private final Set<String> alreadyCompared;
    private static final int[] points = new int[]{-40, -20, 0, 60, 100};
    private static final int[] weights = new int[]{6, 1, 1, 1, 10, 6, 3, 1, 2, 2, 5, 10};

    public SourceMatcher() {
        this.options = new SourceMatcherOptions();
        this.sourceValuesMap = new HashMap<Source, Values>();
        this.alreadyCompared = new HashSet<String>();
    }

    private Values getValues(Source source) {
        Values values = this.sourceValuesMap.get(source);
        if (values == null) {
            values = new Values(source);
            this.sourceValuesMap.put(source, values);
        }
        return values;
    }

    @Override
    public int compare(Source left, Source right) {
        String key = this.getIdKey(left.getId(), right.getId());
        if (this.alreadyCompared.contains(key)) {
            return 0;
        }
        this.alreadyCompared.add(key);
        int itemScore = 0;
        int[] scores = new int[weights.length];
        Values leftValues = this.getValues(left);
        Values rightValues = this.getValues(right);
        if (leftValues.coef[0] * rightValues.coef[0] == 1) {
            itemScore = leftValues.title.equals(rightValues.title) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftValues.title, (String)rightValues.title, (int)3));
            scores[0] = points[itemScore];
        }
        if (leftValues.coef[1] * rightValues.coef[1] == 1) {
            itemScore = leftValues.abbr.equals(rightValues.abbr) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftValues.abbr, (String)rightValues.abbr, (int)3));
            scores[1] = points[itemScore];
        }
        if (leftValues.coef[2] * rightValues.coef[2] == 1) {
            itemScore = leftValues.auth.equals(rightValues.auth) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftValues.auth, (String)rightValues.auth, (int)3));
            scores[2] = points[itemScore];
        }
        if (leftValues.coef[3] * rightValues.coef[3] == 1) {
            itemScore = leftValues.publ.equals(rightValues.publ) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftValues.publ, (String)rightValues.publ, (int)3));
            scores[3] = points[itemScore];
        }
        if (leftValues.coef[4] * rightValues.coef[4] == 1) {
            itemScore = this.getLevel(GedcomUtilities.calcCosine(leftValues.textMap, rightValues.textMap));
            scores[4] = points[itemScore];
        }
        if (leftValues.coef[5] * rightValues.coef[5] == 1) {
            itemScore = leftValues.mediaId.equals(rightValues.mediaId) ? COMPARE_SURE_SAME : COMPARE_SURE_DIFFERENT;
            scores[5] = points[itemScore];
        }
        if (leftValues.coef[6] * rightValues.coef[6] == 1) {
            itemScore = leftValues.mediaTitle.equals(rightValues.mediaTitle) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftValues.mediaTitle, (String)rightValues.mediaTitle, (int)3));
            scores[6] = points[itemScore];
        }
        if (leftValues.coef[7] * rightValues.coef[7] == 1) {
            itemScore = leftValues.repo.equals(rightValues.repo) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftValues.repo.getRepositoryName(), (String)rightValues.repo.getRepositoryName(), (int)3));
            scores[7] = points[itemScore];
        }
        if (leftValues.coef[8] * rightValues.coef[8] == 1) {
            int n = itemScore = leftValues.caln.equals(rightValues.caln) ? COMPARE_SURE_SAME : COMPARE_SURE_DIFFERENT;
            if (itemScore == COMPARE_SURE_DIFFERENT) {
                return 0;
            }
            scores[8] = points[itemScore];
        }
        if (leftValues.coef[9] * rightValues.coef[9] == 1) {
            itemScore = this.getLevel(GedcomUtilities.calcCosine(leftValues.noteMap, rightValues.noteMap));
            scores[9] = Math.max(points[itemScore], 0);
        }
        if (leftValues.coef[10] * rightValues.coef[10] == 1) {
            itemScore = this.getLevel(GedcomUtilities.calcCosine(leftValues.nameMap, rightValues.nameMap));
            scores[10] = points[itemScore];
        }
        if (leftValues.coef[11] * rightValues.coef[11] == 1) {
            itemScore = this.getLevel(GedcomUtilities.calcCosine(leftValues.dataMap, rightValues.dataMap));
            scores[11] = points[itemScore];
        }
        int weightedScore = 0;
        for (int i = 0; i < scores.length; ++i) {
            weightedScore += scores[i] * weights[i];
        }
        int weight = Math.min(leftValues.weightedCoef, rightValues.weightedCoef);
        int score = weightedScore / weight + weight;
        return score;
    }

    private String getValue(Property source, String tag) {
        Property prop = source.getProperty(tag);
        return prop == null ? "" : prop.getValue();
    }

    private String getNote(Property source) {
        Property note = source.getProperty("NOTE");
        if (note != null) {
            return note.getValue();
        }
        note = source.getProperty("SNOTE");
        return note == null ? "" : note.getValue();
    }

    private Map<String, Integer> getLastNames(Property source) {
        ArrayList<String> list = new ArrayList<String>();
        for (PropertyForeignXRef fxref : source.getProperties(PropertyForeignXRef.class)) {
            Indi wife;
            if (!fxref.getTargetEntity().isPresent()) continue;
            Entity ent = (Entity)fxref.getTargetEntity().get();
            if (ent instanceof Indi) {
                Indi indi = (Indi)ent;
                for (String lastname : indi.getLastNames()) {
                    list.add(GedcomUtilities.normalizeString((String)lastname));
                }
                continue;
            }
            if (!(ent instanceof Fam)) continue;
            Fam fam = (Fam)ent;
            Indi husb = fam.getHusband();
            if (husb != null) {
                for (String lastname : husb.getLastNames()) {
                    list.add(GedcomUtilities.normalizeString((String)lastname));
                }
            }
            if ((wife = fam.getWife()) == null) continue;
            for (String lastname : wife.getLastNames()) {
                list.add(GedcomUtilities.normalizeString((String)lastname));
            }
        }
        return list.isEmpty() ? null : GedcomUtilities.buildMap(list);
    }

    private String getDataAsText(Property source) {
        Property pEven;
        StringBuilder sb = new StringBuilder();
        Property pData = source.getProperty("DATA");
        if (pData != null && (pEven = pData.getProperty("EVEN")) != null) {
            Property pPlace;
            sb.append(pEven.getDisplayValue());
            sb.append(" ");
            Property pDate = pEven.getProperty("DATE");
            if (pDate != null) {
                sb.append(pDate.getDisplayValue());
                sb.append(" ");
            }
            if ((pPlace = pEven.getProperty("PLAC")) != null) {
                sb.append(pPlace.getDisplayValue());
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    @Override
    public String[] getKeys(Source entity) {
        HashSet<String> keys = new HashSet<String>();
        Values values = new Values(entity);
        this.sourceValuesMap.put(entity, values);
        if (values.coef[0] == 1) {
            keys.addAll(SourceMatcher.getKeyWords(values.title, 3));
        }
        if (values.coef[1] == 1) {
            keys.addAll(SourceMatcher.getKeyWords(values.abbr, 3));
        }
        if (values.coef[4] == 1) {
            keys.addAll(SourceMatcher.getKeyWords(values.textMap, 3));
        }
        if (values.coef[5] == 1) {
            keys.add(values.mediaId);
        }
        return (String[])keys.toArray(String[]::new);
    }

    @Override
    public String getHexaKey(Source entity) {
        return "";
    }

    @Override
    public void reset() {
        this.alreadyCompared.clear();
    }

    private class Values {
        private final String title;
        private final String abbr;
        private final String auth;
        private final String publ;
        private final Map<String, Integer> textMap;
        private final String mediaId;
        private final String mediaTitle;
        private final Repository repo;
        private final String caln;
        private final Map<String, Integer> noteMap;
        private final Map<String, Integer> nameMap;
        private final Map<String, Integer> dataMap;
        private final int[] coef = new int[weights.length];
        private int weightedCoef;

        public Values(Source source) {
            PropertyRepository pRepo;
            PropertyMedia pMedia;
            this.title = GedcomUtilities.normalizeString((String)source.getTitle());
            this.coef[0] = this.title.isBlank() ? 0 : 1;
            this.abbr = GedcomUtilities.normalizeString((String)SourceMatcher.this.getValue((Property)source, "ABBR"));
            this.coef[1] = this.abbr.isBlank() ? 0 : 1;
            this.auth = GedcomUtilities.normalizeString((String)SourceMatcher.this.getValue((Property)source, "AUTH"));
            this.coef[2] = this.auth.isBlank() ? 0 : 1;
            this.publ = GedcomUtilities.normalizeString((String)SourceMatcher.this.getValue((Property)source, "PUBL"));
            this.coef[3] = this.publ.isBlank() ? 0 : 1;
            String str = source.getText();
            this.textMap = EntityMatcher.getWordsMap(str);
            this.coef[4] = str.isBlank() ? 0 : 1;
            Property prop = source.getProperty("OBJE");
            if (prop != null && prop instanceof PropertyMedia && (pMedia = (PropertyMedia)prop).getTargetEntity().isPresent()) {
                Media media = (Media)pMedia.getTargetEntity().get();
                this.mediaId = media.getId();
                this.coef[5] = 1;
                this.mediaTitle = GedcomUtilities.normalizeString((String)media.getTitle());
                this.coef[6] = this.mediaTitle.isBlank() ? 0 : 1;
            } else {
                this.mediaId = "";
                this.coef[5] = 0;
                this.mediaTitle = "";
                this.coef[6] = 0;
            }
            prop = source.getProperty("REPO");
            if (prop != null && prop instanceof PropertyRepository && (pRepo = (PropertyRepository)prop).getTargetEntity().isPresent()) {
                this.repo = (Repository)pRepo.getTargetEntity().get();
                this.coef[7] = 1;
                this.caln = SourceMatcher.this.getValue(prop, "CALN");
                this.coef[8] = this.caln.isBlank() ? 0 : 1;
            } else {
                this.repo = null;
                this.coef[7] = 0;
                this.caln = "";
                this.coef[8] = 0;
            }
            str = SourceMatcher.this.getValue((Property)source, "NOTE");
            this.noteMap = EntityMatcher.getWordsMap(str);
            this.coef[9] = str.isBlank() ? 0 : 1;
            this.nameMap = SourceMatcher.this.getLastNames((Property)source);
            this.coef[10] = this.nameMap == null ? 0 : 1;
            str = SourceMatcher.this.getDataAsText((Property)source);
            this.dataMap = EntityMatcher.getWordsMap(str);
            this.coef[11] = str.isBlank() ? 0 : 1;
            this.weightedCoef = 0;
            for (int i = 0; i < this.coef.length; ++i) {
                this.weightedCoef += this.coef[i] * weights[i];
            }
            this.weightedCoef -= this.coef[9] * weights[9];
        }
    }
}

