/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.views.tree.style;

import ancestris.modules.views.tree.style.Style;
import genj.renderer.BlueprintManager;
import genj.tree.TreeMetrics;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TreeStyleManager {
    private static final Resources RESOURCES = Resources.get(TreeStyleManager.class);
    private static final String[] STYLES = new String[]{"default", "classic", "small_picture"};
    public static final String PERSOSTYLE = "perso";
    public static final String STYLEH = "perso_horizontal";
    private static final float MINZOOM = 0.1f;
    private static final float MAXZOOM = 1.0f;
    private static final float DEFZOOM = 0.5f;
    private static TreeStyleManager instance;
    private final Map<String, Style> key2style = new LinkedHashMap<String, Style>();
    private final BlueprintManager bpm = BlueprintManager.getInstance();
    public static String[] ORDERCOLORS;
    private Map<String, Color> colors;
    private Font font;
    private TreeMetrics tm;

    public static TreeStyleManager getInstance(Registry registry) {
        if (instance == null) {
            instance = new TreeStyleManager(registry);
        }
        return instance;
    }

    private TreeStyleManager(Registry registry) {
        this.key2style.clear();
        if (registry != null) {
            this.key2style.put(PERSOSTYLE, this.getStyle(PERSOSTYLE, registry));
            this.key2style.put(STYLEH, this.getStyle(STYLEH, registry, "h."));
        }
        for (String key : STYLES) {
            Registry styleRegistry = new Registry(this.getClass().getResourceAsStream(key + ".properties"));
            Style style = this.getStyle(key, styleRegistry);
            this.key2style.put(key, style);
        }
    }

    private Style getStyle(String key, Registry registry) {
        return this.getStyle(key, registry, "");
    }

    private Style getStyle(String key, Registry registry, String prefix) {
        if (key == null) {
            key = PERSOSTYLE;
        }
        String name = RESOURCES.getString("style." + key, false);
        this.colors = new HashMap<String, Color>();
        this.colors.put("background", Color.WHITE);
        this.colors.put("selects", new Color(255, 204, 0));
        this.colors.put("roots", new Color(102, 0, 0));
        this.colors.put("maleindis", new Color(0, 0, 255));
        this.colors.put("femaleindis", new Color(255, 51, 255));
        this.colors.put("unknownindis", new Color(128, 128, 128));
        this.colors.put("fams", new Color(204, 204, 204));
        this.colors.put("arcs", new Color(51, 51, 51));
        this.colors = registry.get(prefix + "color", this.colors);
        this.font = new Font("SansSerif", 0, 11);
        this.font = registry.get(prefix + "font", this.font);
        this.tm = new TreeMetrics(registry.get(prefix + "windis", 115), registry.get(prefix + "hindis", 28), registry.get(prefix + "wfams", 91), registry.get(prefix + "hfams", 13), registry.get(prefix + "pad", 18), registry.get(prefix + "indisthick", 3), registry.get(prefix + "famsthick", 2));
        Style style = new Style(key, name, new ImageIcon((Object)this, STYLEH.equals(key) ? PERSOSTYLE : key), this.bpm.getBlueprint("INDI", registry.get(prefix + "blueprint.INDI", "").trim()), this.bpm.getBlueprint("FAM", registry.get(prefix + "blueprint.FAM", "").trim()), this.colors, this.font, registry.get(prefix + "bend", true), registry.get(prefix + "marrs", true), registry.get(prefix + "antial", true), registry.get(prefix + "roundedrect", true), this.tm, Math.max(0.1f, Math.min(1.0f, registry.get(prefix + "zoom", 0.5f))));
        return style;
    }

    public List<Style> getStyles(boolean noHorizontal) {
        ArrayList<Style> retour = new ArrayList<Style>();
        if (noHorizontal) {
            for (String key : this.key2style.keySet()) {
                if (STYLEH.equals(key)) continue;
                retour.add(this.getStyle(key));
            }
        } else {
            for (String key : this.key2style.keySet()) {
                if (PERSOSTYLE.equals(key)) continue;
                retour.add(this.getStyle(key));
            }
        }
        return retour;
    }

    public Style getStyle(String key) {
        return this.key2style.get(key);
    }

    public Style getPersoStyle(boolean horizontal) {
        if (horizontal) {
            return this.key2style.get(STYLEH);
        }
        return this.key2style.get(PERSOSTYLE);
    }

    public void putStyle(Registry registry) {
        Style style = this.key2style.get(PERSOSTYLE);
        registry.put("color", style.colors);
        registry.put("font", style.font);
        registry.put("windis", style.tm.wIndis);
        registry.put("hindis", style.tm.hIndis);
        registry.put("wfams", style.tm.wFams);
        registry.put("hfams", style.tm.hFams);
        registry.put("pad", style.tm.pad);
        registry.put("indisthick", style.tm.indisThick);
        registry.put("famsthick", style.tm.famsThick);
        registry.put("bend", Boolean.valueOf(style.bend));
        registry.put("marrs", Boolean.valueOf(style.marr));
        registry.put("roundedrect", Boolean.valueOf(style.roundrect));
        registry.put("antial", Boolean.valueOf(style.antialiasing));
        registry.put("blueprint.INDI", style.blueprintIndi.getName());
        registry.put("blueprint.FAM", style.blueprintFam.getName());
        registry.put("zoom", (float)style.zoom);
        style = this.key2style.get(STYLEH);
        registry.put("h.color", style.colors);
        registry.put("h.font", style.font);
        registry.put("h.windis", style.tm.wIndis);
        registry.put("h.hindis", style.tm.hIndis);
        registry.put("h.wfams", style.tm.wFams);
        registry.put("h.hfams", style.tm.hFams);
        registry.put("h.pad", style.tm.pad);
        registry.put("h.indisthick", style.tm.indisThick);
        registry.put("h.famsthick", style.tm.famsThick);
        registry.put("h.bend", Boolean.valueOf(style.bend));
        registry.put("h.marrs", Boolean.valueOf(style.marr));
        registry.put("h.roundedrect", Boolean.valueOf(style.roundrect));
        registry.put("h.antial", Boolean.valueOf(style.antialiasing));
        registry.put("h.blueprint.INDI", style.blueprintIndi.getName());
        registry.put("h.blueprint.FAM", style.blueprintFam.getName());
        registry.put("h.zoom", (float)style.zoom);
    }

    static {
        ORDERCOLORS = new String[]{"background", "selects", "roots", "maleindis", "femaleindis", "unknownindis", "fams", "arcs"};
    }
}

