/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import ancestris.util.Utilities;
import genj.search.Matcher;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegExMatcher
extends Matcher {
    private Pattern compiled;

    RegExMatcher() {
    }

    @Override
    public void init(String pattern, boolean case_sensitive) {
        this.case_sensitive = case_sensitive;
        try {
            this.compiled = Pattern.compile(pattern, 98);
        }
        catch (PatternSyntaxException pe) {
            throw new IllegalArgumentException("There's a problem with the regular expression '" + pattern + "': " + pe.getDescription());
        }
    }

    @Override
    protected void match(String input, List<Matcher.Match> result) {
        String removedAccents = Utilities.removeDiacritics((String)input);
        java.util.regex.Matcher m = this.compiled.matcher(removedAccents);
        while (m.find()) {
            result.add(new Matcher.Match(m.start(), m.end() - m.start()));
        }
        return;
    }
}

