/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyRepository;
import genj.gedcom.Repository;

public class Source
extends Entity {
    public Source(String tag, String id) {
        super(tag, id);
        this.assertTag("SOUR");
    }

    @Override
    public boolean isValid() {
        return this.getValue().isEmpty();
    }

    @Override
    public void moveEntityValue() {
        String value = this.getValue();
        if (!value.isEmpty()) {
            if (this.getTitle().isEmpty()) {
                this.setTitle(value);
                this.setValue("");
            } else {
                super.moveEntityValue();
            }
        }
    }

    @Override
    protected String getToStringPrefix(boolean showIds) {
        return this.getTitle();
    }

    @Override
    public String getDisplayTitle() {
        return this.getDisplayTitle(true);
    }

    @Override
    public String getDisplayTitle(boolean showIds) {
        int cut;
        int len;
        int maxLen = 30;
        String str = this.getTitle().trim();
        if (!str.isEmpty() && maxLen != 0 && (len = str.length()) > maxLen && (cut = str.indexOf(" ", maxLen)) != -1) {
            str = str.substring(0, cut);
        }
        if (str.isEmpty()) {
            str = "?";
        }
        if (showIds) {
            return this.getId() + " - " + str;
        }
        return str;
    }

    public String getTitle() {
        Property title = this.getProperty("TITL");
        return title != null ? title.getValue() : "";
    }

    public void setTitle(String title) {
        Property property = this.getProperty("TITL");
        if (property == null) {
            property = this.addProperty("TITL", title);
        } else {
            property.setValue(title);
        }
    }

    public String getText() {
        Property p = this.getProperty("TEXT");
        return p != null ? p.getValue() : "";
    }

    public String getAbbreviation() {
        Property p = this.getProperty("ABBR");
        return p != null ? p.getValue() : "";
    }

    public String getPublication() {
        Property p = this.getProperty("PUBL");
        return p != null ? p.getValue() : "";
    }

    public String getAuthor() {
        Property p = this.getProperty("AUTH");
        return p != null ? p.getValue() : "";
    }

    public String getNote() {
        Property p = this.getProperty("NOTE");
        return p != null ? p.getValue() : "";
    }

    public String getRepoName() {
        Entity target;
        Property repo = this.getProperty("REPO");
        if (repo != null && repo instanceof PropertyRepository && (target = (Entity)((PropertyRepository)repo).getTargetEntity().orElse(null)) != null && target instanceof Repository) {
            return ((Repository)target).getRepositoryName();
        }
        return "";
    }

    public String getCaln() {
        Property caln;
        Property repo = this.getProperty("REPO");
        if (repo != null && repo instanceof PropertyRepository && (caln = repo.getProperty("CALN")) != null) {
            return caln.getValue();
        }
        return "";
    }

    public Entity getMedia() {
        Property prop = this.getProperty("OBJE");
        if (prop != null && prop instanceof PropertyMedia) {
            PropertyMedia pMedia = (PropertyMedia)prop;
            return pMedia.getTargetEntity().orElse(null);
        }
        return null;
    }

    public String getSearchString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTitle());
        sb.append(" ");
        sb.append(this.getText());
        sb.append(" ");
        sb.append(this.getAbbreviation());
        sb.append(" ");
        sb.append(this.getAuthor());
        sb.append(" ");
        sb.append(this.getRepoName());
        sb.append(" ");
        sb.append(this.getCaln());
        sb.append(" ");
        sb.append(this.getNote());
        sb.append(" ");
        sb.append(this.getId());
        sb.append(" ");
        return sb.toString();
    }
}

