/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.crypto.Enigma;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.Submitter;
import genj.util.ReferenceSet;
import genj.util.WordBuffer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyName
extends Property {
    public static final int PREFIX_AS_IS = 0;
    public static final int PREFIX_LAST = 1;
    public static final int IGNORE_PREFIX = 2;
    public static final String TAG = "NAME";
    private static final String KEY_LASTNAME = "NAME.last";
    private static final String KEY_FIRSTNAME = "NAME.first";
    private static final String KEY_NICKNAME = "NICK";
    private String lastName = "";
    private String firstName = "";
    private String suffix = "";
    private String nameTagValue;
    private String nameAsString;
    private int mutePropertyChange = 0;

    PropertyName(String tag) {
        super(tag);
    }

    public PropertyName() {
        super(TAG);
    }

    @Override
    public PropertyComparator2 getComparator() {
        return NAMEComparator.getInstance();
    }

    public boolean isMutePropertyChange() {
        return this.mutePropertyChange != 0;
    }

    public boolean mutePropertyChange() {
        boolean isMute = this.isMutePropertyChange();
        ++this.mutePropertyChange;
        return isMute;
    }

    public void unmutePropertyChange() {
        this.unmutePropertyChange(false);
    }

    public void unmutePropertyChange(boolean clear) {
        if (clear) {
            this.mutePropertyChange = 0;
        } else {
            --this.mutePropertyChange;
            if (this.mutePropertyChange < 0) {
                this.mutePropertyChange = 0;
            }
        }
    }

    public String getFirstName() {
        return PropertyName.gedcomToValue(this.firstName, !this.isGrammar7());
    }

    public String getGivenName() {
        String tagGiven = GedcomOptions.getInstance().getGivenTag();
        String split = this.isGrammar7() ? ",|\\s" : ",";
        String[] firstNames = this.firstName.split(split);
        String given = null;
        if (tagGiven.isEmpty()) {
            for (String first : firstNames) {
                if (!(first = first.trim()).matches("\"[^\"]*\"") && !first.matches("<[^>]*>") && !first.matches("\\[[^\\]]*\\]")) continue;
                given = first.substring(1, first.length() - 1);
                break;
            }
        } else if (this.getProperty(tagGiven) != null) {
            given = this.getProperty(tagGiven).getValue();
        }
        return given == null ? firstNames[0] : given;
    }

    @Override
    public boolean isValid() {
        if (!(this.getEntity() instanceof Indi) && !(this.getEntity() instanceof Submitter)) {
            return true;
        }
        return this.nameAsString == null;
    }

    @Override
    public boolean hasWarning() {
        Collator c = this.getGedcom().getCollator();
        return this.isValid() && !c.equals(this.nameTagValue.replaceAll(" */ *", "/").replaceAll(" +", " "), this.computeNameValue().replaceAll(" */ *", "/"));
    }

    public static String getLabelForFirstName() {
        return Gedcom.getResources().getString("prop.name.firstname");
    }

    public static String getLabelForLastName() {
        return Gedcom.getResources().getString("prop.name.lastname");
    }

    public static String getLabelForSuffix() {
        return Gedcom.getResources().getString("prop.name.suffix");
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getNick() {
        return this.getPropertyValue(KEY_NICKNAME);
    }

    public void setNick(String nick) {
        Property n = this.getProperty(KEY_NICKNAME);
        if (n == null) {
            if (nick.length() == 0) {
                return;
            }
            this.addProperty(KEY_NICKNAME, nick);
        } else {
            n.setValue(nick);
        }
    }

    public String getNamePrefix() {
        return PropertyName.gedcomToValue(this.getPropertyValue("NPFX"), !this.isGrammar7());
    }

    public String getNamePrefix(boolean displayValue) {
        if (displayValue) {
            return this.getNamePrefix().replaceAll(" *, *", " ");
        }
        return this.getNamePrefix();
    }

    public String getSurnamePrefix() {
        return this.getPropertyValue("SPFX");
    }

    public String getSuffix() {
        return this.getPropertyValue("NSFX").trim();
    }

    @Override
    public String getValue() {
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        if (this.nameTagValue != null) {
            return this.nameTagValue;
        }
        return this.computeNameValue();
    }

    public String getNameTagValue() {
        return this.nameTagValue;
    }

    private String computeNameValue() {
        return this.computeNameValue(this.getNamePrefix(true), this.getFirstName(), this.getSurnamePrefix(), this.getLastName(), this.getSuffix());
    }

    public void fixNameValue() {
        this.nameTagValue = this.computeNameValue();
    }

    private String computeNameValue(String npfx, String first, String spfx, String last, String nsfx) {
        WordBuffer wb = new WordBuffer();
        first = first.replaceAll(",$", "");
        wb.append(npfx).append(first);
        WordBuffer wpname = new WordBuffer();
        wpname.append(spfx).append(last).setFiller("");
        String name = wpname.toString();
        if (name.length() > 0 || nsfx.length() > 0) {
            wb.append(" /" + name + "/");
        }
        wb.append(nsfx);
        return wb.toString();
    }

    @Override
    public String getDisplayValue() {
        return this.getDisplayValue(true);
    }

    private String getDisplayValue(boolean displayInterrogationMark) {
        String filler;
        if (this.isSecret()) {
            return "";
        }
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        if (",".equals(this.getLastName())) {
            return this.isGrammar7() ? "" : ",";
        }
        WordBuffer b = new WordBuffer();
        String last = this.getLastName();
        if (last.length() == 0 && displayInterrogationMark) {
            last = "?";
        }
        String first = this.getFirstName().replaceAll(", *$", "");
        String string = filler = this.isGrammar7() ? " " : ", ";
        if (GedcomOptions.getInstance().getNameFormat() == GedcomOptions.NameFormat.LAST) {
            b.append(this.getSurnamePrefix()).append(last).append(this.getSuffix());
            if (b.length() < 1) {
                b.append(first);
            } else {
                b.setFiller(filler).append(first);
            }
        } else {
            b.append(first).append(this.getSurnamePrefix()).append(last).append(this.getSuffix());
        }
        return b.toString();
    }

    @Override
    public String getReportValue() {
        return this.getDisplayValue(false);
    }

    @Override
    Property.PropertyFormatter formatImpl(char marker) {
        if (marker == 'g') {
            return new Property.PropertyFormatter(this, this.getGivenName());
        }
        return super.formatImpl(marker);
    }

    public PropertyName setName(String setLast) {
        return this.setName(this.firstName, setLast, this.suffix);
    }

    public final PropertyName setName(String setFirst, String setLast) {
        return this.setName(setFirst, setLast, this.suffix);
    }

    public PropertyName setName(String setFirst, String setLast, String setSuffix) {
        return this.setName(this.getPropertyValue("NPFX"), setFirst, this.getPropertyValue("SPFX"), setLast, setSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyName setName(String nPfx, String first, String sPfx, String last, String suff) {
        String old;
        boolean hasParent = this.getParent() != null;
        String string = old = hasParent ? this.getValue() : null;
        if (GedcomOptions.getInstance().isUpperCaseNames()) {
            NameParser parser = new NameParser((String)last);
            last = parser.getPrefix() + parser.getLast().toUpperCase();
        }
        if (!this.isGrammar7()) {
            first = PropertyName.gedcomFromValue(first, true);
            nPfx = PropertyName.gedcomFromValue(nPfx, true);
        }
        this.remember(first, (String)last);
        try {
            boolean isMuted = this.mutePropertyChange();
            if (hasParent && !isMuted) {
                this.addNameSubProperty(true, "GIVN", first);
                this.addNameSubProperty(true, "SURN", (String)last);
                this.addNameSubProperty(true, "NSFX", suff);
                this.addNameSubProperty(true, "SPFX", sPfx);
                this.addNameSubProperty(true, "NPFX", nPfx);
            }
            this.nameAsString = null;
            this.lastName = last;
            this.firstName = first;
            this.suffix = suff;
            if (old != null && !isMuted) {
                this.propagatePropertyChanged(this, old);
            }
        }
        finally {
            this.unmutePropertyChange();
        }
        this.fixNameValue();
        return this;
    }

    public void upperCaseName() {
        NameParser parser = new NameParser(this.getLastName());
        this.setName(parser.getPrefix() + parser.getLast().toUpperCase());
    }

    public PropertyName replaceAllLastNames(String from) {
        Property[] others;
        String to = this.getLastName();
        for (Property other : others = this.getSameLastNames(from)) {
            if (!(other instanceof PropertyName) || other == this) continue;
            ((PropertyName)other).setName(to);
        }
        return this;
    }

    private String addNameSubProperty(boolean force, String tag, String value) {
        String oldValue;
        Property sub = this.getProperty(tag);
        String string = oldValue = sub != null ? sub.getValue() : "";
        if (sub == null) {
            if (!value.isEmpty()) {
                sub = this.addProperty(tag, value);
                sub.setGuessed(!force);
                return sub.getValue();
            }
            return "";
        }
        if (force) {
            if (value == null || value.isEmpty()) {
                if (!oldValue.isEmpty()) {
                    this.delProperty(sub);
                    return "";
                }
            } else {
                if (!value.equals(oldValue)) {
                    sub.setValue(value);
                }
                sub.setGuessed(false);
            }
        }
        return sub.getValue();
    }

    private static String gedcomToValue(String namePiece, boolean transform) {
        if (!transform) {
            return namePiece;
        }
        if (!((String)namePiece).matches(".*[^, ] +[^, ].*")) {
            return ((String)namePiece).replaceAll(" *, *", " ");
        }
        if (!((String)namePiece).contains(",")) {
            namePiece = (String)namePiece + ",";
        }
        return namePiece;
    }

    private static String gedcomFromValue(String namePiece, boolean transform) {
        if (!transform) {
            return namePiece;
        }
        String np = namePiece;
        if (np.indexOf(44) == -1) {
            np = np.replaceAll(" +", ", ");
        }
        np = np.replaceAll(" *, *", ", ");
        np = np.replaceAll(", *$", "");
        return np;
    }

    @Override
    void afterAddNotify() {
        super.afterAddNotify();
        this.remember(this.firstName, this.lastName);
    }

    @Override
    void beforeDelNotify() {
        this.remember("", "");
        super.beforeDelNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String newValue) {
        this.nameTagValue = newValue;
        if (Enigma.isEncrypted(newValue)) {
            this.setName("", "", "");
            this.nameAsString = newValue;
            return;
        }
        String _lastName = "";
        String _suffix = "";
        String[] parts = newValue.split("/", -1);
        String _firstName = parts[0];
        if (parts.length == 3) {
            _lastName = parts[1];
            _suffix = parts[2];
        } else if (parts.length != 1) {
            _firstName = "";
            _lastName = "";
            _suffix = "";
            this.nameAsString = newValue;
        }
        _firstName = PropertyName.stripPrefix(_firstName, this.getNamePrefix());
        _lastName = PropertyName.stripPrefix(_lastName, this.getSurnamePrefix());
        this.remember(_firstName, _lastName);
        try {
            this.mutePropertyChange();
            _firstName = this.addNameSubProperty(false, "GIVN", PropertyName.gedcomFromValue(_firstName, !this.isGrammar7()));
            _lastName = this.addNameSubProperty(false, "SURN", _lastName);
            _suffix = this.addNameSubProperty(false, "NSFX", _suffix);
            this.nameAsString = null;
            this.lastName = _lastName;
            this.firstName = _firstName;
            this.suffix = _suffix;
        }
        finally {
            this.unmutePropertyChange();
        }
        this.nameTagValue = newValue;
    }

    private static String stripPrefix(String value, String prefix) {
        if (value.toLowerCase().startsWith(prefix.toLowerCase())) {
            return value.substring(prefix.length()).trim();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh(Property property) {
        String propagateTag = property.getTag();
        String[] nameTags = new String[]{"NPFX", "GIVN", "SPFX", "SURN", "NSFX"};
        boolean refresh = false;
        for (String tag : nameTags) {
            if (!propagateTag.equals(tag)) continue;
            refresh = true;
            break;
        }
        if (!refresh) {
            return;
        }
        try {
            if (!this.mutePropertyChange()) {
                for (String tag : nameTags) {
                    Property p = this.getProperty(tag);
                    if (p == null) continue;
                    p.setGuessed(false);
                }
                boolean isG7 = this.isGrammar7();
                this.setName(PropertyName.gedcomToValue(this.getPropertyValue("NPFX"), !isG7), PropertyName.gedcomToValue(this.getPropertyValue("GIVN"), !isG7), this.getPropertyValue("SPFX"), this.getPropertyValue("SURN"), this.getPropertyValue("NSFX"));
            }
        }
        finally {
            this.unmutePropertyChange();
        }
    }

    @Override
    void propagatePropertyAdded(Property property, int pos, Property added) {
        this.refresh(added);
        super.propagatePropertyAdded(property, pos, added);
    }

    @Override
    void propagatePropertyDeleted(Property property, int pos, Property deleted) {
        this.refresh(deleted);
        super.propagatePropertyDeleted(property, pos, deleted);
    }

    @Override
    void propagatePropertyChanged(Property property, String oldValue) {
        this.refresh(property);
        super.propagatePropertyChanged(property, oldValue);
    }

    public List<String> getLastNames(boolean sortByName) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new ArrayList<String>(0);
        }
        return PropertyName.getLastNames(gedcom, sortByName);
    }

    public List<String> getFirstNames(boolean sortByName) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new ArrayList<String>(0);
        }
        return PropertyName.getFirstNames(gedcom, sortByName);
    }

    public List<String> getNickNames(boolean sortByName) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new ArrayList<String>(0);
        }
        return PropertyName.getNickNames(gedcom, sortByName);
    }

    public static List<String> getLastNames(Gedcom gedcom, boolean sortByName) {
        return gedcom.getReferenceSet(KEY_LASTNAME).getKeys(sortByName ? gedcom.getCollator() : null);
    }

    public static List<String> getFirstNames(Gedcom gedcom, boolean sortByName) {
        return gedcom.getReferenceSet(KEY_FIRSTNAME).getKeys(sortByName ? gedcom.getCollator() : null);
    }

    public static List<String> getNickNames(Gedcom gedcom, boolean sortByName) {
        return gedcom.getReferenceSet(KEY_NICKNAME).getKeys(sortByName ? gedcom.getCollator() : null);
    }

    public int getLastNameCount() {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return 0;
        }
        return PropertyName.getLastNameCount(gedcom, this.getLastName());
    }

    public static int getLastNameCount(Gedcom gedcom, String last) {
        return gedcom.getReferenceSet(KEY_LASTNAME).getReferences(last).size();
    }

    public Property[] getSameLastNames() {
        return this.getSameLastNames(this.getLastName());
    }

    private Property[] getSameLastNames(String last) {
        return PropertyName.toArray(this.getGedcom().getReferenceSet(KEY_LASTNAME).getReferences(last));
    }

    private void remember(String newFirst, String newLast) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return;
        }
        ReferenceSet<String, Property> refSet = gedcom.getReferenceSet(KEY_LASTNAME);
        if (this.lastName.length() > 0) {
            refSet.remove(this.lastName, this);
        }
        if (newLast.length() > 0) {
            refSet.add(newLast, this);
        }
        refSet = gedcom.getReferenceSet(KEY_FIRSTNAME);
        if (this.firstName.length() > 0) {
            refSet.remove(this.firstName, this);
        }
        if (newFirst.length() > 0) {
            String f = newFirst;
            refSet.add(f, this);
        }
    }

    private static class NAMEComparator
    extends PropertyComparator2.Default<PropertyName> {
        private static final NAMEComparator INSTANCE = new NAMEComparator();

        private NAMEComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public String getSortGroup(PropertyName p) {
            return this.shortcut(p.getDisplayValue().trim(), 1);
        }

        @Override
        public int compare(PropertyName p1, PropertyName p2) {
            int r = this.compareNull(p1, p2);
            if (r != Integer.MAX_VALUE) {
                return r;
            }
            Collator c = p1.getGedcom().getCollator();
            r = c.compare(p1.getDisplayValue(), p2.getDisplayValue());
            return r;
        }
    }

    private static class NameParser {
        private static final Pattern PREFIX_PATTERN = Pattern.compile("(d'|von der|von|zu|del|de las|de les|de los|de|las|la|os|das|da|dos|af|av)( +)(.*)");
        private String prefix = "";
        private String last = "";

        public NameParser(String last) {
            Matcher m = PREFIX_PATTERN.matcher(last);
            if (m.matches()) {
                this.prefix = m.group(1) + " ";
                this.last = m.group(3);
            } else {
                this.prefix = "";
                this.last = last;
            }
        }

        String getPrefix() {
            return this.prefix;
        }

        String getLast() {
            return this.last;
        }
    }
}

