/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.SelectEntityPanel;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.MetaProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.LookupEvent;
import org.openide.util.NbBundle;

public class Swivel
extends AbstractAncestrisContextAction {
    protected static final Resources RESOURCES = Resources.get(Swivel.class);
    protected static final Logger LOG = Logger.getLogger("ancestris.edit.beans");
    private static ImageIcon IMAGE;
    private PropertyXRef xref;

    @Override
    public void resultChanged(LookupEvent ev) {
        this.xref = null;
        this.setEnabled(false);
        if (this.lkpInfo != null && this.lkpInfo.allInstances().size() == 1) {
            for (Property prop : this.lkpInfo.allInstances()) {
                if (!(prop instanceof PropertyXRef)) continue;
                this.xref = (PropertyXRef)prop;
            }
            super.resultChanged(ev);
        }
    }

    @Override
    protected void contextChanged() {
        super.contextChanged();
        if (this.xref != null && this.xref.getTargetEntity().isPresent()) {
            IMAGE = this.xref.getTargetEntity().get().getImage(false);
            this.setImage(IMAGE.getOverLayed(MetaProperty.IMG_LINK));
            this.setText(RESOURCES.getString("xref.swivel"));
            this.setTip(this.xref);
        }
        this.setEnabled(this.xref != null);
    }

    public Swivel() {
    }

    public Swivel(PropertyXRef xref) {
        this.xref = xref;
        super.setText(RESOURCES.getString("xref.swivel"));
        super.setImage(MetaProperty.IMG_LINK);
        this.setTip(xref);
        this.setEnabled(xref != null);
    }

    @Override
    public void actionPerformedImpl(ActionEvent event) {
        if (this.xref == null) {
            return;
        }
        String type = this.xref.getTargetType();
        if (type == null) {
            type = "INDI";
        }
        String msg = NbBundle.getMessage(this.getClass(), (String)"xrefbean.swivel.askentity", (Object)(this.xref.isValid() ? this.xref.getTargetEntity().get().toString(true) : this.xref.getValue()));
        SelectEntityPanel select = new SelectEntityPanel(this.xref.getGedcom(), type, msg, null);
        if (DialogManager.OK_OPTION != DialogManager.create(this.getText(), select).setMessageType(3).setOptionType(2).setDialogId("xrefbean.swivel").show()) {
            return;
        }
        final Entity newTarget = select.getSelection();
        if (this.xref.getTarget() != null) {
            LOG.fine("Swiveling " + this.xref.getEntity().getId() + "." + this.xref.getPath() + " from " + this.xref.getTarget().getEntity().getId() + " to " + newTarget.getId());
        } else {
            LOG.fine("Swiveling " + this.xref.getEntity().getId() + "." + this.xref.getPath() + " to " + newTarget.getId());
        }
        try {
            this.xref.getGedcom().doUnitOfWork(new UnitOfWork(){

                @Override
                public void perform(Gedcom gedcom) throws GedcomException {
                    if (Swivel.this.xref.isValid() && Swivel.this.xref.getTargetEntity().equals(newTarget)) {
                        return;
                    }
                    PropertyXRef backpointer = Swivel.this.xref.getTarget();
                    if (backpointer != null) {
                        Swivel.this.xref.unlink();
                    }
                    Swivel.this.xref.setValue("@" + newTarget.getId() + "@");
                    Swivel.this.xref.link();
                    if (backpointer != null && backpointer != Swivel.this.xref) {
                        backpointer.getParent().delProperty(backpointer);
                    }
                }
            });
        }
        catch (GedcomException ge) {
            DialogManager.create(this.getText(), ge.getMessage()).setMessageType(2).show();
            LOG.log(Level.FINER, ge.getMessage(), ge);
        }
    }

    private void setTip(PropertyXRef xref) {
        String ref = "";
        if (xref != null && xref.isValid()) {
            Entity ent = xref.getTargetEntity().orElse(null);
            if (ent != null) {
                ref = ent.getId();
            }
            super.setImage(IMAGE.getOverLayed(MetaProperty.IMG_LINK));
        }
        super.setTip(RESOURCES.getString("xref.swivel.tip", ref));
    }
}

