/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.core.TextOptions;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;

public class NodeWrapper {
    private static String NO_NAME = "?";
    private static String NO_DATE = "-";
    public static int PARENTS = 0;
    public static int SIBLING = 1;
    public static int BROTHER = 2;
    public static int SISTER = 3;
    public static int MEUNKNOWN = 4;
    public static int MEMALE = 5;
    public static int MEFEMALE = 6;
    public static int SPOUSE = 7;
    public static int CHILD = 8;
    public static int BOY = 9;
    public static int GIRL = 10;
    private static String b = "";
    private static String m = "";
    private static String d = "";
    private static String c = "";
    private static String bu = "";
    private Entity entity = null;
    private int type = 0;
    private Object object = null;
    private Indi myIndi = null;

    public NodeWrapper(int type, Object o) {
        this.type = type;
        this.object = o;
        b = TextOptions.getInstance().getBirthSymbol();
        m = TextOptions.getInstance().getMarriageSymbol();
        d = TextOptions.getInstance().getDeathSymbol();
        c = TextOptions.getInstance().getBaptismSymbol();
        bu = TextOptions.getInstance().getBurialSymbol();
        if (type == MEUNKNOWN) {
            Indi indi = (Indi)o;
            this.entity = indi;
            if (indi.getSex() == 1) {
                this.type = MEMALE;
            } else if (indi.getSex() == 2) {
                this.type = MEFEMALE;
            }
        } else if (type == SIBLING) {
            Indi indi = (Indi)o;
            this.entity = indi;
            if (indi.getSex() == 1) {
                this.type = BROTHER;
            } else if (indi.getSex() == 2) {
                this.type = SISTER;
            }
        } else if (type == CHILD) {
            Indi indi = (Indi)o;
            this.entity = indi;
            if (indi.getSex() == 1) {
                this.type = BOY;
            } else if (indi.getSex() == 2) {
                this.type = GIRL;
            }
        } else if (type == PARENTS) {
            this.entity = (Fam)o;
        } else if (type == SPOUSE) {
            this.entity = (Fam)o;
        }
    }

    public NodeWrapper(int type, Object o, Indi indi) {
        this.type = type;
        this.object = o;
        this.myIndi = indi;
        this.entity = (Fam)o;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public int getType() {
        return this.type;
    }

    public String getDisplayValue() {
        if (this.object == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder("<html>");
        if (this.type == PARENTS) {
            Fam fam = (Fam)this.object;
            Indi husband = fam.getHusband();
            Indi wife = fam.getWife();
            ret.append(this.getName(husband));
            ret.append(m).append(fam.getMarriageDate() != null ? fam.getMarriageDate().getDisplayValue() : "").append(" ");
            ret.append(this.getName(wife));
            this.entity = husband != null ? husband : (wife != null ? wife : fam);
        } else if (this.type == SIBLING || this.type == BROTHER || this.type == SISTER) {
            Indi indi = (Indi)this.object;
            ret.append(this.getName(indi));
        } else if (this.type == MEUNKNOWN || this.type == MEMALE || this.type == MEFEMALE) {
            Indi indi = (Indi)this.object;
            ret.append(this.getName(indi));
        } else if (this.type == SPOUSE) {
            String dateStr;
            Fam fam = (Fam)this.object;
            Indi husband = fam.getHusband();
            Indi wife = fam.getWife();
            if (husband != null && husband.equals(this.myIndi)) {
                ret.append(wife != null ? this.getName(wife) : "");
                this.entity = wife != null ? wife : husband;
            } else if (wife != null && wife.equals(this.myIndi)) {
                ret.append(husband != null ? this.getName(husband) : "");
                this.entity = husband != null ? husband : wife;
            } else {
                ret.append("");
                this.entity = fam;
            }
            String string = dateStr = fam.getMarriageDate() != null ? fam.getMarriageDate().getDisplayValue() : NO_DATE;
            if (dateStr.trim().isEmpty()) {
                dateStr = NO_DATE;
            }
            ret.append(m).append(dateStr).append(" (").append(fam.getId()).append(") ");
        } else if (this.type == CHILD || this.type == BOY || this.type == GIRL) {
            Indi indi = (Indi)this.object;
            ret.append(this.getName(indi));
        } else {
            ret.append(this.object.toString());
        }
        ret.append("</html>");
        return ret.toString();
    }

    private String getName(Indi indi) {
        String dd;
        String bd;
        String fn;
        String ln;
        boolean useChr = false;
        boolean useBuri = false;
        if (indi == null) {
            return "";
        }
        String string = ln = indi.getFullSurname() != null ? indi.getFullSurname() : NO_NAME;
        if (ln.trim().isEmpty()) {
            ln = NO_NAME;
        }
        String string2 = fn = indi.getFirstName() != null ? indi.getFirstName() : NO_NAME;
        if (fn.trim().isEmpty()) {
            fn = NO_NAME;
        }
        if (fn.endsWith(",")) {
            fn = fn.replaceAll("\\s*,\\s*$", "");
        }
        String string3 = bd = indi.getBirthAsString() != null ? indi.getBirthAsString() : NO_NAME;
        if (bd.trim().isEmpty()) {
            String chr = indi.getCHRAsString();
            if (TextOptions.getInstance().isUseChr() && !"".equals(chr)) {
                bd = chr;
                useChr = true;
            } else {
                bd = NO_DATE;
            }
        }
        String string4 = dd = indi.getDeathAsString() != null ? indi.getDeathAsString() : NO_NAME;
        if (dd.trim().isEmpty()) {
            String burial = indi.getBuriAsString();
            if (TextOptions.getInstance().isUseBuri() && !"".equals(burial)) {
                dd = burial;
                useBuri = true;
            } else {
                dd = NO_DATE;
            }
        }
        StringBuilder ret = new StringBuilder("");
        ret.append(ln).append(", ").append(fn);
        ret.append(" (").append(useChr ? c : b).append(bd).append(" ");
        ret.append(useBuri ? bu : d).append(dd).append(") ");
        return ret.toString();
    }

    public boolean isMe() {
        return this.type == MEUNKNOWN || this.type == MEMALE || this.type == MEFEMALE;
    }

    public Fam getCurrentFamily() {
        if (this.type < SPOUSE) {
            return null;
        }
        if (this.type == SPOUSE) {
            return (Fam)this.object;
        }
        if (this.type > SPOUSE) {
            Indi child = (Indi)this.object;
            Fam fam = child.getFamilyWhereBiologicalChild();
            if (fam == null) {
                return null;
            }
            return fam;
        }
        return null;
    }
}

