/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.gedcomconversion;

import ancestris.modules.editors.gedcomconversion.GedcomVersionConverter;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ConversionPanel
extends JPanel
implements PropertyChangeListener {
    private final Gedcom gedcom;
    private final Entity header;
    private final JButton cancelButton;
    private Grammar toGrammar;
    private ButtonGroup buttonGroup1;
    private JButton convertButton;
    private JLabel encodingDescriptionLabel;
    private JLabel formatCurrentLabel;
    private JLabel formatCurrentValue;
    private JLabel formatLabel;
    private JComboBox<GedcomConstants.Encodings> formatToComboBox;
    private JLabel formatToLabel;
    private JLabel gedcomCurrentLabel;
    private JLabel gedcomCurrentValue;
    private JLabel gedcomFutureLabel;
    private JLabel gedcomLabel;
    private JRadioButton norm551Button;
    private JRadioButton norm55Button;
    private JRadioButton norm7Button;
    private Label progressLabel;

    public ConversionPanel(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.header = gedcom.getFirstEntity("HEAD");
        this.cancelButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"Cancel_button"));
        this.initComponents();
        this.norm55Button.setText("5.5");
        this.norm551Button.setText("5.5.1");
        this.norm7Button.setText("7.0.13");
        this.progressLabel.setText("");
        this.load();
        this.updateCombo();
        this.displayInfo();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.gedcomLabel = new JLabel();
        this.gedcomCurrentLabel = new JLabel();
        this.gedcomCurrentValue = new JLabel();
        this.gedcomFutureLabel = new JLabel();
        this.norm55Button = new JRadioButton();
        this.norm551Button = new JRadioButton();
        this.norm7Button = new JRadioButton();
        this.formatLabel = new JLabel();
        this.formatCurrentLabel = new JLabel();
        this.formatCurrentValue = new JLabel();
        this.formatToLabel = new JLabel();
        this.formatToComboBox = new JComboBox<GedcomConstants.Encodings>(GedcomConstants.Encodings.values());
        this.encodingDescriptionLabel = new JLabel();
        this.convertButton = new JButton();
        this.progressLabel = new Label();
        this.gedcomLabel.setFont(new Font("Noto Sans", 1, 12));
        this.gedcomLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/gedcomconversion/Version.png")));
        Mnemonics.setLocalizedText((JLabel)this.gedcomLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.gedcomLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.gedcomCurrentLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.gedcomCurrentLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.gedcomCurrentValue, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.gedcomCurrentValue.text"));
        Mnemonics.setLocalizedText((JLabel)this.gedcomFutureLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.gedcomFutureLabel.text"));
        this.buttonGroup1.add(this.norm55Button);
        Mnemonics.setLocalizedText((AbstractButton)this.norm55Button, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.norm55Button.text"));
        this.norm55Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConversionPanel.this.norm55ButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.norm551Button);
        Mnemonics.setLocalizedText((AbstractButton)this.norm551Button, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.norm551Button.text"));
        this.norm551Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConversionPanel.this.norm551ButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.norm7Button);
        Mnemonics.setLocalizedText((AbstractButton)this.norm7Button, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.norm7Button.text"));
        this.norm7Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConversionPanel.this.norm7ButtonActionPerformed(evt);
            }
        });
        this.formatLabel.setFont(new Font("Noto Sans", 1, 12));
        this.formatLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/gedcomconversion/Code.png")));
        Mnemonics.setLocalizedText((JLabel)this.formatLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.formatLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.formatCurrentLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.formatCurrentLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.formatCurrentValue, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.formatCurrentValue.text"));
        Mnemonics.setLocalizedText((JLabel)this.formatToLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.formatToLabel.text"));
        this.formatToComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConversionPanel.this.formatToComboBoxItemStateChanged(evt);
            }
        });
        this.encodingDescriptionLabel.setFont(new Font("Noto Sans", 2, 12));
        Mnemonics.setLocalizedText((JLabel)this.encodingDescriptionLabel, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.encodingDescriptionLabel.text"));
        this.encodingDescriptionLabel.setVerticalAlignment(1);
        this.encodingDescriptionLabel.setPreferredSize(new Dimension(220, 94));
        Mnemonics.setLocalizedText((AbstractButton)this.convertButton, (String)NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.convertButton.text"));
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConversionPanel.this.convertButtonActionPerformed(evt);
            }
        });
        this.progressLabel.setFont(new Font("Open Sans", 0, 12));
        this.progressLabel.setText(NbBundle.getMessage(ConversionPanel.class, (String)"ConversionPanel.progressLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatCurrentLabel).addComponent(this.gedcomCurrentLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatCurrentValue).addComponent(this.gedcomCurrentValue)).addGap(56, 56, 56).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.formatToLabel).addGap(18, 18, 18).addComponent(this.formatToComboBox, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.gedcomFutureLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.norm55Button).addComponent(this.norm7Button).addComponent(this.norm551Button))).addComponent(this.encodingDescriptionLabel, -1, 304, Short.MAX_VALUE)).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatLabel, -2, 143, -2).addComponent(this.gedcomLabel)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.progressLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.convertButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.gedcomLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.gedcomCurrentValue).addComponent(this.gedcomCurrentLabel).addComponent(this.gedcomFutureLabel))).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.norm55Button))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.norm551Button).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.norm7Button).addGap(39, 39, 39).addComponent(this.formatLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.formatCurrentValue).addComponent(this.formatCurrentLabel).addComponent(this.formatToLabel).addComponent(this.formatToComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encodingDescriptionLabel, -1, 121, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.progressLabel, -2, -1, -2).addComponent(this.convertButton)).addContainerGap()));
    }

    private void formatToComboBoxItemStateChanged(ItemEvent evt) {
        this.updateOK();
        this.displayInfo();
    }

    private void norm55ButtonActionPerformed(ActionEvent evt) {
        this.updateCombo();
        this.updateOK();
    }

    private void norm551ButtonActionPerformed(ActionEvent evt) {
        this.updateCombo();
        this.updateOK();
    }

    private void norm7ButtonActionPerformed(ActionEvent evt) {
        this.updateCombo();
        this.updateOK();
    }

    private void convertButtonActionPerformed(ActionEvent evt) {
        try {
            this.gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    ConversionPanel.this.commit();
                }
            });
        }
        catch (Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void load() {
        String format = this.getProperty(".:CHAR");
        this.formatCurrentValue.setText(format);
        this.formatToComboBox.setSelectedItem(format);
        Grammar grammar = this.header.getGedcom().getGrammar();
        String grammarFound = this.getProperty(".:GEDC:VERS");
        this.gedcomCurrentValue.setText(grammarFound);
        switch (grammar.getVersion()) {
            case "5.5": {
                this.norm55Button.setEnabled(false);
                this.norm551Button.setSelected(true);
                this.norm7Button.setEnabled(false);
                break;
            }
            case "5.5.1": {
                this.norm55Button.setEnabled(true);
                this.norm551Button.setEnabled(false);
                this.norm7Button.setEnabled(true);
                this.norm7Button.setSelected(true);
                break;
            }
            case "7.0.13": {
                this.norm55Button.setEnabled(false);
                this.norm551Button.setSelected(true);
                this.norm7Button.setEnabled(false);
                break;
            }
        }
        this.updateOK();
    }

    private void updateOK() {
        boolean isSame1 = this.gedcomCurrentValue.getText().equals(this.getNewGrammar());
        boolean isSame2 = this.formatCurrentValue.getText().equals(String.valueOf(this.formatToComboBox.getSelectedItem()));
        this.convertButton.setEnabled(!isSame1 || !isSame2);
    }

    private void updateCombo() {
        if (this.norm7Button.isSelected()) {
            this.formatToComboBox.setSelectedItem(GedcomConstants.Encodings.UTF8);
            this.formatToComboBox.setEnabled(false);
        } else {
            this.formatToComboBox.setEnabled(true);
        }
    }

    private void displayInfo() {
        this.encodingDescriptionLabel.setText("<html>" + NbBundle.getMessage(this.getClass(), (String)(this.formatToComboBox.getSelectedItem().toString() + "_label")) + "</html>");
    }

    private String getNewGrammar() {
        if (this.norm55Button.isSelected()) {
            return "5.5";
        }
        if (this.norm551Button.isSelected()) {
            return "5.5.1";
        }
        if (this.norm7Button.isSelected()) {
            return "7.0.13";
        }
        return "";
    }

    protected String getProperty(String tag) {
        Property prop = this.header.getPropertyByPath(tag);
        return prop != null ? prop.getValue() : "";
    }

    private void setProperty(String tag, String text) {
        text = text.trim();
        Property prop = this.header.getPropertyByPath(tag);
        if (prop == null) {
            prop = this.header.setValue(new TagPath(tag), text);
        } else {
            prop.setValue(text);
        }
    }

    public void execute() {
        DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITLE_update", (Object)this.gedcom.getDisplayName()), (JComponent)this).setMessageType(-1).setOptions(new Object[]{this.cancelButton}).setDialogId("actionConversion").show();
    }

    public void commit() {
        Utilities.setCursorWaiting((JPanel)this);
        GedcomVersionConverter versionConverter = null;
        if (!this.formatCurrentValue.getText().equals(String.valueOf(this.formatToComboBox.getSelectedItem()))) {
            GedcomConstants.Encodings format = (GedcomConstants.Encodings)this.formatToComboBox.getSelectedItem();
            this.gedcom.setEncoding(format);
            this.setProperty(".:CHAR", format.toString());
        }
        if (!this.gedcomCurrentValue.getText().equals(this.getNewGrammar())) {
            this.toGrammar = Grammar.V551;
            if (this.norm55Button.isSelected()) {
                this.toGrammar = Grammar.V55;
            } else if (this.norm551Button.isSelected()) {
                this.toGrammar = Grammar.V551;
            } else if (this.norm7Button.isSelected()) {
                this.toGrammar = Grammar.V70;
            }
            this.gedcom.setGrammar(this.toGrammar);
            this.setProperty(".:GEDC:VERS", this.getNewGrammar());
            versionConverter = new GedcomVersionConverter(this.gedcom, this.gedcomCurrentValue.getText(), this.getNewGrammar());
            versionConverter.addPropertyChangeListener(this);
            versionConverter.convert();
            versionConverter.removePropertyChangeListener(this);
            this.result(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("exception".equals(evt.getPropertyName())) {
            this.result((String)evt.getNewValue());
            return;
        }
        if ("stateName".equals(evt.getPropertyName())) {
            this.progressLabel.setText((String)evt.getNewValue());
        }
    }

    public void result(String exception) {
        Utilities.setCursorNormal((JPanel)this);
        this.cancelButton.doClick();
        String title = NbBundle.getMessage(ConversionPanel.class, (String)"MSG_GedcomModificationResults");
        Object message = NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_Title");
        String fromFormat = this.formatCurrentValue.getText();
        String toFormat = this.formatToComboBox.getSelectedItem().toString();
        if (!(fromFormat.isEmpty() || toFormat.isEmpty() || fromFormat.equals(toFormat))) {
            message = (String)message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_FormatChanged", (Object)fromFormat, (Object)toFormat);
            message = (String)message + "<br>";
        }
        message = (String)message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_VersionChanged", (Object)this.gedcomCurrentValue.getText(), (Object)this.getNewGrammar());
        message = exception == null ? (String)message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_VersionSuccessChanged") : (String)message + "<font color=red>" + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_VersionFailureChanged", (Object)exception) + "</font>";
        message = (String)message + "<br>";
        message = (String)message + NbBundle.getMessage(ConversionPanel.class, (String)"RSLT_EndOfMessage");
        DialogManager.create((String)title, (String)message).setMessageType(1).setOptionType(10).setDialogId(this.getClass()).show();
    }
}

