/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.GedcomValidate;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyDate;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.view.ViewContext;
import java.util.List;
import org.openide.util.NbBundle;

public class TestAsso
extends Test {
    TestAsso() {
        super((String[])null, PropertyAssociation.class);
    }

    @Override
    void test(Property prop, TagPath path, List<ViewContext> issues, GedcomValidate report) {
        if (prop instanceof PropertyAssociation) {
            Property date;
            Property event;
            PropertyAssociation theProp = (PropertyAssociation)prop;
            if (!prop.isValid()) {
                return;
            }
            Entity beneficiaire = theProp.getBeneficiary();
            Entity cible = theProp.getWitness();
            if (beneficiaire != null && beneficiaire.equals(cible)) {
                issues.add(new ViewContext(prop).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"err.witness.ident", (Object)((Indi)beneficiaire).getName())));
            }
            if (beneficiaire instanceof Fam) {
                Fam fam = (Fam)beneficiaire;
                if (cible != null && (cible.equals(fam.getHusband()) || cible.equals(fam.getWife()))) {
                    issues.add(new ViewContext(prop).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"err.witness.ident.wedding", (Object)((Indi)cible).getName())));
                }
            }
            if ((event = theProp.getEvent(false)) != null && (date = event.getProperty("DATE")) != null && cible instanceof Indi) {
                PropertyDate dateDeath;
                Indi indi = (Indi)cible;
                PropertyDate dateBirth = indi.getBirthDateOption();
                if (this.isError(dateBirth, (PropertyDate)date)) {
                    issues.add(new ViewContext(prop).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"err.witness.before", (Object)Gedcom.getName((String)event.getTag()), (Object)date.getDisplayValue(), (Object)beneficiaire.getDisplayTitle(), (Object)Gedcom.getName((String)"BIRT"), (Object[])new Object[]{dateBirth.getDisplayValue()})));
                }
                if (this.isError((PropertyDate)date, dateDeath = indi.getDeathDateOption())) {
                    issues.add(new ViewContext(prop).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"err.witness.after", (Object)Gedcom.getName((String)event.getTag()), (Object)date.getDisplayValue(), (Object)beneficiaire.getDisplayTitle(), (Object)Gedcom.getName((String)"DEAT"), (Object[])new Object[]{dateDeath.getDisplayValue()})));
                }
            }
        }
    }

    private boolean isError(PropertyDate date1, PropertyDate date2) {
        PointInTime pit2;
        if (date1 == null || date2 == null) {
            return false;
        }
        if (!date1.isComparable() || !date2.isComparable()) {
            return false;
        }
        PointInTime pit1 = date1.getStart();
        PointInTime pointInTime = pit2 = date2.isRange() ? date2.getEnd() : date2.getStart();
        if (!(pit1.isComplete() && pit2.isComplete() || pit1.getYear() != pit2.getYear())) {
            return false;
        }
        return pit1.compareTo(pit2) > 0;
    }

    @Override
    String getCode() {
        return "06";
    }
}

