/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.modules.nav;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.Indi;
import genj.util.GridBagHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.view.View;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import spin.Spin;

public class NavigatorView
extends View {
    private static final String FATHER = "father";
    private static final String MOTHER = "mother";
    private static final String YSIBLING = "ysibling";
    private static final String OSIBLING = "osibling";
    private static final String PARTNER = "partner";
    private static final String CHILD = "child";
    private static final ImageIcon imgYSiblings = new ImageIcon(NavigatorView.class, "YSiblings");
    private static final ImageIcon imgOSiblings = new ImageIcon(NavigatorView.class, "OSiblings");
    private static final ImageIcon imgChildren = new ImageIcon(NavigatorView.class, "Children");
    private static final ImageIcon imgFather = new ImageIcon(NavigatorView.class, "Father");
    private static final ImageIcon imgMother = new ImageIcon(NavigatorView.class, "Mother");
    private static final ImageIcon imgMPartner = Indi.IMG_MALE;
    private static final ImageIcon imgFPartner = Indi.IMG_FEMALE;
    private GedcomListener callback = (GedcomListener)Spin.over((Object)new GedcomListenerAdapter(){

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (NavigatorView.this.context != null && NavigatorView.this.context.getEntity() == entity) {
                NavigatorView.this.setContext(new Context(gedcom));
            }
        }
    });
    private Map<String, PopupWidget> key2popup = new HashMap<String, PopupWidget>();
    private Context context = new Context();
    private JLabel labelSelf;
    private JPanel indiPanel;
    private JLabel indiPanelTitle;
    private JLabel labelCurrent;
    private JLabel navPanelTitle;
    private JPanel popupPanel;

    public NavigatorView() {
        this.initComponents();
        this.indiPanelTitle.setText(Gedcom.getName((String)"INDI", (boolean)false));
        this.navPanelTitle.setText(NbBundle.getMessage(NavigatorView.class, (String)"nav.navigate.title"));
        this.createPopupPanel();
        this.setPrintableArea((JComponent)((Object)this));
    }

    private void initComponents() {
        this.indiPanelTitle = new JLabel();
        this.indiPanel = new JPanel();
        this.labelCurrent = new JLabel();
        this.navPanelTitle = new JLabel();
        this.popupPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.indiPanelTitle, (String)NbBundle.getMessage(NavigatorView.class, (String)"NavigatorView.indiPanelTitle.text"));
        this.indiPanel.setBorder(BorderFactory.createEtchedBorder());
        Mnemonics.setLocalizedText((JLabel)this.labelCurrent, (String)NbBundle.getMessage(NavigatorView.class, (String)"NavigatorView.labelCurrent.text"));
        GroupLayout indiPanelLayout = new GroupLayout(this.indiPanel);
        this.indiPanel.setLayout(indiPanelLayout);
        indiPanelLayout.setHorizontalGroup(indiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indiPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.labelCurrent, -1, -1, Short.MAX_VALUE).addContainerGap()));
        indiPanelLayout.setVerticalGroup(indiPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(indiPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.labelCurrent).addContainerGap(-1, Short.MAX_VALUE)));
        Mnemonics.setLocalizedText((JLabel)this.navPanelTitle, (String)NbBundle.getMessage(NavigatorView.class, (String)"NavigatorView.navPanelTitle.text"));
        this.popupPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout popupPanelLayout = new GroupLayout(this.popupPanel);
        this.popupPanel.setLayout(popupPanelLayout);
        popupPanelLayout.setHorizontalGroup(popupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 384, Short.MAX_VALUE));
        popupPanelLayout.setVerticalGroup(popupPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 167, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.indiPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.popupPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.indiPanelTitle).addComponent(this.navPanelTitle)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.indiPanelTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indiPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.navPanelTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.popupPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    public Dimension getPreferredSize() {
        return new Dimension(140, 200);
    }

    public void setContext(Context newContext) {
        Indi old;
        if (this.context.getGedcom() != null && this.context.getGedcom() != newContext.getGedcom()) {
            this.context.getGedcom().removeGedcomListener(this.callback);
            if (newContext.getGedcom() != null) {
                newContext.getGedcom().addGedcomListener(this.callback);
            }
        }
        if ((old = (Indi)this.context.getEntity()) != null && this.context.getGedcom().contains((Entity)old) && !(newContext.getEntity() instanceof Indi) && !(newContext.getEntity() instanceof Fam)) {
            return;
        }
        Indi newIndi = null;
        if (newContext.getEntity() instanceof Indi) {
            newIndi = (Indi)newContext.getEntity();
        } else if (newContext.getEntity() instanceof Fam) {
            Component[] theFam = (Component[])newContext.getEntity();
            if (theFam != null && theFam.getWife() != null) {
                newIndi = theFam.getWife();
            }
            if (theFam != null && theFam.getHusband() != null) {
                newIndi = theFam.getHusband();
            }
        }
        if (newIndi != null) {
            this.context = new Context((Entity)newIndi);
            for (Component c : this.popupPanel.getComponents()) {
                c.setEnabled(true);
            }
            Indi current = (Indi)this.context.getEntity();
            this.setJump(FATHER, current.getBiologicalFather());
            this.setJump(MOTHER, current.getBiologicalMother());
            this.setJumps(OSIBLING, current.getOlderSiblings());
            this.setJumps(PARTNER, current.getPartners());
            this.setJumps(YSIBLING, current.getYoungerSiblings());
            this.setJumps(CHILD, current.getChildren());
            this.labelCurrent.setText("<html>" + current.toString() + "</html>");
            this.labelCurrent.setIcon((Icon)current.getImage(false));
            PopupWidget partner = this.getPopup(PARTNER);
            switch (current.getSex()) {
                case 2: {
                    this.labelSelf.setIcon((Icon)imgFPartner);
                    partner.setIcon((Icon)imgMPartner);
                    break;
                }
                case 1: {
                    this.labelSelf.setIcon((Icon)imgMPartner);
                    partner.setIcon((Icon)imgFPartner);
                }
            }
        } else {
            this.context = new Context(newContext.getGedcom());
            for (Component c : this.popupPanel.getComponents()) {
                c.setEnabled(false);
            }
            this.setJump(FATHER, null);
            this.setJump(MOTHER, null);
            this.setJump(OSIBLING, null);
            this.setJumps(PARTNER, null);
            this.setJump(YSIBLING, null);
            this.setJumps(CHILD, null);
            this.labelCurrent.setText("n/a");
            this.labelCurrent.setIcon(null);
        }
    }

    private PopupWidget getPopup(String key) {
        return this.key2popup.get(key);
    }

    private void setJump(String key, Indi i) {
        Indi[] indiArray;
        if (i == null) {
            indiArray = new Indi[]{};
        } else {
            Indi[] indiArray2 = new Indi[1];
            indiArray = indiArray2;
            indiArray2[0] = i;
        }
        this.setJumps(key, indiArray);
    }

    private void setJumps(String key, Indi[] is) {
        PopupWidget popup = this.getPopup(key);
        popup.removeItems();
        if (is == null || is.length == 0) {
            popup.setEnabled(false);
        } else {
            popup.setEnabled(true);
            for (int i = 0; i < is.length; ++i) {
                popup.addItem((Action)((Object)new Jump(is[i])));
            }
        }
    }

    private JComponent createPopup(String key, ImageIcon i) {
        PopupWidget result = new PopupWidget();
        result.setIcon((Icon)i);
        result.setFocusPainted(false);
        result.setFireOnClickWithin(500L);
        result.setFocusable(false);
        result.setEnabled(false);
        result.setToolTipText(NbBundle.getMessage(NavigatorView.class, (String)("tip." + key)));
        this.key2popup.put(key, result);
        return result;
    }

    private void createPopupPanel() {
        PopupPanel result = new PopupPanel();
        GridBagHelper gh = new GridBagHelper((Container)result);
        JComponent popFather = this.createPopup(FATHER, imgFather);
        JComponent popMother = this.createPopup(MOTHER, imgMother);
        JComponent popOSibling = this.createPopup(OSIBLING, imgOSiblings);
        JComponent popPartner = this.createPopup(PARTNER, imgMPartner);
        JComponent popYSibling = this.createPopup(YSIBLING, imgYSiblings);
        JComponent popChildren = this.createPopup(CHILD, imgChildren);
        this.labelSelf = new JLabel((Icon)GedcomConstants.getEntityImage((String)"INDI"), 0);
        popPartner.setPreferredSize(popOSibling.getPreferredSize());
        popFather.setPreferredSize(popOSibling.getPreferredSize());
        popMother.setPreferredSize(popOSibling.getPreferredSize());
        this.labelSelf.setPreferredSize(popOSibling.getPreferredSize());
        gh.add((Component)popFather, 4, 1, 1, 1);
        gh.add((Component)popMother, 5, 1, 1, 1);
        gh.add((Component)popOSibling, 1, 2, 2, 1, 0, new Insets(12, 0, 12, 12));
        gh.add((Component)this.labelSelf, 4, 2, 1, 1);
        gh.add((Component)popPartner, 5, 2, 1, 1);
        gh.add((Component)popYSibling, 7, 2, 2, 1, 0, new Insets(12, 12, 12, 0));
        gh.add((Component)popChildren, 4, 3, 2, 1);
        this.popupPanel.setLayout(new BorderLayout());
        this.popupPanel.add((Component)result, "Center");
    }

    private class Jump
    extends AbstractAncestrisAction {
        private Indi target;

        private Jump(Indi taRget) {
            this.target = taRget;
            this.setText(this.target.toString());
            this.setImage((Icon)this.target.getImage(false));
        }

        public void actionPerformed(ActionEvent event) {
            SelectionDispatcher.fireSelection((AWTEvent)event, (Context)new Context((Entity)this.target));
            NavigatorView.this.setContext(new Context((Entity)this.target));
        }
    }

    private class PopupPanel
    extends JPanel {
        private PopupPanel() {
        }

        @Override
        protected void paintChildren(Graphics g) {
            g.setColor(Color.lightGray);
            this.line(g, (JComponent)NavigatorView.this.getPopup(NavigatorView.MOTHER), (JComponent)NavigatorView.this.getPopup(NavigatorView.OSIBLING));
            this.line(g, (JComponent)NavigatorView.this.getPopup(NavigatorView.MOTHER), (JComponent)NavigatorView.this.getPopup(NavigatorView.YSIBLING));
            this.line(g, (JComponent)NavigatorView.this.getPopup(NavigatorView.MOTHER), NavigatorView.this.labelSelf);
            this.line(g, (JComponent)NavigatorView.this.getPopup(NavigatorView.PARTNER), (JComponent)NavigatorView.this.getPopup(NavigatorView.CHILD));
            super.paintChildren(g);
        }

        private void line(Graphics g, JComponent c1, JComponent c2) {
            Rectangle a = c1.getBounds();
            Rectangle b = c2.getBounds();
            int y = (a.y + a.height + b.y) / 2;
            int x = a.x;
            g.drawLine(x, a.y + a.height, x, y);
            x = b.x + b.width / 2;
            g.drawLine(x, y, x, b.y);
            g.drawLine(a.x, y, x, y);
        }
    }
}

